/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing;

import java.io.Serializable;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.addressing.MetadataHeaders;
import weblogic.wsee.message.FreeStandingMsgHeaders;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.soap.SoapMsgHeaders;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.util.ToStringWriter;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class EndpointReference
implements Serializable {
    static final long serialVersionUID = 2515772824816511305L;
    private String address;
    private String portType;
    private String serviceName;
    private String portName;
    private String namespaceURI = "http://www.w3.org/2005/08/addressing";
    private PolicyStatement policy;
    private MsgHeaders refProperties = new FreeStandingMsgHeaders();
    private MsgHeaders refParameters = new FreeStandingMsgHeaders();
    private MetadataHeaders metadata = new MetadataHeaders();
    private transient Element endptElement;

    public EndpointReference() {
    }

    public EndpointReference(String string) {
        this.address = string;
    }

    public EndpointReference(String string, String string2) {
        this.address = string;
        this.portType = string2;
    }

    public String getPortType() {
        return this.portType;
    }

    public void setPortType(String string) {
        this.portType = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setServiceName(String string, String string2) {
        this.serviceName = string;
        this.portName = string2;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public void setNamespaceURI(String string) {
        this.namespaceURI = string;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setPolicy(PolicyStatement policyStatement) {
        this.policy = policyStatement;
    }

    public PolicyStatement getPolicy() {
        return this.policy;
    }

    public MsgHeaders getReferenceProperties() {
        return this.refProperties;
    }

    public void setReferenceProperties(FreeStandingMsgHeaders freeStandingMsgHeaders) {
        this.refProperties = freeStandingMsgHeaders;
    }

    public MsgHeaders getReferenceParameters() {
        return this.refParameters;
    }

    public void setReferenceParameters(FreeStandingMsgHeaders freeStandingMsgHeaders) {
        this.refParameters = freeStandingMsgHeaders;
    }

    public MetadataHeaders getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataHeaders metadataHeaders) {
        this.metadata = metadataHeaders;
    }

    public Element getEndptElement() {
        return this.endptElement;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        toStringWriter.writeField("namespace", this.namespaceURI);
        toStringWriter.writeField("address", this.address);
        toStringWriter.writeField("portType", this.portType);
        toStringWriter.writeField("portName", this.portName);
        toStringWriter.writeField("serviceName", this.serviceName);
        toStringWriter.writeField("refProperties", this.refProperties);
        toStringWriter.writeField("refParameters", this.refParameters);
        toStringWriter.writeField("metadata", this.metadata);
        toStringWriter.writeField("policy", this.policy);
        return toStringWriter.toString();
    }

    public void read(Element element) throws MsgHeaderException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            this.address = DOMUtils.getOptionalValueByTagNameNS(element, this.namespaceURI, "Address");
            if (this.address == null || this.address.length() == 0) {
                this.address = DOMUtils.getOptionalValueByTagNameNS(element, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address");
                this.namespaceURI = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
            }
            if (this.address == null || this.address.length() == 0) {
                throw new MsgHeaderException("Empty address is not allowed.");
            }
            Element element2 = DOMUtils.getOptionalElementByTagNameNS(element, this.namespaceURI, "ServiceName");
            if (element2 != null) {
                this.serviceName = DOMUtils.getTextData(element2);
                this.portName = element2.getAttribute("PortName");
            }
            this.portType = DOMUtils.getOptionalValueByTagNameNS(element, this.namespaceURI, "PortType");
            Element element3 = DOMUtils.getOptionalElementByTagNameNS(element, this.namespaceURI, "ReferenceProperties");
            if (element3 != null) {
                SoapMsgHeaders soapMsgHeaders = new SoapMsgHeaders(element3);
                object4 = soapMsgHeaders.listHeaders();
                while (object4.hasNext()) {
                    object3 = (MsgHeader)object4.next();
                    this.refProperties.addHeader((MsgHeader)object3);
                }
            }
            boolean bl = this.isWSA10();
            object4 = DOMUtils.getOptionalElementByTagNameNS(element, this.namespaceURI, "ReferenceParameters");
            if (object4 != null) {
                object3 = new SoapMsgHeaders((Element)object4);
                object2 = object3.listHeaders();
                while (object2.hasNext()) {
                    object = (MsgHeader)object2.next();
                    ((MsgHeader)object).setRefParam(bl);
                    this.refParameters.addHeader((MsgHeader)object);
                }
            }
            if (bl && (object3 = DOMUtils.getOptionalElementByTagNameNS(element, this.namespaceURI, "Metadata")) != null) {
                object2 = new SoapMsgHeaders((Element)object3);
                object = object2.listHeaders();
                while (object.hasNext()) {
                    MsgHeader msgHeader = (MsgHeader)object.next();
                    this.metadata.addHeader(msgHeader);
                }
            }
            if ((object3 = DOMUtils.getOptionalElementByTagNameNS(element, "http://schemas.xmlsoap.org/ws/2002/12/policy", "Policy")) != null) {
                this.policy = PolicyFinder.readPolicyStatementFromNode((Node)object3);
            }
            this.endptElement = element;
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new MsgHeaderException("Could not parse endpoint reference", (Throwable)((Object)dOMProcessingException));
        }
        catch (PolicyException policyException) {
            throw new MsgHeaderException("Could not read policy", policyException);
        }
    }

    public void write(Element element) throws MsgHeaderException {
        MsgHeader msgHeader;
        Iterator iterator;
        Element element2;
        if (element.getPrefix() == null || !element.getPrefix().equals("wsa")) {
            DOMUtils.addNamespaceDeclaration(element, "wsa", this.namespaceURI);
        }
        DOMUtils.addValueNS(element, this.namespaceURI, "wsa:Address", this.address);
        if (this.serviceName != null) {
            element2 = DOMUtils.addValueNS(element, this.namespaceURI, "wsa:ServiceName", this.serviceName);
            if (this.portName != null) {
                element2.setAttribute("PortName", this.portName);
            }
        }
        if (this.portType != null) {
            DOMUtils.addValueNS(element, this.namespaceURI, "wsa:PortType", this.portType);
        }
        if (!this.refProperties.isEmpty()) {
            element2 = element.getOwnerDocument().createElementNS(this.namespaceURI, "wsa:ReferenceProperties");
            iterator = this.refProperties.listHeaders();
            while (iterator.hasNext()) {
                msgHeader = (MsgHeader)iterator.next();
                msgHeader.writeToParent(element2);
            }
            element.appendChild(element2);
        }
        if (!this.refParameters.isEmpty()) {
            element2 = element.getOwnerDocument().createElementNS(this.namespaceURI, "wsa:ReferenceParameters");
            iterator = this.refParameters.listHeaders();
            while (iterator.hasNext()) {
                msgHeader = (MsgHeader)iterator.next();
                msgHeader.writeToParent(element2);
            }
            element.appendChild(element2);
        }
        if (this.metadata != null && !this.metadata.isEmpty() && this.isWSA10()) {
            element2 = element.getOwnerDocument().createElementNS(this.namespaceURI, "wsa:Metadata");
            iterator = this.metadata.listHeaders();
            while (iterator.hasNext()) {
                msgHeader = (MsgHeader)iterator.next();
                msgHeader.writeToParent(element2);
            }
            element.appendChild(element2);
        }
        if (this.policy != null) {
            try {
                element2 = this.policy.toXML();
                element.appendChild(element2);
            }
            catch (PolicyException policyException) {
                throw new MsgHeaderException("Unable to read policy", policyException);
            }
        }
    }

    private boolean isWSA10() {
        return "http://www.w3.org/2005/08/addressing".equals(this.namespaceURI);
    }
}

