/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing;

import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.addressing.AddressingHeader;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class MessageIdHeader
extends MsgHeader
implements AddressingHeader {
    private static final long serialVersionUID = 5008941738536940940L;
    private QName name = WSAddressingConstants.WSA_HEADER_MESSAGE_ID_10;
    public static final MsgHeaderType TYPE = new MsgHeaderType();
    private String messageId;

    public MessageIdHeader(String string) {
        this.messageId = string;
    }

    public MessageIdHeader(String string, QName qName) {
        this.messageId = string;
        this.name = qName;
    }

    public MessageIdHeader() {
    }

    public MessageIdHeader(QName qName) {
        this.name = qName;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName qName) {
        this.name = qName;
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String string) {
        this.messageId = string;
    }

    public void read(Element element) throws MsgHeaderException {
        try {
            this.messageId = DOMUtils.getTextData(element);
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new MsgHeaderException("Could not get messageId", (Throwable)((Object)dOMProcessingException));
        }
    }

    public void write(Element element) throws MsgHeaderException {
        DOMUtils.addTextData(element, this.messageId);
    }

    public void toString(ToStringWriter toStringWriter) {
        super.toString(toStringWriter);
        toStringWriter.writeField("messageId", this.messageId);
    }
}

