/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing;

import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.addressing.AddressingHeader;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class RelatesToHeader
extends MsgHeader
implements AddressingHeader {
    private static final long serialVersionUID = 1127182093303253908L;
    public QName name = WSAddressingConstants.WSA_HEADER_RELATES_TO_10;
    public static final MsgHeaderType TYPE = new MsgHeaderType();
    private String relatedMessageId;
    private QName relationshipType;

    public RelatesToHeader(String string, QName qName) {
        this.relatedMessageId = string;
        this.relationshipType = qName;
    }

    public RelatesToHeader(String string, QName qName, QName qName2) {
        this.relatedMessageId = string;
        this.relationshipType = qName;
        this.name = qName2;
    }

    public RelatesToHeader() {
    }

    public RelatesToHeader(QName qName) {
        this.name = qName;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName qName) {
        this.name = qName;
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public QName getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(QName qName) {
        this.relationshipType = qName;
    }

    public String getRelatedMessageId() {
        return this.relatedMessageId;
    }

    public void setRelatedMessageId(String string) {
        this.relatedMessageId = string;
    }

    public void read(Element element) throws MsgHeaderException {
        try {
            this.relatedMessageId = DOMUtils.getTextData(element);
            String string = element.getAttributeNS(this.name.getNamespaceURI(), "RelationshipType");
            int n = string.indexOf(58);
            if (n != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                String string4 = DOMUtils.getNamespaceURI(element, string2);
                this.relationshipType = new QName(string4, string3, string2);
            } else {
                this.relationshipType = QName.valueOf(string);
            }
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new MsgHeaderException("Could not parse the relatesTo header", (Throwable)((Object)dOMProcessingException));
        }
    }

    public void write(Element element) throws MsgHeaderException {
        DOMUtils.addTextData(element, this.relatedMessageId);
        if (this.relationshipType == null && this.name != null && "http://www.w3.org/2005/08/addressing".equals(this.name.getNamespaceURI())) {
            DOMUtils.addNamespaceDeclaration(element, "wsa", "http://www.w3.org/2005/08/addressing");
            element.setAttributeNS(this.name.getNamespaceURI(), "wsa:RelationshipType", "http://www.w3.org/2005/08/addressing/reply");
        } else {
            DOMUtils.addNamespaceDeclaration(element, this.relationshipType.getPrefix(), this.relationshipType.getNamespaceURI());
            element.setAttributeNS(this.name.getNamespaceURI(), "wsa:RelationshipType", this.relationshipType.getPrefix() + ":" + this.relationshipType.getLocalPart());
        }
    }
}

