/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPException;
import weblogic.protocol.LocalServerIdentity;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.addressing.AddressingHandler;
import weblogic.wsee.addressing.AddressingHeaderException;
import weblogic.wsee.addressing.AddressingHelper;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.CallbackToHeader;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.FaultDetailHeader;
import weblogic.wsee.addressing.FaultToHeader;
import weblogic.wsee.addressing.FromHeader;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.addressing.RelatesToHeader;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.addressing.ToHeader;
import weblogic.wsee.addressing.policy.api.UsingAddressingPolicyInfo;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.cluster.ServiceIdentityHeader;
import weblogic.wsee.connection.transport.jms.JMSServerTransport;
import weblogic.wsee.connection.transport.jms.JmsServerQueueTransport;
import weblogic.wsee.connection.transport.jms.JmsTransport;
import weblogic.wsee.connection.transport.servlet.HttpServerTransport;
import weblogic.wsee.connection.transport.servlet.HttpTransportUtils;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.jaxrpc.soapfault.WLSOAPFaultException;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMsgHeaders;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.util.AddressingUtil;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.HeaderUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsa.wsaddressing.WSAVersion;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;

public final class ServerAddressingHandler
extends AddressingHandler {
    private static final boolean verbose = Verbose.isVerbose(ServerAddressingHandler.class);
    public static final String SERVER_ENDPOINT = "weblogic.wsee.addressing.ServerEndpoint";
    public static final String HAS_WSA_EXCEPTION = "weblogic.wsee.addressing.server.hasexception";

    public boolean handleRequest(MessageContext messageContext) {
        CallbackToHeader callbackToHeader;
        RelatesToHeader relatesToHeader;
        ActionHeader actionHeader;
        MessageIdHeader messageIdHeader;
        FaultToHeader faultToHeader;
        ReplyToHeader replyToHeader;
        MsgHeader msgHeader;
        Object object;
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        if (verbose) {
            Verbose.log("Looking for WS-Addressing headers");
        }
        this.setWSAVersion(wlMessageContext);
        this.validateWSAVersion(wlMessageContext);
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
        String string = null;
        EndpointReference endpointReference = null;
        if (wlMessageContext.getDispatcher() != null) {
            object = wlMessageContext.getDispatcher().getConnection().getTransport();
            string = (String)wlMessageContext.getProperty("weblogic.wsee.connection.end_point_address");
            if (string == null) {
                string = wlMessageContext.getDispatcher().getConnection().getTransport().getEndpointAddress();
            }
            if (verbose) {
                Verbose.say("ServerAddressingHandler calculating SERVER_ENDPOINT property from transport endpoint addr: " + string);
            }
            if (string != null) {
                try {
                    Object object2;
                    String string2;
                    String string3;
                    if (object instanceof JMSServerTransport || object instanceof JmsTransport || object instanceof JmsServerQueueTransport) {
                        string3 = "jms";
                        string2 = string;
                    } else if (object instanceof HttpServerTransport) {
                        object2 = HttpTransportUtils.getHttpServletRequest(wlMessageContext);
                        string3 = object2.getScheme();
                        string2 = object.getServiceURI();
                    } else {
                        string3 = "http";
                        string2 = string;
                    }
                    object2 = null;
                    if (object instanceof HttpServerTransport && ServerUtil.useReqHostAlways) {
                        boolean bl = string3.equals("https");
                        object2 = ServerUtil.getHTTPServerURL(bl, HttpTransportUtils.getHttpServletRequest(wlMessageContext));
                    } else {
                        object2 = ServerUtil.getServerURL(string3);
                    }
                    if (((String)object2).endsWith("/")) {
                        object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                    }
                    if (!string2.startsWith("/")) {
                        string2 = "/" + string2;
                    }
                    string = (String)object2 + string2;
                    endpointReference = addressingProvider.createEndpointReference(string);
                    msgHeader = new ServiceIdentityHeader();
                    ((ServiceIdentityHeader)msgHeader).setServerName(LocalServerIdentity.getIdentity().getServerName());
                    ((ServiceIdentityHeader)msgHeader).setServiceName("weblogic.wsee.conversation.msg.cluster.service");
                    endpointReference.getReferenceParameters().addHeader(msgHeader);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString(), exception);
                }
            }
            messageContext.setProperty(SERVER_ENDPOINT, endpointReference);
            if (verbose) {
                Verbose.say("ServerAddressingHandler finished calculating SERVER_ENDPOINT as: " + endpointReference);
            }
        }
        object = wlMessageContext.getHeaders();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        msgHeader = (ToHeader)object.getHeader(ToHeader.TYPE);
        if (msgHeader != null) {
            bl = true;
            bl2 = true;
            messageContext.setProperty("weblogic.wsee.addressing.To", (Object)((ToHeader)msgHeader).getAddress());
            HeaderUtil.removeMustUnderstandFromHeader(msgHeader, sOAPMessageContext.getMessage());
        } else {
            if (string != null) {
                messageContext.setProperty("weblogic.wsee.addressing.To", (Object)string);
            } else {
                messageContext.setProperty("weblogic.wsee.addressing.To", (Object)addressingProvider.getAnonymousNamespaceURI());
            }
            if (WSAVersion.WSA10.equals((Object)addressingProvider.getWSAVersion())) {
                msgHeader = addressingProvider.createToHeader(addressingProvider.getAnonymousNamespaceURI());
                bl2 = true;
            }
        }
        boolean bl4 = false;
        boolean bl5 = false;
        FromHeader fromHeader = (FromHeader)object.getHeader(FromHeader.TYPE);
        if (fromHeader != null) {
            HeaderUtil.removeMustUnderstandFromHeader(fromHeader, sOAPMessageContext.getMessage());
            bl = true;
            messageContext.setProperty("weblogic.wsee.addressing.From", (Object)fromHeader.getReference());
            if (addressingProvider.isAnonymousReferenceURI(fromHeader.getReference().getAddress())) {
                messageContext.setProperty("weblogic.wsee.from.anonymous", (Object)"true");
                bl4 = true;
            }
        } else {
            messageContext.setProperty("weblogic.wsee.addressing.From", (Object)addressingProvider.createAnonymousEndpointReference());
            messageContext.setProperty("weblogic.wsee.from.anonymous", (Object)"true");
            bl4 = true;
        }
        if ((replyToHeader = (ReplyToHeader)object.getHeader(ReplyToHeader.TYPE)) != null) {
            HeaderUtil.removeMustUnderstandFromHeader(replyToHeader, sOAPMessageContext.getMessage());
            bl = true;
            messageContext.setProperty("weblogic.wsee.addressing.ReplyTo", (Object)replyToHeader.getReference());
            if (addressingProvider.isAnonymousReferenceURI(replyToHeader.getReference().getAddress())) {
                messageContext.setProperty("weblogic.wsee.reply.anonymous", (Object)"true");
                bl5 = true;
            }
        } else if (bl4) {
            messageContext.setProperty("weblogic.wsee.addressing.ReplyTo", (Object)addressingProvider.createAnonymousEndpointReference());
            messageContext.setProperty("weblogic.wsee.reply.anonymous", (Object)"true");
            bl5 = true;
        } else {
            messageContext.setProperty("weblogic.wsee.addressing.ReplyTo", (Object)fromHeader.getReference());
        }
        if ((faultToHeader = (FaultToHeader)object.getHeader(FaultToHeader.TYPE)) != null) {
            HeaderUtil.removeMustUnderstandFromHeader(faultToHeader, sOAPMessageContext.getMessage());
            bl = true;
            messageContext.setProperty("weblogic.wsee.addressing.FaultTo", (Object)faultToHeader.getReference());
            if (addressingProvider.getAnonymousNamespaceURI().equals(faultToHeader.getReference().getAddress())) {
                messageContext.setProperty("weblogic.wsee.fault.anonymous", (Object)"true");
            }
        } else if (replyToHeader != null) {
            messageContext.setProperty("weblogic.wsee.addressing.FaultTo", (Object)replyToHeader.getReference());
            if (bl5) {
                messageContext.setProperty("weblogic.wsee.fault.anonymous", (Object)"true");
            }
        } else if (fromHeader != null) {
            messageContext.setProperty("weblogic.wsee.addressing.FaultTo", (Object)fromHeader.getReference());
            if (bl4) {
                messageContext.setProperty("weblogic.wsee.fault.anonymous", (Object)"true");
            }
        } else {
            messageContext.setProperty("weblogic.wsee.addressing.FaultTo", (Object)addressingProvider.createAnonymousEndpointReference());
            messageContext.setProperty("weblogic.wsee.fault.anonymous", (Object)"true");
        }
        if ((messageIdHeader = (MessageIdHeader)object.getHeader(MessageIdHeader.TYPE)) != null) {
            HeaderUtil.removeMustUnderstandFromHeader(messageIdHeader, sOAPMessageContext.getMessage());
            bl = true;
            messageContext.setProperty("weblogic.wsee.addressing.MessageId", (Object)messageIdHeader.getMessageId());
        }
        if (bl) {
            messageContext.setProperty("weblogic.wsee.complex", (Object)"true");
            this.checkDuplicatedAddressingHeader(wlMessageContext);
        }
        if ((actionHeader = (ActionHeader)object.getHeader(ActionHeader.TYPE)) != null) {
            HeaderUtil.removeMustUnderstandFromHeader(actionHeader, sOAPMessageContext.getMessage());
            bl = true;
            bl3 = true;
            messageContext.setProperty("weblogic.wsee.addressing.Action", (Object)actionHeader.getActionURI());
        }
        if ((relatesToHeader = (RelatesToHeader)object.getHeader(RelatesToHeader.TYPE)) != null) {
            HeaderUtil.removeMustUnderstandFromHeader(relatesToHeader, sOAPMessageContext.getMessage());
            bl = true;
            messageContext.setProperty("weblogic.wsee.addressing.RelatesTo", (Object)relatesToHeader.getRelatedMessageId());
        }
        if (bl) {
            if (!bl2) {
                throw new AddressingHeaderException(addressingProvider.getMessageAddressingHeaderRequiredReason(), "To", addressingProvider.getMessageAddressingHeaderRequiredFaultQName());
            }
            if (!bl3) {
                throw new AddressingHeaderException(addressingProvider.getMessageAddressingHeaderRequiredReason(), "Action", addressingProvider.getMessageAddressingHeaderRequiredFaultQName());
            }
        }
        if ((callbackToHeader = (CallbackToHeader)object.getHeader(CallbackToHeader.TYPE)) != null) {
            HeaderUtil.removeMustUnderstandFromHeader(callbackToHeader, sOAPMessageContext.getMessage());
            messageContext.setProperty("weblogic.wsee.addressing.CallbackTo", (Object)callbackToHeader.getReference());
        }
        if (verbose) {
            if (msgHeader != null) {
                Verbose.log("<To> " + ((ToHeader)msgHeader).getAddress());
            }
            if (fromHeader != null) {
                Verbose.log("<From> " + fromHeader.getReference());
            }
            if (replyToHeader != null) {
                Verbose.log("<ReplyTo> " + replyToHeader.getReference());
            }
            if (faultToHeader != null) {
                Verbose.log("<FaultTo> " + faultToHeader.getReference());
            }
            if (actionHeader != null) {
                Verbose.log("<Action> " + actionHeader.getActionURI());
            }
            if (messageIdHeader != null) {
                Verbose.log("<MessageId> " + messageIdHeader.getMessageId());
            }
            if (callbackToHeader != null) {
                Verbose.log("<CallbackTo> " + callbackToHeader.getReference());
            }
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (messageContext.getProperty("weblogic.wsee.complex") == null) {
            return true;
        }
        if (messageContext.getProperty("weblogic.wsee.reliable.oneway.reply") != null) {
            return true;
        }
        return this.handleOutbound(WlMessageContext.narrow(messageContext), (EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.ReplyTo"));
    }

    public boolean handleFault(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        if (messageContext.getProperty("weblogic.wsee.complex") == null) {
            return true;
        }
        EndpointReference endpointReference = (EndpointReference)messageContext.getProperty("weblogic.wsee.faultto.override");
        if (endpointReference == null) {
            endpointReference = (EndpointReference)messageContext.getProperty("weblogic.wsee.addressing.FaultTo");
        }
        if (endpointReference == null) {
            return true;
        }
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(messageContext);
        boolean bl = addressingProvider.isAnonymousReferenceURI(endpointReference.getAddress());
        if (bl && wlMessageContext.getProperty("weblogic.wsee.oneway.confirmed") != null) {
            return false;
        }
        Throwable throwable = wlMessageContext.getFault();
        if (throwable instanceof AddressingHeaderException) {
            AddressingHeaderException addressingHeaderException = (AddressingHeaderException)((Object)throwable);
            this.convertToWSAFault(addressingHeaderException, wlMessageContext);
        } else {
            this.addFaultActionHeader(wlMessageContext);
        }
        return this.handleOutbound(wlMessageContext, endpointReference);
    }

    private boolean handleOutbound(WlMessageContext wlMessageContext, EndpointReference endpointReference) {
        MsgHeader msgHeader;
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
        ActionHeader actionHeader = (ActionHeader)wlMessageContext.getHeaders().getHeader(ActionHeader.TYPE);
        if (actionHeader == null) {
            wlMessageContext.removeProperty("weblogic.wsee.addressing.Action");
            actionHeader = wlMessageContext.hasFault() ? addressingProvider.createFaultActionHeader() : addressingProvider.createActionHeader(this.getActionURI(wlMessageContext, false));
            wlMessageContext.getHeaders().addHeader(actionHeader);
        }
        String string = AddressingUtil.wrapSOAPAction(actionHeader.getActionURI());
        this.setSoapActionHeader(wlMessageContext, string);
        MessageIdHeader messageIdHeader = (MessageIdHeader)wlMessageContext.getHeaders().getHeader(MessageIdHeader.TYPE);
        MessageIdHeader messageIdHeader2 = addressingProvider.createMessageIdHeader(Guid.generateGuid());
        if (messageIdHeader != null) {
            ((SoapMsgHeaders)wlMessageContext.getHeaders()).replaceHeader(messageIdHeader2);
        } else {
            wlMessageContext.getHeaders().addHeader(messageIdHeader2);
        }
        this.addRelatesToHeader(wlMessageContext);
        ToHeader toHeader = (ToHeader)wlMessageContext.getHeaders().getHeader(ToHeader.TYPE);
        ToHeader toHeader2 = addressingProvider.createToHeader(endpointReference.getAddress());
        if (toHeader != null) {
            ((SoapMsgHeaders)wlMessageContext.getHeaders()).replaceHeader(toHeader2);
        } else {
            wlMessageContext.getHeaders().addHeader(toHeader2);
        }
        wlMessageContext.setProperty("javax.xml.rpc.service.endpoint.address", toHeader2.getAddress());
        Iterator iterator = endpointReference.getReferenceProperties().listHeaders();
        while (iterator.hasNext()) {
            msgHeader = (MsgHeader)iterator.next();
            if (wlMessageContext.getHeaders().getHeader(msgHeader.getType()) != null) {
                ((SoapMsgHeaders)wlMessageContext.getHeaders()).replaceHeader(msgHeader);
                continue;
            }
            wlMessageContext.getHeaders().addHeader(msgHeader);
        }
        iterator = endpointReference.getReferenceParameters().listHeaders();
        while (iterator.hasNext()) {
            msgHeader = (MsgHeader)iterator.next();
            if (!WSAVersion.MemberSubmission.equals((Object)addressingProvider.getWSAVersion())) {
                msgHeader.setRefParam(true);
            }
            if (wlMessageContext.getHeaders().getHeader(msgHeader.getType()) != null) {
                ((SoapMsgHeaders)wlMessageContext.getHeaders()).replaceHeader(msgHeader);
                continue;
            }
            wlMessageContext.getHeaders().addHeader(msgHeader);
        }
        return true;
    }

    private void addRelatesToHeader(WlMessageContext wlMessageContext) {
        String string = (String)wlMessageContext.getProperty("weblogic.wsee.addressing.MessageId");
        if (string != null) {
            RelatesToHeader relatesToHeader = (RelatesToHeader)wlMessageContext.getHeaders().getHeader(RelatesToHeader.TYPE);
            AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
            QName qName = "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingProvider.getNamespaceURI()) ? WSAddressingConstants.WSA_RESPONSE : null;
            RelatesToHeader relatesToHeader2 = addressingProvider.createRelatesToHeader(string, qName);
            if (relatesToHeader != null) {
                ((SoapMsgHeaders)wlMessageContext.getHeaders()).replaceHeader(relatesToHeader2);
            } else {
                wlMessageContext.getHeaders().addHeader(relatesToHeader2);
            }
        }
    }

    protected void validateWSAVersion(WlMessageContext wlMessageContext) {
        UsingAddressingPolicyInfo usingAddressingPolicyInfo = this.getAddressingPolicyInfo(wlMessageContext);
        if (usingAddressingPolicyInfo == null || usingAddressingPolicyInfo.getUsingAddressingWSAVersionInfo() == null) {
            return;
        }
        WSAVersion wSAVersion = (WSAVersion)((Object)wlMessageContext.getProperty("weblogic.wsee.addressing.version"));
        if (wSAVersion == null) {
            wSAVersion = WSAVersion.WSA10;
        }
        if (usingAddressingPolicyInfo.isValidWSAVersion(wSAVersion)) {
            return;
        }
        throw SOAPFaultUtil.newWLSOAPFaultException((MessageContext)wlMessageContext, "Client", "Sender", "The WS-Addressing version of incoming request does not matched with the WS-Addresssing version which defines with UsingAddressing Policy in WSDL!", null, null, new QName[0]);
    }

    protected void checkDuplicatedAddressingHeader(WlMessageContext wlMessageContext) {
        MsgHeaders msgHeaders = wlMessageContext.getHeaders();
        ActionHeader actionHeader = (ActionHeader)msgHeaders.getHeader(ActionHeader.TYPE);
        if (actionHeader != null && actionHeader.hasDuplicated()) {
            throw this.newCardinalityAddressingHeaderException(wlMessageContext, "Action");
        }
        ToHeader toHeader = (ToHeader)msgHeaders.getHeader(ToHeader.TYPE);
        if (toHeader != null && toHeader.hasDuplicated()) {
            throw this.newCardinalityAddressingHeaderException(wlMessageContext, "To");
        }
        MessageIdHeader messageIdHeader = (MessageIdHeader)msgHeaders.getHeader(MessageIdHeader.TYPE);
        if (messageIdHeader != null && messageIdHeader.hasDuplicated()) {
            throw this.newCardinalityAddressingHeaderException(wlMessageContext, "MessageID");
        }
        ReplyToHeader replyToHeader = (ReplyToHeader)msgHeaders.getHeader(ReplyToHeader.TYPE);
        if (replyToHeader != null && replyToHeader.hasDuplicated()) {
            throw this.newCardinalityAddressingHeaderException(wlMessageContext, "ReplyTo");
        }
        FaultToHeader faultToHeader = (FaultToHeader)msgHeaders.getHeader(FaultToHeader.TYPE);
        if (faultToHeader != null && faultToHeader.hasDuplicated()) {
            wlMessageContext.setProperty("weblogic.wsee.addressing.FaultTo", AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext).createAnonymousEndpointReference());
            throw this.newCardinalityAddressingHeaderException(wlMessageContext, "FaultTo");
        }
    }

    private AddressingHeaderException newCardinalityAddressingHeaderException(WlMessageContext wlMessageContext, String string) {
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
        return new AddressingHeaderException("A header representing a Message Addressing Property is not valid and the message cannot be processed!", string, addressingProvider.getInvalidAddressingHeaderFaultQName(), WSAddressingConstants.WSA_INVALID_CARDINALITY);
    }

    private void setWSAVersion(WlMessageContext wlMessageContext) {
        ToHeader toHeader;
        MsgHeaders msgHeaders = wlMessageContext.getHeaders();
        wlMessageContext.removeProperty("weblogic.wsee.addressing.version");
        ActionHeader actionHeader = (ActionHeader)msgHeaders.getHeader(ActionHeader.TYPE);
        if (actionHeader != null) {
            if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(actionHeader.getName().getNamespaceURI())) {
                wlMessageContext.setProperty("weblogic.wsee.addressing.version", (Object)WSAVersion.MemberSubmission);
                return;
            }
            if ("http://www.w3.org/2005/08/addressing".equals(actionHeader.getName().getNamespaceURI())) {
                return;
            }
        }
        if ((toHeader = (ToHeader)msgHeaders.getHeader(ToHeader.TYPE)) != null && "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(toHeader.getName().getNamespaceURI())) {
            wlMessageContext.setProperty("weblogic.wsee.addressing.version", (Object)WSAVersion.MemberSubmission);
            return;
        }
    }

    private void convertToWSAFault(AddressingHeaderException addressingHeaderException, WlMessageContext wlMessageContext) {
        if (addressingHeaderException == null) {
            return;
        }
        boolean bl = AsyncUtil.isSoap12(wlMessageContext);
        if (bl) {
            WLSOAPFaultException wLSOAPFaultException = SOAPFaultUtil.newWLSOAP12FaultException(addressingHeaderException.getFaultCode().getLocalPart(), addressingHeaderException.getFaultString(), null, null, addressingHeaderException.getHeaderFaultCode());
            QName qName = WSAVersion.MemberSubmission.equals((Object)AddressingHelper.getWSAVersion(wlMessageContext)) ? WSAddressingConstants.WSA_HEADER_PROBLEM_HEADER_QNAME : WSAddressingConstants.WSA_HEADER_PROBLEM_HEADER_QNAME_10;
            Detail detail = SOAPFaultUtil.createDetail(qName, "wsa:" + addressingHeaderException.getFaultHeader(), bl);
            try {
                SOAPFaultUtil.fillSoapDetail(detail, wLSOAPFaultException.getFault());
            }
            catch (SOAPException sOAPException) {
                Verbose.logException(sOAPException);
            }
            wlMessageContext.setFault((Throwable)((Object)wLSOAPFaultException));
        } else {
            QName qName = null;
            if (addressingHeaderException.getHeaderFaultCode() != null && addressingHeaderException.getHeaderFaultCode().length > 0) {
                qName = addressingHeaderException.getHeaderFaultCode()[0];
            }
            WLSOAPFaultException wLSOAPFaultException = SOAPFaultUtil.newWLSOAP11FaultException(qName, addressingHeaderException.getFaultString(), null, null);
            wlMessageContext.setFault((Throwable)((Object)wLSOAPFaultException));
            this.addFaultActionHeader(wlMessageContext);
            FaultDetailHeader faultDetailHeader = AddressingHelper.getAddressingProvider(wlMessageContext).createFaultDetailHeader();
            faultDetailHeader.setProblemHeader(AddressingHelper.getAddressingProvider(wlMessageContext).createProblemHeaderQNameHeader("wsa:" + addressingHeaderException.getFaultHeader()));
            wlMessageContext.getHeaders().addHeader(faultDetailHeader);
        }
    }

    private void addFaultActionHeader(WlMessageContext wlMessageContext) {
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
        ActionHeader actionHeader = addressingProvider.createActionHeader(addressingProvider.getFaultActionUri());
        if (wlMessageContext.getHeaders().getHeader(ActionHeader.TYPE) == null) {
            wlMessageContext.getHeaders().addHeader(actionHeader);
        }
    }
}

