/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing;

import com.bea.xml.XmlDateTime;
import com.bea.xml.XmlException;
import java.util.Date;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.wsee.wsa.wsutility.WSUtilityConstants;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class TimestampHeader
extends MsgHeader {
    public static final QName NAME = WSUtilityConstants.WSU_HEADER_TIMESTAMP;
    public static final MsgHeaderType TYPE = new MsgHeaderType();
    private Date creationTime;
    private Date expirationTime;

    public TimestampHeader(Date date) {
        this.creationTime = date;
    }

    public TimestampHeader(Date date, Date date2) {
        this.creationTime = date;
        this.expirationTime = date2;
    }

    public TimestampHeader() {
    }

    public QName getName() {
        return NAME;
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date date) {
        this.creationTime = date;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date date) {
        this.expirationTime = date;
    }

    public void read(Element element) throws MsgHeaderException {
        try {
            this.creationTime = this.readDateTime(element, "Created");
            this.expirationTime = this.readDateTime(element, "Expires");
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new MsgHeaderException("Could not parse the timestamp header", (Throwable)((Object)dOMProcessingException));
        }
        catch (XmlException xmlException) {
            throw new MsgHeaderException("Ill-formed dateTime in timestamp", xmlException);
        }
    }

    private Date readDateTime(Element element, String string) throws DOMProcessingException, XmlException {
        String string2 = DOMUtils.getOptionalValueByTagNameNS(element, "http://schemas.xmlsoap.org/ws/2002/07/utility", string);
        if (string2 != null) {
            XmlDateTime xmlDateTime = XmlDateTime.Factory.newInstance();
            xmlDateTime.setStringValue(string2);
            return xmlDateTime.getDateValue();
        }
        return null;
    }

    public void write(Element element) throws MsgHeaderException {
        if (this.creationTime != null) {
            this.writeDateTime(element, "Created", this.creationTime);
        }
        if (this.expirationTime != null) {
            this.writeDateTime(element, "Expires", this.expirationTime);
        }
    }

    private void writeDateTime(Element element, String string, Date date) {
        XmlDateTime xmlDateTime = XmlDateTime.Factory.newInstance();
        xmlDateTime.setDateValue(date);
        DOMUtils.addValueNS(element, "http://schemas.xmlsoap.org/ws/2002/07/utility", string, xmlDateTime.getStringValue());
    }
}

