/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing.policy.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.wsee.addressing.policy.api.UsingAddressingPolicyInfo;
import weblogic.wsee.addressing.policy.api.UsingAddressingVersionInfo;
import weblogic.wsee.addressing.policy.internal.WSAUsingAddressingAssertion;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.wsa.wsaddressing.WSAVersion;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsingAddressingPolicyInfoImpl
implements UsingAddressingPolicyInfo {
    private Set<UsingAddressingVersionInfo> allWSAVersionInfo = null;
    private UsingAddressingVersionInfo selectedWSAVersionInfo = null;

    public UsingAddressingPolicyInfoImpl() {
    }

    public UsingAddressingPolicyInfoImpl(NormalizedExpression normalizedExpression) {
        Set set = normalizedExpression.getPolicyAlternatives();
        if (set != null) {
            this.allWSAVersionInfo = new HashSet<UsingAddressingVersionInfo>();
            for (PolicyAlternative policyAlternative : set) {
                Set set2 = policyAlternative.getAssertions(WSAUsingAddressingAssertion.class);
                if (set2 == null) continue;
                for (WSAUsingAddressingAssertion wSAUsingAddressingAssertion : set2) {
                    WSAVersion wSAVersion = this.getWSAVersionByPolicyNamespace(wSAUsingAddressingAssertion.getName().getNamespaceURI());
                    this.allWSAVersionInfo.add(new UsingAddressingVersionInfo(wSAVersion, wSAUsingAddressingAssertion.isRequired()));
                }
            }
            this.selectedWSAVersionInfo = this.selectUsingAddressingVersionInfo(this.allWSAVersionInfo);
        }
    }

    protected UsingAddressingVersionInfo selectUsingAddressingVersionInfo(Set<UsingAddressingVersionInfo> set) {
        if (set == null || set.size() < 1) {
            return null;
        }
        UsingAddressingVersionInfo usingAddressingVersionInfo = null;
        Iterator<UsingAddressingVersionInfo> iterator = set.iterator();
        while (iterator.hasNext()) {
            UsingAddressingVersionInfo usingAddressingVersionInfo2;
            usingAddressingVersionInfo = usingAddressingVersionInfo2 = iterator.next();
            if (!WSAVersion.WSA10.equals((Object)usingAddressingVersionInfo2.getWSAVersion())) continue;
            break;
        }
        return usingAddressingVersionInfo;
    }

    @Override
    public UsingAddressingVersionInfo getUsingAddressingWSAVersionInfo() {
        return this.selectedWSAVersionInfo;
    }

    @Override
    public boolean isValidWSAVersion(WSAVersion wSAVersion) {
        if (wSAVersion == null) {
            return false;
        }
        if (this.selectedWSAVersionInfo == null || this.allWSAVersionInfo == null) {
            return true;
        }
        if (wSAVersion.equals((Object)this.selectedWSAVersionInfo.getWSAVersion())) {
            return true;
        }
        for (UsingAddressingVersionInfo usingAddressingVersionInfo : this.allWSAVersionInfo) {
            if (!wSAVersion.equals((Object)usingAddressingVersionInfo.getWSAVersion())) continue;
            return true;
        }
        return false;
    }

    private WSAVersion getWSAVersionByPolicyNamespace(String string) {
        if (WSAddressingConstants.WSAW_QNAME.getNamespaceURI().equals(string)) {
            return WSAVersion.MemberSubmission;
        }
        if (WSAddressingConstants.WSAW_QNAME_10.getNamespaceURI().equals(string)) {
            return WSAVersion.WSA10;
        }
        return null;
    }
}

