/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing.policy.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;

public class WSAUsingAddressingAssertion
extends PolicyAssertion {
    public QName name = WSAddressingConstants.WSAW_QNAME_10;
    private boolean isRequired = false;

    public WSAUsingAddressingAssertion(QName qName, boolean bl) {
        this.name = qName;
        this.isRequired = bl;
    }

    public WSAUsingAddressingAssertion() {
    }

    public void setName(QName qName) {
        this.name = qName;
    }

    public QName getName() {
        return this.name;
    }

    public Element serialize(Document document) throws PolicyException {
        Element element = DOMUtils.createElement(this.getName(), document, this.getName().getPrefix());
        if (this.isRequired()) {
            DOMUtils.addAttribute(element, WSAddressingConstants.WSAW_ATT_QNAME, "true");
        }
        return element;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean bl) {
        this.isRequired = bl;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        String string = objectInput.readUTF();
        this.name = WSAddressingConstants.WSAW_QNAME.getNamespaceURI().equals(string) ? WSAddressingConstants.WSAW_QNAME : WSAddressingConstants.WSAW_QNAME_10;
        this.isRequired = objectInput.readBoolean();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.name.getNamespaceURI());
        objectOutput.writeBoolean(this.isRequired);
    }
}

