/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.addressing.wsdl;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.addressing.AddressingHandler;
import weblogic.wsee.util.AddressingUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlWriter;

public class EndpointReferenceWsdlExtension
implements WsdlExtension {
    private final boolean verbose = Verbose.isVerbose(AddressingHandler.class);
    private Element originalEndponitReferenceElement = null;
    private String addressLocation = null;
    public static final String KEY = "EndPonit-Reference";

    public EndpointReferenceWsdlExtension(Node node) {
        this.originalEndponitReferenceElement = (Element)node;
    }

    public String getKey() {
        return KEY;
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        String string = wsdlWriter.getEndpointURL(this.getAddressLocation());
        this.updateWSAAddressContent(this.originalEndponitReferenceElement, string);
        Node node = element.getOwnerDocument().importNode(this.originalEndponitReferenceElement, true);
        element.appendChild(node);
    }

    public String getAddressLocation() {
        if (this.addressLocation != null) {
            return this.addressLocation;
        }
        if (this.originalEndponitReferenceElement != null) {
            Element element = AddressingUtil.retrieveAddressElement(this.originalEndponitReferenceElement);
            return element != null ? element.getFirstChild().getNodeValue() : null;
        }
        return null;
    }

    public void setAddressLocation(String string) {
        this.addressLocation = string;
    }

    private void updateWSAAddressContent(Element element, String string) {
        if (string == null) {
            return;
        }
        Element element2 = AddressingUtil.retrieveAddressElement(element);
        if (element2 == null) {
            return;
        }
        if (element2.getFirstChild() == null) {
            element2.appendChild(element2.getOwnerDocument().createTextNode(string));
        } else if (element2.getFirstChild().getNodeType() == 3) {
            int n = element2.getChildNodes().getLength();
            for (int i = 0; i < n && element2.getChildNodes() != null; ++i) {
                element2.removeChild(element2.getChildNodes().item(0));
            }
            element2.appendChild(element2.getOwnerDocument().createTextNode(string));
        } else if (this.verbose) {
            Verbose.log("[WARNING] Unable to found address element or wrong address element type for [" + element2.getNamespaceURI() + "]" + element2.getLocalName());
        }
    }
}

