/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.async;

import java.io.Serializable;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.protocol.LocalServerIdentity;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.PersistentStoreException;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.async.AsyncCallContextFactory;
import weblogic.wsee.async.AsyncHandler;
import weblogic.wsee.async.AsyncInvokeState;
import weblogic.wsee.async.AsyncInvokeStateObjectHandler;
import weblogic.wsee.async.AsyncPostCallContextImpl;
import weblogic.wsee.async.AsyncPreCallContextImpl;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.cluster.ClusterUtil;
import weblogic.wsee.cluster.ServiceIdentityHeader;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.message.FreeStandingMsgHeaders;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMsgHeaders;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.AddressingUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.dispatch.client.ClientDispatcher;
import weblogic.wsee.wsdl.WsdlOperation;

public class AsyncClientHandler
extends AsyncHandler
implements WLHandler {
    private static final boolean verbose = Verbose.isVerbose(AsyncClientHandler.class);

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext;
        WsdlOperation wsdlOperation;
        if (messageContext == null) {
            return true;
        }
        if (!messageContext.containsProperty("weblogic.wsee.async.invoke")) {
            return true;
        }
        if (!messageContext.containsProperty("weblogic.wsee.async.res.epr")) {
            throw new JAXRPCException("Asynchronous response endpoint reference is required to execute an async method. Async methods can only be invoked from stubs with the ServiceClient annotation");
        }
        if (!messageContext.containsProperty("weblogic.wsee.async.invokeNonJws")) {
            this.checkImplementedHandleResponseAndFault(messageContext);
        }
        if ((wsdlOperation = (wlMessageContext = WlMessageContext.narrow(messageContext)).getDispatcher().getOperation()) != null && wsdlOperation.getType() == 1) {
            if (verbose) {
                Verbose.log("Operation " + wsdlOperation.getName() + " is one-way, so no AsyncInvokeState will be stored for it");
            }
            return true;
        }
        AsyncPostCallContextImpl asyncPostCallContextImpl = this.propagateCallContext(messageContext);
        this.constructReplyTo(wlMessageContext);
        this.saveAsyncInvokeState(asyncPostCallContextImpl, wlMessageContext);
        return true;
    }

    private AsyncPostCallContextImpl propagateCallContext(MessageContext messageContext) {
        AsyncPreCallContextImpl asyncPreCallContextImpl = (AsyncPreCallContextImpl)messageContext.getProperty("weblogic.wsee.async.pre.call.context");
        AsyncPostCallContextImpl asyncPostCallContextImpl = (AsyncPostCallContextImpl)AsyncCallContextFactory.getAsyncPostCallContext();
        if (asyncPreCallContextImpl != null) {
            HashMap hashMap = asyncPreCallContextImpl.getProperties();
            if (hashMap.size() > 0) {
                asyncPostCallContextImpl.setProperties(hashMap);
            }
            asyncPostCallContextImpl.setStubName((String)messageContext.getProperty("weblogic.wsee.stub.name"));
            if (asyncPreCallContextImpl.getTimeout() > 0L) {
                asyncPostCallContextImpl.setAbsTimeout(asyncPreCallContextImpl.getTimeout() * 1000L + System.currentTimeMillis());
            }
        }
        messageContext.removeProperty("weblogic.wsee.async.pre.call.context");
        AsyncUtil.setApplicationVersionIdIntoContexts(messageContext, asyncPostCallContextImpl);
        return asyncPostCallContextImpl;
    }

    private void saveAsyncInvokeState(AsyncPostCallContextImpl asyncPostCallContextImpl, WlMessageContext wlMessageContext) {
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        MessageIdHeader messageIdHeader = (MessageIdHeader)wlMessageContext.getHeaders().getHeader(MessageIdHeader.TYPE);
        assert (messageIdHeader != null);
        boolean bl2 = bl = wlMessageContext.getProperty("weblogic.wsee.enable.rm") != null;
        if (bl) {
            object3 = (Map)wlMessageContext.getProperty("weblogic.wsee.invoke_properties");
            if (object3 == null) {
                object3 = new ConcurrentHashMap();
                wlMessageContext.setProperty("weblogic.wsee.invoke_properties", object3);
            }
            if ((object2 = (String)object3.get("weblogic.wsee.sequenceid")) == null || ((String)object2).equals("PendingSeqId")) {
                object3.put("weblogic.wsee.sequenceid", "PendingSeqId");
            }
            if ((object = (String)object3.get("weblogic.wsee.offer.sequence.id")) == null || ((String)object).equals("PendingOfferSeqId")) {
                object3.put("weblogic.wsee.offer.sequence.id", "PendingOfferSeqId");
            }
        }
        object3 = WsStorageFactory.getStorage("weblogic.wsee.async.store", new AsyncInvokeStateObjectHandler());
        object2 = new AsyncInvokeState();
        ((AsyncInvokeState)object2).setAsyncPostCallContext(asyncPostCallContextImpl);
        ((AsyncInvokeState)object2).setMessageContext(wlMessageContext);
        ((AsyncInvokeState)object2).setSubject(ClusterUtil.getSubject((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())));
        ((AsyncInvokeState)object2).setDispatcher((ClientDispatcher)wlMessageContext.getDispatcher());
        if (bl) {
            try {
                wlMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", PolicyContext.getResponseEffectivePolicy(wlMessageContext));
                object = (WssPolicyContext)wlMessageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
                if (object == null) {
                    object = wlMessageContext.getDispatcher().getWsPort().getEndpoint().getService().getWssPolicyContext();
                    wlMessageContext.setProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", object);
                }
            }
            catch (PolicyException policyException) {
                throw new JAXRPCException((Throwable)policyException);
            }
            try {
                ((WsStorage)object3).persistentPut(messageIdHeader.getMessageId(), object2);
            }
            catch (PersistentStoreException persistentStoreException) {
                throw new JAXRPCException((Throwable)persistentStoreException);
            }
        }
        ((WsStorage)object3).put(messageIdHeader.getMessageId(), object2);
    }

    private void constructReplyTo(WlMessageContext wlMessageContext) {
        Serializable serializable;
        ReplyToHeader replyToHeader = (ReplyToHeader)wlMessageContext.getHeaders().getHeader(ReplyToHeader.TYPE);
        assert (replyToHeader != null);
        EndpointReference endpointReference = (EndpointReference)wlMessageContext.getProperty("weblogic.wsee.async.res.epr");
        assert (endpointReference != null);
        if (AddressingUtil.isAnonymous(wlMessageContext, replyToHeader.getReference())) {
            replyToHeader.getReference().setAddress(endpointReference.getAddress());
        }
        FreeStandingMsgHeaders freeStandingMsgHeaders = (FreeStandingMsgHeaders)replyToHeader.getReference().getReferenceParameters();
        FreeStandingMsgHeaders freeStandingMsgHeaders2 = (FreeStandingMsgHeaders)endpointReference.getReferenceParameters();
        freeStandingMsgHeaders.merge(freeStandingMsgHeaders2);
        if (freeStandingMsgHeaders.getHeader(ServiceIdentityHeader.TYPE) == null) {
            serializable = new ServiceIdentityHeader();
            ((ServiceIdentityHeader)serializable).setServerName(LocalServerIdentity.getIdentity().getServerName());
            ((ServiceIdentityHeader)serializable).setServiceName("weblogic.wsee.conversation.msg.cluster.service");
            freeStandingMsgHeaders.addHeader((MsgHeader)serializable);
        }
        serializable = (FreeStandingMsgHeaders)replyToHeader.getReference().getReferenceProperties();
        FreeStandingMsgHeaders freeStandingMsgHeaders3 = (FreeStandingMsgHeaders)endpointReference.getReferenceProperties();
        ((FreeStandingMsgHeaders)serializable).merge(freeStandingMsgHeaders3);
        ((SoapMsgHeaders)wlMessageContext.getHeaders()).replaceHeader(AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext).createReplyToHeader(replyToHeader.getReference()));
    }

    private void checkImplementedHandleResponseAndFault(MessageContext messageContext) {
        Class<?> clazz;
        String string = AsyncUtil.getAsyncResponseMethodName(messageContext);
        String string2 = AsyncUtil.getAsyncFailureMethodName(messageContext);
        Class[] classArray = AsyncUtil.getAsyncResponseMethodParams(messageContext);
        Class[] classArray2 = AsyncUtil.getAsyncFailureMethodParams();
        String string3 = (String)messageContext.getProperty("weblogic.wsee.enclosing.classname");
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXRPCException("No class found for " + string3);
        }
        try {
            clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JAXRPCException("No onAsyncResponse method '" + string + "' found for asynchronous invoke of " + messageContext.getProperty("weblogic.wsee.method.name"));
        }
        try {
            clazz.getMethod(string2, classArray2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JAXRPCException("No onAsyncFailure method '" + string2 + "' found for asynchronous invoke of " + messageContext.getProperty("weblogic.wsee.method.name"));
        }
    }

    public boolean handleClosure(MessageContext messageContext) {
        if (!messageContext.containsProperty("weblogic.wsee.async.invoke")) {
            return true;
        }
        if (verbose) {
            Verbose.say("AsyncClientHandler: handleClosure");
        }
        if (!(messageContext instanceof SOAPMessageContext)) {
            if (verbose) {
                Verbose.say("AsyncClientHandler: handleClosure: mc not soapmc");
            }
            return true;
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        MessageIdHeader messageIdHeader = (MessageIdHeader)wlMessageContext.getHeaders().getHeader(MessageIdHeader.TYPE);
        assert (messageIdHeader != null);
        String string = (String)wlMessageContext.getProperty("weblogic.wsee.offer.sequence.id");
        if (string == null) {
            if (verbose) {
                Verbose.say("AsyncClientHandler: handleClosure: offer sequence id is null!!!");
            }
            return true;
        }
        WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.async.store", new AsyncInvokeStateObjectHandler());
        try {
            AsyncInvokeState asyncInvokeState = (AsyncInvokeState)wsStorage.persistentGet(messageIdHeader.getMessageId());
            if (asyncInvokeState == null) {
                if (verbose) {
                    Verbose.say("AsyncClientHandler: handleClosure: AIS is not stored for messageid " + messageIdHeader.getMessageId());
                }
                return true;
            }
            WlMessageContext wlMessageContext2 = asyncInvokeState.getMessageContext();
            Map map = (Map)wlMessageContext.getProperty("weblogic.wsee.invoke_properties");
            assert (map != null);
            Map map2 = (Map)wlMessageContext2.getProperty("weblogic.wsee.invoke_properties");
            assert (map2 != null);
            map2.put("weblogic.wsee.offer.sequence.id", wlMessageContext.getProperty("weblogic.wsee.offer.sequence.id"));
            if (verbose) {
                Verbose.say("AsyncClientHandler: handleClosure: ais after new seqid = " + asyncInvokeState.asString());
            }
            wsStorage.persistentPut(messageIdHeader.getMessageId(), asyncInvokeState);
        }
        catch (PersistentStoreException persistentStoreException) {
            if (verbose) {
                Verbose.say("AsyncClientHandler: handleClosure: caught exception: " + (Object)((Object)persistentStoreException));
            }
            throw new JAXRPCException((Throwable)persistentStoreException);
        }
        if (verbose) {
            Verbose.say("handleClosure: returning true");
        }
        return true;
    }
}

