/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.async;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.async.AsyncPostCallContextImpl;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.server.StateExpiration;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.dispatch.client.ClientDispatcher;

public class AsyncInvokeState
implements StateExpiration {
    private AsyncPostCallContextImpl asyncPostCtx;
    private WlMessageContext wlmc;
    private ClientDispatcher dispatcher;
    private String serviceClassName;
    private STATE state = STATE.NEW;
    private String msgId;
    private static final boolean verbose = Verbose.isVerbose(AsyncInvokeState.class);
    private static final boolean verboseProps = Verbose.isVerbose(AsyncInvokeState.class.getName() + "Prop");
    private AuthenticatedSubject subject = null;

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public void setServiceClassName(String string) {
        this.serviceClassName = string;
    }

    public ClientDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(ClientDispatcher clientDispatcher) {
        this.dispatcher = clientDispatcher;
    }

    public void setSubject(AuthenticatedSubject authenticatedSubject) {
        this.subject = authenticatedSubject;
    }

    public AuthenticatedSubject getSubject() {
        return this.subject;
    }

    public void setState(STATE sTATE) {
        if (verbose) {
            Verbose.log("AIS: In setPendingReliableResponse(" + (Object)((Object)sTATE) + ") for msgId " + this.msgId);
        }
        this.state = sTATE;
    }

    public STATE getState() {
        return this.state;
    }

    public boolean isExpired() {
        long l;
        boolean bl;
        boolean bl2 = bl = this.wlmc != null && this.wlmc.getProperty("weblogic.wsee.enable.rm") != null;
        if (verbose) {
            Verbose.say("AIS:isExpired called for msg id: " + this.msgId + ", serviceClass=" + this.serviceClassName + ", asString:\t" + this.asString());
        }
        if (verboseProps) {
            this.dumpMessageContextProps(this.msgId);
        }
        if (bl && this.isExpiredRMState(this.msgId)) {
            return true;
        }
        if (this.asyncPostCtx != null && (l = this.asyncPostCtx.getAbsTimeout()) > 0L && l < System.currentTimeMillis()) {
            if (verbose) {
                Verbose.say("AIS: Returning expired on timeout for msg id: " + this.msgId);
            }
            return true;
        }
        if (verbose) {
            Verbose.say("AIS: Returning not expired for msg id: " + this.msgId);
        }
        return false;
    }

    private void dumpMessageContextProps(String string) {
        Object object;
        Object object2;
        if (this.wlmc == null) {
            return;
        }
        Verbose.say("AIS: Dumping wlmc for message id: " + string);
        Verbose.say("\tProperties");
        Iterator iterator = this.wlmc.getPropertyNames();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if ("weblogic.wsee.invoke_properties".equals(object2)) {
                Verbose.say("Invoke Properties:");
                object = (Map)this.wlmc.getProperty((String)object2);
                if (object == null) {
                    Verbose.say("\tNULL");
                    continue;
                }
                for (Object k : object.keySet()) {
                    Verbose.say("\t\t" + k + "=" + object.get(k));
                }
                continue;
            }
            Verbose.say("\t" + (String)object2 + "=" + this.wlmc.getProperty((String)object2));
        }
        Verbose.say("Msg Headers");
        object2 = this.wlmc.getHeaders();
        iterator = null;
        if (object2 != null) {
            iterator = object2.listHeaders();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (MsgHeader)iterator.next();
                Verbose.say(((MsgHeader)object).toString());
            }
        }
    }

    private boolean isExpiredRMState(String string) {
        String string2;
        String string3;
        if (verbose) {
            Verbose.say("AIS: Dealing with RM State for msg id: " + string);
        }
        if (this.state == STATE.PENDING_RESPONSE) {
            if (verbose) {
                Verbose.say("AIS: Have pending reliable response for msg id " + string + ". Returning not-expired");
            }
            return false;
        }
        Map map = (Map)this.wlmc.getProperty("weblogic.wsee.invoke_properties");
        if (map == null) {
            if (verbose) {
                Verbose.say("AIS: invokeProperties is null - looking for explicit server-side properties. Msg id: " + string);
            }
            string3 = (String)this.wlmc.getProperty("weblogic.wsee.reliability.RequestMessageSeqID");
            string2 = (String)this.wlmc.getProperty("weblogic.wsee.reliability.RequestMessageOfferSeqID");
        } else {
            if (verbose) {
                Verbose.say("AIS: invokeProperties is not null - searching it for sequence and offer sequence ID values. Msg id: " + string);
            }
            string3 = (String)map.get("weblogic.wsee.sequenceid");
            string2 = (String)map.get("weblogic.wsee.offer.sequence.id");
        }
        if (string3 == null && string2 == null && map == null) {
            if (verbose) {
                Verbose.say("AIS: invokeProperties is null - returning expired for msg id: " + string);
            }
            return true;
        }
        if (string3 != null && string3.equals("PendingSeqId") || string2 != null && string2.equals("PendingOfferSeqId")) {
            if (verbose) {
                Verbose.say("AIS: seqId is null and oSeqId is null - returning not expired for msg id: " + string);
            }
            return false;
        }
        if (verbose) {
            Verbose.say("AIS: Found sequence ID as:  " + string3 + " for msg id: " + string);
            Verbose.say("AIS: Found offer seq ID as: " + string2 + " for msg id: " + string);
        }
        SAFConversationInfo sAFConversationInfo = null;
        SAFConversationInfo sAFConversationInfo2 = null;
        String string4 = "Sending";
        try {
            if (string2 != null) {
                if (map != null) {
                    sAFConversationInfo2 = SAFManagerImpl.getManager().getConversationInfoOnReceivingSide(string2);
                    string4 = "Receiving";
                } else {
                    sAFConversationInfo2 = SAFManagerImpl.getManager().getConversationInfoOnSendingSide(string2);
                    string4 = "Sending";
                }
                if (verbose) {
                    Verbose.say("AIS: SAFConversationInfo for offer seqid (on " + string4 + " side) " + (sAFConversationInfo2 == null ? "is null" : "was found OK") + " for msg id: " + string);
                }
            }
            if (string3 != null) {
                sAFConversationInfo = SAFManagerImpl.getManager().getConversationInfoOnSendingSide(string3);
                if (sAFConversationInfo == null) {
                    if (verbose) {
                        Verbose.say("AIS: SAFConversationInfo for seqid " + (sAFConversationInfo == null ? "is null" : "was found OK") + " for msg id: " + string);
                    }
                } else if (sAFConversationInfo2 == null) {
                    String string5 = sAFConversationInfo.getConversationOffer().getConversationName();
                    if (map != null) {
                        sAFConversationInfo2 = SAFManagerImpl.getManager().getConversationInfoOnReceivingSide(string5);
                        string4 = "Receiving";
                    } else {
                        sAFConversationInfo2 = SAFManagerImpl.getManager().getConversationInfoOnSendingSide(string5);
                        string4 = "Sending";
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (verbose) {
                Verbose.say("Caught exception " + throwable + "when geting conversation info\nReturning not expired");
            }
            return false;
        }
        if (sAFConversationInfo == null && sAFConversationInfo2 == null) {
            if (verbose) {
                Verbose.say("AIS: Conversation info for seqid and oseqid (" + string4 + " side) are null - returning expired for msg id: " + string);
            }
            return true;
        }
        if (verbose) {
            Verbose.say("AIS: Either sequence or Offer sequence (" + string4 + " side) not terminated - now checking for non-RM timeout on msg id: " + string);
        }
        return false;
    }

    public AsyncPostCallContextImpl getAsyncPostCallContext() {
        return this.asyncPostCtx;
    }

    public WlMessageContext getMessageContext() {
        return this.wlmc;
    }

    public void setAsyncPostCallContext(AsyncPostCallContextImpl asyncPostCallContextImpl) {
        this.asyncPostCtx = asyncPostCallContextImpl;
    }

    public void setMessageContext(WlMessageContext wlMessageContext) {
        MessageIdHeader messageIdHeader;
        MsgHeaders msgHeaders;
        this.wlmc = wlMessageContext;
        String string = null;
        if (this.wlmc != null && (string = (String)this.wlmc.getProperty("weblogic.wsee.addressing.MessageId")) == null && (msgHeaders = this.wlmc.getHeaders()) != null && (messageIdHeader = (MessageIdHeader)msgHeaders.getHeader(MessageIdHeader.TYPE)) != null) {
            string = messageIdHeader.getMessageId();
        }
        if (verbose && this.msgId != null) {
            Verbose.log("AIS: Resetting msgId in AsyncInvokeState. Was " + this.msgId + ", now " + string);
        }
        this.msgId = string;
    }

    public String getMessageId() {
        return this.msgId;
    }

    public void setMessageId(String string) {
        this.msgId = string;
    }

    public String asString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AsyncInvokeState: " + this);
        if (this.asyncPostCtx != null) {
            stringBuffer.append("\n\tExpiration timeout is = " + this.asyncPostCtx.getAbsTimeout() + "\n");
            HashMap hashMap = this.asyncPostCtx.getProperties();
            stringBuffer.append("\tAsyncPostContextProperties\n");
            for (String string : hashMap.keySet()) {
                Object v = hashMap.get(string);
                stringBuffer.append("\n\t" + string + "=" + v + "\n");
            }
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATE {
        NEW,
        PENDING_RESPONSE,
        COMPLETE;

    }
}

