/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.async;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.store.ObjectHandler;
import weblogic.wsee.Version;
import weblogic.wsee.async.AsyncCallContextFactory;
import weblogic.wsee.async.AsyncInvokeState;
import weblogic.wsee.async.AsyncPostCallContextImpl;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.server.EncryptionUtil;
import weblogic.wsee.util.Verbose;

public class AsyncInvokeStateObjectHandler
implements ObjectHandler {
    private static final boolean verbose = Verbose.isVerbose(AsyncInvokeStateObjectHandler.class);
    private static HashSet<String> excludedProperties = new HashSet<String>(Arrays.asList("weblogic.wsee.wsrm.sequence.expiration", "weblogic.wsee.wsrm.offer.sequence.expiration", "weblogic.wsee.seq.expires", "weblogic.wsee.handler.jaxrpcHandlerChain"));
    public static final String USER_DEFINED_EXCLUDED_PROPERTIES = "weblogic.wsee.exclude.properties";

    private static void init() {
        String string = System.getProperty(USER_DEFINED_EXCLUDED_PROPERTIES);
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            excludedProperties.add(string2);
        }
    }

    public void writeObject(ObjectOutput objectOutput, Object object) throws IOException {
        Object object2;
        String string2;
        objectOutput.writeUTF("10.3.6");
        if (object instanceof String) {
            objectOutput.writeInt(0);
            objectOutput.writeUTF((String)object);
            return;
        }
        if (!(object instanceof AsyncInvokeState)) {
            return;
        }
        objectOutput.writeInt(1);
        AsyncInvokeState asyncInvokeState = (AsyncInvokeState)object;
        AsyncPostCallContextImpl asyncPostCallContextImpl = asyncInvokeState.getAsyncPostCallContext();
        objectOutput.writeLong(asyncPostCallContextImpl.getAbsTimeout());
        HashMap hashMap = asyncPostCallContextImpl.getProperties();
        int n = 0;
        for (String string2 : hashMap.keySet()) {
            if (excludedProperties.contains(string2)) continue;
            object2 = hashMap.get(string2);
            ++n;
            if (object2 == null || object2 instanceof Serializable) continue;
            throw new IOException("Properties set in AsyncPreCallContext have to be serializable in order to enable reliable async request/response, violation key: " + string2);
        }
        objectOutput.writeInt(n);
        for (String string2 : hashMap.keySet()) {
            if (excludedProperties.contains(string2)) continue;
            object2 = hashMap.get(string2);
            if (verbose) {
                if (object2 != null) {
                    Verbose.log("Writing " + string2 + " " + object2.toString());
                } else {
                    Verbose.log("Writing " + string2 + " " + null);
                }
            }
            objectOutput.writeUTF(string2);
            if (object2 != null) {
                objectOutput.writeInt(1);
                objectOutput.writeObject(object2);
                continue;
            }
            objectOutput.writeInt(0);
        }
        n = 0;
        Iterator iterator = asyncInvokeState.getMessageContext().getPropertyNames();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (excludedProperties.contains(string2)) continue;
            object2 = asyncInvokeState.getMessageContext().getProperty(string2);
            ++n;
            if (object2 == null || object2 instanceof Serializable) continue;
            throw new IOException("Properties set in the MessageContext have to be serializable in order to enable reliable async request/response, violation key: " + string2);
        }
        objectOutput.writeInt(n);
        iterator = asyncInvokeState.getMessageContext().getPropertyNames();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (excludedProperties.contains(string2)) continue;
            object2 = asyncInvokeState.getMessageContext().getProperty(string2);
            if (string2.equals("javax.xml.rpc.security.auth.password")) {
                objectOutput.writeUTF(string2);
                assert (object2 != null);
                objectOutput.writeUTF(new String(EncryptionUtil.encrypt(((String)object2).getBytes())));
                continue;
            }
            if (verbose) {
                if (object2 != null) {
                    Verbose.log("Writing " + string2 + " " + object2.toString());
                } else {
                    Verbose.log("Writing " + string2 + " " + null);
                }
            }
            objectOutput.writeUTF(string2);
            if (object2 != null) {
                objectOutput.writeInt(1);
                objectOutput.writeObject(object2);
                continue;
            }
            objectOutput.writeInt(0);
        }
        if (asyncInvokeState.getSubject() != null) {
            objectOutput.writeInt(1);
            objectOutput.writeObject(asyncInvokeState.getSubject());
        } else {
            objectOutput.writeInt(0);
        }
        objectOutput.writeObject((Object)asyncInvokeState.getState());
        objectOutput.writeObject(asyncInvokeState.getMessageId());
    }

    public Object readObject(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        Object object;
        String string = objectInput.readUTF();
        Version.checkForKnownVersion(string);
        int n = objectInput.readInt();
        if (n == 0) {
            return objectInput.readUTF();
        }
        AsyncInvokeState asyncInvokeState = new AsyncInvokeState();
        AsyncPostCallContextImpl asyncPostCallContextImpl = (AsyncPostCallContextImpl)AsyncCallContextFactory.getAsyncPostCallContext();
        long l = objectInput.readLong();
        asyncPostCallContextImpl.setAbsTimeout(l);
        int n2 = objectInput.readInt();
        if (verbose) {
            Verbose.log("size is " + n2);
        }
        for (int i = 0; i < n2; ++i) {
            String string2 = objectInput.readUTF();
            int n3 = objectInput.readInt();
            object = null;
            if (n3 == 1) {
                object = objectInput.readObject();
            }
            if (verbose) {
                Verbose.log("Reading key: " + string2);
            }
            asyncPostCallContextImpl.setProperty(string2, object);
        }
        asyncInvokeState.setAsyncPostCallContext(asyncPostCallContextImpl);
        n2 = objectInput.readInt();
        if (verbose) {
            Verbose.log("size is " + n2);
        }
        SoapMessageContext soapMessageContext = new SoapMessageContext();
        for (int i = 0; i < n2; ++i) {
            String string3 = objectInput.readUTF();
            object = null;
            if (string3.equals("javax.xml.rpc.security.auth.password")) {
                object = new String(EncryptionUtil.decrypt(objectInput.readUTF().getBytes()));
            } else {
                int n4 = objectInput.readInt();
                if (n4 == 1) {
                    object = objectInput.readObject();
                }
            }
            if (verbose) {
                Verbose.log("Reading key: " + string3);
            }
            soapMessageContext.setProperty(string3, object);
        }
        asyncInvokeState.setMessageContext(soapMessageContext);
        n2 = objectInput.readInt();
        if (n2 > 0) {
            asyncInvokeState.setSubject((AuthenticatedSubject)objectInput.readObject());
        }
        if (Version.isLaterThanOrEqualTo(string, "10.0")) {
            AsyncInvokeState.STATE sTATE = (AsyncInvokeState.STATE)((Object)objectInput.readObject());
            asyncInvokeState.setState(sTATE);
        }
        if (Version.isLaterThanOrEqualTo(string, "10.3.6")) {
            String string4 = (String)objectInput.readObject();
            asyncInvokeState.setMessageId(string4);
        }
        return asyncInvokeState;
    }

    static {
        AsyncInvokeStateObjectHandler.init();
    }
}

