/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.async;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.rpc.JAXRPCException;
import weblogic.jws.WLDeployment;
import weblogic.jws.WLHttpTransport;
import weblogic.jws.WLHttpsTransport;
import weblogic.jws.WLJmsTransport;
import weblogic.wsee.async.AbstractAsyncResponseBean;
import weblogic.wsee.async.AsyncInvokeState;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.deploy.VersioningHelper;
import weblogic.wsee.jws.container.Request;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.DirectInvokeUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsSkel;

@WebService(name="AsyncResponseServicePortType", serviceName="AsyncResponseService", targetNamespace="http://www.bea.com/async/AsyncResponseService")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL)
@WLHttpTransport(portName="AsyncResponseService", contextPath="_async", serviceUri="AsyncResponseService")
@WLHttpsTransport(portName="AsyncResponseServiceHttps", contextPath="_async", serviceUri="AsyncResponseServiceHttps")
@WLJmsTransport(portName="AsyncResponseServiceJms", contextPath="_async", serviceUri="AsyncResponseServiceJms")
@WLDeployment(deploymentListener={"weblogic.wsee.async.AsyncResponseServiceDeploymentListener"})
public class AsyncResponseBean
extends AbstractAsyncResponseBean {
    private static final boolean verbose = Verbose.isVerbose(AsyncResponseBean.class);

    protected void handleResult(String string, WlMessageContext wlMessageContext, Object object) throws JAXRPCException {
        AsyncInvokeState asyncInvokeState = (AsyncInvokeState)wlMessageContext.getProperty("weblogic.wsee.async.invoke.state");
        if (verbose) {
            Verbose.log("Async response bean handleResult: ais msg id = " + asyncInvokeState.getMessageId());
        }
        if (asyncInvokeState == null) {
            return;
        }
        AsyncUtil.SavedServiceInfo savedServiceInfo = AsyncUtil.getSavedServiceInfo(asyncInvokeState, verbose);
        ClassLoader classLoader = ((WsSkel)savedServiceInfo.wsPort.getEndpoint()).getClassLoader();
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader2 = thread2.getContextClassLoader();
        try {
            thread2.setContextClassLoader(classLoader);
            String string2 = (String)asyncInvokeState.getMessageContext().getProperty("weblogic.wsee.enclosing.classname");
            String string3 = AsyncUtil.getAsyncResponseMethodName(asyncInvokeState.getMessageContext());
            Class[] classArray = AsyncUtil.getAsyncResponseMethodParams(asyncInvokeState.getMessageContext());
            Object[] objectArray = classArray.length == 1 ? new Object[]{savedServiceInfo.apc} : new Object[]{savedServiceInfo.apc, object};
            Request request = new Request(string2, string3, classArray, objectArray);
            DirectInvokeUtil.invoke(savedServiceInfo.uri, request, (String)wlMessageContext.getProperty("weblogic.wsee.conversation.ConversationId"), this._context);
            if (savedServiceInfo.version != null) {
                String string4 = (String)asyncInvokeState.getAsyncPostCallContext().getProperty("weblogic.wsee.async.appname");
                VersioningHelper.updateCount(string4, savedServiceInfo.version, -1);
            }
        }
        catch (JAXRPCException jAXRPCException) {
            throw jAXRPCException;
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable throwable) {
            throw new JAXRPCException(throwable.toString(), throwable);
        }
        finally {
            thread2.setContextClassLoader(classLoader2);
        }
    }

    protected void handleFault(String string, WlMessageContext wlMessageContext, Object object) throws JAXRPCException {
        AsyncInvokeState asyncInvokeState = (AsyncInvokeState)wlMessageContext.getProperty("weblogic.wsee.async.invoke.state");
        if (verbose) {
            Verbose.log("Async response bean handleFault: ais msg id = " + asyncInvokeState.getMessageId());
        }
        if (asyncInvokeState == null) {
            return;
        }
        AsyncUtil.SavedServiceInfo savedServiceInfo = AsyncUtil.getSavedServiceInfo(asyncInvokeState, verbose);
        ClassLoader classLoader = ((WsSkel)savedServiceInfo.wsPort.getEndpoint()).getClassLoader();
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader2 = thread2.getContextClassLoader();
        try {
            thread2.setContextClassLoader(classLoader);
            String string2 = (String)asyncInvokeState.getMessageContext().getProperty("weblogic.wsee.enclosing.classname");
            String string3 = AsyncUtil.getAsyncFailureMethodName(asyncInvokeState.getMessageContext());
            Class[] classArray = AsyncUtil.getAsyncFailureMethodParams();
            Object[] objectArray = new Object[]{savedServiceInfo.apc, object};
            Request request = new Request(string2, string3, classArray, objectArray);
            DirectInvokeUtil.invoke(savedServiceInfo.uri, request, (String)wlMessageContext.getProperty("weblogic.wsee.conversation.ConversationId"), this._context);
            if (savedServiceInfo.version != null) {
                String string4 = (String)asyncInvokeState.getAsyncPostCallContext().getProperty("weblogic.wsee.async.appname");
                VersioningHelper.updateCount(string4, savedServiceInfo.version, -1);
            }
        }
        catch (JAXRPCException jAXRPCException) {
            throw jAXRPCException;
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable throwable) {
            throw new JAXRPCException(throwable);
        }
        finally {
            thread2.setContextClassLoader(classLoader2);
        }
    }
}

