/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.async;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPMessage;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.async.AsyncInvokeState;
import weblogic.wsee.async.AsyncInvokeStateObjectHandler;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.conversation.ContinueHeader;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.handler.HandlerIterator;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.jaxrpc.StubImpl;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistry;
import weblogic.wsee.ws.WsSkel;
import weblogic.wsee.ws.dispatch.client.ClientDispatcher;
import weblogic.xml.crypto.wss.WSSecurityContext;

public class AsyncResponseHandler
extends GenericHandler {
    private static final boolean verbose = Verbose.isVerbose(AsyncResponseHandler.class);
    public static final String APP_NAME_PROPERTY = "weblogic.wsee.async.appname";
    public static final String APP_VERSION_PROPERTY = "weblogic.wsee.async.appversion";
    public static final String ASYNC_FAULT_PROPERTY = "weblogic.wsee.async.fault";
    public static final String ASYNC_RESULT_PROPERTY = "weblogic.wsee.async.result";

    public QName[] getHeaders() {
        return null;
    }

    public boolean handleRequest(MessageContext messageContext) {
        block12: {
            String string;
            if (messageContext == null) {
                return true;
            }
            if (!(messageContext instanceof SOAPMessageContext)) {
                return true;
            }
            if (verbose) {
                Verbose.log("AsyncResponseHandler.handleRequest");
            }
            if ((string = (String)messageContext.getProperty("weblogic.wsee.addressing.RelatesTo")) == null) {
                return false;
            }
            String string2 = "Unknown";
            String string3 = "";
            if (verbose) {
                CharSequence charSequence;
                MsgHeaders msgHeaders = ((SoapMessageContext)messageContext).getHeaders();
                MessageIdHeader messageIdHeader = (MessageIdHeader)msgHeaders.getHeader(MessageIdHeader.TYPE);
                string2 = messageIdHeader != null ? messageIdHeader.getMessageId() : "Unknown";
                SequenceHeader sequenceHeader = (SequenceHeader)msgHeaders.getHeader(SequenceHeader.TYPE);
                if (sequenceHeader != null) {
                    string3 = " on reliable sequence " + sequenceHeader.getSequenceId() + " and seq num " + sequenceHeader.getMessageNumber();
                } else {
                    charSequence = (String)messageContext.getProperty("weblogic.wsee.reliability.RequestMessageSeqNumber");
                    String string4 = (String)messageContext.getProperty("weblogic.wsee.reliability.RequestMessageSeqID");
                    if (string4 != null) {
                        string3 = " on reliable sequence " + string4 + " and seq num " + charSequence;
                    }
                }
                Verbose.log("Processing async response message " + string2 + " related to request msg " + string + string3);
                charSequence = HandlerIterator.getHandlerHistory(messageContext);
                if (charSequence != null) {
                    Verbose.log("Async response message " + string2 + " related to request msg " + string + string3 + " has this handler history: " + charSequence);
                }
            }
            try {
                this.handleRequestInternal(messageContext, string, string2, string3);
                if (verbose) {
                    Verbose.log("Successfully processed async response message " + string2 + " related to request msg " + string + string3);
                }
            }
            catch (Throwable throwable) {
                if (!verbose) break block12;
                Verbose.log("Failed to process async response message " + string2 + " related to request msg " + string + string3 + " error was: " + throwable.toString());
                Verbose.logException(throwable);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestInternal(MessageContext messageContext, String string, String string2, String string3) {
        AsyncInvokeState asyncInvokeState;
        if (messageContext.getProperty("weblogic.wsee.oneway.confirmed") == null) {
            try {
                ((WlMessageContext)messageContext).getDispatcher().getConnection().getTransport().confirmOneway();
            }
            catch (IOException iOException) {
                throw new InvocationException("Failed to confirm oneway", iOException);
            }
            messageContext.setProperty("weblogic.wsee.oneway.confirmed", (Object)"true");
        }
        WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.async.store", new AsyncInvokeStateObjectHandler());
        try {
            asyncInvokeState = (AsyncInvokeState)wsStorage.persistentGet(string);
            if (asyncInvokeState == null) {
                throw new JAXRPCException("Cannot retrieve request information for message " + string);
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            if (verbose) {
                Verbose.logException(persistentStoreException);
            }
            throw new JAXRPCException((Throwable)persistentStoreException);
        }
        AsyncInvokeState asyncInvokeState2 = asyncInvokeState;
        synchronized (asyncInvokeState2) {
            asyncInvokeState = (AsyncInvokeState)wsStorage.get(string);
            if (asyncInvokeState == null) {
                throw new JAXRPCException("Cannot retrieve request information for message " + string);
            }
            if (asyncInvokeState.getState() == AsyncInvokeState.STATE.PENDING_RESPONSE) {
                asyncInvokeState.setState(AsyncInvokeState.STATE.COMPLETE);
                try {
                    wsStorage.persistentPut(string, asyncInvokeState);
                }
                catch (Exception exception) {
                    throw new JAXRPCException("Error while trying to clear the 'pending reliable request' flag from AsyncInvokeState: " + exception.toString(), (Throwable)exception);
                }
            }
            AuthenticatedSubject authenticatedSubject = asyncInvokeState.getSubject();
            AuthorizedInvoke authorizedInvoke = new AuthorizedInvoke(asyncInvokeState, messageContext, string, string2, string3);
            if (authenticatedSubject != null) {
                try {
                    SecurityServiceManager.runAs((AuthenticatedSubject)((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())), (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)authorizedInvoke);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getException() instanceof IOException) {
                        throw new JAXRPCException((Throwable)privilegedActionException.getException());
                    }
                    throw new UndeclaredThrowableException(privilegedActionException.getException());
                }
            }
            try {
                authorizedInvoke.run();
            }
            catch (Exception exception) {
                throw new JAXRPCException((Throwable)exception);
            }
            ContinueHeader continueHeader = (ContinueHeader)((WlMessageContext)messageContext).getHeaders().getHeader(ContinueHeader.TYPE);
            if (continueHeader != null) {
                messageContext.setProperty("weblogic.wsee.conversation.ConversationId", (Object)continueHeader.getConversationId());
                messageContext.setProperty("weblogic.wsee.conversation.IsServerAssigned", (Object)new Boolean(continueHeader.isServerAssigned()));
                messageContext.setProperty("weblogic.wsee.conversation.ConversationPhase", (Object)ConversationPhase.CONTINUE);
                messageContext.setProperty("weblogic.wsee.version.appversion.id", (Object)continueHeader.getAppVersionId());
            }
            this.cleanState(asyncInvokeState, wsStorage, string);
        }
    }

    private void cleanState(AsyncInvokeState asyncInvokeState, WsStorage wsStorage, String string) {
        boolean bl = true;
        if (asyncInvokeState.getMessageContext() != null && asyncInvokeState.getMessageContext().getProperty("weblogic.wsee.enable.rm") != null) {
            bl = false;
        }
        if (bl) {
            try {
                wsStorage.persistentRemove(string);
            }
            catch (PersistentStoreException persistentStoreException) {
                if (verbose) {
                    Verbose.logException(persistentStoreException);
                }
                throw new JAXRPCException((Throwable)persistentStoreException);
            }
        }
    }

    private WsPort getPort(String string) {
        String string2 = WsRegistry.getURL(string);
        String string3 = WsRegistry.getVersion(string);
        return WsRegistry.instance().lookup(string2, string3);
    }

    private class AuthorizedInvoke
    implements PrivilegedExceptionAction {
        private AsyncInvokeState ais = null;
        private MessageContext mc;
        String relatesTo;
        String requestMsgIdMsg;
        String rmSeqIdMsg;

        AuthorizedInvoke(AsyncInvokeState asyncInvokeState, MessageContext messageContext, String string, String string2, String string3) {
            this.ais = asyncInvokeState;
            this.mc = messageContext;
            this.relatesTo = string;
            this.requestMsgIdMsg = string2;
            this.rmSeqIdMsg = string3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws Exception {
            String string;
            CharSequence charSequence;
            WlMessageContext wlMessageContext;
            Object object;
            Object object2;
            block55: {
                Object object3;
                SoapMessageContext soapMessageContext = (SoapMessageContext)this.mc;
                object2 = null;
                object = null;
                ClientDispatcher clientDispatcher = this.ais.getDispatcher();
                wlMessageContext = this.ais.getMessageContext();
                if (wlMessageContext == null) {
                    throw new JAXRPCException("No message context saved");
                }
                boolean bl = this.mc.getProperty("weblogic.wsee.rm.secure") != null;
                WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(this.mc);
                if (wSSecurityContext != null) {
                    wlMessageContext.setProperty("weblogic.xml.crypto.wss.WSSecurityContext", wSSecurityContext);
                }
                String string2 = (String)wlMessageContext.getProperty(AsyncResponseHandler.APP_VERSION_PROPERTY);
                if (verbose) {
                    Verbose.log("Version from savedMc = " + string2);
                }
                String string3 = (String)wlMessageContext.getProperty("weblogic.wsee.enclosing.jws.serviceuri");
                if (string2 != null) {
                    if (verbose) {
                        Verbose.log("adding version " + string2 + " to URI " + string3);
                    }
                    string3 = string3 + "#" + string2;
                } else if (verbose) {
                    Verbose.log("no version ");
                }
                boolean bl2 = wlMessageContext.containsProperty("weblogic.wsee.jaxrpc.SoapDispatchInitiatedOperation");
                if (string3 == null && !bl2) {
                    throw new JAXRPCException("No jws service uri found");
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (string3 != null) {
                    object3 = AsyncResponseHandler.this.getPort(string3);
                    if (object3 == null) {
                        throw new JAXRPCException("No port found for " + string3);
                    }
                    classLoader = ((WsSkel)((WsPort)object3).getEndpoint()).getClassLoader();
                }
                object3 = Thread.currentThread();
                ClassLoader classLoader2 = ((Thread)object3).getContextClassLoader();
                if (clientDispatcher == null || bl) {
                    if (verbose) {
                        Verbose.log("Calculating async response using new ClientDispatcher/Stub for message " + this.requestMsgIdMsg + " related to request msg " + this.relatesTo + this.rmSeqIdMsg);
                    }
                    try {
                        Stub stub;
                        ((Thread)object3).setContextClassLoader(classLoader);
                        charSequence = (String)wlMessageContext.getProperty("weblogic.wsee.service.class.name");
                        if (charSequence == null) {
                            throw new JAXRPCException("No class name found");
                        }
                        string = (String)wlMessageContext.getProperty("weblogic.wsee.service.method.name");
                        if (string == null) {
                            throw new JAXRPCException("No method name found");
                        }
                        String string4 = (String)wlMessageContext.getProperty("weblogic.wsee.operation.name");
                        if (string4 == null) {
                            throw new JAXRPCException("No operation name found");
                        }
                        try {
                            Object obj;
                            Executable executable;
                            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass((String)charSequence);
                            try {
                                executable = clazz.getConstructor(new Class[0]);
                                obj = ((Constructor)executable).newInstance(new Object[0]);
                            }
                            catch (Throwable throwable) {
                                String string5 = (String)wlMessageContext.getProperty("weblogic.wsee.wsdl.location");
                                if (string5 != null) {
                                    Constructor<?> constructor = clazz.getConstructor(String.class);
                                    obj = constructor.newInstance(string5);
                                }
                                throw throwable;
                            }
                            executable = clazz.getMethod(string, new Class[0]);
                            stub = (Stub)((Method)executable).invoke(obj, new Object[0]);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new JAXRPCException((Throwable)classNotFoundException);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new JAXRPCException((Throwable)noSuchMethodException);
                        }
                        catch (Throwable throwable) {
                            throw new JAXRPCException(throwable);
                        }
                        try {
                            ((SoapMessageContext)wlMessageContext).setMessage(soapMessageContext.getMessage());
                            object2 = ((StubImpl)stub)._asyncResponse(string4, soapMessageContext.getMessage(), wlMessageContext);
                        }
                        catch (JAXRPCException jAXRPCException) {
                            object = new RemoteException(jAXRPCException.getMessage(), jAXRPCException.getLinkedCause());
                        }
                        catch (SOAPFaultException sOAPFaultException) {
                            object = new RemoteException("SOAP Fault:" + (Object)((Object)sOAPFaultException) + "--- Detail:" + sOAPFaultException.getDetail(), sOAPFaultException);
                        }
                        catch (RuntimeException runtimeException) {
                            object = new RemoteException(runtimeException.getMessage(), runtimeException);
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                        }
                        Object var24_37 = null;
                        ((Thread)object3).setContextClassLoader(classLoader2);
                    }
                    catch (Throwable throwable) {
                        Object var24_38 = null;
                        ((Thread)object3).setContextClassLoader(classLoader2);
                        throw throwable;
                    }
                }
                if (verbose) {
                    Verbose.log("Calculating async response using existing ClientDispatcher for message " + this.requestMsgIdMsg + " related to request msg " + this.relatesTo + this.rmSeqIdMsg);
                }
                try {
                    block54: {
                        try {
                            ((Thread)object3).setContextClassLoader(classLoader);
                            ((SoapMessageContext)clientDispatcher.getContext()).setMessage(soapMessageContext.getMessage());
                            clientDispatcher.handleAsyncResponse(soapMessageContext.getMessage());
                            if (bl2) {
                                charSequence = ((SoapMessageContext)clientDispatcher.getContext()).getMessage();
                                if (charSequence instanceof SOAPMessage) {
                                    try {
                                        string = (SOAPMessage)charSequence;
                                        if (string.getSOAPBody().hasFault()) {
                                            object = string;
                                            break block54;
                                        }
                                        object2 = string;
                                    }
                                    catch (Exception exception) {
                                        if (verbose) {
                                            Verbose.logException(exception);
                                        } else {
                                            exception.printStackTrace();
                                        }
                                        object2 = charSequence;
                                    }
                                    break block54;
                                }
                                object2 = charSequence;
                                break block54;
                            }
                            object2 = clientDispatcher.getWsMethod().getReturnType() == null ? null : clientDispatcher.getOutParams().remove(clientDispatcher.getWsMethod().getReturnType().getName());
                        }
                        catch (JAXRPCException jAXRPCException) {
                            object = new RemoteException(jAXRPCException.getMessage(), jAXRPCException.getLinkedCause());
                            Object var26_41 = null;
                            ((Thread)object3).setContextClassLoader(classLoader2);
                            break block55;
                        }
                        catch (SOAPFaultException sOAPFaultException) {
                            object = new RemoteException("SOAP Fault:" + (Object)((Object)sOAPFaultException) + "--- Detail:" + sOAPFaultException.getDetail(), sOAPFaultException);
                            Object var26_42 = null;
                            ((Thread)object3).setContextClassLoader(classLoader2);
                            break block55;
                        }
                        catch (RuntimeException runtimeException) {
                            object = new RemoteException(runtimeException.getMessage(), runtimeException);
                            Object var26_43 = null;
                            ((Thread)object3).setContextClassLoader(classLoader2);
                            break block55;
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            Object var26_44 = null;
                            ((Thread)object3).setContextClassLoader(classLoader2);
                        }
                    }
                    Object var26_40 = null;
                    ((Thread)object3).setContextClassLoader(classLoader2);
                }
                catch (Throwable throwable) {
                    Object var26_45 = null;
                    ((Thread)object3).setContextClassLoader(classLoader2);
                    throw throwable;
                }
            }
            if (verbose && (charSequence = HandlerIterator.getHandlerHistory(wlMessageContext)) != null) {
                Verbose.log("Async response message " + this.requestMsgIdMsg + " related to request msg " + this.relatesTo + this.rmSeqIdMsg + " has this *client* handler history: " + charSequence);
            }
            this.mc.setProperty("weblogic.wsee.async.invoke.state", (Object)this.ais);
            if (object != null) {
                if (verbose) {
                    charSequence = object.toString();
                    if (object instanceof SOAPMessage) {
                        try {
                            string = ((SOAPMessage)object).getSOAPBody().getFault();
                            charSequence = string.getFaultString();
                        }
                        catch (Exception exception) {
                            Verbose.logException(exception);
                        }
                    }
                    Verbose.log("Calculated FAULT async response for message " + this.requestMsgIdMsg + " related to request msg " + this.relatesTo + this.rmSeqIdMsg + ": " + charSequence);
                }
                this.mc.setProperty(AsyncResponseHandler.ASYNC_FAULT_PROPERTY, object);
            } else {
                if (verbose) {
                    Verbose.log("Calculated normal async response for message " + this.requestMsgIdMsg + " related to request msg " + this.relatesTo + this.rmSeqIdMsg + ": " + object2);
                }
                this.mc.setProperty(AsyncResponseHandler.ASYNC_RESULT_PROPERTY, object2);
            }
            if (AsyncUtil.isSoap12(this.mc)) {
                this.mc.setProperty("weblogic.wsee.ws.server.OperationName", (Object)new QName("http://www.bea.com/async/AsyncResponseServiceSoap12", "onAsyncDelivery"));
            } else {
                this.mc.setProperty("weblogic.wsee.ws.server.OperationName", (Object)new QName("http://www.bea.com/async/AsyncResponseService", "onAsyncDelivery"));
            }
            return null;
        }
    }
}

