/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.async;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.messaging.saf.SAFEndpoint;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.webservice.WebServiceLogger;
import weblogic.wsee.async.AsyncResponseHandler;
import weblogic.wsee.async.AsyncResponseWsrmWsscHandler;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.cluster.ClusterDispatcher;
import weblogic.wsee.cluster.ForwardingHandler;
import weblogic.wsee.conversation.ConversationHandshakeHandler;
import weblogic.wsee.conversation.ConversationMsgClusterService;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.reliability.ReliableConversationMsgClusterService;
import weblogic.wsee.reliability.WsrmEndpointManager;
import weblogic.wsee.reliability.WsrmSAFEndpoint;
import weblogic.wsee.reliability.WsrmServerHandler;
import weblogic.wsee.reliability.handshake.WsrmServerHandshakeHandler;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.server.jms.WsDispatchMessageListener;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.dispatch.server.SoapFaultHandler;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class AsyncResponseServiceDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(AsyncResponseServiceDeploymentListener.class);

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.say("AsyncResponseServiceDeploymentListener.process");
        }
        WsService wsService = wsDeploymentContext.getWsService();
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            HandlerList handlerList = wsPort.getInternalHandlerList();
            HandlerInfo handlerInfo = new HandlerInfo(AsyncResponseHandler.class, new HashMap(), null);
            HandlerInfo handlerInfo2 = new HandlerInfo(ForwardingHandler.class, new HashMap(), null);
            HandlerInfo handlerInfo3 = new HandlerInfo(ConversationHandshakeHandler.class, new HashMap(), null);
            HandlerInfo handlerInfo4 = new HandlerInfo(WsrmServerHandshakeHandler.class, new HashMap(), null);
            HandlerInfo handlerInfo5 = new HandlerInfo(WsrmServerHandler.class, new HashMap(), null);
            HandlerInfo handlerInfo6 = new HandlerInfo(AsyncResponseWsrmWsscHandler.class, new HashMap(), null);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("ADDRESSING_HANDLER");
            arrayList2.add("SECURITY_HANDLER");
            arrayList.add("OPERATION_LOOKUP_HANDLER");
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            arrayList4.add("CONNECTION_HANDLER");
            arrayList3.add("ADDRESSING_HANDLER");
            arrayList3.add("SECURITY_HANDLER");
            try {
                int n = handlerList.lenientInsert("WSRM_HANDSHAKE_HANDLER", handlerInfo4, arrayList2, arrayList);
                handlerList.insert("RELIABILITY_HANDLER", n + 1, handlerInfo5);
                handlerList.insert("CONVERSATION_HANDSHAKE_HANDLER", n + 2, handlerInfo3);
                handlerList.insert("ASYNC_RESPONSE_HANDLER", n + 3, handlerInfo);
                handlerList.remove("CODEC_HANDLER");
                n = handlerList.lenientInsert("FORWARDING_HANDLER", handlerInfo2, arrayList4, arrayList3);
                handlerList.insert("SOAP_FAULT_HANDLER", n + 1, new HandlerInfo(SoapFaultHandler.class, new HashMap(), null));
                handlerList.insert("ASYNC_RESPONSE_WSRM_WSSC_HANDLER", n + 2, handlerInfo6);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Failed to register handler", handlerException);
            }
            this.setupReliability(wsPort, wsDeploymentContext);
            this.setupClusterService();
        }
    }

    private void setupClusterService() {
        if (verbose) {
            Verbose.say("AsyncResponseServiceDeploymentListener.setupClusterService starting");
        }
        ClusterDispatcher clusterDispatcher = ClusterDispatcher.getInstance();
        clusterDispatcher.registerClusterService(new ConversationMsgClusterService());
        clusterDispatcher.registerClusterService(new ReliableConversationMsgClusterService());
        if (verbose) {
            Verbose.say("AsyncResponseServiceDeploymentListener.setupClusterService done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupReliability(WsPort wsPort, WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        Object object;
        int n;
        if (verbose) {
            Verbose.say("AsyncResponseServiceDeploymentListener.setupReliability: " + wsPort.getWsdlPort().getName());
        }
        WsrmEndpointManager wsrmEndpointManager = (WsrmEndpointManager)SAFManagerImpl.getManager().getEndpointManager(2);
        assert (wsrmEndpointManager != null);
        if (wsrmEndpointManager == null) {
            if (verbose) {
                Verbose.log("SAFManager not initialized. Async response service cannot initialize");
            }
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        WsDispatchMessageListener wsDispatchMessageListener = new WsDispatchMessageListener(wsPort);
        ServerUtil.QueueInfo queueInfo = ServerUtil.getMessagingQueueInfo();
        boolean bl = true;
        String string = null;
        for (n = 0; n < wsDeploymentContext.getServiceURIs().length; ++n) {
            String string2;
            object = wsDeploymentContext.getContextPath();
            string = string2 = wsDeploymentContext.getServiceURIs()[n];
            String string3 = AsyncUtil.calculateServiceTargetURI((String)object, string2);
            BufferManager bufferManager = BufferManager.instance();
            Object object2 = bufferManager;
            synchronized (object2) {
                if (bufferManager.getMessageListener(string3) != null) {
                    bl = false;
                    continue;
                }
                bufferManager.addMessageListener(string3, wsDispatchMessageListener);
            }
            bufferManager.setTargetQueue(string3, queueInfo);
            wsDeploymentContext.addBufferTargetURI(string3);
            object2 = new WsrmSAFEndpoint(string3);
            if (verbose) {
                Verbose.getOut().println("*********************************");
                Verbose.log("Adding endpoint at " + string3);
                Verbose.getOut().println("*********************************");
            }
            wsrmEndpointManager.addEndpoint(string3, (SAFEndpoint)object2);
            if (stringBuffer.length() == 0) {
                stringBuffer.append(AsyncUtil.getAsyncSelector(string3));
                continue;
            }
            stringBuffer.append(" OR (" + AsyncUtil.getAsyncSelector(string3) + ")");
        }
        if (bl) {
            if (verbose) {
                Verbose.log("Set up dynamic MDB to queue: " + queueInfo.getQueueName());
            }
            n = AsyncResponseServiceDeploymentListener.checkQueueExists(queueInfo.getQueueName()) ? 1 : 0;
            object = new SetupDynamicMDBArgs(string, wsDeploymentContext, stringBuffer.toString(), queueInfo.getQueueName(), queueInfo.getMdbRunAsPrincipalName(), "weblogic.wsee.server.jms.MdbWS", 180);
            if (n != 0) {
                if (verbose) {
                    Verbose.log("Found queue, continue set up dynamic MDB to queue: " + queueInfo.getQueueName());
                }
                AsyncUtil.setupDynamicMDB(((SetupDynamicMDBArgs)object).context, ((SetupDynamicMDBArgs)object).messageSelector, ((SetupDynamicMDBArgs)object).queueName, ((SetupDynamicMDBArgs)object).runAsPrincipalName, ((SetupDynamicMDBArgs)object).beanName, ((SetupDynamicMDBArgs)object).txnTimeout);
            } else {
                if (verbose) {
                    Verbose.log("Didn't find queue, defer MDB deployment waiting for queue: " + queueInfo.getQueueName());
                }
                ((SetupDynamicMDBArgs)object).logMessage = true;
                AsyncResponseServiceDeploymentListener.scheduleSetupDynamicMDBRetry((SetupDynamicMDBArgs)object);
            }
        }
    }

    private static boolean checkQueueExists(String string) {
        boolean bl;
        if (System.getProperty("weblogic.wsee.forceDeploy.async.response") != null) {
            bl = true;
        } else {
            try {
                InitialContext initialContext = new InitialContext();
                initialContext.lookup(string);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    private static void scheduleSetupDynamicMDBRetry(SetupDynamicMDBArgs setupDynamicMDBArgs) {
        if (setupDynamicMDBArgs.logMessage) {
            WebServiceLogger.logAsyncResponseServiceNotDeployed((String)setupDynamicMDBArgs.serviceUri, (String)setupDynamicMDBArgs.queueName);
        }
        long l = 60000L;
        TimerManager timerManager = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager();
        MyTimerListener myTimerListener = new MyTimerListener(setupDynamicMDBArgs);
        Timer timer = timerManager.schedule((TimerListener)myTimerListener, l);
        myTimerListener.setTimer(timer);
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }

    private static class MyTimerListener
    implements TimerListener {
        private SetupDynamicMDBArgs _args;
        private Timer _timer;

        public MyTimerListener(SetupDynamicMDBArgs setupDynamicMDBArgs) {
            this._args = setupDynamicMDBArgs;
        }

        public void setTimer(Timer timer) {
            this._timer = timer;
        }

        public void timerExpired(Timer timer) {
            if (verbose) {
                Verbose.log("Dynamic MDB timer popped. Looking for dynamic MDB queue: " + this._args.queueName);
            }
            try {
                boolean bl = AsyncResponseServiceDeploymentListener.checkQueueExists(this._args.queueName);
                this._timer.cancel();
                if (bl) {
                    if (verbose) {
                        Verbose.log("Found queue, continue set up dynamic MDB to queue: " + this._args.queueName);
                    }
                    WebServiceLogger.logAsyncResponseServiceDeployed((String)this._args.serviceUri, (String)this._args.queueName);
                    AsyncUtil.setupDynamicMDB(this._args.context, this._args.messageSelector, this._args.queueName, this._args.runAsPrincipalName, this._args.beanName, this._args.txnTimeout);
                } else {
                    this._args.logMessage = false;
                    AsyncResponseServiceDeploymentListener.scheduleSetupDynamicMDBRetry(this._args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class SetupDynamicMDBArgs {
        String serviceUri;
        WsDeploymentContext context;
        String messageSelector;
        String queueName;
        String runAsPrincipalName;
        String beanName;
        int txnTimeout;
        boolean logMessage;

        public SetupDynamicMDBArgs(String string, WsDeploymentContext wsDeploymentContext, String string2, String string3, String string4, String string5, int n) {
            this.serviceUri = string;
            this.context = wsDeploymentContext;
            this.messageSelector = string2;
            this.queueName = string3;
            this.runAsPrincipalName = string4;
            this.beanName = string5;
            this.txnTimeout = n;
        }
    }
}

