/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.async;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.addressing.RelatesToHeader;
import weblogic.wsee.async.AsyncInvokeState;
import weblogic.wsee.async.AsyncInvokeStateObjectHandler;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.cluster.CorrelationHeader;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.reliability.handshake.WsrmServerHandshakeHandler;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.security.wssp.handlers.WssServerHandler;
import weblogic.wsee.server.WsLifeCycleEvent;
import weblogic.wsee.server.WsLifeCycleListenerRegistry;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.Verbose;

public class AsyncResponseWsrmWsscHandler
extends GenericHandler {
    private static final boolean verbose = Verbose.isVerbose(AsyncResponseWsrmWsscHandler.class);
    public static final String RM_SECURE = "weblogic.wsee.rm.secure";

    public QName[] getHeaders() {
        return null;
    }

    public boolean handleRequest(MessageContext messageContext) {
        if (messageContext == null) {
            return true;
        }
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        MsgHeaders msgHeaders = wlMessageContext.getHeaders();
        if (msgHeaders == null) {
            return true;
        }
        if (verbose) {
            Verbose.log("AsyncResponseWsrmWsscHandler.handleRequest");
        }
        if (this.isRMActions(msgHeaders) && this.handleRequestSecurity(messageContext)) {
            return true;
        }
        SequenceHeader sequenceHeader = (SequenceHeader)msgHeaders.getHeader(SequenceHeader.TYPE);
        if (sequenceHeader == null) {
            return true;
        }
        WsrmSequenceContext wsrmSequenceContext = WsrmServerHandshakeHandler.getRMSequenceContext(false, sequenceHeader.getSequenceId());
        assert (wsrmSequenceContext != null);
        if (!wsrmSequenceContext.getWsrmSecurityContext().isSecureWithWssc()) {
            return true;
        }
        if (this.handleAsyncResponseSecurity(msgHeaders, messageContext, wsrmSequenceContext)) {
            return true;
        }
        if (this.handleConvIdSecurity(msgHeaders, messageContext, wsrmSequenceContext)) {
            return true;
        }
        WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_SEND_AFTER_RES_SEC_VALIDATION);
        return true;
    }

    private boolean handleConvIdSecurity(MsgHeaders msgHeaders, MessageContext messageContext, WsrmSequenceContext wsrmSequenceContext) {
        Throwable throwable;
        CorrelationHeader correlationHeader = (CorrelationHeader)msgHeaders.getHeader(CorrelationHeader.TYPE);
        if (correlationHeader == null) {
            return false;
        }
        if (!AsyncUtil.getWssServerHandler(wsrmSequenceContext).handleRequest(messageContext) && (throwable = WlMessageContext.narrow(messageContext).getFault()) != null) {
            throw new JAXRPCException(throwable);
        }
        return true;
    }

    private boolean handleRequestSecurity(MessageContext messageContext) throws JAXRPCException {
        Throwable throwable;
        if (!new WssServerHandler().handleRequest(messageContext) && (throwable = WlMessageContext.narrow(messageContext).getFault()) != null) {
            throw new JAXRPCException(throwable);
        }
        messageContext.setProperty(RM_SECURE, (Object)"true");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleAsyncResponseSecurity(MsgHeaders msgHeaders, MessageContext messageContext, WsrmSequenceContext wsrmSequenceContext) {
        AsyncInvokeState asyncInvokeState;
        RelatesToHeader relatesToHeader = (RelatesToHeader)msgHeaders.getHeader(RelatesToHeader.TYPE);
        if (relatesToHeader == null) {
            return false;
        }
        String string = relatesToHeader.getRelatedMessageId();
        WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.async.store", new AsyncInvokeStateObjectHandler());
        AsyncInvokeState asyncInvokeState2 = asyncInvokeState = this.getAsyncInvokeState(wsStorage, string);
        synchronized (asyncInvokeState2) {
            try {
                this.runSecurityHandlers(asyncInvokeState, messageContext, wsrmSequenceContext);
            }
            catch (JAXRPCException jAXRPCException) {
                wsStorage.remove(string);
                throw jAXRPCException;
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                wsStorage.remove(string);
                throw undeclaredThrowableException;
            }
            try {
                wsStorage.persistentPut(string, asyncInvokeState);
            }
            catch (PersistentStoreException persistentStoreException) {
                wsStorage.remove(string);
                throw new JAXRPCException((Throwable)persistentStoreException);
            }
            messageContext.setProperty(RM_SECURE, (Object)"true");
            messageContext.setProperty("weblogic.wsee.wssc.sct", asyncInvokeState.getMessageContext().getProperty("weblogic.wsee.wssc.sct"));
        }
        return true;
    }

    private void runSecurityHandlers(AsyncInvokeState asyncInvokeState, MessageContext messageContext, WsrmSequenceContext wsrmSequenceContext) {
        AuthenticatedSubject authenticatedSubject = asyncInvokeState.getSubject();
        AuthorizedInvoke authorizedInvoke = new AuthorizedInvoke(asyncInvokeState, messageContext, wsrmSequenceContext);
        if (authenticatedSubject != null) {
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())), (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)authorizedInvoke);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof IOException) {
                    throw new JAXRPCException((Throwable)privilegedActionException.getException());
                }
                throw new UndeclaredThrowableException(privilegedActionException.getException());
            }
        }
        try {
            authorizedInvoke.run();
        }
        catch (Exception exception) {
            throw new JAXRPCException((Throwable)exception);
        }
    }

    private boolean isSecure(AsyncInvokeState asyncInvokeState) {
        WlMessageContext wlMessageContext = asyncInvokeState.getMessageContext();
        return wlMessageContext.containsProperty("weblogic.xml.crypto.wss.WSSecurityContext");
    }

    private AsyncInvokeState getAsyncInvokeState(WsStorage wsStorage, String string) {
        try {
            AsyncInvokeState asyncInvokeState = (AsyncInvokeState)wsStorage.persistentGet(string);
            if (asyncInvokeState == null) {
                throw new JAXRPCException("Cannot retrieve request information for message " + string);
            }
            return asyncInvokeState;
        }
        catch (PersistentStoreException persistentStoreException) {
            if (verbose) {
                Verbose.logException(persistentStoreException);
            }
            throw new JAXRPCException((Throwable)persistentStoreException);
        }
    }

    private boolean isRMActions(MsgHeaders msgHeaders) {
        ActionHeader actionHeader = (ActionHeader)msgHeaders.getHeader(ActionHeader.TYPE);
        if (actionHeader == null) {
            return false;
        }
        String string = actionHeader.getActionURI();
        return string.startsWith(WsrmConstants.RMVersion.RM_10.getNamespaceUri()) || string.startsWith(WsrmConstants.RMVersion.RM_11.getNamespaceUri());
    }

    private class AuthorizedInvoke
    implements PrivilegedExceptionAction {
        private AsyncInvokeState ais = null;
        private MessageContext mc;
        private WsrmSequenceContext seqCtx;

        AuthorizedInvoke(AsyncInvokeState asyncInvokeState, MessageContext messageContext, WsrmSequenceContext wsrmSequenceContext) {
            this.ais = asyncInvokeState;
            this.mc = messageContext;
            this.seqCtx = wsrmSequenceContext;
        }

        public Object run() throws Exception {
            SoapMessageContext soapMessageContext = (SoapMessageContext)this.mc;
            WlMessageContext wlMessageContext = this.ais.getMessageContext();
            if (wlMessageContext == null) {
                throw new JAXRPCException("No message context saved");
            }
            ((SoapMessageContext)wlMessageContext).setMessage(soapMessageContext.getMessage());
            Throwable throwable = null;
            if (!AsyncUtil.getWssClientHandler(this.seqCtx).handleResponse((MessageContext)wlMessageContext) && (throwable = WlMessageContext.narrow(wlMessageContext).getFault()) != null) {
                throw new JAXRPCException(throwable);
            }
            return null;
        }
    }
}

