/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.async;

import com.bea.staxb.runtime.internal.ClassLoadingUtils;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.ejb.spi.DynamicEJBModule;
import weblogic.ejb.spi.DynamicEJBModuleFactory;
import weblogic.ejb.spi.EjbDescriptorBean;
import weblogic.j2ee.descriptor.RunAsBean;
import weblogic.j2ee.descriptor.SecurityIdentityBean;
import weblogic.j2ee.descriptor.wl.RunAsRoleAssignmentBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.webservice.WebServiceLogger;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.async.AsyncInvokeState;
import weblogic.wsee.async.AsyncPostCallContext;
import weblogic.wsee.async.AsyncPostCallContextImpl;
import weblogic.wsee.buffer2.api.common.BufferingFeature;
import weblogic.wsee.deploy.VersioningHelper;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ContainerFactory;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.security.WssClientHandler;
import weblogic.wsee.security.WssServerHandler;
import weblogic.wsee.security.WssServerPolicyHandler;
import weblogic.wsee.security.wssp.handlers.PostWssServerPolicyHandler;
import weblogic.wsee.security.wssp.handlers.PreWssClientPolicyHandler;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.util.EjbDescriptorCreator;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistry;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;

public class AsyncUtil {
    private static final boolean verbose = Verbose.isVerbose(AsyncUtil.class);
    public static final String SOAP12_ENVELOPE_NS = "http://www.w3.org/2003/05/soap-envelope";
    public static final String ASYNC_RESPONSE_SERVICE_CONTEXT_PATH = "weblogic.async.contextPath";
    public static final String ASYNC_RESPONSE_SERVICE_SERVICE_URI = "weblogic.async.serviceUri";
    private static AuthenticatedSubject _kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static String getAsyncUri(boolean bl, String string) {
        String string2 = System.getProperty(ASYNC_RESPONSE_SERVICE_CONTEXT_PATH);
        String string3 = System.getProperty(ASYNC_RESPONSE_SERVICE_SERVICE_URI);
        if (string2 == null) {
            string2 = "_async";
        }
        if (string3 == null) {
            string3 = "AsyncResponseService";
        }
        if (bl) {
            string3 = string3 + "Soap12";
        }
        if (!"http".equalsIgnoreCase(string)) {
            if ("https".equalsIgnoreCase(string)) {
                string3 = string3 + "Https";
            } else if ("jms".equalsIgnoreCase(string)) {
                string3 = string3 + "Jms";
            } else {
                throw new JAXRPCException("Unsupported transport: " + string);
            }
        }
        return "/" + string2 + "/" + string3;
    }

    public static boolean isSoap12(MessageContext messageContext) {
        if (!(messageContext instanceof WlMessageContext)) {
            return false;
        }
        WlMessageContext wlMessageContext = (WlMessageContext)messageContext;
        Dispatcher dispatcher = wlMessageContext.getDispatcher();
        if (dispatcher != null) {
            return dispatcher.isSOAP12();
        }
        if (!(messageContext instanceof SOAPMessageContext)) {
            return false;
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        try {
            if (SOAP12_ENVELOPE_NS.equals(sOAPMessageContext.getMessage().getSOAPPart().getEnvelope().getNamespaceURI())) {
                return true;
            }
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException((Throwable)sOAPException);
        }
        return false;
    }

    public static String getAsyncResponseMethodName(MessageContext messageContext) {
        String string = (String)messageContext.getProperty("weblogic.wsee.method.name");
        if (string == null) {
            throw new JAXRPCException("No method name property found");
        }
        String string2 = null;
        HashMap hashMap = (HashMap)messageContext.getProperty("weblogic.wsee.async.response.map");
        if (hashMap != null) {
            string2 = (String)hashMap.get(string);
        }
        if (string2 == null) {
            string2 = string.length() > 1 ? "on" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1, string.length()) + "AsyncResponse" : "on" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + "AsyncResponse";
        }
        return string2;
    }

    public static String getAsyncFailureMethodName(MessageContext messageContext) {
        String string = (String)messageContext.getProperty("weblogic.wsee.method.name");
        if (string == null) {
            throw new JAXRPCException("No method name property found");
        }
        String string2 = null;
        HashMap hashMap = (HashMap)messageContext.getProperty("weblogic.wsee.async.failure.map");
        if (hashMap != null) {
            string2 = (String)hashMap.get(string);
        }
        if (string2 == null) {
            string2 = string.length() > 1 ? "on" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1, string.length()) + "AsyncFailure" : "on" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + "AsyncFailure";
        }
        return string2;
    }

    public static Class[] getAsyncResponseMethodParams(MessageContext messageContext) {
        Class[] classArray;
        String string = (String)messageContext.getProperty("weblogic.wsee.return.type");
        if (string == null) {
            throw new JAXRPCException("No return type found");
        }
        if (string.equals("void")) {
            classArray = new Class[]{AsyncPostCallContext.class};
        } else {
            try {
                classArray = new Class[]{AsyncPostCallContext.class, ClassLoadingUtils.loadClass((String)string, null)};
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JAXRPCException((Throwable)classNotFoundException);
            }
        }
        return classArray;
    }

    public static Class[] getAsyncFailureMethodParams() {
        return new Class[]{AsyncPostCallContext.class, Throwable.class};
    }

    public static Container getContainer(MessageContext messageContext) {
        return ContainerFactory.getContainer(messageContext);
    }

    public static String getAsyncSelector(String string) {
        String string2 = new String(string);
        if (string.indexOf("/") == 0) {
            string2 = string.substring(1);
        }
        if (string.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("ASYNC_URI").append("= '").append(string2).append("'");
        stringBuffer.append(" OR ");
        stringBuffer.append("ASYNC_URI").append(" = '/").append(string2).append("'");
        stringBuffer.append(" OR ");
        stringBuffer.append("ASYNC_URI").append(" = '/").append(string2).append("/'");
        stringBuffer.append(" OR ");
        stringBuffer.append("ASYNC_URI").append(" = '").append(string2).append("/'");
        stringBuffer.append(")");
        if (verbose) {
            Verbose.say("Calculated selector for dynamic MDB: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static void setupDynamicMDB(WsDeploymentContext wsDeploymentContext, String string, String string2, String string3, String string4, int n) throws WsDeploymentException {
        AsyncUtil.setupDynamicMDB(wsDeploymentContext, string, string2, string3, string4, n, false);
    }

    public static void setupDynamicMDB(WsDeploymentContext wsDeploymentContext, String string, String string2, String string3, String string4, int n, boolean bl) throws WsDeploymentException {
        AsyncUtil.setupDynamicMDB(wsDeploymentContext, string, string2, string3, string4, n, bl, "weblogic.wsee.mdb.DispatchPolicy");
    }

    public static void setupDynamicMDB(WsDeploymentContext wsDeploymentContext, String string, String string2, String string3, String string4, int n, boolean bl, String string5) throws WsDeploymentException {
        Object object;
        try {
            object = new InitialContext();
            ((InitialContext)object).lookup(string2);
        }
        catch (Exception exception) {
            String string6 = wsDeploymentContext.getServiceName();
            if (wsDeploymentContext.getServiceURIs() != null && wsDeploymentContext.getServiceURIs().length > 0) {
                string6 = AsyncUtil.calculateServiceTargetURI(wsDeploymentContext.getContextPath(), wsDeploymentContext.getServiceURIs()[0]);
            }
            WebServiceLogger.logAsyncOperationsNotAvailable((String)string6, (String)string2);
            return;
        }
        object = DynamicEJBModuleFactory.createDynamicEJBModule(Guid.generateGuidStandardChar());
        EjbDescriptorBean ejbDescriptorBean = n > 0 ? EjbDescriptorCreator.createEjbDescriptorBean(Guid.generateGuidStandardChar(), string4, "javax.jms.Queue", string2, string, n) : EjbDescriptorCreator.createEjbDescriptorBean(Guid.generateGuidStandardChar(), string4, "javax.jms.Queue", string2, string);
        EjbDescriptorCreator.setDispatchPolicy(ejbDescriptorBean, string5);
        if (string3 != null) {
            SecurityIdentityBean securityIdentityBean = ejbDescriptorBean.getEjbJarBean().getEnterpriseBeans().getMessageDrivens()[0].createSecurityIdentity();
            RunAsBean runAsBean = securityIdentityBean.createRunAs();
            runAsBean.setRoleName("ReliableDeliveryRole");
            RunAsRoleAssignmentBean runAsRoleAssignmentBean = ejbDescriptorBean.getWeblogicEjbJarBean().createRunAsRoleAssignment();
            runAsRoleAssignmentBean.setRoleName("ReliableDeliveryRole");
            runAsRoleAssignmentBean.setRunAsPrincipalName(string3);
        }
        object.setEjbDescriptorBean(ejbDescriptorBean);
        if (!object.deployDynamicEJB()) {
            throw new WsDeploymentException("Cannot deploy dynamic MDB");
        }
        if (!object.startDynamicEJB()) {
            object.undeployDynamicEJB();
            throw new WsDeploymentException("Cannot start dynamic MDB");
        }
        if (bl) {
            BufferingFeature.registerQueue(string2, object);
        } else {
            wsDeploymentContext.addDynamicEjb((DynamicEJBModule)object);
        }
    }

    private static WsspVersion getWsspVersion(WsrmSequenceContext wsrmSequenceContext) {
        if (wsrmSequenceContext.getWsrmSecurityContext().isSecureWithWssp10Wssc()) {
            return WsspVersion.WSSP10;
        }
        if (wsrmSequenceContext.getWsrmSecurityContext().isSecureWithWssp12Wssc() || wsrmSequenceContext.getWsrmSecurityContext().isSecureWithWssp12Wssc13()) {
            return WsspVersion.WSSP12;
        }
        throw new JAXRPCException("Not a secure RM sequence");
    }

    public static GenericHandler getWssServerHandler(WsrmSequenceContext wsrmSequenceContext) {
        assert (wsrmSequenceContext != null);
        WsspVersion wsspVersion = AsyncUtil.getWsspVersion(wsrmSequenceContext);
        if (wsspVersion == WsspVersion.WSSP10) {
            return new WssServerHandler();
        }
        return new weblogic.wsee.security.wssp.handlers.WssServerHandler();
    }

    public static GenericHandler getWssServerPolicyHandler(WsrmSequenceContext wsrmSequenceContext) {
        assert (wsrmSequenceContext != null);
        WsspVersion wsspVersion = AsyncUtil.getWsspVersion(wsrmSequenceContext);
        if (wsspVersion == WsspVersion.WSSP10) {
            return new WssServerPolicyHandler();
        }
        return new PostWssServerPolicyHandler();
    }

    public static GenericHandler getWssClientHandler(WsrmSequenceContext wsrmSequenceContext) {
        assert (wsrmSequenceContext != null);
        WsspVersion wsspVersion = AsyncUtil.getWsspVersion(wsrmSequenceContext);
        if (wsspVersion == WsspVersion.WSSP10) {
            return new WssClientHandler();
        }
        return new weblogic.wsee.security.wssp.handlers.WssClientHandler();
    }

    public static GenericHandler getWssClientPolicyHandler(WsrmSequenceContext wsrmSequenceContext) {
        assert (wsrmSequenceContext != null);
        WsspVersion wsspVersion = AsyncUtil.getWsspVersion(wsrmSequenceContext);
        if (wsspVersion == WsspVersion.WSSP10) {
            return null;
        }
        return new PreWssClientPolicyHandler();
    }

    public static void setApplicationVersionIdIntoContexts(MessageContext messageContext, AsyncPostCallContextImpl asyncPostCallContextImpl) {
        String string = ApplicationVersionUtils.getCurrentVersionId();
        if (string != null) {
            String string2 = ApplicationVersionUtils.getApplicationName(ApplicationVersionUtils.getCurrentApplicationId());
            asyncPostCallContextImpl.setProperty("weblogic.wsee.async.appname", string2);
            asyncPostCallContextImpl.setProperty("weblogic.wsee.async.appversion", string);
            messageContext.setProperty("weblogic.wsee.async.appname", (Object)string2);
            messageContext.setProperty("weblogic.wsee.async.appversion", (Object)string);
            VersioningHelper.updateCount(string2, string, 1);
        }
    }

    public static SavedServiceInfo getSavedServiceInfo(AsyncInvokeState asyncInvokeState, boolean bl) {
        SavedServiceInfo savedServiceInfo = new SavedServiceInfo();
        savedServiceInfo.apc = asyncInvokeState.getAsyncPostCallContext();
        savedServiceInfo.version = (String)asyncInvokeState.getAsyncPostCallContext().getProperty("weblogic.wsee.async.appversion");
        if (bl) {
            Verbose.log("Version from ais = " + savedServiceInfo.version);
        }
        savedServiceInfo.uri = (String)asyncInvokeState.getMessageContext().getProperty("weblogic.wsee.enclosing.jws.serviceuri");
        if (savedServiceInfo.uri == null) {
            throw new JAXRPCException("No enclosing JWS service URI provided, cannot complete async operation response phase.");
        }
        if (savedServiceInfo.version != null) {
            if (bl) {
                Verbose.log("Async Response bean - adding version " + savedServiceInfo.version + " to URI " + savedServiceInfo.uri);
            }
            savedServiceInfo.uri = savedServiceInfo.uri + "#" + savedServiceInfo.version;
        } else if (bl) {
            Verbose.log("Async response bean - no version ");
        }
        savedServiceInfo.wsPort = AsyncUtil.getPort(savedServiceInfo.uri);
        if (savedServiceInfo.wsPort == null) {
            throw new JAXRPCException("No port found for " + savedServiceInfo.uri);
        }
        return savedServiceInfo;
    }

    private static WsPort getPort(String string) {
        String string2 = WsRegistry.getURL(string);
        String string3 = WsRegistry.getVersion(string);
        return WsRegistry.instance().lookup(string2, string3);
    }

    public static EndpointReference getDefaultAsyncResponseServiceEPR(String string, boolean bl) {
        String string2 = ServerUtil.getServerURL(string) + AsyncUtil.getAsyncUri(bl, string);
        if ("jms".equalsIgnoreCase(string)) {
            string2 = AsyncUtil.getJMSUrl(string2, ServerUtil.getMessagingQueueInfo().getQueueName());
        }
        EndpointReference endpointReference = new EndpointReference(string2);
        return endpointReference;
    }

    private static String getJMSUrl(String string, String string2) {
        return string + "?URI=" + string2 + "&FACTORY=" + ServerUtil.getJmsConnectionFactory();
    }

    public static String getCurrentPrincipal() {
        return SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)_kernelId).toString();
    }

    public static String calculateServiceTargetURI(String string, String string2) {
        String string3 = string2 == null || string2.length() == 0 || string2.equals("/") ? (string.endsWith("/") ? string.substring(0, string.length() - 1) : string) : string + string2;
        if (verbose) {
            Verbose.say("&& Calculated service target URI '" + string3 + "' from contextPath '" + string + "' and service URI '" + string2 + "'");
        }
        return string3;
    }

    public static class SavedServiceInfo {
        public String version;
        public String uri;
        public AsyncPostCallContextImpl apc;
        public WsPort wsPort;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WsspVersion {
        WSSP10,
        WSSP12;

    }
}

