/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.async;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.xml.domimpl.Saver;
import weblogic.xml.domimpl.SaverOptions;
import weblogic.xml.jaxp.WebLogicDocumentBuilderFactory;

public class AsyncWsdlFactory {
    public static final String WSDL_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/";

    public static byte[] create(byte[] byArray) {
        try {
            Node node;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DocumentBuilderFactory documentBuilderFactory = WebLogicDocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(byteArrayInputStream);
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                System.out.println("## Found element with local name: " + element.getLocalName() + " and URI=" + element.getNamespaceURI());
                if (!"portType".equals(element.getLocalName()) && !"binding".equals(element.getLocalName()) || !WSDL_NAMESPACE_URI.equals(element.getNamespaceURI())) continue;
                System.out.println("Converting operations in the above element");
                AsyncWsdlFactory.convertOperationsToAsync(document, element);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            node = SaverOptions.getDefaults();
            node.setPrettyPrint(true);
            node.setWriteXmlDeclaration(true);
            Saver.save((OutputStream)byteArrayOutputStream, (Document)document, (SaverOptions)node);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    private static void convertOperationsToAsync(Document document, Element element) {
        NodeList nodeList = element.getElementsByTagNameNS(WSDL_NAMESPACE_URI, "operation");
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Object object2;
            Element element2 = (Element)nodeList.item(i);
            System.out.println("Converting operation: " + element2.getAttribute("name"));
            Node node = null;
            Node node2 = null;
            NodeList nodeList2 = element2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                object2 = nodeList2.item(j);
                System.out.println("Found child node of operation: " + object2.getLocalName());
                if (object2.getNodeType() == 1 && object2.getLocalName().equals("input")) {
                    node = (Element)object2;
                    continue;
                }
                if (object2.getNodeType() != 1 || !object2.getLocalName().equals("output")) continue;
                node2 = (Element)object2;
            }
            if (node2 == null) {
                arrayList.add(element2);
                continue;
            }
            if (node == null) {
                String string = node2.getNamespaceURI();
                object2 = node2.getPrefix();
                object = object2 != null ? (String)object2 + ":" : "";
                object = (String)object + "input";
                node = document.createElementNS(string, (String)object);
                element2.insertBefore(node, node2);
            } else {
                AsyncWsdlFactory.clearElement(node);
            }
            NodeList nodeList3 = node2.getChildNodes();
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                object = nodeList3.item(j);
                node.appendChild((Node)object);
            }
            object2 = node2.getAttributes();
            for (int j = 0; j < object2.getLength(); ++j) {
                Attr attr = (Attr)object2.item(j);
                Attr attr2 = (Attr)attr.cloneNode(true);
                node.setAttributeNodeNS(attr2);
            }
            element2.removeChild(node2);
        }
        for (Element element2 : arrayList) {
            element.removeChild(element2);
        }
    }

    private static void clearElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            element.removeChild(node);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            element.removeAttributeNode(attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Usage: AsyncWsdlFactory <input WSDL file> <output WSDL file>");
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        int n = 0;
        try {
            int n2;
            fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[2048];
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = AsyncWsdlFactory.create(byteArrayOutputStream.toByteArray());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            fileOutputStream = new FileOutputStream(file2);
            while ((n2 = byteArrayInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = 1;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        System.exit(n);
    }
}

