/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.async;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.logging.NonCatalogLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wsee.async.AsyncSOAPInvokeState;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.server.EncryptionUtil;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.xml.saaj.MessageFactoryImpl;
import weblogic.xml.saaj.SOAPMessageImpl;

public class SOAPInvokeState
implements AsyncSOAPInvokeState {
    private static final long serialVersionUID = 7337837335502099161L;
    private static final int HASSUBJECT = 1;
    private static final int HASSERVICEURI = 2;
    private SOAPMessage msg = null;
    private AuthenticatedSubject subject = null;
    private Map msgCtxProperties = new HashMap();
    private boolean isSoap12 = false;
    private boolean isMtom = false;
    private String charset = "utf-8";
    private String serviceURI;
    private static HashSet<String> excludedProperties = new HashSet<String>(Arrays.asList("weblogic.wsee.wsrm.sequence.expiration", "weblogic.wsee.wsrm.offer.sequence.expiration", "weblogic.wsee.wsrm.SequenceExpiration", "weblogic.wsee.jws.container", "weblogic.wsee.ejb.target", "weblogic.wsee.handler.jaxrpcHandlerChain"));
    public static final String USER_DEFINED_EXCLUDED_PROPERTIES = "weblogic.wsee.exclude.properties";

    private static void init() {
        String string = System.getProperty(USER_DEFINED_EXCLUDED_PROPERTIES);
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            excludedProperties.add(string2);
        }
    }

    public SOAPInvokeState() {
    }

    public SOAPInvokeState(SOAPMessage sOAPMessage) {
        this(sOAPMessage, true);
    }

    public SOAPInvokeState(SOAPMessage sOAPMessage, boolean bl) {
        this.msg = sOAPMessage;
        this.isMtom = ((SOAPMessageImpl)sOAPMessage).getIsMTOMmessage();
        this.charset = ((SOAPMessageImpl)sOAPMessage).getProperty("javax.xml.soap.character-set-encoding") != null ? (String)((SOAPMessageImpl)sOAPMessage).getProperty("javax.xml.soap.character-set-encoding") : "utf-8";
        if (bl) {
            this.msg = this.getClonedSOAPMessage();
        }
    }

    public SOAPInvokeState(SOAPMessageContext sOAPMessageContext) {
        this(sOAPMessageContext, true);
    }

    public SOAPInvokeState(SOAPMessageContext sOAPMessageContext, boolean bl) {
        if (AsyncUtil.isSoap12((MessageContext)sOAPMessageContext)) {
            this.isSoap12 = true;
        }
        this.msg = sOAPMessageContext.getMessage();
        this.isMtom = ((SOAPMessageImpl)this.msg).getIsMTOMmessage();
        this.charset = ((SOAPMessageImpl)this.msg).getProperty("javax.xml.soap.character-set-encoding") != null ? (String)((SOAPMessageImpl)this.msg).getProperty("javax.xml.soap.character-set-encoding") : "utf-8";
        if (bl) {
            this.msg = this.getClonedSOAPMessage();
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow((MessageContext)sOAPMessageContext);
        try {
            this.serviceURI = wlMessageContext.getDispatcher().getConnection().getTransport().getServiceURI();
        }
        catch (NullPointerException nullPointerException) {
            this.serviceURI = null;
        }
        Iterator iterator = sOAPMessageContext.getPropertyNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.msgCtxProperties.put(string, sOAPMessageContext.getProperty(string));
        }
    }

    public SOAPMessage getSOAPMessage() {
        return this.msg;
    }

    public SOAPMessage getClonedSOAPMessage() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            ((Externalizable)this.msg).writeExternal(objectOutputStream);
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory(this.isSoap12);
            SOAPMessage sOAPMessage = this.isMtom ? ((MessageFactoryImpl)messageFactory).createMessage(false, true) : messageFactory.createMessage();
            MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
            mimeHeaders.removeAllHeaders();
            Iterator iterator = this.msg.getMimeHeaders().getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                mimeHeaders.addHeader(mimeHeader.getName(), mimeHeader.getValue());
            }
            ((Externalizable)sOAPMessage).readExternal(objectInputStream);
            if (this.charset != null) {
                sOAPMessage.setProperty("javax.xml.soap.character-set-encoding", (Object)this.charset);
            }
            return sOAPMessage;
        }
        catch (IOException iOException) {
            throw new JAXRPCException((Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXRPCException((Throwable)classNotFoundException);
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException((Throwable)sOAPException);
        }
    }

    public boolean isSoap12() {
        return this.isSoap12;
    }

    public Map getMessageContextProperties() {
        return this.msgCtxProperties;
    }

    public void setSubject(AuthenticatedSubject authenticatedSubject) {
        this.subject = authenticatedSubject;
    }

    public AuthenticatedSubject getSubject(AuthenticatedSubject authenticatedSubject) {
        if (!SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            throw new SecurityException("Unauthorized access to SOAPInvokeState.getSubject()");
        }
        return this.subject;
    }

    public long getPayloadSize() {
        if (this.msg == null) {
            return 0L;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.msg.writeTo((OutputStream)byteArrayOutputStream);
        }
        catch (SOAPException sOAPException) {
            return 0L;
        }
        catch (IOException iOException) {
            return 0L;
        }
        return byteArrayOutputStream.toByteArray().length;
    }

    public String getServiceURI() {
        return this.serviceURI;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        String string = objectInput.readUTF();
        boolean bl = false;
        boolean bl2 = false;
        if ("9.2".equals(string)) {
            bl = true;
        } else if ("9.5".equals(string)) {
            bl2 = true;
        } else if (!"10.3".equals(string)) {
            throw new IOException("Wrong version, expected: 10.3 actual: " + string);
        }
        this.isSoap12 = objectInput.readBoolean();
        if (!bl && !bl2) {
            this.isMtom = objectInput.readBoolean();
            this.charset = objectInput.readUTF();
        }
        try {
            MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory(this.isSoap12);
            this.msg = this.isMtom ? ((MessageFactoryImpl)messageFactory).createMessage(false, true) : messageFactory.createMessage();
        }
        catch (SOAPException sOAPException) {
            throw new IOException(sOAPException.getMessage());
        }
        if (!bl) {
            int n = objectInput.readInt();
            MimeHeaders mimeHeaders = this.msg.getMimeHeaders();
            mimeHeaders.removeAllHeaders();
            for (int i = 0; i < n; ++i) {
                mimeHeaders.addHeader(objectInput.readUTF(), objectInput.readUTF());
            }
        }
        ((Externalizable)this.msg).readExternal(objectInput);
        int n = objectInput.readInt();
        if ((n & 1) != 0) {
            try {
                int n2 = objectInput.readInt();
                byte[] byArray = new byte[n2];
                objectInput.readFully(byArray);
                byArray = EncryptionUtil.decrypt(byArray);
                object2 = new ByteArrayInputStream(byArray);
                object = new ObjectInputStream((InputStream)object2);
                this.subject = (AuthenticatedSubject)((ObjectInputStream)object).readObject();
            }
            catch (Exception exception) {
                new NonCatalogLogger("WebServices").warning("Couldn't completely read SOAPInvokeState object", (Throwable)exception);
            }
        } else {
            this.subject = null;
        }
        int n3 = objectInput.readInt();
        for (int i = 0; i < n3; ++i) {
            object2 = objectInput.readUTF();
            if (((String)object2).equals("javax.xml.rpc.security.auth.password")) {
                int n4 = objectInput.readInt();
                if (n4 > 0) {
                    byte[] byArray = new byte[n4];
                    objectInput.readFully(byArray);
                    byte[] byArray2 = EncryptionUtil.decrypt(byArray);
                    object = new String(byArray2);
                } else {
                    object = null;
                }
            } else {
                object = (Serializable)objectInput.readObject();
            }
            this.msgCtxProperties.put(object2, object);
        }
        if ((n & 2) != 0) {
            this.serviceURI = objectInput.readUTF();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Iterator iterator;
        int n;
        objectOutput.writeUTF("10.3");
        objectOutput.writeBoolean(this.isSoap12);
        objectOutput.writeBoolean(this.isMtom);
        objectOutput.writeUTF(this.charset);
        if (this.msg != null) {
            Iterator iterator2 = this.msg.getMimeHeaders().getAllHeaders();
            n = 0;
            while (iterator2.hasNext()) {
                iterator2.next();
                ++n;
            }
            objectOutput.writeInt(n);
            iterator2 = this.msg.getMimeHeaders().getAllHeaders();
            while (iterator2.hasNext()) {
                iterator = (MimeHeader)iterator2.next();
                objectOutput.writeUTF(iterator.getName());
                objectOutput.writeUTF(iterator.getValue());
            }
            ((Externalizable)this.msg).writeExternal(objectOutput);
        }
        int n2 = 0;
        if (this.subject != null) {
            n2 |= 1;
        }
        if (this.serviceURI != null) {
            n2 |= 2;
        }
        objectOutput.writeInt(n2);
        if (this.subject != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            iterator = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)((Object)iterator)).writeObject(this.subject);
            ((ObjectOutputStream)((Object)iterator)).flush();
            Object object = byteArrayOutputStream.toByteArray();
            object = EncryptionUtil.encrypt((byte[])object);
            objectOutput.writeInt(((Object)object).length);
            objectOutput.write((byte[])object);
        }
        n = 0;
        for (Object object : this.msgCtxProperties.keySet()) {
            if (excludedProperties.contains(object)) continue;
            ++n;
        }
        objectOutput.writeInt(n);
        for (Object object : this.msgCtxProperties.keySet()) {
            if (excludedProperties.contains(object)) continue;
            Object v = this.msgCtxProperties.get(object);
            if (v != null && !(v instanceof Serializable)) {
                throw new IOException("The property " + (String)object + " is not serializable");
            }
            Serializable serializable = (Serializable)v;
            if (serializable != null) {
                Serializable serializable2 = serializable;
                synchronized (serializable2) {
                    this.writeContextValue((String)object, serializable, objectOutput);
                    continue;
                }
            }
            this.writeNullContextValue((String)object, objectOutput);
        }
        if (this.serviceURI != null) {
            objectOutput.writeUTF(this.serviceURI);
        }
    }

    private void writeContextValue(String string, Serializable serializable, ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(string);
        if (string.equals("javax.xml.rpc.security.auth.password")) {
            byte[] byArray = ((String)((Object)serializable)).getBytes();
            byte[] byArray2 = EncryptionUtil.encrypt(byArray);
            objectOutput.writeInt(byArray2.length);
            objectOutput.write(byArray2);
        } else {
            objectOutput.writeObject(serializable);
        }
    }

    private void writeNullContextValue(String string, ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(string);
        if (string.equals("javax.xml.rpc.security.auth.password")) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeObject(null);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.writeExternal(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.readExternal(objectInputStream);
    }

    static {
        SOAPInvokeState.init();
    }
}

