/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind;

import com.bea.xbean.schema.SoapEncSchemaTypeSystem;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.SchemaTypeSystem;
import com.bea.xml.XmlBeans;
import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import com.bea.xml.XmlOptions;
import java.io.IOException;
import java.io.InputStream;

class SoapEncodingTypes {
    private static String SOAP_ENCODING_FILE = "SoapEncoding11.xsd";
    private static SoapEncodingTypes INSTANCE = SoapEncodingTypes.createInstance();
    private SchemaTypeSystem mTypeSystem;

    static SoapEncodingTypes getInstance() {
        return INSTANCE;
    }

    private static SoapEncodingTypes createInstance() {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        try {
            thread2.setContextClassLoader(ClassLoader.getSystemClassLoader());
            SoapEncodingTypes soapEncodingTypes = new SoapEncodingTypes();
            return soapEncodingTypes;
        }
        catch (XmlException xmlException) {
            throw new RuntimeException(xmlException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            thread2.setContextClassLoader(classLoader);
        }
    }

    SchemaTypeSystem getSchemaTypeSystem() {
        return this.mTypeSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SoapEncodingTypes() throws XmlException, IOException {
        SchemaDocument schemaDocument;
        XmlOptions xmlOptions;
        InputStream inputStream = this.getClass().getResourceAsStream(SOAP_ENCODING_FILE);
        if (inputStream == null) {
            throw new AssertionError((Object)(SOAP_ENCODING_FILE + " is not in the classpath"));
        }
        try {
            xmlOptions = new XmlOptions();
            xmlOptions.setDocumentSourceName("http://schemas.xmlsoap.org/soap/encoding");
            xmlOptions.setCompileDownloadUrls();
            xmlOptions.setLoadUseDefaultResolver();
            schemaDocument = SchemaDocument.Factory.parse((InputStream)inputStream, (XmlOptions)xmlOptions);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        xmlOptions = new XmlOptions();
        xmlOptions.setCompileDownloadUrls();
        xmlOptions.setLoadUseDefaultResolver();
        xmlOptions.setCompileNoAnnotations();
        this.mTypeSystem = XmlBeans.compileXsd((XmlObject[])new SchemaDocument[]{schemaDocument}, (SchemaTypeLoader)SoapEncSchemaTypeSystem.get(), (XmlOptions)xmlOptions);
    }
}

