/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind;

import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import com.bea.util.jam.JParameter;
import com.bea.xml.XmlObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.bind.buildtime.S2JBindingsBuilder;
import weblogic.wsee.bind.buildtime.internal.EmptyBuildtimeBindings;
import weblogic.wsee.bind.buildtime.internal.TylarBuildtimeBindings;
import weblogic.wsee.bind.buildtime.internal.TylarS2JBindingsBuilderImpl;
import weblogic.wsee.bind.buildtime.internal.XmlBeansApacheBindingsBuilderImpl;
import weblogic.wsee.bind.buildtime.internal.XmlBeansApacheBuildtimeBindings;
import weblogic.wsee.bind.buildtime.internal.XmlBeansBindingsBuilderImpl;
import weblogic.wsee.bind.buildtime.internal.XmlBeansBuildtimeBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeFamily {
    private static HashMap<String, TypeFamily> keyMap = new HashMap();
    private String id;
    private String jarName;
    private BuildtimeBindings.Factory buildtimeBindingsFactory;
    private S2JBindingsBuilder s2jBindingsBuilder;
    public static final TypeFamily TYLAR = new TypeFamily("TYLAR", "tylar", TylarBuildtimeBindings.Factory.getInstance(), new TylarS2JBindingsBuilderImpl());
    public static final TypeFamily XMLBEANS = new TypeFamily("XMLBEANS", "xmlbeans", XmlBeansBuildtimeBindings.Factory.getInstance(), new XmlBeansBindingsBuilderImpl());
    public static final TypeFamily XMLBEANS_APACHE = new TypeFamily("XMLBEANS_APACHE", "xmlbeans_apache", XmlBeansApacheBuildtimeBindings.Factory.getInstance(), new XmlBeansApacheBindingsBuilderImpl());
    public static final TypeFamily NO_COMPLEX_TYPES = new TypeFamily("NO_COMPLEX_TYPES", "noCmplxTypes", EmptyBuildtimeBindings.Factory.getInstance(), null);

    private TypeFamily(String string, String string2, BuildtimeBindings.Factory factory, S2JBindingsBuilder s2JBindingsBuilder) {
        this.id = string;
        this.jarName = string2;
        this.buildtimeBindingsFactory = factory;
        this.s2jBindingsBuilder = s2JBindingsBuilder;
    }

    public String getId() {
        return this.id;
    }

    public String getJarName() {
        return this.jarName;
    }

    public BuildtimeBindings.Factory getBuildtimeBindingsFactory() {
        return this.buildtimeBindingsFactory;
    }

    public S2JBindingsBuilder getS2JBindingsBuilder() {
        return this.s2jBindingsBuilder;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof TypeFamily)) {
            return false;
        }
        TypeFamily typeFamily = (TypeFamily)object;
        return typeFamily.getId().equals(this.id);
    }

    public String toString() {
        return "id='" + this.id + "',  builderClass='" + this.getS2JBindingsBuilder().getClass().getName() + "'";
    }

    public static TypeFamily getTypeFamilyForKey(String string) {
        return keyMap.get(string.toUpperCase(Locale.ENGLISH));
    }

    public static Set<String> getTypeFamilyKeys() {
        return keyMap.keySet();
    }

    public static TypeFamily getTypeFamilyForClass(JClass jClass) {
        for (JMethod jMethod : jClass.getMethods()) {
            if (TypeFamily.isMatch(jMethod.getReturnType(), org.apache.xmlbeans.XmlObject.class)) {
                return XMLBEANS_APACHE;
            }
            if (TypeFamily.isMatch(jMethod.getReturnType(), XmlObject.class)) {
                return XMLBEANS;
            }
            for (JParameter jParameter : jMethod.getParameters()) {
                if (TypeFamily.isMatch(jParameter.getType(), org.apache.xmlbeans.XmlObject.class)) {
                    return XMLBEANS_APACHE;
                }
                if (!TypeFamily.isMatch(jParameter.getType(), XmlObject.class)) continue;
                return XMLBEANS;
            }
        }
        return TYLAR;
    }

    private static boolean isMatch(JClass jClass, Class clazz) {
        JClass jClass2 = jClass.forName(clazz.getName());
        if (jClass2.isUnresolvedType()) {
            return false;
        }
        return jClass2.isAssignableFrom(jClass);
    }

    static {
        keyMap.put(TYLAR.getId().toUpperCase(Locale.ENGLISH), TYLAR);
        keyMap.put(XMLBEANS.getId().toUpperCase(Locale.ENGLISH), XMLBEANS);
        keyMap.put(XMLBEANS_APACHE.getId().toUpperCase(Locale.ENGLISH), XMLBEANS_APACHE);
        keyMap.put(NO_COMPLEX_TYPES.getId().toUpperCase(Locale.ENGLISH), NO_COMPLEX_TYPES);
    }
}

