/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.buildtime.internal;

import com.bea.staxb.buildtime.FaultMessage;
import com.bea.staxb.buildtime.WrappedOperationInfo;
import com.bea.xbean.schema.StscState;
import com.bea.xbean.xb.xmlconfig.ConfigDocument;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.XmlObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xb.xmlconfig.ConfigDocument;
import weblogic.wsee.util.Verbose;

public abstract class BindingsBuilderBase {
    private static final boolean VERBOSE = Verbose.isVerbose(BindingsBuilderBase.class);
    protected List<ClassLoader> mClassLoaders = null;
    protected List<QName> paramTypes = new ArrayList<QName>();
    protected List<QName> paramElements = new ArrayList<QName>();
    protected List<FaultMessage> faultTypes = new ArrayList<FaultMessage>();
    protected List<FaultMessage> faultElements = new ArrayList<FaultMessage>();
    protected List<WrappedOperationInfo> wrapperInfos = new ArrayList<WrappedOperationInfo>();
    protected boolean includeGlobalTypes = false;
    protected boolean sortSchemaTypes = false;
    protected ClassLoader mXmlObjectClassLoader = null;
    protected List<SchemaDocument> schemaDocs = new ArrayList<SchemaDocument>();
    protected File codegenDir = null;
    private static final String CONFIG_URI = "http://xml.apache.org/xmlbeans/2004/02/xbean/config";
    private static final String COMPATIBILITY_CONFIG_URI = "http://www.bea.com/2002/09/xbean/config";
    private static final Map MAP_COMPATIBILITY_CONFIG_URIS = new HashMap();

    public void addBaseTypeLibrary(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("BindingsBuilderBase.addBaseTypeLibrary() received null classloader");
        }
        if (this.mClassLoaders == null) {
            this.mClassLoaders = new ArrayList<ClassLoader>();
        }
        this.mClassLoaders.add(classLoader);
    }

    public void addParamType(QName qName) {
        this.paramTypes.add(qName);
    }

    public void addParamElement(QName qName) {
        this.paramElements.add(qName);
    }

    public void addFaultType(FaultMessage faultMessage) {
        this.faultTypes.add(faultMessage);
    }

    public void addFaultElement(FaultMessage faultMessage) {
        this.faultElements.add(faultMessage);
    }

    public void addWrapperOperation(WrappedOperationInfo wrappedOperationInfo) {
        this.wrapperInfos.add(wrappedOperationInfo);
    }

    public void includeGlobalTypes(boolean bl) {
        this.includeGlobalTypes = bl;
    }

    public void sortSchemaTypes(boolean bl) {
        this.sortSchemaTypes = bl;
    }

    protected ConfigDocument.Config[] getBindingConfig(File[] fileArray) throws com.bea.xml.XmlException {
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        com.bea.xml.SchemaTypeLoader schemaTypeLoader = com.bea.xml.XmlBeans.typeLoaderForClassLoader((ClassLoader)SchemaDocument.class.getClassLoader());
        ArrayList<ConfigDocument.Config> arrayList = new ArrayList<ConfigDocument.Config>();
        for (File file : fileArray) {
            ArrayList arrayList2 = new ArrayList();
            try {
                com.bea.xml.XmlOptions xmlOptions = new com.bea.xml.XmlOptions();
                xmlOptions.put((Object)"LOAD_LINE_NUMBERS");
                xmlOptions.setErrorListener(arrayList2);
                xmlOptions.setLoadSubstituteNamespaces(MAP_COMPATIBILITY_CONFIG_URIS);
                XmlObject xmlObject = schemaTypeLoader.parse(file, null, xmlOptions);
                if (!(xmlObject instanceof ConfigDocument)) {
                    StscState.addError(arrayList2, (String)"invalid.document.type", (Object[])new Object[]{file, "xsd config"}, (XmlObject)xmlObject);
                } else {
                    StscState.addInfo(arrayList2, (String)("Loading config file " + file));
                    if (xmlObject.validate(new com.bea.xml.XmlOptions().setErrorListener(arrayList2))) {
                        arrayList.add(((ConfigDocument)xmlObject).getConfig());
                    }
                }
            }
            catch (Exception exception) {
                throw new com.bea.xml.XmlException((Throwable)exception);
            }
            for (XmlObject xmlObject : arrayList2) {
                if (xmlObject.getSeverity() != 0) continue;
                throw new com.bea.xml.XmlException((com.bea.xml.XmlError)xmlObject);
            }
        }
        File[] fileArray2 = arrayList.toArray(new ConfigDocument.Config[arrayList.size()]);
        return fileArray2;
    }

    protected ConfigDocument.Config[] getApacheBindingConfig(File[] fileArray) throws XmlException {
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        SchemaTypeLoader schemaTypeLoader = XmlBeans.typeLoaderForClassLoader((ClassLoader)SchemaDocument.class.getClassLoader());
        ArrayList<ConfigDocument.Config> arrayList = new ArrayList<ConfigDocument.Config>();
        for (File file : fileArray) {
            ArrayList arrayList2 = new ArrayList();
            try {
                XmlOptions xmlOptions = new XmlOptions();
                xmlOptions.put((Object)"LOAD_LINE_NUMBERS");
                xmlOptions.setErrorListener(arrayList2);
                xmlOptions.setLoadSubstituteNamespaces(MAP_COMPATIBILITY_CONFIG_URIS);
                org.apache.xmlbeans.XmlObject xmlObject = schemaTypeLoader.parse(file, null, xmlOptions);
                if (!(xmlObject instanceof org.apache.xmlbeans.impl.xb.xmlconfig.ConfigDocument)) {
                    org.apache.xmlbeans.impl.schema.StscState.addError(arrayList2, (String)"invalid.document.type", (Object[])new Object[]{file, "xsd config"}, (org.apache.xmlbeans.XmlObject)xmlObject);
                } else {
                    org.apache.xmlbeans.impl.schema.StscState.addInfo(arrayList2, (String)("Loading config file " + file));
                    if (xmlObject.validate(new XmlOptions().setErrorListener(arrayList2))) {
                        arrayList.add(((org.apache.xmlbeans.impl.xb.xmlconfig.ConfigDocument)xmlObject).getConfig());
                    }
                }
            }
            catch (Exception exception) {
                throw new XmlException((Throwable)exception);
            }
            for (org.apache.xmlbeans.XmlObject xmlObject : arrayList2) {
                if (xmlObject.getSeverity() != 0) continue;
                throw new XmlException((XmlError)xmlObject);
            }
        }
        File[] fileArray2 = arrayList.toArray(new ConfigDocument.Config[arrayList.size()]);
        return fileArray2;
    }

    public void setXmlObjectClassLoader(ClassLoader classLoader) {
        this.mXmlObjectClassLoader = classLoader;
    }

    public ClassLoader getXmlObjectClassLoader() {
        return this.mXmlObjectClassLoader;
    }

    public void setCodegenDir(File file) {
        this.codegenDir = file;
    }

    public void addSchemaDocument(SchemaDocument schemaDocument) {
        if (schemaDocument == null) {
            throw new IllegalArgumentException("XmlBeansBindingsBuilderImpl.addSchemaDocument() received null xsd");
        }
        this.schemaDocs.add(schemaDocument);
        if (VERBOSE) {
            Verbose.log("added schema " + schemaDocument.getSchema().getTargetNamespace());
        }
    }

    static {
        MAP_COMPATIBILITY_CONFIG_URIS.put(COMPATIBILITY_CONFIG_URI, CONFIG_URI);
    }
}

