/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.buildtime.internal;

import com.bea.staxb.buildtime.internal.bts.BindingFile;
import com.bea.staxb.buildtime.internal.bts.BindingLoader;
import com.bea.staxb.buildtime.internal.bts.BindingType;
import com.bea.staxb.buildtime.internal.bts.BindingTypeName;
import com.bea.staxb.buildtime.internal.bts.ByNameBean;
import com.bea.staxb.buildtime.internal.bts.JavaTypeName;
import com.bea.staxb.buildtime.internal.bts.JaxrpcEnumType;
import com.bea.staxb.buildtime.internal.bts.ListArrayType;
import com.bea.staxb.buildtime.internal.bts.MethodName;
import com.bea.staxb.buildtime.internal.bts.QNameProperty;
import com.bea.staxb.buildtime.internal.bts.SimpleBindingType;
import com.bea.staxb.buildtime.internal.bts.SimpleContentBean;
import com.bea.staxb.buildtime.internal.bts.SimpleDocumentBinding;
import com.bea.staxb.buildtime.internal.bts.SoapArrayType;
import com.bea.staxb.buildtime.internal.bts.WrappedArrayType;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.staxb.buildtime.internal.tylar.Tylar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.JavaXmlTypeMappingBean;
import weblogic.j2ee.descriptor.PackageMappingBean;
import weblogic.j2ee.descriptor.VariableMappingBean;
import weblogic.wsee.util.ExceptionUtil;

class Buildtime109MappingHelper {
    private Tylar mTylar;
    private List mErrors = null;
    private Map mPackage2Namespace = new HashMap();

    public Buildtime109MappingHelper(Tylar tylar) {
        if (tylar == null) {
            throw new IllegalArgumentException("null tylars");
        }
        this.mTylar = tylar;
    }

    public void buildMappings(JavaWsdlMappingBean javaWsdlMappingBean) {
        for (BindingType bindingType : this.getBindingTypes()) {
            if (bindingType instanceof ByNameBean || bindingType instanceof SimpleContentBean || bindingType instanceof WrappedArrayType || bindingType instanceof SoapArrayType) {
                this.buildTypeMapping(javaWsdlMappingBean, bindingType.getName().getJavaName(), bindingType.getName().getXmlName(), "complexType");
                continue;
            }
            if (bindingType instanceof SimpleDocumentBinding) {
                this.buildTypeMappingForElement(javaWsdlMappingBean, bindingType.getName().getJavaName(), bindingType.getName().getXmlName(), ((SimpleDocumentBinding)bindingType).getTypeOfElement(), "element");
                continue;
            }
            if (bindingType instanceof JaxrpcEnumType || bindingType instanceof ListArrayType || bindingType instanceof SimpleBindingType) {
                this.buildSimpleType(javaWsdlMappingBean, bindingType);
                continue;
            }
            this.addError("BindingType is ignored " + bindingType.getName());
        }
        this.buildPackageMappings(javaWsdlMappingBean);
    }

    public Exception[] getErrors() {
        if (this.mErrors == null) {
            return new Exception[0];
        }
        Exception[] exceptionArray = new Exception[this.mErrors.size()];
        this.mErrors.toArray(exceptionArray);
        return exceptionArray;
    }

    private void addError(Throwable throwable) {
        if (this.mErrors == null) {
            this.mErrors = new ArrayList();
        }
        this.mErrors.add(throwable);
    }

    private void addError(String string) {
        this.addError(new Exception(string));
    }

    private void addPackageMapping(String string, XmlTypeName xmlTypeName) {
        if (xmlTypeName.getQName() == null) {
            this.addPackageMapping(string, xmlTypeName.getOuterComponent());
        } else {
            this.addPackageMapping(string, xmlTypeName.getQName());
        }
    }

    private void addPackageMapping(String string, QName qName) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("Buildtime109MappingHelper.addPackageMapping:  null javaclass corresponding to QName:" + qName);
        }
        if (qName == null) {
            throw new IllegalArgumentException("Buildtime109MappingHelper.addPackageMapping:  null QName corresponding to JavaClass " + string);
        }
        String string3 = qName.getNamespaceURI();
        boolean bl = ExceptionUtil.classNameIsSchemaBuiltin(string);
        if (string3.equals("http://www.w3.org/2001/XMLSchema") && bl) {
            return;
        }
        int n = string.lastIndexOf(".");
        boolean bl2 = n != -1;
        int n2 = string.indexOf("[]");
        boolean bl3 = n2 != -1;
        String string4 = null;
        if (bl2) {
            if (bl3 && ExceptionUtil.classNameIsSchemaBuiltin(string2 = string.substring(0, n2))) {
                return;
            }
            string4 = string.substring(0, n);
        } else {
            if (bl3) {
                return;
            }
            if (bl) {
                return;
            }
            string4 = string;
        }
        string2 = (String)this.mPackage2Namespace.get(string4);
        if (string2 == null) {
            this.mPackage2Namespace.put(string4, string3);
        } else if (!string2.equals(string4)) {
            this.addError("Namespace for " + string + " already mapped to " + string2);
        }
    }

    private void buildPackageMappings(JavaWsdlMappingBean javaWsdlMappingBean) {
        for (Map.Entry entry : this.mPackage2Namespace.entrySet()) {
            PackageMappingBean packageMappingBean = javaWsdlMappingBean.createPackageMapping();
            packageMappingBean.setNamespaceURI((String)entry.getValue());
            packageMappingBean.setPackageType((String)entry.getKey());
        }
    }

    private void buildSimpleType(JavaWsdlMappingBean javaWsdlMappingBean, BindingType bindingType) {
        JavaTypeName javaTypeName = bindingType.getName().getJavaName();
        XmlTypeName xmlTypeName = bindingType.getName().getXmlName();
        this.addPackageMapping(javaTypeName.toString(), xmlTypeName);
        JavaXmlTypeMappingBean javaXmlTypeMappingBean = javaWsdlMappingBean.createJavaXmlTypeMapping();
        javaXmlTypeMappingBean.setJavaType(javaTypeName.toString());
        javaXmlTypeMappingBean.setQnameScope("simpleType");
        if (xmlTypeName.isAnonymousType()) {
            javaXmlTypeMappingBean.setAnonymousTypeQname(Buildtime109MappingHelper.getAnonymousString(xmlTypeName));
        } else {
            javaXmlTypeMappingBean.setRootTypeQname(xmlTypeName.getQName());
        }
    }

    private void buildTypeMapping(JavaWsdlMappingBean javaWsdlMappingBean, JavaTypeName javaTypeName, XmlTypeName xmlTypeName, String string) {
        BindingLoader bindingLoader = this.mTylar.getBindingLoader();
        String string2 = javaTypeName.toString();
        BindingTypeName bindingTypeName = bindingLoader.lookupTypeFor(javaTypeName);
        BindingType bindingType = bindingLoader.getBindingType(bindingTypeName);
        JavaXmlTypeMappingBean javaXmlTypeMappingBean = javaWsdlMappingBean.createJavaXmlTypeMapping();
        this.addPackageMapping(string2, xmlTypeName);
        javaXmlTypeMappingBean.setJavaType(string2);
        if (xmlTypeName.isAnonymousType()) {
            javaXmlTypeMappingBean.setAnonymousTypeQname(Buildtime109MappingHelper.getAnonymousString(xmlTypeName));
        } else {
            javaXmlTypeMappingBean.setRootTypeQname(xmlTypeName.getQName());
        }
        javaXmlTypeMappingBean.setQnameScope(string);
        if (bindingType instanceof ByNameBean) {
            ByNameBean byNameBean = (ByNameBean)bindingType;
            this.addVariableMappings(javaXmlTypeMappingBean, byNameBean.getProperties());
            if (byNameBean.getAnyElementProperty() != null) {
                VariableMappingBean variableMappingBean = javaXmlTypeMappingBean.createVariableMapping();
                variableMappingBean.createXmlWildcard();
                this.fillVariableMappingBean((QNameProperty)byNameBean.getAnyElementProperty(), variableMappingBean);
            }
        } else if (bindingType instanceof SimpleContentBean) {
            this.addVariableMappings(javaXmlTypeMappingBean, ((SimpleContentBean)bindingType).getAttributeProperties());
        }
    }

    private void buildTypeMappingForElement(JavaWsdlMappingBean javaWsdlMappingBean, JavaTypeName javaTypeName, XmlTypeName xmlTypeName, XmlTypeName xmlTypeName2, String string) {
        if (javaTypeName == null) {
            throw new IllegalArgumentException("null jtn");
        }
        if (xmlTypeName == null) {
            throw new IllegalArgumentException("null xmlType");
        }
        if (javaTypeName.toString().equals("javax.xml.soap.SOAPElement")) {
            return;
        }
        String string2 = javaTypeName.toString();
        JavaXmlTypeMappingBean javaXmlTypeMappingBean = javaWsdlMappingBean.createJavaXmlTypeMapping();
        this.addPackageMapping(string2, xmlTypeName2);
        javaXmlTypeMappingBean.setJavaType(string2);
        if (xmlTypeName.isAnonymousType()) {
            javaXmlTypeMappingBean.setAnonymousTypeQname(Buildtime109MappingHelper.getAnonymousString(xmlTypeName));
        } else {
            javaXmlTypeMappingBean.setRootTypeQname(xmlTypeName.getQName());
        }
        javaXmlTypeMappingBean.setQnameScope(string);
    }

    private void addVariableMappings(JavaXmlTypeMappingBean javaXmlTypeMappingBean, Collection collection) {
        for (QNameProperty qNameProperty : collection) {
            VariableMappingBean variableMappingBean = javaXmlTypeMappingBean.createVariableMapping();
            if (qNameProperty.isAttribute()) {
                variableMappingBean.setXmlAttributeName(qNameProperty.getQName().getLocalPart());
            } else {
                variableMappingBean.setXmlElementName(qNameProperty.getQName().getLocalPart());
            }
            this.fillVariableMappingBean(qNameProperty, variableMappingBean);
        }
    }

    private void fillVariableMappingBean(QNameProperty qNameProperty, VariableMappingBean variableMappingBean) {
        String string = qNameProperty.getFieldName();
        if (string != null) {
            variableMappingBean.setJavaVariableName(string);
            variableMappingBean.createDataMember();
        } else {
            String string2;
            MethodName methodName = qNameProperty.getGetterName();
            if (methodName == null) {
                this.addError(new Exception("no getter for " + qNameProperty.getQName().getLocalPart()));
            }
            String string3 = (string2 = methodName.getSimpleName()).startsWith("is") ? string2.substring(2) : string2.substring(3);
            variableMappingBean.setJavaVariableName(string3);
        }
    }

    private List getBindingTypes() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getBindingFiles().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((BindingFile)iterator.next()).bindingTypes().iterator();
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
        }
        return arrayList;
    }

    private List getBindingFiles() {
        return Arrays.asList((Object[])this.mTylar.getBindingFiles());
    }

    private static String getAnonymousString(XmlTypeName xmlTypeName) {
        try {
            return Buildtime109MappingHelper.to109AnonymousTypeName(xmlTypeName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return xmlTypeName.toString().trim();
        }
    }

    private static String to109AnonymousTypeName(XmlTypeName xmlTypeName) {
        boolean bl;
        String string = xmlTypeName.toString().trim();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (string.length() < 1) {
            throw new IllegalArgumentException("malformed XmlTypeName document_type decl: " + string);
        }
        boolean bl2 = bl = string.charAt(0) == 'e';
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char c = string2.charAt(0);
            switch (c) {
                case 't': {
                    int n;
                    if (string2.length() == 1) {
                        if (!stringTokenizer.hasMoreTokens()) {
                            throw new IllegalArgumentException("malformed XmlTypeName document_type decl: " + string);
                        }
                        String string3 = stringTokenizer.nextToken();
                        if ('e' != string3.charAt(0)) {
                            throw new IllegalArgumentException("malformed XmlTypeName document_type decl: " + string);
                        }
                        if (string3.charAt(1) != '=' || string3.length() < 3) {
                            throw new IllegalArgumentException("malformed XmlTypeName element decl: " + string);
                        }
                        string3 = string3.substring(2);
                        if (stringBuffer.length() == 0) {
                            stringBuffer.append(">" + string3);
                            break;
                        }
                        n = Buildtime109MappingHelper.findInsertPoint(stringBuffer);
                        stringBuffer.insert(n, ">" + string3 + ">");
                        break;
                    }
                    int n2 = string2.indexOf(64);
                    if (n2 == -1 || n2 == string2.length() - 1) {
                        throw new IllegalArgumentException("malformed XmlTypeName document_type decl: " + string);
                    }
                    n = Buildtime109MappingHelper.findInsertPoint(stringBuffer);
                    stringBuffer.insert(n, string2.substring(2, n2) + ">");
                    stringBuffer.insert(0, string2.substring(n2 + 1) + ":");
                    break;
                }
                case 'e': {
                    if (bl && stringBuffer.length() == 0) {
                        stringBuffer.append(string2);
                        break;
                    }
                    throw new IllegalArgumentException("malformed XmlTypeName document_type decl: " + string);
                }
                case 'd': {
                    int n = string2.indexOf(64);
                    if (n == -1 || n == string2.length() - 1) {
                        throw new IllegalArgumentException("malformed XmlTypeName document_type decl: " + string);
                    }
                    stringBuffer.insert(0, string2.substring(n + 1) + ":");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unupported XmlTypeName component '" + c + "' in: " + string);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static int findInsertPoint(StringBuffer stringBuffer) {
        if (stringBuffer.charAt(0) == '>') {
            int n = stringBuffer.length();
            for (int i = 0; i < n; ++i) {
                if (stringBuffer.charAt(i) == '>') continue;
                return i;
            }
            throw new IllegalArgumentException(stringBuffer.toString() + " not a valid path.");
        }
        return 0;
    }
}

