/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.buildtime.internal;

import com.bea.staxb.buildtime.ArrayNameHelper;
import com.bea.staxb.buildtime.ArrayNamespaceInfo;
import com.bea.staxb.buildtime.BindingCompiler;
import com.bea.staxb.buildtime.Java2Schema;
import com.bea.staxb.buildtime.internal.Java2SchemaWrapperElement;
import com.bea.staxb.buildtime.internal.bts.BindingFile;
import com.bea.staxb.buildtime.internal.bts.BindingType;
import com.bea.staxb.buildtime.internal.bts.BindingTypeName;
import com.bea.staxb.buildtime.internal.bts.JavaTypeName;
import com.bea.staxb.buildtime.internal.bts.SimpleBindingType;
import com.bea.staxb.buildtime.internal.bts.SimpleDocumentBinding;
import com.bea.staxb.buildtime.internal.bts.SoapArrayType;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.staxb.buildtime.internal.logger.MessageSink;
import com.bea.staxb.buildtime.internal.tylar.ExplodedTylar;
import com.bea.util.jam.JClass;
import com.bea.xbean.xb.xsdschema.AnyDocument;
import com.bea.xbean.xb.xsdschema.Attribute;
import com.bea.xbean.xb.xsdschema.ComplexRestrictionType;
import com.bea.xbean.xb.xsdschema.DocumentationDocument;
import com.bea.xbean.xb.xsdschema.ExplicitGroup;
import com.bea.xbean.xb.xsdschema.ImportDocument;
import com.bea.xbean.xb.xsdschema.LocalComplexType;
import com.bea.xbean.xb.xsdschema.LocalElement;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xbean.xb.xsdschema.TopLevelComplexType;
import com.bea.xbean.xb.xsdschema.TopLevelElement;
import com.bea.xbean.xb.xsdschema.TopLevelSimpleType;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.XmlBeans;
import com.bea.xml.XmlCursor;
import com.bea.xml.XmlObject;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Element;
import weblogic.wsee.bind.buildtime.BindingException;
import weblogic.wsee.bind.buildtime.J2SBindingsBuilder;
import weblogic.wsee.bind.buildtime.internal.BindingMessageSink;
import weblogic.wsee.bind.buildtime.internal.Java2SchemaTypeWrapperElement;
import weblogic.wsee.bind.buildtime.internal.TylarBuildtimeBindings;
import weblogic.wsee.bind.buildtime.internal.TylarJ2SBindingsBuilderImpl;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.ObjectUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.XBeanSchemaProcessor;
import weblogic.wsee.util.XBeanUtil;

class SoapAwareJava2Schema
extends Java2Schema {
    private static final boolean verbose = Verbose.isVerbose(SoapAwareJava2Schema.class);
    private static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    private static final JavaTypeName SOAPELEMENT_JTN = JavaTypeName.forClassName((String)TylarJ2SBindingsBuilderImpl.SOAPELEMENT_CLASSNAME);
    private static final String SOAPELEMENT_CLASSNAME = SOAPElement.class.getName();
    private static final String UNBOUNDED = "unbounded";
    private static final String ANYTYPE = "anyType";
    private static final String SOAPENC_NS = "http://schemas.xmlsoap.org/soap/encoding/";
    protected static final QName SOAPENC_ARRAY = new QName("http://schemas.xmlsoap.org/soap/encoding/", "Array");
    protected static final QName SOAPENC_ARRAYTYPE = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    private static final QName XSD_ANYTYPE = new QName("http://www.w3.org/2001/XMLSchema", "anyType");
    protected static final String SOAPARRAY_NAME_PREFIX = "ArrayOf";
    private static final String SOAP_ENC_XSD_LOCATION = "/weblogic/wsee/wsdl/schema/soap-encoding-11.xsd";
    private static final SchemaDocument SOAP_ENC_SCHEMA_DOC;
    private BindingMessageSink messageSink = new BindingMessageSink();
    private boolean jaxRpcByteArrayStyle = false;
    private boolean localElementDefaultRequired = true;
    private boolean localElementDefaultNillable = true;
    private boolean setElementFormDefaultUnqualified = false;
    protected boolean allowNullByMinOccursZeroInWrapperElements = false;
    private boolean mNeedsSoapEncodedSchema = false;
    private List mAllSoapElements = null;
    private List mAllSoapElementsForElementAny = null;
    private List mSoapEncPrimitiveWrapperTypes = null;
    private Map mArray2SetOfSoapArrayElemQNames = null;
    private Map mArrayInfo2SetOfPrimitiveByteArrayElemQNamesInEncodedStyle = null;
    private List mWrapperElements = null;
    private List<Java2SchemaTypeWrapperElement> mTypeWrapperElements = null;
    private boolean mNeedListSchema = false;
    private List<ElementTypePair> mElmList = null;
    private J2SBindingsBuilder mJ2SBindingsBuilder = null;
    private Set<QName> mSpecialTypeQNames = null;
    protected Collection mGeneratedSoapArrayJavaTypeNames = new HashSet();
    private Set mXmlBeansClassNames = null;
    private Set mGeneratedXmlBeansArraySchemaTypeQNames = null;
    private Map mArray2SetOfXmlBeansLitArrayElemQNames = null;
    private List<SchemaDocument> mXBeanIncludedSchemas = new LinkedList<SchemaDocument>();

    public SoapAwareJava2Schema(J2SBindingsBuilder j2SBindingsBuilder) {
        this.mJ2SBindingsBuilder = j2SBindingsBuilder;
        this.setLocalElementDefaultRequired(this.localElementDefaultRequired);
        this.setLocalElementDefaultNillable(this.localElementDefaultNillable);
        this.setMessageSink((MessageSink)this.messageSink);
        if (this.setElementFormDefaultUnqualified) {
            super.setElementFormDefaultQualified(false);
        }
    }

    public void addTypeWrapperElement(Java2SchemaTypeWrapperElement java2SchemaTypeWrapperElement) {
        if (this.mTypeWrapperElements == null) {
            this.mTypeWrapperElements = new ArrayList<Java2SchemaTypeWrapperElement>();
        }
        JClass jClass = java2SchemaTypeWrapperElement.getServiceClass();
        JClass jClass2 = java2SchemaTypeWrapperElement.getElementJavaType();
        this.handleWrappedType(jClass, jClass2);
        this.mTypeWrapperElements.add(java2SchemaTypeWrapperElement);
    }

    public void addWrapperElement(Java2SchemaWrapperElement java2SchemaWrapperElement) {
        if (this.mWrapperElements == null) {
            this.mWrapperElements = new ArrayList();
        }
        JClass jClass = java2SchemaWrapperElement.getServiceClass();
        JClass[] jClassArray = java2SchemaWrapperElement.getElementJavaTypes();
        for (int i = 0; i < jClassArray.length; ++i) {
            JClass jClass2 = jClassArray[i];
            this.handleWrappedType(jClass, jClass2);
        }
        this.mWrapperElements.add(java2SchemaWrapperElement);
    }

    public void addSpecialTypeQNames(QName qName) {
        if (this.mSpecialTypeQNames == null) {
            this.mSpecialTypeQNames = new HashSet<QName>();
        }
        this.mSpecialTypeQNames.add(qName);
    }

    private void genearteSpecialTypeForRpcLitStyle(Map map) {
        if (this.mSpecialTypeQNames == null) {
            return;
        }
        for (QName qName : this.mSpecialTypeQNames) {
            String string;
            if (this.isTopLevelTypeExist(qName, string = qName.getNamespaceURI())) continue;
            this.addSpecialType(qName, map);
        }
    }

    private void handleWrappedType(JClass jClass, JClass jClass2) {
        if (jClass2.isArrayType()) {
            JClass jClass3 = jClass2.getArrayComponentType();
            if (XBeanUtil.isXmlBean(jClass3)) {
                this.addXmlBeanClassName(jClass3.getQualifiedName());
            } else if (this.isBoundToAnyType(jClass2.getQualifiedName())) {
                this.bindJavaArrayToLiteralArray(ClassUtil.getTargetNamespace(jClass), jClass, jClass2);
            }
        } else if (!TylarBuildtimeBindings.isSpecialJavaType(jClass2.getQualifiedName()) && !jClass2.getQualifiedName().equals(SOAPELEMENT_CLASSNAME)) {
            this.addClassToBind(jClass2);
        }
    }

    public void bindJavaArrayToSoapArray(String string, JClass jClass, JClass jClass2) {
        this.bindJavaArrayToSoapArray(string, jClass, jClass2, null);
    }

    public void bindJavaArrayToSoapArray(String string, JClass jClass, JClass jClass2, QName qName) {
        SoapAwareJava2Schema.validateArrayType(jClass2);
        Set set = this.findOrCreateElementNameSetFor(string, jClass, jClass2);
        if (qName != null) {
            set.add(qName);
        }
        if (this.typeIs1DPrimitiveByteArray(jClass2) && this.jaxRpcByteArrayStyle) {
            return;
        }
        this.addClassToBind(jClass2.getArrayComponentType());
    }

    public void addClassToBind(JClass jClass) {
        if (!XBeanUtil.isXmlBean(jClass)) {
            super.addClassToBind(jClass);
        } else {
            this.addXmlBeanClassName(jClass.getQualifiedName());
        }
    }

    public void addSoapElement(QName qName) {
        if (this.mAllSoapElements == null) {
            this.mAllSoapElements = new ArrayList();
        }
        this.mAllSoapElements.add(qName);
        if (!this.isBoundToAnyType(SOAPElement.class.getName())) {
            if (this.mAllSoapElementsForElementAny == null) {
                this.mAllSoapElementsForElementAny = new ArrayList();
            }
            this.mAllSoapElementsForElementAny.add(qName);
        }
    }

    void addSpecialJavaElement(QName qName, JClass jClass) {
        if (this.mElmList == null) {
            this.mElmList = new ArrayList<ElementTypePair>();
        }
        this.mElmList.add(new ElementTypePair(qName, jClass));
    }

    protected static void validateArrayType(JClass jClass) {
        if (jClass == null) {
            throw new IllegalArgumentException("null javatype");
        }
        if (!jClass.isArrayType()) {
            throw new IllegalArgumentException(jClass.getQualifiedName() + " is not an array type");
        }
    }

    protected void addEncodedClassToBind(JClass jClass) {
        if (this.mSoapEncPrimitiveWrapperTypes != null && this.mSoapEncPrimitiveWrapperTypes.contains(jClass)) {
            return;
        }
        if (JamUtil.isSoapEncJavaPrimitiveWrapperClass(jClass)) {
            this.assertResolved(jClass);
            if (this.mSoapEncPrimitiveWrapperTypes == null) {
                this.mSoapEncPrimitiveWrapperTypes = new ArrayList();
            }
            this.mSoapEncPrimitiveWrapperTypes.add(jClass);
            this.mNeedsSoapEncodedSchema = true;
            return;
        }
        if (SoapAwareJava2Schema.isCollectionType((JClass)jClass)) {
            this.mSoapSpecificTypes.add(jClass);
        }
        this.addClassToBind(jClass);
    }

    protected BindingType createJavaCollectionType(BindingTypeName bindingTypeName) {
        SoapArrayType soapArrayType = SoapAwareJava2Schema.createSoapEncCollectionType((BindingTypeName)bindingTypeName);
        this.mBindingFile.addBindingType((BindingType)soapArrayType, true, true);
        QName qName = bindingTypeName.getXmlName().getQName();
        SchemaDocument.Schema schema = this.findOrCreateSchema(qName.getNamespaceURI());
        SoapAwareJava2Schema.addSoapEncNS(schema);
        TopLevelComplexType topLevelComplexType = schema.addNewComplexType();
        topLevelComplexType.setName(qName.getLocalPart());
        ComplexRestrictionType complexRestrictionType = topLevelComplexType.addNewComplexContent().addNewRestriction();
        complexRestrictionType.setBase(SOAPENC_ARRAY);
        return soapArrayType;
    }

    private static void addSoapEncNS(SchemaDocument.Schema schema) {
        ImportDocument.Import import_;
        for (ImportDocument.Import import_2 : import_ = schema.getImportArray()) {
            if (!import_2.getNamespace().equals(SOAPENC_NS)) continue;
            return;
        }
        ImportDocument.Import import_3 = schema.addNewImport();
        import_3.setNamespace(SOAPENC_NS);
    }

    protected void postProcessOutputs(Map map, BindingFile bindingFile) {
        this.generateEncodePrimitiveByteArrayElements();
        this.generateWrappedXmlBeanSchemaTypes();
        this.generateSoapEncodedWrapperTypes(bindingFile);
        this.generateSpecialElements(map);
        this.generateSoapElements(map, bindingFile);
        this.generateSoapArrays(map, bindingFile);
        this.generateTypeWrapperElements(map);
        this.generateWrapperElements(map);
        this.genearteSpecialTypeForRpcLitStyle(map);
        if (this.mNeedListSchema) {
            SoapArrayType soapArrayType = this.createListSchema(map);
            bindingFile.addBindingType((BindingType)soapArrayType, true, true);
        }
        this.addSoapEncSchemaDoc();
    }

    private SoapArrayType createListSchema(Map map) {
        SchemaDocument.Schema schema = SoapAwareJava2Schema.getSchemaFor(TylarJ2SBindingsBuilderImpl.JAVA_LIST_QNAME.getNamespaceURI(), map);
        ImportDocument.Import import_ = schema.addNewImport();
        import_.setNamespace(SOAPENC_NS);
        TopLevelComplexType topLevelComplexType = schema.addNewComplexType();
        topLevelComplexType.setName(TylarJ2SBindingsBuilderImpl.JAVA_LIST_QNAME.getLocalPart());
        ComplexRestrictionType complexRestrictionType = topLevelComplexType.addNewComplexContent().addNewRestriction();
        complexRestrictionType.setBase(SOAPENC_ARRAY);
        Attribute attribute = complexRestrictionType.addNewAttribute();
        attribute.setRef(SOAPENC_ARRAYTYPE);
        ExplicitGroup explicitGroup = complexRestrictionType.addNewSequence();
        LocalElement localElement = explicitGroup.addNewElement();
        localElement.setName(ANYTYPE);
        localElement.setType(XSD_ANYTYPE);
        localElement.setMinOccurs(BigInteger.ZERO);
        localElement.setMaxOccurs((Object)UNBOUNDED);
        XmlTypeName xmlTypeName = XmlTypeName.forTypeNamed((QName)TylarJ2SBindingsBuilderImpl.JAVA_LIST_QNAME);
        BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)JavaTypeName.forString((String)List.class.getName()), (XmlTypeName)xmlTypeName);
        SoapArrayType soapArrayType = new SoapArrayType(bindingTypeName);
        soapArrayType.setRanks(1);
        return soapArrayType;
    }

    private QName xmlBeanArrayQName(JClass jClass, String string) {
        if (!jClass.isArrayType()) {
            return null;
        }
        int n = jClass.getArrayDimensions();
        if (n <= 0) {
            return null;
        }
        String string2 = jClass.getSimpleName();
        string2 = string2.substring(0, string2.indexOf("["));
        for (int i = 0; i < n; ++i) {
            string2 = SOAPARRAY_NAME_PREFIX + string2;
        }
        QName qName = new QName(string, string2);
        return qName;
    }

    private boolean generatedXmlBeanArraySchemaTypeQName(QName qName) {
        if (this.mGeneratedXmlBeansArraySchemaTypeQNames == null) {
            return false;
        }
        return this.mGeneratedXmlBeansArraySchemaTypeQNames.contains(qName);
    }

    private void addXmlBeanArraySchemaTypeQName(QName qName) {
        if (this.mGeneratedXmlBeansArraySchemaTypeQNames == null) {
            this.mGeneratedXmlBeansArraySchemaTypeQNames = new HashSet();
        }
        this.mGeneratedXmlBeansArraySchemaTypeQNames.add(qName);
    }

    private void addXmlBeanClassName(String string) {
        if (this.mXmlBeansClassNames == null) {
            this.mXmlBeansClassNames = new HashSet();
        }
        this.mXmlBeansClassNames.add(string);
    }

    private void generateWrappedXmlBeanSchemaTypes() {
        if (this.mXmlBeansClassNames == null) {
            return;
        }
        XBeanSchemaProcessor xBeanSchemaProcessor = new XBeanSchemaProcessor((BindingCompiler)this, this.mJ2SBindingsBuilder.getXmlObjectClassLoader());
        Iterator iterator = this.mXmlBeansClassNames.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                boolean bl;
                String string = (String)iterator.next();
                String string2 = XBeanUtil.getSchemaTypeSourceName(this.mJ2SBindingsBuilder.getXmlObjectClassLoader(), string);
                if (string2 != null || (bl = XBeanUtil.isBuiltInTypeXmlBean(this.mJ2SBindingsBuilder.getXmlObjectClassLoader(), string))) continue;
                this.logError(" ERROR !  could not get Schema Name for XmlBean named '" + string + "'.   This is completely unexpected and might be caused by missing *.xsd " + "files in the build environment.   The building and running of this Service is likely to FAIL.");
            }
            try {
                xBeanSchemaProcessor.includeAllRelevantSchemas(this.mXmlBeansClassNames);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logError(" ERROR !  could not add Xml Schema Type for XmlBean named '" + this.mXmlBeansClassNames + "'.   This is completely unexpected and might be caused by missing *.xsb and *.xsd " + "files in the build environment.   The building and running of this Service is likely to FAIL.");
            }
        }
    }

    private ArrayNamespaceInfo[] getArrayNamespaceInfos() {
        ArrayNamespaceInfo[] arrayNamespaceInfoArray = new ArrayNamespaceInfo[this.mArray2SetOfSoapArrayElemQNames.keySet().size()];
        this.mArray2SetOfSoapArrayElemQNames.keySet().toArray(arrayNamespaceInfoArray);
        return arrayNamespaceInfoArray;
    }

    protected QName[] getElementNamesForSoapArrayClass(ArrayNamespaceInfo arrayNamespaceInfo, String string) {
        HashSet<QName> hashSet = (HashSet<QName>)this.mArray2SetOfSoapArrayElemQNames.get(arrayNamespaceInfo);
        if (hashSet == null) {
            hashSet = new HashSet<QName>();
            this.mArray2SetOfSoapArrayElemQNames.put(arrayNamespaceInfo, hashSet);
        }
        String string2 = arrayNamespaceInfo.getNamespace();
        QName qName = new QName(string2, SOAPARRAY_NAME_PREFIX + string);
        hashSet.add(qName);
        QName[] qNameArray = new QName[hashSet.size()];
        hashSet.toArray(qNameArray);
        return qNameArray;
    }

    private void generateSoapArrays(Map map, BindingFile bindingFile) {
        if (this.mArray2SetOfSoapArrayElemQNames == null) {
            return;
        }
        ArrayNamespaceInfo[] arrayNamespaceInfoArray = this.getArrayNamespaceInfos();
        for (int i = 0; i < arrayNamespaceInfoArray.length; ++i) {
            this.generateSoapArray(map, arrayNamespaceInfoArray[i], bindingFile, this.mGeneratedSoapArrayJavaTypeNames);
        }
    }

    protected BindingType generateSoapArray(Map map, ArrayNamespaceInfo arrayNamespaceInfo, BindingFile bindingFile, Collection collection) {
        BindingType bindingType;
        JClass jClass = arrayNamespaceInfo.getArrayClass();
        JavaTypeName javaTypeName = JavaTypeName.forJClass((JClass)jClass);
        JClass jClass2 = jClass.getArrayComponentType();
        int n = jClass.getArrayDimensions();
        boolean bl = jClass2.isPrimitiveType();
        JavaTypeName javaTypeName2 = JavaTypeName.forJClass((JClass)jClass2);
        BindingTypeName bindingTypeName = this.getBindingLoader().lookupTypeFor(javaTypeName2);
        if (bindingTypeName == null) {
            throw new IllegalArgumentException("could not find binding type for array component type: " + jClass.getArrayComponentType());
        }
        QName qName = bindingTypeName.getXmlName().getQName();
        qName = this.arrayComponentQNameForSoapEncWrapper(jClass2, qName);
        String string = this.arrayComponentNameForJClass(jClass2, qName.getLocalPart());
        QName[] qNameArray = this.getElementNamesForSoapArrayClass(arrayNamespaceInfo, string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(SOAPARRAY_NAME_PREFIX);
        }
        QName qName2 = new QName(arrayNamespaceInfo.getNamespace(), stringBuffer.toString() + string);
        if (!collection.contains(qName2)) {
            ExplicitGroup explicitGroup;
            ComplexRestrictionType complexRestrictionType;
            SoapArrayType soapArrayType;
            BindingTypeName bindingTypeName2;
            XmlTypeName xmlTypeName;
            collection.add(qName2);
            if (!this.isTopLevelTypeExist(qName2, qName2.getNamespaceURI())) {
                xmlTypeName = SoapAwareJava2Schema.getSchemaFor(qName2.getNamespaceURI(), map);
                bindingTypeName2 = xmlTypeName.addNewComplexType();
                bindingTypeName2.setName(qName2.getLocalPart());
                soapArrayType = bindingTypeName2.addNewComplexContent();
                complexRestrictionType = soapArrayType.addNewRestriction();
                complexRestrictionType.setBase(SOAPENC_ARRAY);
                explicitGroup = complexRestrictionType.addNewSequence();
                LocalElement localElement = explicitGroup.addNewElement();
                localElement.setName(string);
                localElement.setType(qName);
                localElement.setMaxOccurs((Object)UNBOUNDED);
                if (bl) {
                    localElement.setNillable(false);
                } else {
                    localElement.setNillable(true);
                }
                Attribute attribute = complexRestrictionType.addNewAttribute();
                attribute.setRef(SOAPENC_ARRAYTYPE);
                this.checkNsForImport(qName2.getNamespaceURI(), qName.getNamespaceURI());
                if (n > 1) {
                    String string2 = "type";
                    Element element = (Element)localElement.getDomNode();
                    String string3 = element.getAttribute(string2);
                    Element element2 = (Element)attribute.getDomNode();
                    String string4 = "http://schemas.xmlsoap.org/wsdl/";
                    String string5 = "arrayType";
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append("[");
                    for (int i = 1; i < n; ++i) {
                        stringBuffer2.append(",");
                    }
                    stringBuffer2.append("]");
                    element2.setAttributeNS(string4, string5, string3 + stringBuffer2.toString());
                    String string6 = qName.getNamespaceURI();
                    if (!string6.equals(XSD_NS)) {
                        String string7 = string3.substring(0, string3.indexOf(":"));
                        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string7, string6);
                    }
                }
            }
            xmlTypeName = XmlTypeName.forTypeNamed((QName)qName2);
            bindingTypeName2 = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
            soapArrayType = new SoapArrayType(bindingTypeName2);
            soapArrayType.setRanks(n);
            if (bl) {
                soapArrayType.setItemNillable(false);
            } else {
                soapArrayType.setItemNillable(true);
            }
            soapArrayType.setItemName(qName);
            soapArrayType.setItemType(bindingTypeName);
            bindingFile.addBindingType((BindingType)soapArrayType, true, true);
            bindingType = soapArrayType;
            for (int i = 0; i < qNameArray.length; ++i) {
                bindingTypeName2 = XmlTypeName.forGlobalName((char)'e', (QName)qNameArray[i]);
                soapArrayType = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)bindingTypeName2);
                if (this.getBindingLoader().getBindingType((BindingTypeName)soapArrayType) == null) continue;
                if (!this.isTopLevelElementExist(qNameArray[i], qNameArray[i].getNamespaceURI())) {
                    complexRestrictionType = SoapAwareJava2Schema.getSchemaFor(qNameArray[i].getNamespaceURI(), map);
                    explicitGroup = complexRestrictionType.addNewElement();
                    explicitGroup.setName(qNameArray[i].getLocalPart());
                    explicitGroup.setType(qName2);
                    this.checkNsForImport(qNameArray[i].getNamespaceURI(), qName2.getNamespaceURI());
                }
                complexRestrictionType = new SimpleDocumentBinding((BindingTypeName)soapArrayType);
                complexRestrictionType.setTypeOfElement(XmlTypeName.forTypeNamed((QName)qName2));
                bindingFile.addBindingType((BindingType)complexRestrictionType, true, true);
            }
        } else {
            XmlTypeName xmlTypeName = XmlTypeName.forTypeNamed((QName)qName2);
            BindingTypeName bindingTypeName3 = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
            bindingType = this.mBindingFile.getBindingType(bindingTypeName3);
        }
        return bindingType;
    }

    private QName arrayComponentQNameForSoapEncWrapper(JClass jClass, QName qName) {
        if (!JamUtil.isSoapEncJavaPrimitiveWrapperClass(jClass)) {
            return qName;
        }
        return new QName(XSD_NS, JamUtil.soapEncodedTypeForJavaPrimitiveWrapper(jClass));
    }

    private void generateSoapElements(Map map, BindingFile bindingFile) {
        if (this.isBoundToAnyType(SOAPElement.class.getName())) {
            if (this.mAllSoapElements == null) {
                return;
            }
            QName[] qNameArray = new QName[this.mAllSoapElements.size()];
            this.mAllSoapElements.toArray(qNameArray);
            for (int i = 0; i < qNameArray.length; ++i) {
                TopLevelElement topLevelElement;
                SchemaDocument.Schema schema;
                QName qName = qNameArray[i];
                String string = qName.getNamespaceURI();
                if (!this.isTopLevelElementExist(qName, string)) {
                    schema = SoapAwareJava2Schema.getSchemaFor(string, map);
                    topLevelElement = schema.addNewElement();
                    topLevelElement.setName(qName.getLocalPart());
                    topLevelElement.setType(XS_ANYTYPE);
                }
                string = XmlTypeName.forGlobalName((char)'e', (QName)qName);
                schema = BindingTypeName.forPair((JavaTypeName)SOAPELEMENT_JTN, (XmlTypeName)string);
                topLevelElement = new SimpleDocumentBinding((BindingTypeName)schema);
                topLevelElement.setTypeOfElement(XmlTypeName.forTypeNamed((QName)XS_ANYTYPE));
                bindingFile.addBindingType((BindingType)topLevelElement, false, true);
            }
        } else {
            if (this.mAllSoapElementsForElementAny == null) {
                return;
            }
            QName[] qNameArray = new QName[this.mAllSoapElementsForElementAny.size()];
            this.mAllSoapElementsForElementAny.toArray(qNameArray);
            for (int i = 0; i < qNameArray.length; ++i) {
                TopLevelComplexType topLevelComplexType;
                SchemaDocument.Schema schema;
                QName qName = qNameArray[i];
                String string = qName.getNamespaceURI();
                if (!this.isTopLevelTypeExist(qName, string)) {
                    schema = SoapAwareJava2Schema.getSchemaFor(string, map);
                    topLevelComplexType = schema.addNewComplexType();
                    topLevelComplexType.setName(qName.getLocalPart());
                    ExplicitGroup explicitGroup = topLevelComplexType.addNewSequence();
                    AnyDocument.Any any = explicitGroup.addNewAny();
                }
                string = XmlTypeName.forGlobalName((char)'e', (QName)qName);
                schema = BindingTypeName.forPair((JavaTypeName)SOAPELEMENT_JTN, (XmlTypeName)string);
                topLevelComplexType = new SimpleDocumentBinding((BindingTypeName)schema);
                topLevelComplexType.setTypeOfElement(XmlTypeName.forTypeNamed((QName)XS_ANYTYPE));
                bindingFile.addBindingType((BindingType)topLevelComplexType, false, true);
            }
        }
    }

    private void generateSoapEncodedWrapperTypes(BindingFile bindingFile) {
        if (this.mSoapEncPrimitiveWrapperTypes == null) {
            return;
        }
        for (JClass jClass : this.mSoapEncPrimitiveWrapperTypes) {
            JavaTypeName javaTypeName = JavaTypeName.forJClass((JClass)jClass);
            String string = JamUtil.soapEncodedTypeForJavaPrimitiveWrapper(jClass);
            if (string == null) {
                this.logError(" Could not get SOAP ENCODED type for java class '" + jClass.getQualifiedName() + "'");
                continue;
            }
            QName qName = new QName(SOAPENC_NS, string);
            XmlTypeName xmlTypeName = XmlTypeName.forTypeNamed((QName)qName);
            BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
            SimpleBindingType simpleBindingType = new SimpleBindingType(bindingTypeName);
            QName qName2 = new QName(XSD_NS, string);
            XmlTypeName xmlTypeName2 = XmlTypeName.forTypeNamed((QName)qName2);
            simpleBindingType.setAsIfXmlType(xmlTypeName2);
            bindingFile.addBindingType((BindingType)simpleBindingType, true, true);
        }
    }

    private void addSoapEncSchemaDoc() {
        if (!this.mNeedsSoapEncodedSchema) {
            return;
        }
        if (SOAP_ENC_SCHEMA_DOC != null) {
            if (!this.isSoapEncSchemaDocExist()) {
                this.getTns2Schemadoc().put("soapenc", SOAP_ENC_SCHEMA_DOC);
            }
        } else {
            this.logError("SoapAwarejava2Schema:  Could not load SOAP-ENCODED schema from /weblogic/wsee/wsdl/schema/soap-encoding-11.xsd");
        }
    }

    private void generateSpecialElements(Map map) {
        if (this.mElmList == null) {
            return;
        }
        for (ElementTypePair elementTypePair : this.mElmList) {
            QName qName = TylarBuildtimeBindings.getSpecialJavaType(elementTypePair.clazz.getQualifiedName());
            String string = elementTypePair.element.getNamespaceURI();
            if (this.isTopLevelElementExist(elementTypePair.element, string)) continue;
            SchemaDocument.Schema schema = SoapAwareJava2Schema.getSchemaFor(string, map);
            TopLevelElement topLevelElement = schema.addNewElement();
            topLevelElement.setName(elementTypePair.element.getLocalPart());
            topLevelElement.setType(qName);
            this.addSpecialType(qName, map);
        }
    }

    private void addSpecialType(QName qName, Map map) {
        TopLevelComplexType topLevelComplexType;
        SchemaDocument.Schema schema = SoapAwareJava2Schema.getSchemaFor(qName.getNamespaceURI(), map);
        TopLevelComplexType[] topLevelComplexTypeArray = schema.getComplexTypeArray();
        boolean bl = false;
        for (int i = 0; !bl && i < topLevelComplexTypeArray.length; ++i) {
            topLevelComplexType = topLevelComplexTypeArray[i];
            if (!topLevelComplexType.getName().equals(qName.getLocalPart())) continue;
            bl = true;
        }
        if (!bl) {
            TopLevelComplexType topLevelComplexType2 = schema.addNewComplexType();
            topLevelComplexType2.setName(qName.getLocalPart());
            topLevelComplexType = topLevelComplexType2.addNewAnnotation();
            DocumentationDocument.Documentation documentation = topLevelComplexType.addNewDocumentation();
            SoapAwareJava2Schema.setTextValue((XmlObject)documentation, "Internal type created by WebLogic - Do not edit!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTextValue(XmlObject xmlObject, String string) {
        XmlCursor xmlCursor = xmlObject.newCursor();
        try {
            xmlCursor.setTextValue(string);
        }
        finally {
            xmlCursor.dispose();
        }
    }

    protected void generateTypeWrapperElements(Map map) {
        if (this.mTypeWrapperElements == null) {
            return;
        }
        for (Java2SchemaTypeWrapperElement java2SchemaTypeWrapperElement : this.mTypeWrapperElements) {
            BindingTypeName bindingTypeName;
            QName qName = java2SchemaTypeWrapperElement.getWrapperName();
            String string = qName.getNamespaceURI();
            SchemaDocument.Schema schema = this.findOrCreateSchema(string);
            JClass jClass = java2SchemaTypeWrapperElement.getElementJavaType();
            QName qName2 = null;
            if (XBeanUtil.isXmlBean(jClass)) {
                if (!XBeanUtil.xmlBeanIsDocumentType(this.mJ2SBindingsBuilder.getXmlObjectClassLoader(), jClass.getQualifiedName()) && (qName2 = XBeanUtil.getQNameFromXmlBean(this.mJ2SBindingsBuilder.getXmlObjectClassLoader(), jClass.getQualifiedName())) == null) {
                    this.logError(" could not load XMLSchema QName for xmlBean type '" + jClass.getQualifiedName() + "'");
                }
            } else if (TylarBuildtimeBindings.isSpecialJavaType(jClass.getQualifiedName())) {
                qName2 = TylarBuildtimeBindings.getSpecialJavaType(jClass.getQualifiedName());
                this.addSpecialType(qName2, map);
            } else if (jClass.getQualifiedName().equals(SOAPELEMENT_CLASSNAME)) {
                qName2 = this.isBoundToAnyType(SOAPELEMENT_CLASSNAME) ? XS_ANYTYPE : XmlTypeName.forElementWildCardType().getQName();
            } else {
                bindingTypeName = this.getBindingLoader().lookupTypeFor(JavaTypeName.forJClass((JClass)jClass));
                if (bindingTypeName == null) {
                    this.logError("Could not locate schema type bound to wrapped element type: " + jClass.getQualifiedName());
                    continue;
                }
                qName2 = bindingTypeName.getXmlName().getQName();
            }
            if (qName2 == null || SoapAwareJava2Schema.containsElementNamed((SchemaDocument.Schema)schema, (String)qName.getLocalPart())) continue;
            this.checkNsForImport(string, qName2.getNamespaceURI());
            bindingTypeName = schema.addNewElement();
            bindingTypeName.setName(qName.getLocalPart());
            bindingTypeName.setType(qName2);
        }
    }

    protected void generateWrapperElements(Map map) {
        if (this.mWrapperElements == null) {
            return;
        }
        for (Java2SchemaWrapperElement java2SchemaWrapperElement : this.mWrapperElements) {
            String string;
            QName qName = java2SchemaWrapperElement.getWrapperName();
            if (this.isTopLevelElementExist(qName, string = qName.getNamespaceURI())) continue;
            SchemaDocument.Schema schema = this.findOrCreateSchema(string);
            if (SoapAwareJava2Schema.containsElementNamed((SchemaDocument.Schema)schema, (String)qName.getLocalPart())) {
                this.logError("Unable to create doc wrapped element named '" + qName + "' because one was already generated");
                continue;
            }
            TopLevelElement topLevelElement = schema.addNewElement();
            topLevelElement.setName(qName.getLocalPart());
            LocalComplexType localComplexType = topLevelElement.addNewComplexType();
            ExplicitGroup explicitGroup = localComplexType.addNewSequence();
            JClass[] jClassArray = java2SchemaWrapperElement.getElementJavaTypes();
            String[] stringArray = java2SchemaWrapperElement.getElementNames();
            LocalElement localElement = null;
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                Object object2;
                if (jClassArray[i].isArrayType()) {
                    if (XBeanUtil.isArrayOfXmlBean(jClassArray[i])) {
                        object2 = JavaTypeName.forJClass((JClass)jClassArray[i]);
                        int n = object2.getArrayDepth();
                        object = jClassArray[i].getArrayComponentType().getQualifiedName();
                        if (n == 1 && !this.isBoundToAnyType(jClassArray[i].getQualifiedName())) {
                            AnyDocument.Any any = explicitGroup.addNewAny();
                            any.setMaxOccurs((Object)UNBOUNDED);
                            if (localElement == null) continue;
                            localElement.unsetMinOccurs();
                            localElement.setNillable(true);
                            localElement = null;
                            continue;
                        }
                        this.generateXmlBeanArrayWrapperElement(jClassArray[i], schema, explicitGroup, qName, stringArray[i]);
                        localElement = null;
                        continue;
                    }
                    if (jClassArray[i].getArrayComponentType().getQualifiedName().equals(SOAPELEMENT_CLASSNAME) && !this.isBoundToAnyType(jClassArray[i].getQualifiedName())) {
                        object2 = explicitGroup.addNewAny();
                        object2.setMaxOccurs((Object)UNBOUNDED);
                        if (localElement == null) continue;
                        localElement.unsetMinOccurs();
                        localElement.setNillable(true);
                        localElement = null;
                        continue;
                    }
                    object2 = this.getBindingLoader().lookupTypeFor(JavaTypeName.forJClass((JClass)jClassArray[i]));
                    if (object2 == null) {
                        this.logError("Could not locate schema type bound to wrapped element type: " + jClassArray[i].getQualifiedName());
                        continue;
                    }
                    LocalElement localElement2 = explicitGroup.addNewElement();
                    localElement2.setName(stringArray[i]);
                    localElement2.setType(object2.getXmlName().getQName());
                    localElement = null;
                    object = object2.getXmlName().getQName();
                    if (object == null) continue;
                    this.checkNsForImport(string, ((QName)object).getNamespaceURI());
                    continue;
                }
                object2 = null;
                if (XBeanUtil.isXmlBean(jClassArray[i])) {
                    if (!this.isBoundToAnyType(jClassArray[i].getQualifiedName())) {
                        AnyDocument.Any any = explicitGroup.addNewAny();
                        if (localElement == null) continue;
                        localElement.unsetMinOccurs();
                        localElement.setNillable(true);
                        localElement = null;
                        continue;
                    }
                    if (XBeanUtil.xmlBeanIsDocumentType(this.mJ2SBindingsBuilder.getXmlObjectClassLoader(), jClassArray[i].getQualifiedName())) {
                        QName qName2 = XBeanUtil.getQNameFromXmlBean(this.mJ2SBindingsBuilder.getXmlObjectClassLoader(), jClassArray[i].getQualifiedName());
                        if (qName2 == null) {
                            this.logError(" XmlBean '" + jClassArray[i].getQualifiedName() + "'was generated from  an xml document.  " + "Its top level element is of an anonymous complex type.  Unable to determine the QName of the " + "top level element.  Without this information we cannot " + "specify an xml schema ref attribute pointing to xmlBean's schema element.");
                        }
                        object = explicitGroup.addNewElement();
                        object.setRef(qName2);
                        if (qName2 != null) {
                            this.checkNsForImport(string, qName2.getNamespaceURI());
                        }
                        localElement = null;
                        continue;
                    }
                    object2 = XBeanUtil.getQNameFromXmlBean(this.mJ2SBindingsBuilder.getXmlObjectClassLoader(), jClassArray[i].getQualifiedName());
                    if (object2 == null) {
                        this.logError(" could not load XMLSchema QName for xmlBean type '" + jClassArray[i].getQualifiedName() + "'");
                    }
                } else if (TylarBuildtimeBindings.isSpecialJavaType(jClassArray[i].getQualifiedName())) {
                    object2 = TylarBuildtimeBindings.getSpecialJavaType(jClassArray[i].getQualifiedName());
                    this.addSpecialType((QName)object2, map);
                } else if (jClassArray[i].getQualifiedName().equals(SOAPELEMENT_CLASSNAME)) {
                    object2 = this.isBoundToAnyType(SOAPELEMENT_CLASSNAME) ? XS_ANYTYPE : XmlTypeName.forElementWildCardType().getQName();
                } else {
                    BindingTypeName bindingTypeName = this.getBindingLoader().lookupTypeFor(JavaTypeName.forJClass((JClass)jClassArray[i]));
                    if (bindingTypeName == null) {
                        this.logError("Could not locate schema type bound to wrapped element type: " + jClassArray[i].getQualifiedName());
                        continue;
                    }
                    object2 = bindingTypeName.getXmlName().getQName();
                }
                if (object2 != null) {
                    this.checkNsForImport(string, ((QName)object2).getNamespaceURI());
                }
                if (jClassArray[i].getQualifiedName().equals(SOAPELEMENT_CLASSNAME) && !this.isBoundToAnyType(SOAPELEMENT_CLASSNAME)) {
                    AnyDocument.Any any = explicitGroup.addNewAny();
                    if (localElement == null) continue;
                    localElement.unsetMinOccurs();
                    localElement.setNillable(true);
                    localElement = null;
                    continue;
                }
                if (jClassArray[i].isArrayType() && !this.isBoundToAnyType(jClassArray[i].getQualifiedName())) {
                    AnyDocument.Any any = explicitGroup.addNewAny();
                    any.setMinOccurs(BigInteger.ZERO);
                    any.setMaxOccurs((Object)UNBOUNDED);
                    if (localElement == null) continue;
                    localElement.unsetMinOccurs();
                    localElement.setNillable(true);
                    localElement = null;
                    continue;
                }
                LocalElement localElement3 = explicitGroup.addNewElement();
                localElement3.setName(stringArray[i]);
                localElement3.setType((QName)object2);
                if (JamUtil.isSoapEncJavaPrimitiveWrapperClass(jClassArray[i])) {
                    localElement3.setNillable(true);
                    localElement3.setMinOccurs(BigInteger.ZERO);
                    localElement = localElement3;
                }
                if (!this.allowNullByMinOccursZeroInWrapperElements || jClassArray[i].isPrimitiveType()) continue;
                localElement3.setMinOccurs(BigInteger.ZERO);
                localElement = localElement3;
            }
        }
    }

    private void generateXmlBeanArrayWrapperElement(JClass jClass, SchemaDocument.Schema schema, ExplicitGroup explicitGroup, QName qName, String string) {
        this.generateXmlBeanArrayType(jClass, schema, qName.getNamespaceURI());
        QName qName2 = this.xmlBeanArrayQName(jClass, qName.getNamespaceURI());
        LocalElement localElement = explicitGroup.addNewElement();
        localElement.setName(string);
        localElement.setType(qName2);
    }

    private void generateXmlBeanArrayType(JClass jClass, SchemaDocument.Schema schema, String string) {
        JavaTypeName javaTypeName = JavaTypeName.forJClass((JClass)jClass);
        int n = javaTypeName.getArrayDepth();
        if (n <= 0) {
            return;
        }
        JavaTypeName javaTypeName2 = javaTypeName.getArrayTypeMinus1Dim(n);
        String string2 = "";
        if (n > 1) {
            for (int i = 0; i < n - 1; ++i) {
                string2 = string2 + "[]";
            }
        }
        String string3 = javaTypeName2.getClassName() + string2;
        JClass jClass2 = jClass.forName(string3);
        QName qName = this.xmlBeanArrayQName(jClass2, string);
        QName qName2 = this.xmlBeanArrayQName(jClass, string);
        if (!this.generatedXmlBeanArraySchemaTypeQName(qName) && n > 1) {
            this.generateXmlBeanArrayType(jClass2, schema, string);
        }
        if (!this.generatedXmlBeanArraySchemaTypeQName(qName2)) {
            if (verbose) {
                Verbose.log("  generate xmlBeanArrayType '" + qName2 + "'");
            }
            this.addXmlBeanArraySchemaTypeQName(qName2);
            TopLevelComplexType topLevelComplexType = schema.addNewComplexType();
            topLevelComplexType.setName(qName2.getLocalPart());
            ExplicitGroup explicitGroup = topLevelComplexType.addNewSequence();
            LocalElement localElement = explicitGroup.addNewElement();
            if (n == 1) {
                if (XBeanUtil.xmlBeanIsDocumentType(this.mJ2SBindingsBuilder.getXmlObjectClassLoader(), jClass.getArrayComponentType().getQualifiedName())) {
                    QName qName3 = XBeanUtil.getQNameFromXmlBean(this.mJ2SBindingsBuilder.getXmlObjectClassLoader(), jClass2.getQualifiedName());
                    localElement.setRef(qName3);
                } else {
                    JClass jClass3 = jClass.getArrayComponentType();
                    QName qName4 = XBeanUtil.getQNameFromXmlBean(this.mJ2SBindingsBuilder.getXmlObjectClassLoader(), jClass3.getQualifiedName());
                    localElement.setName(jClass2.getSimpleName() + "Elem");
                    localElement.setType(qName4);
                }
            } else {
                localElement.setName(qName.getLocalPart() + "Elem");
                localElement.setType(qName);
            }
            localElement.setMinOccurs(BigInteger.ZERO);
            localElement.setMaxOccurs((Object)UNBOUNDED);
            localElement.setNillable(true);
        }
    }

    protected static SchemaDocument.Schema getSchemaFor(String string, Map map) {
        SchemaDocument schemaDocument = (SchemaDocument)map.get(string);
        if (schemaDocument == null) {
            schemaDocument = SchemaDocument.Factory.newInstance();
            if (schemaDocument.getSchema() == null) {
                schemaDocument.addNewSchema();
            }
            schemaDocument.getSchema().setTargetNamespace(string);
            map.put(string, schemaDocument);
        }
        return schemaDocument.getSchema();
    }

    protected Set findOrCreateElementNameSetFor(String string, JClass jClass, JClass jClass2) {
        if (this.typeIs1DPrimitiveByteArray(jClass2) && this.jaxRpcByteArrayStyle) {
            if (this.mArrayInfo2SetOfPrimitiveByteArrayElemQNamesInEncodedStyle == null) {
                this.mArrayInfo2SetOfPrimitiveByteArrayElemQNamesInEncodedStyle = new HashMap();
            }
            return this.findOrCreateElementNameSetFor(string, jClass, jClass2, this.mArrayInfo2SetOfPrimitiveByteArrayElemQNamesInEncodedStyle);
        }
        if (this.mArray2SetOfSoapArrayElemQNames == null) {
            this.mArray2SetOfSoapArrayElemQNames = new HashMap();
        }
        return this.findOrCreateElementNameSetFor(string, jClass, jClass2, this.mArray2SetOfSoapArrayElemQNames);
    }

    protected Set findOrCreateElementNameSetFor(String string, JClass jClass, JClass jClass2, Map map) {
        ArrayNamespaceInfo arrayNamespaceInfo = ArrayNameHelper.getArrayNamespaceInfo((String)string, (JClass)jClass, (JClass)jClass2);
        HashSet hashSet = (HashSet)map.get(arrayNamespaceInfo);
        if (hashSet == null) {
            hashSet = new HashSet();
            map.put(arrayNamespaceInfo, hashSet);
        }
        return hashSet;
    }

    protected Set findOrCreateElementNameSetForXBeanLitArray(String string, JClass jClass, JClass jClass2) {
        ArrayNamespaceInfo arrayNamespaceInfo;
        HashSet hashSet;
        if (this.mArray2SetOfXmlBeansLitArrayElemQNames == null) {
            this.mArray2SetOfXmlBeansLitArrayElemQNames = new HashMap();
        }
        if ((hashSet = (HashSet)this.mArray2SetOfXmlBeansLitArrayElemQNames.get(arrayNamespaceInfo = ArrayNameHelper.getArrayNamespaceInfo((String)string, (JClass)jClass, (JClass)jClass2))) == null) {
            hashSet = new HashSet();
            this.mArray2SetOfXmlBeansLitArrayElemQNames.put(arrayNamespaceInfo, hashSet);
        }
        return hashSet;
    }

    public ExplodedTylar bindAsExplodedTylar(File file) {
        ExplodedTylar explodedTylar = super.bindAsExplodedTylar(file);
        if (!this.messageSink.getErrorMessages().isEmpty()) {
            throw new BindingException(this.messageSink.getErrorMessages());
        }
        return explodedTylar;
    }

    private void generateEncodePrimitiveByteArrayElements() {
        if (this.mArrayInfo2SetOfPrimitiveByteArrayElemQNamesInEncodedStyle == null) {
            return;
        }
        Map map = this.mArrayInfo2SetOfPrimitiveByteArrayElemQNamesInEncodedStyle;
        ArrayNamespaceInfo[] arrayNamespaceInfoArray = new ArrayNamespaceInfo[map.keySet().size()];
        map.keySet().toArray(arrayNamespaceInfoArray);
        JavaTypeName javaTypeName = JavaTypeName.forString((String)"byte[]");
        JavaTypeName javaTypeName2 = JavaTypeName.forString((String)"byte");
        JClass jClass = arrayNamespaceInfoArray[0].getServiceClass().forName("byte");
        BindingTypeName bindingTypeName = this.getBindingLoader().lookupTypeFor(javaTypeName2);
        if (bindingTypeName == null) {
            throw new IllegalArgumentException("could not find binding type for literal array element class type: " + jClass);
        }
        QName qName = bindingTypeName.getXmlName().getQName();
        for (int i = 0; i < arrayNamespaceInfoArray.length; ++i) {
            HashSet hashSet = (HashSet)map.get(arrayNamespaceInfoArray[i]);
            if (hashSet == null) {
                hashSet = new HashSet();
                map.put(arrayNamespaceInfoArray[i], hashSet);
            }
            QName[] qNameArray = new QName[hashSet.size()];
            hashSet.toArray(qNameArray);
            this.createLitArraySchemaElementsAndBindings(javaTypeName, XS_BASE_64_BINARY, qNameArray);
        }
    }

    public void setJaxRpcByteArrayStyle(boolean bl) {
        this.jaxRpcByteArrayStyle = bl;
    }

    public void includeSchema(SchemaDocument schemaDocument, String string, Map map) {
        super.includeSchema(schemaDocument, string, map);
        this.mXBeanIncludedSchemas.add(schemaDocument);
    }

    protected boolean isTopLevelElementExist(QName qName, String string) {
        for (Object object : this.mXBeanIncludedSchemas) {
            if (!ObjectUtil.equals(string, object.getSchema().getTargetNamespace()) || !SoapAwareJava2Schema.containsElementNamed((SchemaDocument.Schema)object.getSchema(), (String)qName.getLocalPart())) continue;
            this.logWarning("Element named '" + qName + "' was already imported from XmlBeans Schema");
            return true;
        }
        for (Object object : this.mTns2Schemadoc.keySet()) {
            if (!ObjectUtil.equals(string, object) || !SoapAwareJava2Schema.containsElementNamed((SchemaDocument.Schema)((SchemaDocument)this.mTns2Schemadoc.get(object)).getSchema(), (String)qName.getLocalPart())) continue;
            this.logWarning("Element named '" + qName + "' was already imported from XmlBeans Schema");
            return true;
        }
        return false;
    }

    protected boolean isTopLevelTypeExist(QName qName, String string) {
        for (Object object : this.mXBeanIncludedSchemas) {
            if (!ObjectUtil.equals(string, object.getSchema().getTargetNamespace()) || !SoapAwareJava2Schema.containsTypeNamed(object.getSchema(), qName.getLocalPart())) continue;
            this.logWarning("Schema Type named '" + qName + "' was already imported from XmlBeans Schema");
            return true;
        }
        for (Object object : this.mTns2Schemadoc.keySet()) {
            if (!ObjectUtil.equals(string, object) || !SoapAwareJava2Schema.containsTypeNamed(((SchemaDocument)this.mTns2Schemadoc.get(object)).getSchema(), qName.getLocalPart())) continue;
            this.logWarning("Schema Type named '" + qName + "' was already imported from XmlBeans Schema");
            return true;
        }
        return false;
    }

    protected boolean isSoapEncSchemaDocExist() {
        for (Object object : this.mXBeanIncludedSchemas) {
            if (!ObjectUtil.equals(SOAP_ENC_SCHEMA_DOC.getSchema().getTargetNamespace(), object.getSchema().getTargetNamespace())) continue;
            this.logWarning("SOAP_ENC_SCHEMA_DOC was already imported from XmlBeans Schema");
            return true;
        }
        for (Object object : this.mTns2Schemadoc.keySet()) {
            if (!ObjectUtil.equals(object, SOAP_ENC_SCHEMA_DOC.getSchema().getTargetNamespace())) continue;
            this.logWarning("SOAP_ENC_SCHEMA_DOC was already imported from XmlBeans Schema");
            return true;
        }
        return false;
    }

    protected static boolean containsTypeNamed(SchemaDocument.Schema schema, String string) {
        TopLevelComplexType[] topLevelComplexTypeArray = schema.getComplexTypeArray();
        for (int i = 0; i < topLevelComplexTypeArray.length; ++i) {
            if (!ObjectUtil.equals(string, topLevelComplexTypeArray[i].getName())) continue;
            return true;
        }
        TopLevelSimpleType[] topLevelSimpleTypeArray = schema.getSimpleTypeArray();
        for (int i = 0; i < topLevelSimpleTypeArray.length; ++i) {
            if (!ObjectUtil.equals(string, topLevelSimpleTypeArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    static {
        SchemaDocument schemaDocument = null;
        try {
            SchemaTypeLoader schemaTypeLoader = XmlBeans.typeLoaderForClassLoader((ClassLoader)SoapAwareJava2Schema.class.getClassLoader());
            InputStream inputStream = SoapAwareJava2Schema.class.getResourceAsStream(SOAP_ENC_XSD_LOCATION);
            schemaDocument = (SchemaDocument)schemaTypeLoader.parse(inputStream, SchemaDocument.type, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SOAP_ENC_SCHEMA_DOC = schemaDocument;
    }

    private static class ElementTypePair {
        private QName element = null;
        private JClass clazz = null;

        public ElementTypePair(QName qName, JClass jClass) {
            this.element = qName;
            this.clazz = jClass;
        }
    }
}

