/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.buildtime.internal;

import com.bea.staxb.buildtime.FaultMessage;
import com.bea.staxb.buildtime.internal.bts.BindingLoader;
import com.bea.staxb.buildtime.internal.bts.BindingType;
import com.bea.staxb.buildtime.internal.bts.BindingTypeName;
import com.bea.staxb.buildtime.internal.bts.ByNameBean;
import com.bea.staxb.buildtime.internal.bts.JavaTypeName;
import com.bea.staxb.buildtime.internal.bts.QNameProperty;
import com.bea.staxb.buildtime.internal.bts.SimpleDocumentBinding;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.staxb.buildtime.internal.tylar.DebugTylarWriter;
import com.bea.staxb.buildtime.internal.tylar.DefaultTylarLoader;
import com.bea.staxb.buildtime.internal.tylar.Tylar;
import com.bea.util.jam.JClass;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.XmlException;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.bind.buildtime.internal.Buildtime109MappingHelper;
import weblogic.wsee.bind.buildtime.internal.SoapAwareJava2Schema;
import weblogic.wsee.bind.buildtime.internal.TylarJ2SBindingsBuilderImpl;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.XBeanUtil;

public class TylarBuildtimeBindings
implements BuildtimeBindings {
    private static final boolean VERBOSE = Verbose.isVerbose(TylarBuildtimeBindings.class);
    private static final String XMLOBJECT_SCHEMATYPE_FIELD = "type";
    public static final String ATTACHMENT_NAMESPACE = "http://www.bea.com/servers/wls90/wsee/attachment";
    public static final QName JAVAX_AWT_IMAGE = new QName("http://www.bea.com/servers/wls90/wsee/attachment", "image");
    public static final QName JAVAX_MAIL_INTERNET_MIMEMULTIPART = new QName("http://www.bea.com/servers/wls90/wsee/attachment", "mimemultipart");
    public static final QName JAVAX_XML_TRANSFORM_SOURCE = new QName("http://www.bea.com/servers/wls90/wsee/attachment", "textXml");
    public static final QName JAVAX_ACTIVATION_DATAHANDLER = new QName("http://www.bea.com/servers/wls90/wsee/attachment", "datahandler");
    private static final Map specialJavaTypeMaps = TylarBuildtimeBindings.createSpecialJavaTypes();
    private static final Map specialSchemaTypeMaps = TylarBuildtimeBindings.createSpecialSchemaTypes();
    private Tylar mTylar;
    private Class mBuilderClass = null;
    private ClassLoader mXmlObjectClassLoader = null;
    private Map mWrapperElements = null;

    void setWrapperElements(Map map) {
        this.mWrapperElements = map;
    }

    static boolean isSpecialJavaType(String string) {
        return specialJavaTypeMaps.containsKey(string);
    }

    static QName getSpecialJavaType(String string) {
        return (QName)specialJavaTypeMaps.get(string);
    }

    TylarBuildtimeBindings(Tylar tylar, File file, Class clazz, ClassLoader classLoader) {
        if (tylar == null) {
            throw new IllegalArgumentException("null tylar");
        }
        this.mTylar = tylar;
        this.mBuilderClass = clazz;
        this.mXmlObjectClassLoader = classLoader;
    }

    public boolean useCheckedExceptionFromWsdlFault() {
        return true;
    }

    public void generate109Descriptor(JavaWsdlMappingBean javaWsdlMappingBean) {
        if (javaWsdlMappingBean == null) {
            throw new IllegalArgumentException("null out");
        }
        if (VERBOSE) {
            Verbose.log("generate109Descriptor for " + javaWsdlMappingBean + ".  Tylar contents:");
            this.debug(new PrintWriter(System.out));
        }
        Buildtime109MappingHelper buildtime109MappingHelper = new Buildtime109MappingHelper(this.mTylar);
        buildtime109MappingHelper.buildMappings(javaWsdlMappingBean);
    }

    public String getClassFromSchemaType(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException("null name");
        }
        String string = (String)specialSchemaTypeMaps.get(qName);
        if (string != null) {
            return string;
        }
        return this.getClassFromXmlType(XmlTypeName.forTypeNamed((QName)qName));
    }

    public String getClassFromSchemaElement(QName qName) {
        String string;
        if (qName == null) {
            throw new IllegalArgumentException("null name");
        }
        XmlTypeName xmlTypeName = XmlTypeName.forGlobalName((char)'e', (QName)qName);
        String string2 = this.getClassFromXmlType(xmlTypeName);
        BindingTypeName bindingTypeName = this.getTypeBindingTypeName(string2);
        if (bindingTypeName != null && (string = (String)specialSchemaTypeMaps.get(bindingTypeName.getXmlName().getQName())) != null) {
            return string;
        }
        return string2;
    }

    public String getExceptionClassFromFaultMessageType(FaultMessage faultMessage) {
        QName qName = faultMessage.getMessageName();
        QName qName2 = faultMessage.getComponentName();
        String string = faultMessage.getPartName();
        if (qName == null) {
            throw new IllegalArgumentException("null messageName");
        }
        if (string == null) {
            throw new IllegalArgumentException("null partName");
        }
        if (qName2 == null) {
            throw new IllegalArgumentException("null type");
        }
        XmlTypeName xmlTypeName = XmlTypeName.forTypeNamed((QName)qName2);
        return this.getExceptionClassFromXmlTypeName(qName, string, xmlTypeName);
    }

    public String getExceptionClassFromFaultMessageElement(FaultMessage faultMessage) {
        QName qName = faultMessage.getMessageName();
        QName qName2 = faultMessage.getComponentName();
        String string = faultMessage.getPartName();
        if (qName == null) {
            throw new IllegalArgumentException("null messageName");
        }
        if (string == null) {
            throw new IllegalArgumentException("null partName");
        }
        if (qName2 == null) {
            throw new IllegalArgumentException("null type");
        }
        XmlTypeName xmlTypeName = XmlTypeName.forGlobalName((char)'e', (QName)qName2);
        return this.getExceptionClassFromXmlTypeName(qName, string, xmlTypeName);
    }

    private String getExceptionClassFromXmlTypeName(QName qName, String string, XmlTypeName xmlTypeName) {
        XmlTypeName xmlTypeName2 = XmlTypeName.forFaultType((QName)qName, (String)string, (XmlTypeName)xmlTypeName);
        BindingLoader bindingLoader = this.mTylar.getBindingLoader();
        BindingTypeName bindingTypeName = bindingLoader.lookupPojoFor(xmlTypeName2);
        String string2 = bindingTypeName != null ? bindingTypeName.getJavaName().toString() : this.getClassFromXmlType(xmlTypeName);
        if (VERBOSE) {
            Verbose.log(" for typeName " + xmlTypeName + ", exceptionClass name for faultTypeName '" + xmlTypeName2 + " is '" + string2 + "'");
        }
        return string2;
    }

    public String getWrappedSimpleClassNameFromFaultMessageType(FaultMessage faultMessage) {
        QName qName = faultMessage.getMessageName();
        QName qName2 = faultMessage.getComponentName();
        String string = faultMessage.getPartName();
        if (qName == null) {
            throw new IllegalArgumentException("null messageName");
        }
        if (string == null) {
            throw new IllegalArgumentException("null partName");
        }
        if (qName2 == null) {
            throw new IllegalArgumentException("null type");
        }
        XmlTypeName xmlTypeName = XmlTypeName.forTypeNamed((QName)qName2);
        return this.getSingleBuiltinClassNameFromXmlTypeName(qName, string, xmlTypeName);
    }

    public String getWrappedSimpleClassNameFromFaultMessageElement(FaultMessage faultMessage) {
        QName qName = faultMessage.getMessageName();
        QName qName2 = faultMessage.getComponentName();
        String string = faultMessage.getPartName();
        if (qName == null) {
            throw new IllegalArgumentException("null messageName");
        }
        if (string == null) {
            throw new IllegalArgumentException("null partName");
        }
        if (qName2 == null) {
            throw new IllegalArgumentException("null type");
        }
        XmlTypeName xmlTypeName = XmlTypeName.forGlobalName((char)'e', (QName)qName2);
        return this.getSingleBuiltinClassNameFromXmlTypeName(qName, string, xmlTypeName);
    }

    private String getSingleBuiltinClassNameFromXmlTypeName(QName qName, String string, XmlTypeName xmlTypeName) {
        XmlTypeName xmlTypeName2 = XmlTypeName.forFaultType((QName)qName, (String)string, (XmlTypeName)xmlTypeName);
        BindingLoader bindingLoader = this.mTylar.getBindingLoader();
        BindingTypeName bindingTypeName = bindingLoader.lookupPojoFor(xmlTypeName2);
        if (bindingTypeName != null) {
            bindingTypeName = bindingLoader.lookupPojoFor(xmlTypeName);
            if (bindingTypeName != null) {
                return bindingTypeName.getJavaName().toString();
            }
            throw new IllegalArgumentException(" could not get exception class for " + qName);
        }
        return null;
    }

    public List getElementNamesCtorOrderFromFaultMessageElement(FaultMessage faultMessage) {
        ArrayList arrayList = new ArrayList();
        QName qName = faultMessage.getMessageName();
        QName qName2 = faultMessage.getComponentName();
        String string = faultMessage.getPartName();
        if (qName == null) {
            throw new IllegalArgumentException("null messageName");
        }
        if (string == null) {
            throw new IllegalArgumentException("messageName " + qName + ", has a null partName");
        }
        if (qName2 == null) {
            throw new IllegalArgumentException("messageName " + qName + ", partName " + string + ", has a null xmlElement");
        }
        XmlTypeName xmlTypeName = XmlTypeName.forGlobalName((char)'e', (QName)qName2);
        BindingLoader bindingLoader = this.mTylar.getBindingLoader();
        BindingTypeName bindingTypeName = bindingLoader.lookupPojoFor(xmlTypeName);
        if (bindingTypeName != null) {
            Object object;
            BindingType bindingType = bindingLoader.getBindingType(bindingTypeName);
            if (VERBOSE) {
                Verbose.log(" getElementNamesCtorOrderFromFaultMessageElement BindingType for TypeName " + xmlTypeName + ", is " + bindingType);
            }
            if (bindingType instanceof SimpleDocumentBinding) {
                object = ((SimpleDocumentBinding)bindingType).getTypeOfElement();
                JavaTypeName javaTypeName = bindingTypeName.getJavaName();
                BindingTypeName bindingTypeName2 = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)object);
                if (VERBOSE) {
                    Verbose.log("element's type from SimpleDocumentBinding is " + object + " now lookup BindingType for constructed BTN " + bindingTypeName2);
                }
                bindingType = bindingLoader.getBindingType(bindingTypeName2);
            }
            object = "Wsdl Fault '" + faultMessage.getMessageName() + "'";
            this.getElementNamesCtorOrderFromBindingType(bindingType, (String)object, arrayList);
        }
        return arrayList;
    }

    public List getElementNamesCtorOrderFromFaultMessageType(FaultMessage faultMessage) {
        ArrayList arrayList = new ArrayList();
        QName qName = faultMessage.getMessageName();
        QName qName2 = faultMessage.getComponentName();
        String string = faultMessage.getPartName();
        if (qName == null) {
            throw new IllegalArgumentException("null messageName");
        }
        if (string == null) {
            throw new IllegalArgumentException("messageName " + qName + ", has a null partName");
        }
        if (qName2 == null) {
            throw new IllegalArgumentException("messageName " + qName + ", partName " + string + ", has a null xmlType");
        }
        XmlTypeName xmlTypeName = XmlTypeName.forGlobalName((char)'t', (QName)qName2);
        BindingLoader bindingLoader = this.mTylar.getBindingLoader();
        BindingTypeName bindingTypeName = bindingLoader.lookupPojoFor(xmlTypeName);
        if (bindingTypeName != null) {
            BindingType bindingType = bindingLoader.getBindingType(bindingTypeName);
            if (VERBOSE) {
                Verbose.log(" getElementNamesCtorOrderFromFaultMessageElement BindingType for TypeName " + xmlTypeName + ", is " + bindingType);
            }
            String string2 = "Wsdl Fault '" + faultMessage.getMessageName() + "'";
            this.getElementNamesCtorOrderFromBindingType(bindingType, string2, arrayList);
        }
        return arrayList;
    }

    private void getElementNamesCtorOrderFromBindingType(BindingType bindingType, String string, List list) {
        if (bindingType == null) {
            return;
        }
        if (bindingType instanceof ByNameBean) {
            ByNameBean byNameBean = (ByNameBean)bindingType;
            Collection collection = byNameBean.getProperties();
            if (VERBOSE) {
                Verbose.log("getElementNamesCtorOrderFromBindingType: ByNameBean has " + collection.size() + " properties");
            }
            if (collection.size() > 0) {
                int n = 0;
                for (QNameProperty[] qNamePropertyArray : collection) {
                    int n2;
                    if (VERBOSE) {
                        Verbose.log(" process next constructor property " + n + "  " + qNamePropertyArray);
                    }
                    if ((n2 = qNamePropertyArray.getCtorParamIndex()) < 0) continue;
                    ++n;
                }
                if (n > 0) {
                    QNameProperty[] qNamePropertyArray;
                    qNamePropertyArray = new QNameProperty[n];
                    for (QNameProperty qNameProperty : collection) {
                        int n3 = qNameProperty.getCtorParamIndex();
                        if (n3 >= n) {
                            throw new IllegalArgumentException("Error !  " + string + " has " + n + " constructor parameters, but the BindingType ByNameBean has a QNameProperty '" + qNameProperty.getQName() + "' with a CtorParamIndex value of " + n3 + ", which exceeds the maximum allowed value of " + (n - 1) + ".  All QNameProperties must be ordered " + "with unique sequential CtorParamIndex values starting from 0.");
                        }
                        if (n3 < 0) continue;
                        qNamePropertyArray[n3] = qNameProperty;
                    }
                    for (int i = 0; i < n; ++i) {
                        if (qNamePropertyArray[i] == null) {
                            throw new IllegalArgumentException("Error !  " + string + " has " + n + " constructor parameters, but the propertyArray entry for constructor param " + i + " is NULL.  Something may be wrong with binding-file.xml");
                        }
                        list.add(qNamePropertyArray[i].getQName());
                        if (!VERBOSE) continue;
                        Verbose.log("getElementNamesCtorOrderFromBindingType: added paramQName '" + qNamePropertyArray[i].getQName() + " to list ");
                    }
                }
            }
        } else if (VERBOSE) {
            Verbose.log("getElementNamesCtorOrderFromBindingType:   BindingType " + bindingType + ", is not a ByNameBean.  Skipping.");
        }
    }

    public List getElementNamesCtorOrderFromException(JClass jClass) {
        JavaTypeName javaTypeName = JavaTypeName.forJClass((JClass)jClass);
        BindingLoader bindingLoader = this.mTylar.getBindingLoader();
        ArrayList arrayList = new ArrayList();
        BindingTypeName bindingTypeName = bindingLoader.lookupTypeFor(javaTypeName);
        if (bindingTypeName != null) {
            BindingType bindingType = bindingLoader.getBindingType(bindingTypeName);
            if (VERBOSE) {
                Verbose.log(" getElementNamesCtorOrderFromException BindingType for JavaTypeName " + javaTypeName + ", is " + bindingType);
            }
            String string = "Java Exception '" + jClass.getQualifiedName() + "'";
            this.getElementNamesCtorOrderFromBindingType(bindingType, string, arrayList);
        }
        return arrayList;
    }

    public QName getSchemaType(String string) {
        QName qName;
        if (string == null) {
            throw new IllegalArgumentException("null javaType");
        }
        if (string.equals(TylarJ2SBindingsBuilderImpl.SOAPELEMENT_CLASSNAME)) {
            return SoapAwareJava2Schema.XS_ANYTYPE;
        }
        BindingTypeName bindingTypeName = this.getTypeBindingTypeName(string);
        QName qName2 = qName = bindingTypeName == null ? null : bindingTypeName.getXmlName().getQName();
        if (qName == null) {
            qName = this.getSpecialJavaTypes(string);
        }
        if (qName == null && this.mXmlObjectClassLoader != null) {
            qName = this.getSchemaTypeFromXmlObject(string);
        }
        if (VERBOSE) {
            Verbose.log("javaType = " + string + " schemaType = " + qName);
        }
        return qName;
    }

    public SchemaDocument[] getSchemas() {
        return this.mTylar.getSchemas();
    }

    public DocumentFragment[] getSchemaDocumentFragments() {
        SchemaDocument[] schemaDocumentArray = this.getSchemas();
        DocumentFragment[] documentFragmentArray = new DocumentFragment[schemaDocumentArray.length];
        for (int i = 0; i < schemaDocumentArray.length; ++i) {
            Node node = schemaDocumentArray[i].getSchema().newDomNode();
            Verbose.log(node);
            Verbose.log(node.getClass());
            documentFragmentArray[i] = (DocumentFragment)schemaDocumentArray[i].getSchema().newDomNode();
        }
        return documentFragmentArray;
    }

    public Class getBuilderClass() {
        return this.mBuilderClass;
    }

    public LinkedHashMap getJavaTypesForWrapperElement(QName qName) {
        if (this.mWrapperElements != null) {
            LinkedHashMap linkedHashMap = null;
            LinkedHashMap linkedHashMap2 = (LinkedHashMap)this.mWrapperElements.get(qName);
            if (linkedHashMap2 != null) {
                linkedHashMap = new LinkedHashMap();
                for (Map.Entry entry : linkedHashMap2.entrySet()) {
                    BindingTypeName bindingTypeName = this.getTypeBindingTypeName((String)entry.getValue());
                    if (bindingTypeName != null) {
                        String string = (String)specialSchemaTypeMaps.get(bindingTypeName.getXmlName().getQName());
                        if (string != null) {
                            linkedHashMap.put(entry.getKey(), string);
                            continue;
                        }
                        linkedHashMap.put(entry.getKey(), (String)entry.getValue());
                        continue;
                    }
                    linkedHashMap.put(entry.getKey(), (String)entry.getValue());
                }
            }
            return linkedHashMap;
        }
        return null;
    }

    public String toDebugString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.debug(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    public void debug(PrintWriter printWriter) {
        try {
            new DebugTylarWriter(printWriter).write(this.mTylar);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static Map createSpecialJavaTypes() {
        HashMap<String, QName> hashMap = new HashMap<String, QName>();
        hashMap.put(Image.class.getName(), JAVAX_AWT_IMAGE);
        hashMap.put(MimeMultipart.class.getName(), JAVAX_MAIL_INTERNET_MIMEMULTIPART);
        hashMap.put(Source.class.getName(), JAVAX_XML_TRANSFORM_SOURCE);
        hashMap.put(DataHandler.class.getName(), JAVAX_ACTIVATION_DATAHANDLER);
        return hashMap;
    }

    private static Map createSpecialSchemaTypes() {
        HashMap<QName, String> hashMap = new HashMap<QName, String>();
        hashMap.put(JAVAX_AWT_IMAGE, Image.class.getName());
        hashMap.put(JAVAX_MAIL_INTERNET_MIMEMULTIPART, MimeMultipart.class.getName());
        hashMap.put(JAVAX_XML_TRANSFORM_SOURCE, Source.class.getName());
        hashMap.put(JAVAX_ACTIVATION_DATAHANDLER, DataHandler.class.getName());
        return hashMap;
    }

    public QName getSchemaTypeFromXmlObject(String string) {
        return XBeanUtil.getQNameFromXmlBean(this.mXmlObjectClassLoader, string);
    }

    private QName getSpecialJavaTypes(String string) {
        return (QName)specialJavaTypeMaps.get(string);
    }

    private String getClassFromXmlType(XmlTypeName xmlTypeName) {
        BindingLoader bindingLoader = this.mTylar.getBindingLoader();
        BindingTypeName bindingTypeName = bindingLoader.lookupPojoFor(xmlTypeName);
        if (bindingTypeName != null) {
            return bindingTypeName.getJavaName().toString();
        }
        bindingTypeName = bindingLoader.lookupXmlObjectFor(xmlTypeName);
        if (bindingTypeName != null) {
            return bindingTypeName.getJavaName().toString();
        }
        throw new IllegalArgumentException("unable to find java type for " + xmlTypeName);
    }

    private BindingTypeName getTypeBindingTypeName(String string) {
        JavaTypeName javaTypeName = JavaTypeName.forString((String)string);
        return this.mTylar.getBindingLoader().lookupTypeFor(javaTypeName);
    }

    public static class Factory
    implements BuildtimeBindings.Factory {
        private static Factory instance;

        private Factory() {
        }

        public BuildtimeBindings loadFromURI(URI uRI) throws IOException, XmlException {
            Tylar tylar = DefaultTylarLoader.getInstance().load(uRI);
            URL uRL = uRI.toURL();
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL});
            return new TylarBuildtimeBindings(tylar, null, TylarBuildtimeBindings.class, uRLClassLoader);
        }

        public static Factory getInstance() {
            if (instance == null) {
                instance = new Factory();
            }
            return instance;
        }
    }
}

