/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.buildtime.internal;

import com.bea.staxb.buildtime.internal.Java2SchemaWrapperElement;
import com.bea.staxb.buildtime.internal.annobeans.ClassBindingInfoBean;
import com.bea.staxb.buildtime.internal.annobeans.TargetSchemaTypeBean;
import com.bea.staxb.buildtime.internal.annobeans.TargetTopLevelElementBean;
import com.bea.staxb.buildtime.internal.tylar.CompositeTylar;
import com.bea.staxb.buildtime.internal.tylar.Tylar;
import com.bea.util.annogen.override.AnnoBeanSet;
import com.bea.util.annogen.override.AnnoOverrider;
import com.bea.util.annogen.override.JamElementIdPool;
import com.bea.util.annogen.override.StoredAnnoOverrider;
import com.bea.util.annogen.view.AnnoViewerParams;
import com.bea.util.annogen.view.JamAnnoViewer;
import com.bea.util.jam.JAnnotatedElement;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JamClassLoader;
import com.bea.util.jam.JamServiceFactory;
import com.bea.xml.XmlException;
import java.io.File;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import weblogic.jws.WildcardParticle;
import weblogic.wsee.bind.EncodingStyles;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.bind.buildtime.J2SBindingsBuilder;
import weblogic.wsee.bind.buildtime.TylarJ2SBindingsBuilder;
import weblogic.wsee.bind.buildtime.internal.Java2SchemaTypeWrapperElement;
import weblogic.wsee.bind.buildtime.internal.SoapAwareJava2Schema;
import weblogic.wsee.bind.buildtime.internal.TylarBindingsBuilderBase;
import weblogic.wsee.bind.buildtime.internal.TylarBuildtimeBindings;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.Verbose;

public class TylarJ2SBindingsBuilderImpl
extends TylarBindingsBuilderBase
implements TylarJ2SBindingsBuilder {
    static final String SOAPELEMENT_CLASSNAME = SOAPElement.class.getName();
    private static final String JAVA_UTIL_NAMESPACE = "language-builtins.util";
    public static final QName JAVA_LIST_QNAME = new QName("language-builtins.util", "List");
    private static final JClass SOAPELEMENT_JCLASS;
    private File[] xsdConfigFiles = null;
    private static final boolean VERBOSE;
    protected SoapAwareJava2Schema mBinder;
    private StoredAnnoOverrider mOverrides = null;
    private JamElementIdPool mIdPool = null;

    public TylarJ2SBindingsBuilderImpl() {
        if (VERBOSE) {
            Verbose.log("Constructed a TylarJ2SBindingsBuilderImpl");
        }
        this.mBinder = new SoapAwareJava2Schema(this);
        this.mBinder.setJaxRpcRules(true);
    }

    private StoredAnnoOverrider getOverrides() {
        if (this.mOverrides == null) {
            this.mOverrides = StoredAnnoOverrider.Factory.create();
        }
        return this.mOverrides;
    }

    private JamElementIdPool getIdPool() {
        if (this.mIdPool == null) {
            this.mIdPool = JamElementIdPool.Factory.create();
        }
        return this.mIdPool;
    }

    public void addWildcardBinding(String string, WildcardParticle wildcardParticle) {
        this.mBinder.addWildcardBinding(string, com.bea.staxb.buildtime.WildcardParticle.valueOf((String)wildcardParticle.toString()));
    }

    public void javaTypeToSchemaType(JClass jClass, JClass jClass2, int n) {
        if (jClass2 == null) {
            throw new IllegalArgumentException("null clazz");
        }
        if (TylarBuildtimeBindings.isSpecialJavaType(jClass2.getQualifiedName())) {
            this.mBinder.addSpecialTypeQNames(TylarBuildtimeBindings.getSpecialJavaType(jClass2.getQualifiedName()));
            return;
        }
        if (jClass2.getQualifiedName().equals(SOAPELEMENT_CLASSNAME)) {
            return;
        }
        if (VERBOSE) {
            Verbose.log("bindJavaType " + jClass2.getQualifiedName());
        }
        boolean bl = EncodingStyles.isEncoded(n);
        if (jClass2.isArrayType()) {
            if (bl) {
                this.mBinder.bindJavaArrayToSoapArray(ClassUtil.getTargetNamespace(jClass), jClass, jClass2);
            } else {
                this.mBinder.bindJavaArrayToLiteralArray(ClassUtil.getTargetNamespace(jClass), jClass, jClass2);
            }
        } else if (n == 6) {
            this.mBinder.addEncodedClassToBind(jClass2);
        } else {
            this.mBinder.addClassToBind(jClass2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void javaTypeToSchemaElement(JClass jClass, JClass jClass2, QName qName, int n) {
        if (jClass2 == null) {
            throw new IllegalArgumentException("null clazz");
        }
        if (qName == null) {
            throw new IllegalArgumentException("null elemName");
        }
        if (VERBOSE) {
            Verbose.log("bindJavaTypeToSchemaElement " + jClass2.getQualifiedName() + "  " + qName);
            Verbose.log("\n\n" + SOAPELEMENT_JCLASS.getQualifiedName() + "  " + jClass2.getQualifiedName() + "  " + SOAPELEMENT_JCLASS.isAssignableFrom(jClass2));
        }
        if (TylarJ2SBindingsBuilderImpl.isSoapElement(jClass2)) {
            this.mBinder.addSoapElement(qName);
            return;
        } else {
            if (TylarBuildtimeBindings.isSpecialJavaType(jClass2.getQualifiedName())) {
                this.mBinder.addSpecialJavaElement(qName, jClass2);
                return;
            }
            if (jClass2.isArrayType()) {
                if (EncodingStyles.isEncoded(n)) {
                    this.mBinder.bindJavaArrayToSoapArray(ClassUtil.getTargetNamespace(jClass), jClass, jClass2, qName);
                    return;
                } else {
                    if (!EncodingStyles.isLiteral(n)) throw new IllegalArgumentException("unknown encodingStyle, neither literal nor encoded: " + n);
                    this.mBinder.bindJavaArrayToLiteralArray(ClassUtil.getTargetNamespace(jClass), jClass, jClass2, qName);
                }
                return;
            } else {
                this.mBinder.addClassToBind(jClass2);
                this.addTargetElement(jClass2, qName);
                Java2SchemaTypeWrapperElement java2SchemaTypeWrapperElement = new Java2SchemaTypeWrapperElement(jClass, qName, jClass2);
                this.mBinder.addTypeWrapperElement(java2SchemaTypeWrapperElement);
            }
        }
    }

    public void wrapJavaTypeToSchemaElement(JClass jClass, JClass[] jClassArray, String[] stringArray, QName qName) {
        Java2SchemaWrapperElement java2SchemaWrapperElement = new Java2SchemaWrapperElement(jClass, qName, jClassArray, stringArray);
        this.mBinder.addWrapperElement(java2SchemaWrapperElement);
    }

    public BuildtimeBindings createBuildtimeBindings(File file) throws IOException, XmlException {
        AnnoViewerParams annoViewerParams;
        Tylar tylar;
        if (file == null) {
            throw new IllegalArgumentException("null outputDir");
        }
        if (VERBOSE) {
            Verbose.banner("TylarJ2SBindingsBuilderImpl.createBuildtimeBindings");
            Verbose.log("generating BuildtimeBindings in " + file);
        }
        if (this.xsdConfigFiles != null) {
            this.mBinder.setBindingConfig(this.getBindingConfig(this.xsdConfigFiles));
        }
        if ((tylar = this.getBaseTypeLibraries()) != null) {
            this.mBinder.setBaseLibrary(tylar);
        }
        this.mBinder.setVerbose(VERBOSE);
        if (this.mOverrides != null) {
            annoViewerParams = AnnoViewerParams.Factory.create();
            annoViewerParams.addOverrider((AnnoOverrider)this.mOverrides);
            this.mBinder.setAnnoViewer(JamAnnoViewer.Factory.create((AnnoViewerParams)annoViewerParams));
        }
        if ((annoViewerParams = this.mBinder.bindAsExplodedTylar(file)) == null) {
            throw new IOException("binding failed, check log for details");
        }
        if (tylar != null) {
            annoViewerParams = new CompositeTylar(new Tylar[]{annoViewerParams, tylar});
        }
        return new TylarBuildtimeBindings((Tylar)annoViewerParams, file, J2SBindingsBuilder.class, this.getXmlObjectClassLoader());
    }

    public void setXsdConfig(File[] fileArray) {
        this.xsdConfigFiles = fileArray;
    }

    public static boolean isSoapElement(JClass jClass) {
        return SOAPELEMENT_JCLASS.isAssignableFrom(jClass);
    }

    private void addTargetElement(JClass jClass, QName qName) {
        StoredAnnoOverrider storedAnnoOverrider = this.getOverrides();
        AnnoBeanSet annoBeanSet = storedAnnoOverrider.findOrCreateStoredAnnoSetFor(this.getIdPool().getIdFor((JAnnotatedElement)jClass));
        ClassBindingInfoBean classBindingInfoBean = (ClassBindingInfoBean)annoBeanSet.findOrCreateBeanFor(ClassBindingInfoBean.class);
        TargetSchemaTypeBean targetSchemaTypeBean = classBindingInfoBean.schemaType();
        if (targetSchemaTypeBean == null) {
            targetSchemaTypeBean = new TargetSchemaTypeBean();
            classBindingInfoBean.set_schemaType(targetSchemaTypeBean);
        }
        TargetTopLevelElementBean targetTopLevelElementBean = new TargetTopLevelElementBean();
        targetTopLevelElementBean.set_localName(qName.getLocalPart());
        targetTopLevelElementBean.set_namespaceUri(qName.getNamespaceURI());
        TargetTopLevelElementBean[] targetTopLevelElementBeanArray = targetSchemaTypeBean.topLevelElements();
        if (targetTopLevelElementBeanArray == null || targetTopLevelElementBeanArray.length == 0) {
            targetSchemaTypeBean.set_topLevelElements(new TargetTopLevelElementBean[]{targetTopLevelElementBean});
        } else {
            TargetTopLevelElementBean[] targetTopLevelElementBeanArray2 = new TargetTopLevelElementBean[targetTopLevelElementBeanArray.length + 1];
            System.arraycopy(targetTopLevelElementBeanArray, 0, targetTopLevelElementBeanArray2, 0, targetTopLevelElementBeanArray.length);
            targetTopLevelElementBeanArray2[targetTopLevelElementBeanArray2.length - 1] = targetTopLevelElementBean;
            targetSchemaTypeBean.set_topLevelElements(targetTopLevelElementBeanArray2);
        }
    }

    public void setJaxRpcByteArrayStyle(boolean bl) {
        this.mBinder.setJaxRpcByteArrayStyle(bl);
    }

    public void setUpperCasePropName(boolean bl) {
        this.mBinder.setUpperCasePropName(bl);
    }

    public void setLocalElementDefaultRequired(boolean bl) {
        this.mBinder.setLocalElementDefaultRequired(bl);
    }

    public void setLocalElementDefaultNillable(boolean bl) {
        this.mBinder.setLocalElementDefaultNillable(bl);
    }

    static {
        VERBOSE = Verbose.isVerbose(TylarJ2SBindingsBuilderImpl.class);
        ClassLoader classLoader = TylarJ2SBindingsBuilderImpl.class.getClassLoader();
        JamClassLoader jamClassLoader = JamServiceFactory.getInstance().createJamClassLoader(classLoader);
        if (jamClassLoader == null) {
            throw new IllegalStateException("null sysCl");
        }
        JClass jClass = jamClassLoader.loadClass(SOAPELEMENT_CLASSNAME);
        if (jClass == null) {
            throw new IllegalStateException("null jclass");
        }
        if (jClass.isUnresolvedType()) {
            throw new IllegalStateException(SOAPELEMENT_CLASSNAME + " is not in the classpath");
        }
        SOAPELEMENT_JCLASS = jClass;
    }
}

