/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.buildtime.internal;

import com.bea.staxb.buildtime.Schema2Java;
import com.bea.staxb.buildtime.internal.bts.BindingLoader;
import com.bea.staxb.buildtime.internal.bts.BindingTypeName;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.staxb.buildtime.internal.tylar.CompositeTylar;
import com.bea.staxb.buildtime.internal.tylar.Tylar;
import com.bea.staxb.buildtime.internal.tylar.TylarWriter;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.SchemaTypeSystem;
import com.bea.xml.XmlBeans;
import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import com.bea.xml.XmlOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.ByteArrayHolder;
import weblogic.wsee.bind.BaseTypeLoaderFactory;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.bind.buildtime.S2JBindingsBuilder;
import weblogic.wsee.bind.buildtime.TylarS2JBindingsBuilder;
import weblogic.wsee.bind.buildtime.internal.HolderTypeBase;
import weblogic.wsee.bind.buildtime.internal.TylarBindingsBuilderBase;
import weblogic.wsee.bind.buildtime.internal.TylarBuildtimeBindings;
import weblogic.wsee.bind.tylar.CompilingTylar;
import weblogic.wsee.util.HolderUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.jspgen.GenFactory;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.xml.schema.binding.internal.NameUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TylarS2JBindingsBuilderImpl
extends TylarBindingsBuilderBase
implements TylarS2JBindingsBuilder {
    private static final boolean VERBOSE = Verbose.isVerbose(TylarS2JBindingsBuilderImpl.class);
    private boolean jaxRPCWrappedArrayStyle = false;
    private boolean writeJavaTypes = true;
    private boolean useJaxRpcRules = true;
    protected Set<QName> holderTypeNames = new HashSet<QName>();
    protected Set<QName> holderElementNames = new HashSet<QName>();
    private File[] xsdConfigFiles = null;

    @Override
    public void setJaxRPCWrappedArrayStyle(boolean bl) {
        this.jaxRPCWrappedArrayStyle = bl;
    }

    @Override
    public void setWriteJavaTypes(boolean bl) {
        this.writeJavaTypes = bl;
    }

    @Override
    public void setUseJaxRpcRules(boolean bl) {
        this.useJaxRpcRules = bl;
    }

    public TylarS2JBindingsBuilderImpl() {
        if (VERBOSE) {
            Verbose.log("Constructed a TylarS2JBindingsBuilderImpl");
        }
    }

    @Override
    public void addHolderType(QName qName) {
        this.holderTypeNames.add(qName);
    }

    @Override
    public void addHolderElement(QName qName) {
        this.holderElementNames.add(qName);
    }

    @Override
    public BuildtimeBindings createBuildtimeBindings(File file, WsdlDefinitions wsdlDefinitions) throws IOException, XmlException {
        SchemaDocument schemaDocument2;
        if (file == null) {
            throw new IllegalArgumentException("null dir");
        }
        if (VERBOSE) {
            Verbose.banner("TylarS2JBindingsBuilderImpl.createBuildtimeBindings");
            Verbose.log("generating BuildtimeBindings in " + file + " using " + this.schemaDocs.size() + " schemas");
        }
        file.mkdirs();
        Tylar tylar = this.getBaseTypeLibraries();
        SchemaTypeLoader schemaTypeLoader = BaseTypeLoaderFactory.newInstance(tylar);
        ArrayList<SchemaDocument> arrayList = new ArrayList<SchemaDocument>();
        arrayList.addAll(this.schemaDocs);
        for (SchemaDocument schemaDocument2 : wsdlDefinitions.getTypes().getSchemaArray()) {
            if (arrayList.contains(schemaDocument2) || schemaDocument2.getSchema().getTargetNamespace() == null || schemaTypeLoader.isNamespaceDefined(schemaDocument2.getSchema().getTargetNamespace())) continue;
            arrayList.add(schemaDocument2);
        }
        SchemaDocument[] schemaDocumentArray = new SchemaDocument.Schema[arrayList.size()];
        int n = 0;
        for (SchemaDocument schemaDocument2 : arrayList) {
            schemaDocumentArray[n++] = schemaDocument2.getSchema();
        }
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setCompileDownloadUrls();
        xmlOptions.setCompileNoAnnotations();
        xmlOptions.setCompileNoPvrRule();
        schemaDocument2 = XmlBeans.compileXsd((XmlObject[])schemaDocumentArray, (SchemaTypeLoader)schemaTypeLoader, (XmlOptions)xmlOptions);
        Schema2Java schema2Java = new Schema2Java((SchemaTypeSystem)schemaDocument2);
        schema2Java.setParamTypes(this.paramTypes);
        schema2Java.setParamElements(this.paramElements);
        schema2Java.setFaultTypes(this.faultTypes);
        schema2Java.setFaultElements(this.faultElements);
        schema2Java.setWrapperOperations(this.wrapperInfos);
        schema2Java.setIncludeGlobalTypes(this.includeGlobalTypes);
        schema2Java.setSortSchemaTypes(this.sortSchemaTypes);
        schema2Java.setJaxRpcRules(this.useJaxRpcRules);
        schema2Java.setJaxRPCWrappedArrayStyle(this.jaxRPCWrappedArrayStyle);
        schema2Java.setWriteJavaFiles(this.writeJavaTypes);
        schema2Java.setBindingConfig(this.getBindingConfig(this.xsdConfigFiles));
        if (tylar != null) {
            schema2Java.setBaseLibrary(tylar);
        }
        if (this.codegenDir != null) {
            schema2Java.setCodegenDir(this.codegenDir);
        }
        schema2Java.setVerbose(VERBOSE);
        schema2Java.setCompileJava(false);
        CompilingTylar compilingTylar = CompilingTylar.create(file);
        schema2Java.bind((TylarWriter)compilingTylar);
        ((TylarWriter)compilingTylar).close();
        if (compilingTylar == null) {
            throw new IOException("binding failed, check log for details");
        }
        if (tylar != null) {
            compilingTylar = new CompositeTylar(new Tylar[]{compilingTylar, tylar});
        }
        TylarBuildtimeBindings tylarBuildtimeBindings = new TylarBuildtimeBindings(compilingTylar, file, S2JBindingsBuilder.class, this.getXmlObjectClassLoader());
        tylarBuildtimeBindings.setWrapperElements(schema2Java.getNameListFromWrapperElement());
        this.generateHolderTypes(file, compilingTylar, tylarBuildtimeBindings);
        return tylarBuildtimeBindings;
    }

    @Override
    public void includeGlobalTypes(boolean bl) {
        this.includeGlobalTypes = bl;
    }

    @Override
    public void sortSchemaTypes(boolean bl) {
        this.sortSchemaTypes = bl;
    }

    private void generateHolderTypes(File file, Tylar tylar, BuildtimeBindings buildtimeBindings) throws IOException {
        Object object;
        BindingLoader bindingLoader = tylar.getBindingLoader();
        HolderUtil.NameCollisionsFilter.getInstance().reset();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (QName qName : this.holderTypeNames) {
            String string;
            object = XmlTypeName.forTypeNamed((QName)qName);
            BindingTypeName bindingTypeName = bindingLoader.lookupPojoFor(object);
            if (bindingTypeName == null || HolderUtil.getStandardHolder(string = bindingTypeName.getJavaName().toString()) != null || this.getStandardSchemaHolder(qName) != null) continue;
            this.createHolderName(string, qName, arrayList3, arrayList2, arrayList);
        }
        for (QName qName : this.holderElementNames) {
            object = buildtimeBindings.getClassFromSchemaElement(qName);
            if (HolderUtil.getStandardHolder((String)object) != null || this.getStandardSchemaHolder(qName) != null) continue;
            this.createHolderName((String)object, qName, arrayList3, arrayList2, arrayList);
        }
        this.createHolderClasses(arrayList3, arrayList2, arrayList, file);
    }

    private String getStandardSchemaHolder(QName qName) {
        if (("http://www.w3.org/2001/XMLSchema".equals(qName.getNamespaceURI()) || "http://schemas.xmlsoap.org/soap/encoding/".equals(qName.getNamespaceURI()) || "http://www.w3.org/2003/05/soap-encoding".equals(qName.getNamespaceURI())) && ("base64Binary".equals(qName.getLocalPart()) || "hexBinary".equals(qName.getLocalPart()) || "base64".equals(qName.getLocalPart()))) {
            return ByteArrayHolder.class.getName();
        }
        return null;
    }

    private void createHolderName(String string, QName qName, List<String> list, List<String> list2, List<String> list3) {
        if (VERBOSE) {
            Verbose.log("Creating holder for type " + string);
        }
        String string2 = null;
        String string3 = null;
        if (string.startsWith("java.") || string.startsWith("javax.") || HolderUtil.isPrimitiveType(string) || string.startsWith("[") || string.endsWith("[]")) {
            string2 = com.bea.xbean.common.NameUtil.getPackageFromNamespace((String)qName.getNamespaceURI(), (boolean)true);
            string2 = StringUtil.isEmpty(string2) ? "holders" : string2 + ".holders";
            string3 = NameUtil.getJAXRPCClassName((String)qName.getLocalPart());
        } else {
            string2 = HolderUtil.getHolderPackage(string);
            string3 = HolderUtil.getShortHolderName(string);
        }
        string3 = string3 + "Holder";
        String string4 = null;
        string4 = string2 == null || "".equals(string2) ? string3 : string2 + "." + string3;
        HolderUtil.NameCollisionsFilter.getInstance().use(string4);
        list.add(string2);
        list2.add(string3);
        list3.add(string);
    }

    private void createHolderClasses(List<String> list, List<String> list2, List<String> list3, File file) throws IOException {
        File file2 = this.codegenDir;
        if (file2 == null) {
            file2 = new File(file, "META-INF/src");
            file2.mkdirs();
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            String string2 = list2.get(i);
            String string3 = list3.get(i);
            string2 = HolderUtil.NameCollisionsFilter.getInstance().filterClassName(string, string2);
            PrintStream printStream = TylarS2JBindingsBuilderImpl.createJavaSourceStream(file2, string, string2);
            HolderTypeBase holderTypeBase = (HolderTypeBase)GenFactory.create("weblogic.wsee.bind.buildtime.internal.HolderType");
            holderTypeBase.setClassName(string2.endsWith("Holder") ? string2.substring(0, string2.length() - "Holder".length()) : string2);
            holderTypeBase.setPackageName(string);
            holderTypeBase.setValueType(string3);
            holderTypeBase.setOutput(printStream);
            holderTypeBase.generate();
            printStream.close();
        }
    }

    private static PrintStream createJavaSourceStream(File file, String string, String string2) throws IOException {
        File file2 = new File(file, string.replace('.', File.separatorChar));
        file2.mkdirs();
        File file3 = new File(file2, string2 + ".java");
        return new PrintStream(new FileOutputStream(file3), true);
    }

    @Override
    public void setXsdConfig(File[] fileArray) {
        this.xsdConfigFiles = fileArray;
    }
}

