/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.buildtime.internal;

import com.bea.staxb.buildtime.BindingCompiler;
import com.bea.staxb.buildtime.Java2Schema;
import com.bea.staxb.buildtime.internal.bts.BindingFile;
import com.bea.staxb.buildtime.internal.bts.BindingLoader;
import com.bea.staxb.buildtime.internal.bts.BindingType;
import com.bea.staxb.buildtime.internal.bts.BindingTypeName;
import com.bea.staxb.buildtime.internal.bts.ByNameBean;
import com.bea.staxb.buildtime.internal.bts.JavaTypeName;
import com.bea.staxb.buildtime.internal.bts.MethodName;
import com.bea.staxb.buildtime.internal.bts.QNameProperty;
import com.bea.staxb.buildtime.internal.bts.SimpleBindingType;
import com.bea.staxb.buildtime.internal.bts.SimpleDocumentBinding;
import com.bea.staxb.buildtime.internal.bts.SoapArrayType;
import com.bea.staxb.buildtime.internal.bts.WrappedArrayType;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.staxb.buildtime.internal.tylar.TylarWriter;
import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JField;
import com.bea.util.jam.JMethod;
import com.bea.util.jam.JParameter;
import com.bea.xml.SchemaGlobalElement;
import com.bea.xml.SchemaLocalAttribute;
import com.bea.xml.SchemaParticle;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeSystem;
import com.bea.xml.XmlObject;
import com.bea.xml.soap.SOAPArrayType;
import com.bea.xml.soap.SchemaWSDLArrayType;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jws.WebMethod;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import weblogic.jws.Callback;
import weblogic.jws.wlw.WLW81CallbackJWS;
import weblogic.wsee.bind.buildtime.internal.WLW81JavaNamePicker;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.XBeanUtil;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlMethod;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlParameter;
import weblogic.wsee.wsdl.WsdlPart;
import weblogic.wsee.wsdl.WsdlPartnerLinkType;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.builder.WsdlMessageBuilder;
import weblogic.wsee.wsdl.builder.WsdlMethodBuilder;
import weblogic.wsee.wsdl.builder.WsdlOperationBuilder;
import weblogic.wsee.wsdl.builder.WsdlPartBuilder;
import weblogic.wsee.wsdl.builder.WsdlPortTypeBuilder;
import weblogic.wsee.wsdl.builder.WsdlServiceBuilder;
import weblogic.wsee.wsdl.internal.WsdlMethodImpl;
import weblogic.wsee.wsdl.internal.WsdlParameterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLW81SchemaAndJavaBinder
extends BindingCompiler {
    private SchemaTypeSystem sts;
    private BindingLoader bindingLoader;
    private BindingFile bindingFile = new BindingFile();
    private JClass serviceJClass;
    private boolean serviceJClassIsCallbackJws = false;
    private WsdlServiceBuilder _wsdlService;
    private WLW81JavaNamePicker propertyNamePicker = new WLW81JavaNamePicker(false);
    private WLW81JavaNamePicker getterSetterNamePicker = new WLW81JavaNamePicker(true);
    private HashMap<String, JMethod> methodMap = new HashMap();
    private HashMap<String, JMethod> callbackMethodMap = new HashMap();
    private boolean flipCallbackInputAndOutputParts = true;
    static HashSet<String> soapEncodingSimpleElements = new HashSet();
    private static final String COLLECTION_ELEMENT_NAME = "item";
    public static final QName XS_ANYTYPE;
    private Map nameListFromWrapperElement = new HashMap();
    private static final QName arrayType;

    public WLW81SchemaAndJavaBinder(SchemaTypeSystem schemaTypeSystem) {
        this.setSchemaTypeSystem(schemaTypeSystem);
    }

    WLW81SchemaAndJavaBinder() {
    }

    public void setFlipCallbackInputAndOutputParts(boolean bl) {
        this.flipCallbackInputAndOutputParts = bl;
    }

    public void setServiceJClass(JClass jClass) {
        this.serviceJClass = jClass;
        this.serviceJClassIsCallbackJws = jClass.getAnnotation(WLW81CallbackJWS.class) != null;
        this.populateMethodMap();
    }

    public JClass getServiceJClass() {
        return this.serviceJClass;
    }

    public WsdlService getWsdlService() {
        return this._wsdlService;
    }

    public void setWsdlService(WsdlService wsdlService) {
        this._wsdlService = (WsdlServiceBuilder)wsdlService;
    }

    public void setSchemaTypeSystem(SchemaTypeSystem schemaTypeSystem) {
        if (schemaTypeSystem == null) {
            throw new IllegalArgumentException("null sts");
        }
        this.sts = schemaTypeSystem;
    }

    protected void internalBind(TylarWriter tylarWriter) {
        block5: {
            if (this.sts == null) {
                throw new IllegalStateException("SchemaTypeSystem not set");
            }
            if (this.serviceJClass == null) {
                throw new IllegalStateException("Service JClass not set");
            }
            if (this._wsdlService == null) {
                throw new IllegalStateException("WsldService not set");
            }
            this.bind();
            try {
                tylarWriter.writeBindingFile(this.bindingFile);
                tylarWriter.writeSchemaTypeSystem(this.sts);
            }
            catch (IOException iOException) {
                if (this.logError(iOException)) break block5;
                return;
            }
        }
    }

    private void bind() {
        this.bindingLoader = super.getBaseBindingLoader();
        this.bind(this._wsdlService);
        QName qName = WLW81SchemaAndJavaBinder.getJsCallbackServiceName(this._wsdlService.getDefinitions());
        if (qName != null) {
            for (WsdlServiceBuilder wsdlServiceBuilder : this._wsdlService.getDefinitions().getServices().values()) {
                if (!wsdlServiceBuilder.getName().equals(qName)) continue;
                this.bind(wsdlServiceBuilder);
                break;
            }
        }
    }

    public static QName getJsCallbackServiceName(WsdlDefinitions wsdlDefinitions) {
        WsdlPartnerLinkType wsdlPartnerLinkType = (WsdlPartnerLinkType)wsdlDefinitions.getExtension("PartnerLinkType");
        if (wsdlPartnerLinkType != null) {
            for (WsdlService wsdlService : wsdlDefinitions.getServices().values()) {
                for (WsdlPortType wsdlPortType : wsdlService.getPortTypes()) {
                    try {
                        if (!wsdlPortType.getName().equals(wsdlPartnerLinkType.getPortTypeName("Callback"))) continue;
                        return wsdlService.getName();
                    }
                    catch (WsdlException wsdlException) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    private void bind(WsdlServiceBuilder wsdlServiceBuilder) {
        this.bindingLoader = super.getBaseBindingLoader();
        for (WsdlPortTypeBuilder wsdlPortTypeBuilder : wsdlServiceBuilder.getPortTypes()) {
            String string = this.getBindingTypeForPortType(wsdlServiceBuilder, wsdlPortTypeBuilder);
            if (!string.equals("SOAP12") && !string.equals("SOAP11")) continue;
            for (WsdlOperationBuilder wsdlOperationBuilder : wsdlPortTypeBuilder.getOperations().values()) {
                this.bindOperation(wsdlOperationBuilder);
            }
        }
    }

    private String getBindingTypeForPortType(WsdlService wsdlService, WsdlPortType wsdlPortType) {
        for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
            WsdlPortType wsdlPortType2 = wsdlPort.getPortType();
            if (!wsdlPortType2.getName().equals(wsdlPortType.getName())) continue;
            WsdlBinding wsdlBinding = wsdlPort.getBinding();
            String string = wsdlBinding.getBindingType();
            return string;
        }
        return "unknown";
    }

    private void bindOperation(WsdlOperationBuilder wsdlOperationBuilder) {
        WsdlMethod wsdlMethod;
        JMethod jMethod = this.getJMethodThatMapsToOperation(wsdlOperationBuilder);
        if (this.isCallbackOperation(wsdlOperationBuilder) && this.flipCallbackInputAndOutputParts) {
            wsdlMethod = this.getWsdlMethodForCallback(wsdlOperationBuilder);
        } else if (this.serviceJClassIsCallbackJws) {
            if (jMethod == null) {
                return;
            }
            wsdlMethod = this.getWsdlMethodForCallback(wsdlOperationBuilder);
        } else {
            wsdlMethod = wsdlOperationBuilder.getWsdlMethod();
        }
        if (jMethod == null) {
            return;
        }
        WsdlPart wsdlPart = wsdlMethod.getResultPart();
        JClass jClass = jMethod.getReturnType();
        this.bindReturn(wsdlPart, jClass, jMethod, wsdlOperationBuilder.getName());
        int n = 0;
        for (WsdlParameter wsdlParameter : wsdlMethod.getParameters()) {
            WsdlPart wsdlPart2 = wsdlParameter.getPrimaryPart();
            n += this.bindParameters(wsdlPart2, jMethod.getParameters(), n, jMethod);
        }
    }

    private void bindReturn(WsdlPart wsdlPart, JClass jClass, JMethod jMethod, QName qName) {
        if (wsdlPart == null) {
            if (jClass != null && !jClass.isVoidType()) {
                throw new IllegalArgumentException("Operation " + qName + " should map to a java method with a void return type.");
            }
            return;
        }
        QName qName2 = wsdlPart.getType();
        if (qName2 != null) {
            this.bindParameterForTypeQName(qName2, jClass);
        } else {
            QName qName3 = wsdlPart.getElement();
            SchemaGlobalElement schemaGlobalElement = this.sts.findElement(qName3);
            SchemaType schemaType = schemaGlobalElement.getType();
            boolean bl = this.isWrapped(jMethod);
            if (!bl) {
                this.bindNonWrappedElement(jClass, qName3, schemaType);
            } else {
                this.bindWrappedElement(jClass, qName3, schemaType);
            }
        }
    }

    private int bindParameters(WsdlPart wsdlPart, JParameter[] jParameterArray, int n, JMethod jMethod) {
        QName qName = wsdlPart.getType();
        if (qName != null) {
            this.bindParameterForTypeQName(qName, jParameterArray[n].getType());
            return 1;
        }
        QName qName2 = wsdlPart.getElement();
        SchemaGlobalElement schemaGlobalElement = this.sts.findElement(qName2);
        SchemaType schemaType = schemaGlobalElement.getType();
        boolean bl = this.isWrapped(jMethod);
        if (!bl) {
            this.bindNonWrappedElement(jParameterArray[n].getType(), qName2, schemaType);
            return 1;
        }
        try {
            return this.bindWrappedElement(jParameterArray, n, qName2, schemaType);
        }
        catch (IllegalStateException illegalStateException) {
            this.logError("Error binding parameters for wrapped method '" + jMethod.getSimpleName() + "'.");
            this.logError(illegalStateException);
            throw illegalStateException;
        }
    }

    private void bindParameterForTypeQName(QName qName, JClass jClass) {
        SchemaType schemaType = this.sts.findType(qName);
        if (schemaType != null) {
            this.bindParameter(schemaType, jClass);
        }
    }

    private void bindNonWrappedElement(JClass jClass, QName qName, SchemaType schemaType) {
        JavaTypeName javaTypeName = JavaTypeName.forString((String)jClass.getQualifiedName());
        XmlTypeName xmlTypeName = XmlTypeName.forGlobalName((char)'e', (QName)qName);
        XmlTypeName xmlTypeName2 = XmlTypeName.forSchemaType((SchemaType)schemaType);
        BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
        SimpleDocumentBinding simpleDocumentBinding = new SimpleDocumentBinding(bindingTypeName);
        simpleDocumentBinding.setTypeOfElement(xmlTypeName2);
        this.bindingFile.addBindingType((BindingType)simpleDocumentBinding, this.shouldBeFromJavaDefault(bindingTypeName), true);
        this.bindParameter(schemaType, jClass);
    }

    private void bindWrappedElement(JClass jClass, QName qName, SchemaType schemaType) {
        SchemaProperty[] schemaPropertyArray = schemaType.getProperties();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(schemaPropertyArray.length * 4 / 3);
        for (int i = 0; i < schemaPropertyArray.length; ++i) {
            this.bindParameter(schemaPropertyArray[i].getType(), jClass);
            linkedHashMap.put(schemaPropertyArray[i].getName().getLocalPart(), jClass.getQualifiedName());
        }
        if (schemaType.hasElementWildcards()) {
            linkedHashMap.put(XmlTypeName.forElementWildCardElement().getQName().getLocalPart(), jClass.getQualifiedName());
        }
        this.nameListFromWrapperElement.put(qName, linkedHashMap);
    }

    private int bindWrappedElement(JParameter[] jParameterArray, int n, QName qName, SchemaType schemaType) {
        if (schemaType.hasElementWildcards()) {
            SchemaParticle schemaParticle = schemaType.getContentModel();
            SchemaParticle[] schemaParticleArray = schemaParticle == null ? new SchemaParticle[]{} : (schemaParticle.getParticleType() == 5 || schemaParticle.getParticleType() == 4 ? new SchemaParticle[]{schemaParticle} : schemaType.getContentModel().getParticleChildren());
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(schemaParticleArray.length * 4 / 3);
            if (jParameterArray.length < n + schemaParticleArray.length) {
                throw new IllegalStateException("Java class parameters do not match WSDL definition.");
            }
            for (int i = 0; i < schemaParticleArray.length; ++i) {
                if (schemaParticleArray[i].getParticleType() == 5) {
                    linkedHashMap.put(XmlTypeName.forElementWildCardElement().getQName().getLocalPart(), jParameterArray[n + i].getType().getQualifiedName());
                    continue;
                }
                this.bindParameter(schemaParticleArray[i].getType(), jParameterArray[n + i].getType());
                linkedHashMap.put(schemaParticleArray[i].getName().getLocalPart(), jParameterArray[n + i].getType().getQualifiedName());
            }
            this.nameListFromWrapperElement.put(qName, linkedHashMap);
            return schemaParticleArray.length;
        }
        SchemaProperty[] schemaPropertyArray = schemaType.getProperties();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(schemaPropertyArray.length * 4 / 3);
        if (jParameterArray.length < n + schemaPropertyArray.length) {
            throw new IllegalStateException("Java class parameters do not match WSDL definition.");
        }
        for (int i = 0; i < schemaPropertyArray.length; ++i) {
            this.bindParameter(schemaPropertyArray[i].getType(), jParameterArray[n + i].getType());
            linkedHashMap.put(schemaPropertyArray[i].getName().getLocalPart(), jParameterArray[n + i].getType().getQualifiedName());
        }
        this.nameListFromWrapperElement.put(qName, linkedHashMap);
        return schemaPropertyArray.length;
    }

    private void bindParameter(SchemaType schemaType, JClass jClass) {
        if (schemaType.isSimpleType() || this.isSoapEncodingSimpleType(schemaType)) {
            this.bindParameterAtomic(jClass, schemaType);
        } else {
            if (schemaType.isAttributeType()) {
                throw new IllegalArgumentException("Parameter cannot be an attribute.");
            }
            if (WLW81SchemaAndJavaBinder.isSoapArray(schemaType)) {
                this.bindParameterSoapArray(jClass, schemaType);
            } else if (WLW81SchemaAndJavaBinder.isLiteralArray(schemaType)) {
                this.bindParameterLiteralArray(jClass, schemaType);
            } else if (!WLW81SchemaAndJavaBinder.isXmlBeanOrXBeanArray(jClass)) {
                if (jClass.getQualifiedName().equals("javax.activation.DataHandler")) {
                    BindingTypeName bindingTypeName = this.bindingTypeName(jClass, schemaType);
                    ByNameBean byNameBean = new ByNameBean(bindingTypeName);
                    this.bindingFile.addBindingType((BindingType)byNameBean, this.shouldBeFromJavaDefault(bindingTypeName), true);
                } else {
                    this.bindParameterComplex(jClass, schemaType);
                }
            }
        }
    }

    private boolean isSoapEncodingSimpleType(SchemaType schemaType) {
        String string;
        QName qName;
        if (schemaType != null && (qName = schemaType.getName()) != null && (string = qName.getNamespaceURI()) != null && string.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return soapEncodingSimpleElements.contains(schemaType.getName().getLocalPart());
        }
        return false;
    }

    private static boolean isXmlBeanOrXBeanArray(JClass jClass) {
        if (jClass == null) {
            return false;
        }
        if (jClass.isArrayType()) {
            JClass jClass2 = jClass.getArrayComponentType();
            return WLW81SchemaAndJavaBinder.isXmlBeanOrXBeanArray(jClass2);
        }
        JClass jClass3 = jClass.forName("org.apache.xmlbeans.XmlObject");
        if (!jClass3.isUnresolvedType() && jClass3.isAssignableFrom(jClass)) {
            return true;
        }
        jClass3 = jClass.getClassLoader().loadClass(XmlObject.class.getName());
        return jClass3.isAssignableFrom(jClass);
    }

    private void bindParameterAtomic(JClass jClass, SchemaType schemaType) {
        BindingTypeName bindingTypeName;
        SchemaType schemaType2 = schemaType.getBaseType();
        if (schemaType2 != null && this.bindingLoader.getBindingType(bindingTypeName = this.bindingTypeName(jClass, schemaType)) == null && this.bindingFile.getBindingType(bindingTypeName) == null) {
            SimpleBindingType simpleBindingType = new SimpleBindingType(bindingTypeName);
            XmlTypeName xmlTypeName = XmlTypeName.forSchemaType((SchemaType)schemaType2);
            simpleBindingType.setAsIfXmlType(xmlTypeName);
            this.bindingFile.addBindingType((BindingType)simpleBindingType, this.shouldBeFromJavaDefault(bindingTypeName), true);
        }
    }

    private void bindParameterSoapArray(JClass jClass, SchemaType schemaType) {
        boolean bl;
        boolean bl2;
        if (XBeanUtil.isXmlBean(jClass)) {
            return;
        }
        if (jClass.isArrayType() && XBeanUtil.isXmlBean(jClass.getArrayComponentType())) {
            return;
        }
        BindingTypeName bindingTypeName = this.bindingTypeName(jClass, schemaType);
        SoapArrayType soapArrayType = new SoapArrayType(this.bindingTypeName(jClass, schemaType));
        SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
        boolean bl3 = bl2 = schemaPropertyArray != null && schemaPropertyArray.length == 1;
        boolean bl4 = schemaPropertyArray != null && schemaPropertyArray.length == 1 ? schemaPropertyArray[0].hasNillable() != 0 : (bl = false);
        if (bl2) {
            soapArrayType.setItemName(schemaPropertyArray[0].getName());
        }
        soapArrayType.setItemNillable(bl);
        SchemaLocalAttribute schemaLocalAttribute = schemaType.getAttributeModel().getAttribute(new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType"));
        SOAPArrayType sOAPArrayType = ((SchemaWSDLArrayType)schemaLocalAttribute).getWSDLArrayType();
        boolean bl5 = WLW81SchemaAndJavaBinder.isCollectionType(jClass);
        if (!jClass.isArrayType() && !bl5) {
            throw new IllegalArgumentException("Soap Array type must be mapped to a java array for schema type " + schemaType.getName() + " - " + jClass.getQualifiedName());
        }
        if (bl5) {
            WrappedArrayType wrappedArrayType = WLW81SchemaAndJavaBinder.createCollectionType(bindingTypeName);
            this.bindingFile.addBindingType((BindingType)wrappedArrayType, this.shouldBeFromJavaDefault(bindingTypeName), true);
        } else {
            BindingType bindingType;
            JClass jClass2;
            Object object;
            BindingTypeName bindingTypeName2;
            SchemaType schemaType2;
            int n;
            if (sOAPArrayType != null) {
                n = sOAPArrayType.getDimensions().length + sOAPArrayType.getRanks().length;
                schemaType2 = this.sts.findType(sOAPArrayType.getQName());
                if (schemaType2 != null) {
                    if (n == jClass.getArrayDimensions()) {
                        BindingType bindingType2 = this.getOrCreateBindingType(jClass.getArrayComponentType(), schemaType2);
                        bindingTypeName2 = bindingType2.getName();
                    } else {
                        int n2 = jClass.getArrayDimensions();
                        object = jClass.getArrayComponentType().getQualifiedName();
                        for (int i = 0; i < n2 - n; ++i) {
                            object = (String)object + "[]";
                        }
                        jClass2 = jClass.forName((String)object);
                        bindingType = this.getOrCreateBindingType(jClass2, schemaType2);
                        bindingTypeName2 = bindingType.getName();
                    }
                } else {
                    XmlTypeName xmlTypeName = WLW81SchemaAndJavaBinder.soapArrayTypeName(schemaType);
                    object = JavaTypeName.forString((String)jClass.getQualifiedName());
                    bindingTypeName2 = BindingTypeName.forPair((JavaTypeName)object, (XmlTypeName)xmlTypeName);
                }
            } else {
                n = 1;
                schemaType2 = null;
                SchemaType schemaType3 = null;
                object = schemaType.getElementProperties();
                if (((SchemaProperty[])object).length != 1) {
                    throw new IllegalArgumentException("Array element length must be 1: ");
                }
                schemaType3 = schemaPropertyArray[0].getType();
                schemaType2 = this.getOrCreateBindingType(jClass.getArrayComponentType(), schemaType3);
                bindingTypeName2 = schemaType2.getName();
            }
            soapArrayType.setRanks(n);
            soapArrayType.setItemType(bindingTypeName2);
            schemaType2 = WLW81SchemaAndJavaBinder.soapArrayTypeName(schemaType);
            schemaType2 = schemaType2.getOuterComponent();
            int n3 = n;
            object = jClass.getQualifiedName();
            while (schemaType2.getComponentType() == 121) {
                object = ((String)object).substring(0, ((String)object).lastIndexOf(91));
                jClass2 = JavaTypeName.forString((String)object);
                bindingType = BindingTypeName.forPair((JavaTypeName)jClass2, (XmlTypeName)schemaType2);
                SoapArrayType soapArrayType2 = new SoapArrayType((BindingTypeName)bindingType);
                soapArrayType2.setRanks(1);
                soapArrayType2.setItemType(bindingTypeName2);
                this.bindingFile.addBindingType((BindingType)soapArrayType2, true, true);
                schemaType2 = schemaType2.getOuterComponent();
            }
            this.bindingFile.addBindingType((BindingType)soapArrayType, this.shouldBeFromJavaDefault(bindingTypeName), true);
        }
    }

    public static WrappedArrayType createCollectionType(BindingTypeName bindingTypeName) {
        WrappedArrayType wrappedArrayType = new WrappedArrayType(bindingTypeName);
        wrappedArrayType.setItemNillable(true);
        BindingTypeName bindingTypeName2 = BindingTypeName.forPair((JavaTypeName)JavaTypeName.forString((String)Object.class.getName()), (XmlTypeName)XmlTypeName.forTypeNamed((QName)XS_ANYTYPE));
        wrappedArrayType.setItemType(bindingTypeName2);
        wrappedArrayType.setItemName(new QName(COLLECTION_ELEMENT_NAME));
        return wrappedArrayType;
    }

    public static boolean isCollectionType(JClass jClass) {
        return Java2Schema.isCollectionType((JClass)jClass);
    }

    public static boolean isCollectionType(Class clazz) {
        return Java2Schema.isCollectionType((Class)clazz);
    }

    public static boolean isCollectionType(String string) {
        return Java2Schema.isCollectionType((String)string);
    }

    private void bindParameterLiteralArray(JClass jClass, SchemaType schemaType) {
        WrappedArrayType wrappedArrayType;
        if (XBeanUtil.isXmlBean(jClass)) {
            return;
        }
        if (jClass.isArrayType() && XBeanUtil.isXmlBean(jClass.getArrayComponentType())) {
            return;
        }
        BindingTypeName bindingTypeName = this.bindingTypeName(jClass, schemaType);
        boolean bl = WLW81SchemaAndJavaBinder.isCollectionType(jClass);
        if (!jClass.isArrayType() && !bl) {
            throw new IllegalArgumentException("Literal Array type must be mapped to a java array for schema type " + schemaType.getName() + " - " + jClass.getQualifiedName());
        }
        if (bl) {
            wrappedArrayType = WLW81SchemaAndJavaBinder.createCollectionType(bindingTypeName);
        } else {
            wrappedArrayType = new WrappedArrayType(bindingTypeName);
            SchemaProperty schemaProperty = schemaType.getProperties()[0];
            wrappedArrayType.setItemName(schemaProperty.getName());
            wrappedArrayType.setItemNillable(schemaProperty.hasNillable() != 0);
            SchemaType schemaType2 = WLW81SchemaAndJavaBinder.getLiteralArrayItemType(schemaType);
            String string = jClass.getQualifiedName();
            String string2 = string.substring(0, string.lastIndexOf(91));
            JClass jClass2 = jClass.forName(string2);
            BindingType bindingType = this.getOrCreateBindingType(jClass2, schemaType2);
            wrappedArrayType.setItemType(bindingType.getName());
        }
        this.bindingFile.addBindingType((BindingType)wrappedArrayType, this.shouldBeFromJavaDefault(bindingTypeName), true);
    }

    private void bindParameterComplex(JClass jClass, SchemaType schemaType) {
        BindingTypeName bindingTypeName = this.bindingTypeName(jClass, schemaType);
        if (this.bindingFile.getBindingType(bindingTypeName) == null) {
            ByNameBean byNameBean = new ByNameBean(bindingTypeName);
            this.bindingFile.addBindingType((BindingType)byNameBean, this.shouldBeFromJavaDefault(bindingTypeName), true);
            SchemaProperty[] schemaPropertyArray = schemaType.getProperties();
            for (int i = 0; i < schemaPropertyArray.length; ++i) {
                this.addPropertyToByNameBean(byNameBean, schemaPropertyArray[i], jClass);
            }
        }
    }

    private void addPropertyToByNameBean(ByNameBean byNameBean, SchemaProperty schemaProperty, JClass jClass) {
        BindingType bindingType;
        QNameProperty qNameProperty = new QNameProperty();
        String string = this.javaPropertyName(schemaProperty);
        JClass jClass2 = this.addGetterSetterOrFieldToQNameProperty(qNameProperty, jClass, schemaProperty, string);
        JavaTypeName javaTypeName = null;
        boolean bl = WLW81SchemaAndJavaBinder.isMultiple(schemaProperty);
        if (bl && jClass2.getArrayComponentType() != null) {
            javaTypeName = JavaTypeName.forString((String)jClass2.getQualifiedName());
            jClass2 = jClass2.getArrayComponentType();
        }
        if ((bindingType = this.getOrCreateBindingType(jClass2, schemaProperty)) != null) {
            qNameProperty.setQName(schemaProperty.getName());
            qNameProperty.setAttribute(schemaProperty.isAttribute());
            qNameProperty.setNillable(schemaProperty.hasNillable() != 0);
            qNameProperty.setOptional(WLW81SchemaAndJavaBinder.isOptional(schemaProperty));
            qNameProperty.setMultiple(bl);
            qNameProperty.setBindingType(bindingType);
            qNameProperty.setCollectionClass(javaTypeName);
            byNameBean.addProperty(qNameProperty);
        }
    }

    private BindingType getOrCreateBindingType(JClass jClass, SchemaProperty schemaProperty) {
        return this.getOrCreateBindingType(jClass, schemaProperty.getType());
    }

    private BindingType getOrCreateBindingType(JClass jClass, SchemaType schemaType) {
        BindingTypeName bindingTypeName = this.bindingTypeName(jClass, schemaType);
        BindingType bindingType = this.bindingLoader.getBindingType(bindingTypeName);
        if (bindingType == null) {
            this.bindParameter(schemaType, jClass);
            bindingType = this.bindingFile.getBindingType(bindingTypeName);
        }
        return bindingType;
    }

    private JClass addGetterSetterOrFieldToQNameProperty(QNameProperty qNameProperty, JClass jClass, SchemaProperty schemaProperty, String string) {
        JClass jClass2;
        JField jField = this.getJFieldForProperty(jClass, schemaProperty);
        if (jField != null && jField.isPublic()) {
            jClass2 = jField.getType();
            qNameProperty.setFieldName(string);
        } else {
            JMethod jMethod = this.getGetterJMethodForProperty(jClass, schemaProperty);
            JMethod jMethod2 = this.getSetterJMethodForProperty(jClass, schemaProperty);
            if (jMethod == null || jMethod2 == null) {
                throw new IllegalArgumentException("Could not find read/write property for schemaProperty: " + schemaProperty.getName() + " on class " + jClass.getQualifiedName());
            }
            jClass2 = jMethod.getReturnType();
            qNameProperty.setGetter(MethodName.create((JMethod)jMethod));
            qNameProperty.setSetter(MethodName.create((JMethod)jMethod2));
        }
        return jClass2;
    }

    private BindingTypeName bindingTypeName(JClass jClass, SchemaType schemaType) {
        JavaTypeName javaTypeName = JavaTypeName.forString((String)jClass.getQualifiedName());
        XmlTypeName xmlTypeName = XmlTypeName.forSchemaType((SchemaType)schemaType);
        BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
        return bindingTypeName;
    }

    private JMethod getSetterJMethodForProperty(JClass jClass, SchemaProperty schemaProperty) {
        return this.getJMethodForProperty("set", jClass, schemaProperty);
    }

    private JMethod getGetterJMethodForProperty(JClass jClass, SchemaProperty schemaProperty) {
        JMethod jMethod = this.getJMethodForProperty("get", jClass, schemaProperty);
        if (jMethod == null) {
            jMethod = this.getJMethodForProperty("is", jClass, schemaProperty);
        }
        return jMethod;
    }

    private JMethod getJMethodForProperty(String string, JClass jClass, SchemaProperty schemaProperty) {
        String string2 = this.methodNameFromProperty(string, schemaProperty);
        JMethod[] jMethodArray = jClass.getMethods();
        for (int i = 0; i < jMethodArray.length; ++i) {
            if (!jMethodArray[i].getSimpleName().equals(string2)) continue;
            return jMethodArray[i];
        }
        return null;
    }

    private JField getJFieldForProperty(JClass jClass, SchemaProperty schemaProperty) {
        String string = this.javaPropertyName(schemaProperty);
        JField[] jFieldArray = jClass.getFields();
        for (int i = 0; i < jFieldArray.length; ++i) {
            if (!jFieldArray[i].getSimpleName().equals(string)) continue;
            return jFieldArray[i];
        }
        return null;
    }

    private JMethod getJMethodThatMapsToOperation(WsdlOperation wsdlOperation) {
        String string = this.methodNameFromOperationName(wsdlOperation);
        JMethod jMethod = this.methodMap.get(string);
        if (null == jMethod) {
            jMethod = this.callbackMethodMap.get(string);
        }
        return jMethod;
    }

    private boolean isCallbackOperation(WsdlOperation wsdlOperation) {
        return this.callbackMethodMap.get(this.methodNameFromOperationName(wsdlOperation)) != null;
    }

    private String javaPropertyName(SchemaProperty schemaProperty) {
        return this.propertyNamePicker.pick(schemaProperty.getName().getLocalPart());
    }

    private String methodNameFromOperationName(WsdlOperation wsdlOperation) {
        return wsdlOperation.getName().getLocalPart();
    }

    private String methodNameFromProperty(String string, SchemaProperty schemaProperty) {
        return string + this.getterSetterNamePicker.pick(schemaProperty.getName().getLocalPart());
    }

    private boolean isWrapped(JMethod jMethod) {
        return WLW81SchemaAndJavaBinder.isWrapped(jMethod, this.serviceJClass);
    }

    public static boolean isWrapped(JMethod jMethod, JClass jClass) {
        JAnnotation jAnnotation = jMethod.getAnnotation(SOAPBinding.class);
        if (jAnnotation != null) {
            SOAPBinding.Style style = JamUtil.getAnnotationEnumValue(jAnnotation, "style", SOAPBinding.Style.class, SOAPBinding.Style.DOCUMENT);
            SOAPBinding.Use use = JamUtil.getAnnotationEnumValue(jAnnotation, "use", SOAPBinding.Use.class, SOAPBinding.Use.LITERAL);
            SOAPBinding.ParameterStyle parameterStyle = JamUtil.getAnnotationEnumValue(jAnnotation, "parameterStyle", SOAPBinding.ParameterStyle.class, SOAPBinding.ParameterStyle.WRAPPED);
            return style == SOAPBinding.Style.DOCUMENT && use == SOAPBinding.Use.LITERAL && parameterStyle == SOAPBinding.ParameterStyle.WRAPPED;
        }
        jAnnotation = jMethod.getAnnotation("com.bea.control.ServiceControl$SOAPBinding");
        if (jAnnotation != null) {
            String string = jAnnotation.getValue("use").asString();
            String string2 = jAnnotation.getValue("style").asString();
            String string3 = jAnnotation.getValue("parameterStyle").asString();
            if (string.trim().length() == 0) {
                string = "LITERAL";
            }
            if (string2.trim().length() == 0) {
                string = "DOCUMENT";
            }
            if (string3.trim().length() == 0) {
                string = "WRAPPED";
            }
            return string.equals("LITERAL") && string2.equals("DOCUMENT") && string3.equals("WRAPPED");
        }
        jAnnotation = jClass.getAnnotation(SOAPBinding.class);
        if (jAnnotation != null) {
            SOAPBinding.Style style = JamUtil.getAnnotationEnumValue(jAnnotation, "style", SOAPBinding.Style.class, SOAPBinding.Style.DOCUMENT);
            SOAPBinding.Use use = JamUtil.getAnnotationEnumValue(jAnnotation, "use", SOAPBinding.Use.class, SOAPBinding.Use.LITERAL);
            SOAPBinding.ParameterStyle parameterStyle = JamUtil.getAnnotationEnumValue(jAnnotation, "parameterStyle", SOAPBinding.ParameterStyle.class, SOAPBinding.ParameterStyle.WRAPPED);
            return style == SOAPBinding.Style.DOCUMENT && use == SOAPBinding.Use.LITERAL && parameterStyle == SOAPBinding.ParameterStyle.WRAPPED;
        }
        jAnnotation = jClass.getAnnotation("com.bea.control.ServiceControl$SOAPBinding");
        if (jAnnotation != null) {
            String string = jAnnotation.getValue("use").asString();
            String string4 = jAnnotation.getValue("style").asString();
            String string5 = jAnnotation.getValue("parameterStyle").asString();
            if (string.trim().length() == 0) {
                string = "LITERAL";
            }
            if (string4.trim().length() == 0) {
                string = "DOCUMENT";
            }
            if (string5.trim().length() == 0) {
                string = "WRAPPED";
            }
            return string.equals("LITERAL") && string4.equals("DOCUMENT") && string5.equals("WRAPPED");
        }
        return true;
    }

    private void populateMethodMap() {
        this.methodMap.clear();
        this.callbackMethodMap.clear();
        WLW81SchemaAndJavaBinder.populateMethodMap(this.serviceJClass, this.methodMap, this.callbackMethodMap);
    }

    public static void populateMethodMap(JClass jClass, HashMap<String, JMethod> hashMap, HashMap<String, JMethod> hashMap2) {
        String string;
        int n;
        JMethod[] jMethodArray;
        String string2;
        JAnnotation jAnnotation;
        JMethod[] jMethodArray2 = jClass.getMethods();
        for (int i = 0; i < jMethodArray2.length; ++i) {
            String string3 = jMethodArray2[i].getSimpleName();
            jAnnotation = jMethodArray2[i].getAnnotation(WebMethod.class);
            if (jAnnotation != null && (string2 = JamUtil.getAnnotationStringValue(jAnnotation, "operationName")) != null && !string2.equals("")) {
                string3 = string2;
            }
            hashMap.put(string3, jMethodArray2[i]);
        }
        JField[] jFieldArray = jClass.getFields();
        for (int i = 0; i < jFieldArray.length; ++i) {
            jAnnotation = jFieldArray[i];
            string2 = jAnnotation.getAnnotation(Callback.class);
            if (string2 == null) continue;
            jMethodArray = jAnnotation.getType().getMethods();
            for (n = 0; n < jMethodArray.length; ++n) {
                String string4;
                string = jMethodArray[n].getSimpleName();
                JAnnotation jAnnotation2 = jMethodArray[n].getAnnotation(WebMethod.class);
                if (jAnnotation2 != null && (string4 = JamUtil.getAnnotationStringValue(jAnnotation2, "operationName")) != null && !string4.equals("")) {
                    string = string4;
                }
                hashMap2.put(string, jMethodArray[n]);
            }
        }
        JClass[] jClassArray = jClass.getClasses();
        for (int i = 0; i < jClassArray.length; ++i) {
            string2 = jClassArray[i];
            if (!string2.getSimpleName().equals(jClass.getSimpleName() + "$Callback")) continue;
            jMethodArray = string2.getMethods();
            for (n = 0; n < jMethodArray.length; ++n) {
                string = jMethodArray[n].getSimpleName();
                hashMap2.put(string, jMethodArray[n]);
            }
        }
    }

    public WsdlMethod getWsdlMethodForCallback(WsdlOperationBuilder wsdlOperationBuilder) {
        String string;
        WsdlMethodImpl wsdlMethodImpl = new WsdlMethodImpl();
        WsdlMessageBuilder wsdlMessageBuilder = wsdlOperationBuilder.getOutput();
        WsdlMessageBuilder wsdlMessageBuilder2 = wsdlOperationBuilder.getInput();
        WsdlPartBuilder wsdlPartBuilder = null;
        String string2 = this.findReturnPartForCallback(wsdlOperationBuilder);
        if (!StringUtil.isEmpty(string2)) {
            wsdlPartBuilder = wsdlMessageBuilder2.getParts().get(string2);
            wsdlMethodImpl.setResultPart(wsdlPartBuilder);
        }
        if (StringUtil.isEmpty(string = wsdlOperationBuilder.getParameterOrder())) {
            this.fillWithOutParameterOrder(wsdlMethodImpl, wsdlMessageBuilder, wsdlMessageBuilder2, wsdlPartBuilder);
        } else {
            this.fillWithParameterOrder(wsdlMethodImpl, wsdlMessageBuilder, wsdlMessageBuilder2, wsdlPartBuilder, string);
        }
        return wsdlMethodImpl;
    }

    private String findReturnPartForCallback(WsdlOperationBuilder wsdlOperationBuilder) {
        Object object;
        String string = wsdlOperationBuilder.getParameterOrder();
        HashSet<String> hashSet = new HashSet<String>();
        if (string != null) {
            object = new StringTokenizer(string, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                hashSet.add(((StringTokenizer)object).nextToken());
            }
        }
        object = wsdlOperationBuilder.getInput();
        WsdlMessageBuilder wsdlMessageBuilder = wsdlOperationBuilder.getOutput();
        if (object == null) {
            return null;
        }
        String string2 = null;
        for (WsdlPart wsdlPart : object.getParts().values()) {
            WsdlPart wsdlPart2;
            WsdlPart wsdlPart3 = wsdlPart2 = wsdlMessageBuilder == null ? null : wsdlMessageBuilder.getParts().get(wsdlPart.getName());
            if (wsdlPart2 == null && hashSet.contains(wsdlPart.getName()) || wsdlPart.equals(wsdlPart2)) continue;
            if (string2 == null) {
                string2 = wsdlPart.getName();
                continue;
            }
            if (StringUtil.isEmpty(string)) {
                return null;
            }
            throw new IllegalStateException("More than one return outPart found in operation: " + wsdlOperationBuilder + ". Only one outPart name can be " + "missing in the parameterOrder");
        }
        return string2;
    }

    public void fillWithOutParameterOrder(WsdlMethodBuilder wsdlMethodBuilder, WsdlMessageBuilder wsdlMessageBuilder, WsdlMessageBuilder wsdlMessageBuilder2, WsdlPart wsdlPart) {
        HashSet<WsdlPartBuilder> hashSet = new HashSet<WsdlPartBuilder>();
        if (wsdlMessageBuilder != null) {
            for (WsdlPartBuilder wsdlPartBuilder : wsdlMessageBuilder.getParts().values()) {
                WsdlPartBuilder wsdlPartBuilder2 = null;
                if (wsdlMessageBuilder2 != null) {
                    wsdlPartBuilder2 = wsdlMessageBuilder2.getParts().get(wsdlPartBuilder.getName());
                    if (wsdlPartBuilder2 == null || !wsdlPartBuilder2.equals(wsdlPartBuilder)) {
                        wsdlPartBuilder2 = null;
                    } else {
                        hashSet.add(wsdlPartBuilder2);
                    }
                }
                wsdlMethodBuilder.addWsdlParameter(new WsdlParameterImpl(wsdlPartBuilder, wsdlPartBuilder2));
            }
        }
        if (wsdlMessageBuilder2 != null) {
            for (WsdlPartBuilder wsdlPartBuilder : wsdlMessageBuilder2.getParts().values()) {
                if (wsdlPartBuilder == wsdlPart || hashSet.contains(wsdlPartBuilder)) continue;
                wsdlMethodBuilder.addWsdlParameter(new WsdlParameterImpl(null, wsdlPartBuilder));
            }
        }
    }

    public void fillWithParameterOrder(WsdlMethodBuilder wsdlMethodBuilder, WsdlMessageBuilder wsdlMessageBuilder, WsdlMessageBuilder wsdlMessageBuilder2, WsdlPart wsdlPart, String string) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            object = new StringTokenizer(string, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        object = new HashSet();
        for (String object2 : arrayList) {
            WsdlPartBuilder wsdlPartBuilder = wsdlMessageBuilder.getParts().get(object2);
            WsdlPartBuilder wsdlPartBuilder2 = null;
            if (wsdlMessageBuilder2 != null) {
                wsdlPartBuilder2 = wsdlMessageBuilder2.getParts().get(object2);
                if (wsdlPartBuilder2 != null && wsdlPartBuilder == null || wsdlPartBuilder != null && wsdlPartBuilder.equals(wsdlPartBuilder2)) {
                    object.add(wsdlPartBuilder2);
                } else {
                    wsdlPartBuilder2 = null;
                }
            }
            if (wsdlPartBuilder == null && wsdlPartBuilder2 == null) {
                throw new IllegalArgumentException("No In part or out part found for: " + object2 + " with Parameter Order = " + string);
            }
            wsdlMethodBuilder.addWsdlParameter(new WsdlParameterImpl(wsdlPartBuilder, wsdlPartBuilder2));
        }
        if (wsdlMessageBuilder2 != null) {
            for (WsdlPartBuilder wsdlPartBuilder : wsdlMessageBuilder2.getParts().values()) {
                if (wsdlPartBuilder == wsdlPart || object.contains(wsdlPartBuilder)) continue;
                wsdlMethodBuilder.addWsdlParameter(new WsdlParameterImpl(null, wsdlPartBuilder));
            }
        }
    }

    public Map getNameListFromWrapperElement() {
        return this.nameListFromWrapperElement;
    }

    private static boolean isLiteralArray(SchemaType schemaType) {
        return WLW81SchemaAndJavaBinder.getLiteralArrayItemType(schemaType) != null;
    }

    private static SchemaType getLiteralArrayItemType(SchemaType schemaType) {
        if (schemaType.isSimpleType() || schemaType.getContentType() == 2) {
            return null;
        }
        SchemaProperty[] schemaPropertyArray = schemaType.getProperties();
        if (schemaPropertyArray.length != 1 || schemaPropertyArray[0].isAttribute()) {
            return null;
        }
        BigInteger bigInteger = schemaPropertyArray[0].getMaxOccurs();
        if (bigInteger != null && bigInteger.compareTo(BigInteger.ONE) <= 0) {
            return null;
        }
        return schemaPropertyArray[0].getType();
    }

    private static boolean isSoapArray(SchemaType schemaType) {
        while (schemaType != null) {
            String string = XmlTypeName.forSchemaType((SchemaType)schemaType).toString();
            if (string.equals("t=Array@http://schemas.xmlsoap.org/soap/encoding/") || string.startsWith("t=Array@http://www.w3.org/") && string.endsWith("/soap-encoding")) {
                return true;
            }
            schemaType = schemaType.getBaseType();
        }
        return false;
    }

    private static XmlTypeName soapArrayTypeName(SchemaType schemaType) {
        SOAPArrayType sOAPArrayType = WLW81SchemaAndJavaBinder.getWsdlArrayType(schemaType);
        if (sOAPArrayType != null) {
            return XmlTypeName.forSoapArrayType((SOAPArrayType)sOAPArrayType);
        }
        SchemaType schemaType2 = XmlObject.type;
        SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
        if (schemaPropertyArray.length == 1) {
            schemaType2 = schemaPropertyArray[0].getType();
        }
        return XmlTypeName.forNestedNumber((char)'y', (int)1, (XmlTypeName)XmlTypeName.forSchemaType((SchemaType)schemaType2));
    }

    private static SOAPArrayType getWsdlArrayType(SchemaType schemaType) {
        SchemaLocalAttribute schemaLocalAttribute = schemaType.getAttributeModel().getAttribute(arrayType);
        if (schemaLocalAttribute != null) {
            return ((SchemaWSDLArrayType)schemaLocalAttribute).getWSDLArrayType();
        }
        return null;
    }

    private static boolean isMultiple(SchemaProperty schemaProperty) {
        return schemaProperty.getMaxOccurs() == null || schemaProperty.getMaxOccurs().compareTo(BigInteger.ONE) > 0;
    }

    private static boolean isOptional(SchemaProperty schemaProperty) {
        return schemaProperty.getMinOccurs().signum() == 0 && !WLW81SchemaAndJavaBinder.isMultiple(schemaProperty);
    }

    private boolean shouldBeFromJavaDefault(BindingTypeName bindingTypeName) {
        JavaTypeName javaTypeName = bindingTypeName.getJavaName();
        XmlTypeName xmlTypeName = bindingTypeName.getXmlName();
        if (xmlTypeName.isSchemaType()) {
            return this.bindingFile.lookupTypeFor(javaTypeName) == null && this.bindingLoader.lookupTypeFor(javaTypeName) == null;
        }
        if (xmlTypeName.getComponentType() == 101) {
            return this.bindingFile.lookupElementFor(javaTypeName) == null && this.bindingLoader.lookupElementFor(javaTypeName) == null;
        }
        return false;
    }

    static {
        soapEncodingSimpleElements.add("ENTITIES");
        soapEncodingSimpleElements.add("ENTITY");
        soapEncodingSimpleElements.add("ID");
        soapEncodingSimpleElements.add("IDREF");
        soapEncodingSimpleElements.add("IDREFS");
        soapEncodingSimpleElements.add("NCName");
        soapEncodingSimpleElements.add("NMTOKEN");
        soapEncodingSimpleElements.add("NMTOKENS");
        soapEncodingSimpleElements.add("NOTATION");
        soapEncodingSimpleElements.add("Name");
        soapEncodingSimpleElements.add("QName");
        soapEncodingSimpleElements.add("anyURI");
        soapEncodingSimpleElements.add("base64Binary");
        soapEncodingSimpleElements.add("boolean");
        soapEncodingSimpleElements.add("byte");
        soapEncodingSimpleElements.add("date");
        soapEncodingSimpleElements.add("dateTime");
        soapEncodingSimpleElements.add("decimal");
        soapEncodingSimpleElements.add("double");
        soapEncodingSimpleElements.add("duration");
        soapEncodingSimpleElements.add("float");
        soapEncodingSimpleElements.add("gDay");
        soapEncodingSimpleElements.add("gMonth");
        soapEncodingSimpleElements.add("gMonthDay");
        soapEncodingSimpleElements.add("gYear");
        soapEncodingSimpleElements.add("gYearMonth");
        soapEncodingSimpleElements.add("hexBinary");
        soapEncodingSimpleElements.add("int");
        soapEncodingSimpleElements.add("integer");
        soapEncodingSimpleElements.add("language");
        soapEncodingSimpleElements.add("long");
        soapEncodingSimpleElements.add("negativeInteger");
        soapEncodingSimpleElements.add("nonNegativeInteger");
        soapEncodingSimpleElements.add("nonPositiveInteger");
        soapEncodingSimpleElements.add("normalizedString");
        soapEncodingSimpleElements.add("positiveInteger");
        soapEncodingSimpleElements.add("short");
        soapEncodingSimpleElements.add("string");
        soapEncodingSimpleElements.add("time");
        soapEncodingSimpleElements.add("token");
        soapEncodingSimpleElements.add("unsignedByte");
        soapEncodingSimpleElements.add("unsignedInt");
        soapEncodingSimpleElements.add("unsignedLong");
        soapEncodingSimpleElements.add("unsignedShort");
        XS_ANYTYPE = Java2Schema.XS_ANYTYPE;
        arrayType = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    }
}

