/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.buildtime.internal;

import com.bea.staxb.buildtime.ArrayNamespaceInfo;
import com.bea.staxb.buildtime.internal.bts.BindingFile;
import com.bea.staxb.buildtime.internal.bts.BindingLoader;
import com.bea.staxb.buildtime.internal.bts.BindingType;
import com.bea.staxb.buildtime.internal.bts.BindingTypeName;
import com.bea.staxb.buildtime.internal.bts.ByNameBean;
import com.bea.staxb.buildtime.internal.bts.JavaTypeName;
import com.bea.staxb.buildtime.internal.bts.SimpleBindingType;
import com.bea.staxb.buildtime.internal.bts.SimpleDocumentBinding;
import com.bea.staxb.buildtime.internal.bts.SoapArrayType;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.staxb.buildtime.internal.facade.Java2SchemaContext;
import com.bea.staxb.buildtime.internal.facade.TypegenFacade;
import com.bea.staxb.buildtime.internal.logger.BindingLogger;
import com.bea.util.jam.JClass;
import com.bea.xbean.xb.xsdschema.Attribute;
import com.bea.xbean.xb.xsdschema.ComplexContentDocument;
import com.bea.xbean.xb.xsdschema.ComplexRestrictionType;
import com.bea.xbean.xb.xsdschema.ExplicitGroup;
import com.bea.xbean.xb.xsdschema.ExtensionType;
import com.bea.xbean.xb.xsdschema.LocalElement;
import com.bea.xbean.xb.xsdschema.NumFacet;
import com.bea.xbean.xb.xsdschema.RestrictionDocument;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xbean.xb.xsdschema.TopLevelComplexType;
import com.bea.xbean.xb.xsdschema.TopLevelElement;
import com.bea.xbean.xb.xsdschema.TopLevelSimpleType;
import com.bea.xml.XmlAnySimpleType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.bind.buildtime.J2SBindingsBuilder;
import weblogic.wsee.bind.buildtime.internal.SoapAwareJava2Schema;
import weblogic.wsee.bind.buildtime.internal.WLW81TypegenFacade;

class WLW81SoapAwareJava2Schema
extends SoapAwareJava2Schema {
    private static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    private String mTargetNamespaceForComplexTypes;
    private boolean mIsRpcEncoded;
    private Map<Class, BindingType> mSpecialClasses = new HashMap<Class, BindingType>();
    private Java2SchemaContext mWLW81FacadeContext = new Java2SchemaContext(){

        public BindingLogger getLogger() {
            return WLW81SoapAwareJava2Schema.this;
        }

        public BindingLoader getBindingLoader() {
            return WLW81SoapAwareJava2Schema.this.getBindingLoader();
        }

        public BindingType findOrCreateBindingTypeFor(JClass jClass) {
            if (jClass.isArrayType()) {
                ArrayNamespaceInfo arrayNamespaceInfo = new ArrayNamespaceInfo(null, jClass, WLW81SoapAwareJava2Schema.this.mTargetNamespaceForComplexTypes);
                if (WLW81SoapAwareJava2Schema.this.mIsRpcEncoded) {
                    WLW81SoapAwareJava2Schema.this.findOrCreateElementNameSetFor(WLW81SoapAwareJava2Schema.this.mTargetNamespaceForComplexTypes, null, jClass);
                    return WLW81SoapAwareJava2Schema.this.generateSoapArray(WLW81SoapAwareJava2Schema.this.mTns2Schemadoc, arrayNamespaceInfo, WLW81SoapAwareJava2Schema.this.mBindingFile, WLW81SoapAwareJava2Schema.this.mGeneratedSoapArrayJavaTypeNames);
                }
                WLW81SoapAwareJava2Schema.this.findOrCreateLiteralElementNameSetFor(WLW81SoapAwareJava2Schema.this.mTargetNamespaceForComplexTypes, null, jClass);
                return WLW81SoapAwareJava2Schema.this.generateLiteralArray(arrayNamespaceInfo, WLW81SoapAwareJava2Schema.this.mGeneratedArrayJavaTypeNames);
            }
            return WLW81SoapAwareJava2Schema.this.findOrCreateBindingTypeFor(jClass);
        }

        public void checkNsForImport(String string, String string2) {
            WLW81SoapAwareJava2Schema.this.checkNsForImport(string, string2);
        }

        public boolean isElementFormDefaultQualified() {
            return WLW81SoapAwareJava2Schema.this.isElementFormDefaultQualified();
        }
    };

    public WLW81SoapAwareJava2Schema(J2SBindingsBuilder j2SBindingsBuilder, boolean bl, String string) {
        super(j2SBindingsBuilder);
        this.mTargetNamespaceForComplexTypes = string;
        this.mIsRpcEncoded = bl;
        this.mLiteralArrayConstituentElementNameBySchemaArrayElement = false;
        this.allowNullByMinOccursZeroInWrapperElements = true;
    }

    protected TypegenFacade createTypegenFacade(TopLevelComplexType topLevelComplexType, ExtensionType extensionType, String string, ByNameBean byNameBean) {
        return new WLW81TypegenFacade(this.mWLW81FacadeContext, topLevelComplexType, extensionType, string, byNameBean);
    }

    public void addClassToBind(JClass jClass) {
        if (jClass.getContainingClass() == null) {
            super.addClassToBind(jClass);
        } else {
            this.assertCompilationStarted(false);
            if (this.mClassesToBind.contains(jClass)) {
                return;
            }
            this.assertResolved(jClass);
            if (!WLW81SoapAwareJava2Schema.isValidInputType((JClass)jClass)) {
                this.logError("Invalid input java type '" + jClass.getQualifiedName() + "'");
                return;
            }
            this.mClassesToBind.add(jClass);
        }
    }

    private BindingType findOrCreateBindingTypeForSpecialClasses(JClass jClass) {
        Class<Character> clazz = null;
        if (Character.class.getName().equals(jClass.getQualifiedName())) {
            clazz = Character.class;
        } else if ("char".equals(jClass.getQualifiedName())) {
            clazz = Character.TYPE;
        }
        if (clazz == null) {
            return null;
        }
        BindingType bindingType = this.mSpecialClasses.get(clazz);
        if (bindingType != null) {
            return bindingType;
        }
        JavaTypeName javaTypeName = JavaTypeName.forString((String)clazz.getName());
        QName qName = new QName(this.mTargetNamespaceForComplexTypes, clazz.getSimpleName());
        XmlTypeName xmlTypeName = XmlTypeName.forTypeNamed((QName)qName);
        BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
        SimpleBindingType simpleBindingType = new SimpleBindingType(bindingTypeName);
        QName qName2 = new QName(XSD_NS, "string");
        XmlTypeName xmlTypeName2 = XmlTypeName.forTypeNamed((QName)qName2);
        simpleBindingType.setAsIfXmlType(xmlTypeName2);
        this.mBindingFile.addBindingType((BindingType)simpleBindingType, true, true);
        this.mSpecialClasses.put(clazz, (BindingType)simpleBindingType);
        return simpleBindingType;
    }

    protected String getDefaultNamespaceForJClass(JClass jClass) {
        return this.mTargetNamespaceForComplexTypes;
    }

    protected String getDefaultLocalNameFor(JClass jClass) {
        String string = jClass.getSimpleName();
        int n = string.lastIndexOf(36);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return WLW81SoapAwareJava2Schema.makeNcNameSafe((String)string);
    }

    protected QName getLiteralArrayTypeName(ArrayNamespaceInfo arrayNamespaceInfo, String string) {
        QName qName;
        JClass jClass = arrayNamespaceInfo.getArrayClass();
        int n = jClass.getArrayDimensions();
        JClass jClass2 = jClass.getArrayComponentType();
        String string2 = arrayNamespaceInfo.getNamespace();
        if (n >= 2 && jClass2.isPrimitiveType() && jClass2.getQualifiedName().equals("byte")) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i < n; ++i) {
                stringBuffer.append("ArrayOf");
            }
            qName = new QName(string2, stringBuffer.toString() + "Binary");
        } else {
            String string3 = this.arrayComponentNameForJClass(jClass2, string);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("ArrayOf");
            }
            qName = new QName(string2, stringBuffer.toString() + string3);
        }
        return qName;
    }

    protected String arrayComponentNameForJClass(JClass jClass, String string) {
        String string2 = jClass.getQualifiedName();
        if (string2.equals("java.lang.Integer")) {
            return "Int";
        }
        if (string2.equals("java.math.BigDecimal")) {
            return "Decimal";
        }
        if (string2.equals("java.math.BigInteger")) {
            return "Integer";
        }
        if (string2.equals("java.util.Calendar")) {
            return "Date";
        }
        return this.getDefaultLocalNameFor(jClass);
    }

    protected BindingType findOrCreateBindingTypeFor(JClass jClass) {
        if (jClass == null) {
            throw new IllegalArgumentException("null clazz");
        }
        BindingType bindingType = this.findOrCreateBindingTypeForSpecialClasses(jClass);
        if (bindingType != null) {
            return bindingType;
        }
        return super.findOrCreateBindingTypeFor(jClass);
    }

    protected BindingType generateSoapArray(Map map, ArrayNamespaceInfo arrayNamespaceInfo, BindingFile bindingFile, Collection collection) {
        BindingType bindingType;
        JavaTypeName javaTypeName;
        JClass jClass;
        if (this.typeIs1DPrimitiveByteArray(arrayNamespaceInfo.getArrayClass())) {
            XmlTypeName xmlTypeName = XmlTypeName.forTypeNamed((QName)XS_BASE_64_BINARY);
            JavaTypeName javaTypeName2 = JavaTypeName.forJClass((JClass)arrayNamespaceInfo.getArrayClass());
            BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName2, (XmlTypeName)xmlTypeName);
            return this.mBindingFile.getBindingType(bindingTypeName);
        }
        Map map2 = this.mGeneratedArrayJavaTypeNames;
        JClass jClass2 = arrayNamespaceInfo.getArrayClass();
        JavaTypeName javaTypeName3 = JavaTypeName.forJClass((JClass)jClass2);
        JClass jClass3 = jClass = jClass2.getArrayComponentType();
        int n = jClass2.getArrayDimensions();
        if (n > 1) {
            String string = jClass.getQualifiedName();
            for (int i = 0; i < n - 1; ++i) {
                string = string + "[]";
            }
            jClass3 = jClass.forName(string);
            javaTypeName = new ArrayNamespaceInfo(arrayNamespaceInfo.getServiceClass(), jClass3, arrayNamespaceInfo.getNamespace());
            this.generateSoapArray(map, (ArrayNamespaceInfo)javaTypeName, bindingFile, null);
        }
        boolean bl = jClass.isPrimitiveType();
        javaTypeName = JavaTypeName.forJClass((JClass)jClass);
        BindingTypeName bindingTypeName = null;
        bindingTypeName = jClass.getQualifiedName().equals("char") || jClass.getQualifiedName().equals(Character.class.getName()) ? this.mBindingFile.lookupTypeFor(javaTypeName) : this.getBindingLoader().lookupTypeFor(javaTypeName);
        if (bindingTypeName == null) {
            throw new IllegalArgumentException("could not find binding type for literal array element class type: " + jClass);
        }
        QName qName = bindingTypeName.getXmlName().getQName();
        String string = this.arrayComponentNameForJClass(jClass, qName.getLocalPart());
        QName[] qNameArray = this.getElementNamesForSoapArrayClass(arrayNamespaceInfo, string);
        JavaTypeName javaTypeName4 = JavaTypeName.forJClass((JClass)jClass3);
        BindingTypeName bindingTypeName2 = null;
        bindingTypeName2 = jClass.getQualifiedName().equals("char") || jClass.getQualifiedName().equals(Character.class.getName()) ? this.mBindingFile.lookupTypeFor(javaTypeName4) : this.getBindingLoader().lookupTypeFor(javaTypeName4);
        if (bindingTypeName2 == null) {
            throw new IllegalArgumentException("could not find binding type for literal array constituent class type: " + jClass3);
        }
        QName qName2 = bindingTypeName2.getXmlName().getQName();
        QName qName3 = this.getLiteralArrayTypeName(arrayNamespaceInfo, qName.getLocalPart());
        String string2 = null;
        string2 = n <= 1 ? this.arrayComponentNameForJClass(jClass, qName.getLocalPart()) : qName2.getLocalPart();
        if (!map2.keySet().contains(javaTypeName3)) {
            map2.put(javaTypeName3, qName3.getNamespaceURI());
            SchemaDocument.Schema schema = WLW81SoapAwareJava2Schema.getSchemaFor(qName3.getNamespaceURI(), map);
            TopLevelComplexType topLevelComplexType = schema.addNewComplexType();
            topLevelComplexType.setName(qName3.getLocalPart());
            ComplexContentDocument.ComplexContent complexContent = topLevelComplexType.addNewComplexContent();
            ComplexRestrictionType complexRestrictionType = complexContent.addNewRestriction();
            complexRestrictionType.setBase(SOAPENC_ARRAY);
            ExplicitGroup explicitGroup = complexRestrictionType.addNewSequence();
            LocalElement localElement = explicitGroup.addNewElement();
            localElement.setName(string2);
            localElement.setType(qName2);
            localElement.setMaxOccurs((Object)"unbounded");
            if (bl) {
                localElement.setNillable(false);
            } else {
                localElement.setNillable(true);
            }
            Attribute attribute = complexRestrictionType.addNewAttribute();
            attribute.setRef(SOAPENC_ARRAYTYPE);
            String string3 = "type";
            Element element = (Element)localElement.getDomNode();
            String string4 = element.getAttribute(string3);
            Element element2 = (Element)attribute.getDomNode();
            String string5 = "http://schemas.xmlsoap.org/wsdl/";
            String string6 = "arrayType";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[]");
            element2.setAttributeNS(string5, string6, string4 + stringBuffer.toString());
            String string7 = qName2.getNamespaceURI();
            String string8 = string4.substring(0, string4.indexOf(":"));
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string8, string7);
            XmlTypeName xmlTypeName = XmlTypeName.forTypeNamed((QName)qName3);
            BindingTypeName bindingTypeName3 = BindingTypeName.forPair((JavaTypeName)javaTypeName3, (XmlTypeName)xmlTypeName);
            SoapArrayType soapArrayType = new SoapArrayType(bindingTypeName3);
            soapArrayType.setRanks(n);
            if (bl) {
                soapArrayType.setItemNillable(false);
            } else {
                soapArrayType.setItemNillable(true);
            }
            soapArrayType.setItemName(qName);
            soapArrayType.setItemType(bindingTypeName);
            bindingFile.addBindingType((BindingType)soapArrayType, true, true);
            bindingType = soapArrayType;
            this.checkNsForImport(qName3.getNamespaceURI(), qName.getNamespaceURI());
            for (int i = 0; i < qNameArray.length; ++i) {
                bindingTypeName3 = XmlTypeName.forGlobalName((char)'e', (QName)qNameArray[i]);
                soapArrayType = BindingTypeName.forPair((JavaTypeName)javaTypeName3, (XmlTypeName)bindingTypeName3);
                if (this.getBindingLoader().getBindingType((BindingTypeName)soapArrayType) == null) continue;
                SchemaDocument.Schema schema2 = WLW81SoapAwareJava2Schema.getSchemaFor(qNameArray[i].getNamespaceURI(), map);
                TopLevelElement topLevelElement = schema2.addNewElement();
                topLevelElement.setName(qNameArray[i].getLocalPart());
                topLevelElement.setType(qName3);
                this.checkNsForImport(qNameArray[i].getNamespaceURI(), qName3.getNamespaceURI());
                SimpleDocumentBinding simpleDocumentBinding = new SimpleDocumentBinding((BindingTypeName)soapArrayType);
                simpleDocumentBinding.setTypeOfElement(XmlTypeName.forTypeNamed((QName)qName3));
                bindingFile.addBindingType((BindingType)simpleDocumentBinding, true, true);
            }
        } else {
            String string9 = (String)map2.get(javaTypeName3);
            if (!string9.equals(qName3.getNamespaceURI())) {
                qName3 = new QName(string9, qName3.getLocalPart(), qName3.getPrefix());
            }
            XmlTypeName xmlTypeName = XmlTypeName.forTypeNamed((QName)qName3);
            BindingTypeName bindingTypeName4 = BindingTypeName.forPair((JavaTypeName)javaTypeName3, (XmlTypeName)xmlTypeName);
            bindingType = this.mBindingFile.getBindingType(bindingTypeName4);
        }
        return bindingType;
    }

    protected void postProcessOutputs(Map map, BindingFile bindingFile) {
        super.postProcessOutputs(map, bindingFile);
        SchemaDocument.Schema schema = this.findOrCreateSchema(this.mTargetNamespaceForComplexTypes);
        for (Class clazz : this.mSpecialClasses.keySet()) {
            this.createStringBasedSimpleType(schema, clazz.getSimpleName());
        }
    }

    private TopLevelSimpleType createStringBasedSimpleType(SchemaDocument.Schema schema, String string) {
        TopLevelSimpleType[] topLevelSimpleTypeArray = schema.getSimpleTypeArray();
        for (int i = 0; i < topLevelSimpleTypeArray.length; ++i) {
            if (!topLevelSimpleTypeArray.equals(topLevelSimpleTypeArray[i].getName())) continue;
            this.logWarning("Simple type {" + schema.getTargetNamespace() + "}" + string + " already existed! " + string + " may not be encoded/decoded correctly at runtime!");
            return topLevelSimpleTypeArray[i];
        }
        TopLevelComplexType[] topLevelComplexTypeArray = schema.getComplexTypeArray();
        for (int i = 0; i < topLevelComplexTypeArray.length; ++i) {
            if (!topLevelComplexTypeArray.equals(topLevelComplexTypeArray[i].getName())) continue;
            this.logError("Complex type {" + schema.getTargetNamespace() + "}" + string + " already existed!" + string + " may not be encoded/decoded correctly at runtime!");
        }
        TopLevelSimpleType topLevelSimpleType = schema.addNewSimpleType();
        topLevelSimpleType.setName(string);
        RestrictionDocument.Restriction restriction = topLevelSimpleType.addNewRestriction();
        restriction.setBase(new QName(XSD_NS, "string"));
        NumFacet numFacet = restriction.addNewLength();
        XmlAnySimpleType xmlAnySimpleType = XmlAnySimpleType.Factory.newInstance();
        xmlAnySimpleType.setStringValue("1");
        numFacet.setValue(xmlAnySimpleType);
        return topLevelSimpleType;
    }
}

