/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.internal;

import com.bea.staxb.buildtime.internal.bts.BindingFile;
import com.bea.staxb.buildtime.internal.tylar.DebugTylarWriter;
import com.bea.staxb.buildtime.internal.tylar.Tylar;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.xml.stax.util.XMLPrettyPrinter;

public class BindingDebugUtils {
    public static final boolean DUMPING_ENABLED = false;
    private static BindingDebugUtils INSTANCE = new BindingDebugUtils();
    private File mTempDir = new File("d:/pcaltemp");
    private long mId = System.currentTimeMillis() % 10000000L;

    public static BindingDebugUtils getInstance() {
        return INSTANCE;
    }

    private BindingDebugUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpSchema(String string, SchemaDocument schemaDocument) {
        Writer writer = null;
        try {
            writer = this.getWriter(string);
            schemaDocument.save(writer);
            writer.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpJavaWsdlMappingBean(String string, JavaWsdlMappingBean javaWsdlMappingBean) {
        Writer writer = null;
        try {
            writer = this.getWriter(string);
            BindingDebugUtils.dumpJavaWsdlMappingBean(javaWsdlMappingBean, writer);
            writer.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpTylar(String string, Tylar tylar) {
        Writer writer = null;
        try {
            writer = this.getWriter(string);
            new DebugTylarWriter(new PrintWriter(writer, true)).write(tylar);
            writer.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpBindingFile(String string, BindingFile bindingFile) {
        Writer writer = null;
        try {
            writer = this.getWriter(string);
            new DebugTylarWriter(new PrintWriter(writer, true)).writeBindingFile(bindingFile);
            writer.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static void dumpSchemaType(SchemaType schemaType) {
        System.out.println("SchemaType '" + schemaType.getName() + "' element properties:");
        SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
        if (schemaPropertyArray != null) {
            for (int i = 0; i < schemaPropertyArray.length; ++i) {
                System.out.println("  " + schemaPropertyArray[i].getName());
            }
        }
        System.out.println("SchemaType '" + schemaType.getName() + "' attributeproperties:");
        SchemaProperty[] schemaPropertyArray2 = schemaType.getAttributeProperties();
        if (schemaPropertyArray2 != null) {
            for (int i = 0; i < schemaPropertyArray2.length; ++i) {
                System.out.println("  " + schemaPropertyArray2[i].getName());
            }
        }
    }

    private static void dumpJavaWsdlMappingBean(JavaWsdlMappingBean javaWsdlMappingBean, Writer writer) throws IOException, XMLStreamException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((DescriptorBean)javaWsdlMappingBean).getDescriptor().toXML((OutputStream)byteArrayOutputStream);
        StringReader stringReader = new StringReader(byteArrayOutputStream.toString());
        XMLStreamReader xMLStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(stringReader);
        XMLPrettyPrinter xMLPrettyPrinter = new XMLPrettyPrinter(writer);
        while (xMLStreamReader.hasNext()) {
            xMLPrettyPrinter.write(xMLStreamReader);
            xMLStreamReader.next();
        }
        xMLPrettyPrinter.flush();
    }

    private Writer getWriter(String string) throws IOException {
        File file = new File(this.mTempDir, String.valueOf(this.mId++));
        file.mkdirs();
        this.dumpTrace(file);
        File file2 = new File(file, string);
        return new FileWriter(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpTrace(File file) throws IOException {
        File file2 = new File(file, "stacktrace.txt");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file2);
            new Exception().printStackTrace(new PrintWriter((Writer)fileWriter, true));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }
}

