/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.runtime.internal;

import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.xml.SchemaGlobalElement;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.SchemaTypeSystem;
import javax.xml.namespace.QName;
import weblogic.wsee.bind.internal.FormQualifiedHelper;

class AnonymousTypeFinder {
    private static final char NS_ANON_NAME_SEPARATOR = ':';
    private static final char SEP = '>';
    private String mNamespace;
    private SchemaTypeSystem mSts;

    public AnonymousTypeFinder(SchemaTypeSystem schemaTypeSystem) {
        this.mSts = schemaTypeSystem;
    }

    public SchemaType getTypeNamed(String string) {
        XmlTypeName xmlTypeName = XmlTypeName.forString((String)string);
        SchemaType schemaType = xmlTypeName.findTypeIn((SchemaTypeLoader)this.mSts);
        if (schemaType != null) {
            return schemaType;
        }
        if (string.indexOf(93) != -1) {
            return null;
        }
        if (string.startsWith(String.valueOf('y') + ".")) {
            return null;
        }
        int n = string.lastIndexOf(58);
        this.mNamespace = string.substring(0, n);
        return this.findSchemaType(string.substring(n + 1)).getSchemaType();
    }

    public SchemaProperty getHiddenArrayElementComponentTypeNamed(String string) {
        int n = string.indexOf(91);
        if (n == -1) {
            return null;
        }
        string = string.substring(0, n);
        int n2 = string.lastIndexOf(58);
        this.mNamespace = string.substring(0, n2);
        ElementNode elementNode = this.findSchemaElement(string.substring(n2 + 1));
        try {
            return elementNode.getSchemaProperty();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return null;
        }
    }

    private TypeNode findSchemaType(String string) {
        if (string.startsWith(">")) {
            return this.findSchemaElement(string.substring(1)).getTypeNode();
        }
        return new GlobalTypeNode(string);
    }

    private ElementNode findSchemaElement(String string) {
        int n = string.lastIndexOf(62);
        if (n == -1) {
            return new GlobalElementNode(string);
        }
        TypeNode typeNode = this.findSchemaType(string.substring(0, n));
        return new LocalElementNode(typeNode, string.substring(n + 1));
    }

    private class GlobalElementNode
    extends ElementNode {
        private String mName;

        public GlobalElementNode(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null elementName");
            }
            this.mName = string;
        }

        public SchemaType getSchemaType() {
            SchemaGlobalElement schemaGlobalElement = AnonymousTypeFinder.this.mSts.findElement(this.qname(this.mName));
            if (schemaGlobalElement == null) {
                throw new IllegalStateException("no element named " + schemaGlobalElement);
            }
            SchemaType schemaType = schemaGlobalElement.getType();
            if (schemaType == null) {
                throw new IllegalStateException(schemaGlobalElement.getName() + " has no type");
            }
            return schemaType;
        }

        public TypeNode getTypeNode() {
            return new TypeNode(this.getSchemaType());
        }

        public SchemaProperty getSchemaProperty() {
            throw new IllegalStateException();
        }
    }

    private class LocalElementNode
    extends ElementNode {
        private TypeNode mEnclosingType;
        private String mName;

        public LocalElementNode(TypeNode typeNode, String string) {
            if (typeNode == null) {
                throw new IllegalArgumentException("null enclosingType");
            }
            if (string == null) {
                throw new IllegalArgumentException("null elementName");
            }
            this.mEnclosingType = typeNode;
            this.mName = string;
        }

        public SchemaType getSchemaType() {
            SchemaProperty schemaProperty = this.getSchemaProperty();
            return schemaProperty.getType();
        }

        public SchemaProperty getSchemaProperty() {
            SchemaType schemaType = this.mEnclosingType.getSchemaType();
            if (schemaType == null) {
                throw new IllegalStateException("enclosing type returned null");
            }
            SchemaProperty schemaProperty = FormQualifiedHelper.getInstance().getElementProperty(schemaType, this.mName);
            if (schemaProperty == null) {
                throw new IllegalStateException("type named '" + schemaType.getName() + "' does not have local element named " + this.mName);
            }
            return schemaProperty;
        }

        public TypeNode getTypeNode() {
            return new TypeNode(this.getSchemaType());
        }
    }

    private class GlobalTypeNode
    extends TypeNode {
        String mNamed;

        public GlobalTypeNode(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.mNamed = string;
        }

        public SchemaType getSchemaType() {
            SchemaType schemaType = AnonymousTypeFinder.this.mSts.findType(this.qname(this.mNamed));
            if (schemaType == null) {
                throw new IllegalStateException("could not find schema type named " + this.qname(this.mNamed));
            }
            return schemaType;
        }
    }

    private abstract class ElementNode
    extends ParseNode {
        private ElementNode() {
        }

        public abstract SchemaProperty getSchemaProperty();

        public abstract TypeNode getTypeNode();
    }

    private class TypeNode
    extends ParseNode {
        private SchemaType schemaType;

        public TypeNode() {
        }

        public TypeNode(SchemaType schemaType) {
            this.schemaType = schemaType;
        }

        public SchemaType getSchemaType() {
            return this.schemaType;
        }
    }

    private abstract class ParseNode {
        private ParseNode() {
        }

        public abstract SchemaType getSchemaType();

        protected QName qname(String string) {
            return new QName(AnonymousTypeFinder.this.mNamespace, string);
        }
    }
}

