/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.runtime.internal;

import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.staxb.runtime.NodeFromStreamReader;
import com.bea.staxb.runtime.StreamReaderFromNode;
import com.bea.staxb.runtime.UnmarshalOptions;
import com.bea.xbean.store.Jsr173;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.XmlException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.bind.runtime.DeserializerContext;
import weblogic.wsee.bind.runtime.internal.BindingContextImpl;
import weblogic.wsee.bind.runtime.internal.GenericStreamReaderFromNode;
import weblogic.wsee.bind.runtime.internal.WLSDomNodeFromStreamReader;
import weblogic.wsee.bind.types.TypeRegistry;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.XBeanUtil;
import weblogic.xml.dom.DOMStreamReaderExt;

abstract class BaseDeserializerContext
extends BindingContextImpl
implements DeserializerContext {
    private static final boolean mVerbose = Verbose.isVerbose(BaseDeserializerContext.class);
    private static final TypeRegistry registry = TypeRegistry.getInstance();
    protected UnmarshalOptions OPTIONS = null;
    protected MessageContext msgCtx;
    protected static boolean validateXml = false;

    public BaseDeserializerContext(SchemaTypeLoader schemaTypeLoader, boolean bl) {
        super(schemaTypeLoader);
        validateXml = bl;
        this.OPTIONS = BaseDeserializerContext.createUnmarshalOptions();
    }

    public Object deserializeType(SOAPElement sOAPElement, Class clazz, XmlTypeName xmlTypeName, boolean bl) throws XmlException, XMLStreamException {
        if (sOAPElement == null) {
            throw new IllegalArgumentException("null SOAPElement");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("null javaType");
        }
        if (xmlTypeName == null) {
            throw new IllegalArgumentException("null xmlType");
        }
        if (mVerbose) {
            Verbose.log("XML Beans loaded from: " + BaseDeserializerContext.whereFrom(Jsr173.class));
            Verbose.logArgs("xml root", sOAPElement.getNodeName(), "javaType", clazz.getName(), "xmlType", xmlTypeName, "isMTOMmessage", bl);
        }
        if (registry.isWellKnownType(clazz, xmlTypeName.getQName(), bl)) {
            return registry.deserializeType(sOAPElement, clazz, xmlTypeName.getQName(), this, bl);
        }
        return this.internalDeserializeType(sOAPElement, xmlTypeName, clazz);
    }

    public Object deserializeElement(SOAPElement sOAPElement, Class clazz, XmlTypeName xmlTypeName, boolean bl) throws XmlException, XMLStreamException {
        if (sOAPElement == null) {
            throw new IllegalArgumentException("null SOAPElement");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("null javaType");
        }
        if (xmlTypeName == null) {
            throw new IllegalArgumentException("null xmlType");
        }
        if (mVerbose) {
            Verbose.logArgs("xml root", sOAPElement, "javaType", clazz.getName(), "xmlElement", xmlTypeName, "isMTOMmessage", bl);
        }
        if (registry.isWellKnownElement(clazz, xmlTypeName.getQName(), bl)) {
            return registry.deserializeElement(sOAPElement, clazz, xmlTypeName.getQName(), this, bl);
        }
        return this.internalDeserializeElement(sOAPElement, xmlTypeName, clazz);
    }

    public Object deserializeWrappedElement(SOAPElement sOAPElement, Class clazz, XmlTypeName xmlTypeName, boolean bl) throws XmlException, XMLStreamException {
        return this.deserializeType(sOAPElement, clazz, xmlTypeName, bl);
    }

    protected abstract Object unmarshalType(XMLStreamReader var1, XmlTypeName var2, Class var3) throws XmlException;

    protected abstract Object unmarshalElement(XMLStreamReader var1, XmlTypeName var2, Class var3) throws XmlException;

    private static String whereFrom(Class clazz) {
        String string = clazz.getName();
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        string = string.replace('.', '/');
        string = string + ".class";
        URL uRL = clazz.getResource(string);
        return uRL.getFile();
    }

    private Object internalDeserializeType(SOAPElement sOAPElement, XmlTypeName xmlTypeName, Class clazz) throws XmlException, XMLStreamException {
        XMLStreamReader xMLStreamReader = BaseDeserializerContext.createReader(sOAPElement);
        Object object = this.unmarshalType(xMLStreamReader, xmlTypeName, clazz);
        if (mVerbose) {
            Verbose.log("result = " + object);
        }
        return object;
    }

    private Object internalDeserializeElement(SOAPElement sOAPElement, XmlTypeName xmlTypeName, Class clazz) throws XmlException, XMLStreamException {
        XMLStreamReader xMLStreamReader = BaseDeserializerContext.createReader(sOAPElement);
        Object object = this.unmarshalElement(xMLStreamReader, xmlTypeName, clazz);
        if (mVerbose) {
            Verbose.log("result = " + object);
        }
        return object;
    }

    private static XMLStreamReader createReader(SOAPElement sOAPElement) throws XMLStreamException {
        if (sOAPElement == null) {
            throw new IllegalArgumentException("null SOAPElement");
        }
        return new DOMStreamReaderExt((Node)sOAPElement);
    }

    protected Object v91deserializeXmlObjects(boolean bl, boolean bl2, boolean bl3, SOAPElement sOAPElement, Class clazz, QName qName) throws XmlException {
        Object object;
        if (bl3) {
            throw new XmlException("  ERROR: " + clazz.getName() + ", is an array of XmlBeans.  Arrays of XmlBeans are not supported " + "in 9.1 style XmlBean marshalling");
        }
        if (bl) {
            if (bl2) {
                object = this.deserializeXmlObject((Element)sOAPElement, clazz);
            } else {
                Element element = XBeanUtil.createXMLFragmentFromElement((Element)sOAPElement);
                object = this.deserializeXmlObject(element, clazz);
            }
        } else {
            object = this.deserializeXmlObject((Element)sOAPElement, clazz);
        }
        return object;
    }

    public Object deserializeXmlObject(Element element, Class clazz) throws XmlException {
        try {
            Class<?>[] classArray = clazz.getDeclaredClasses();
            Class<?> clazz2 = null;
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].getName().endsWith("Factory")) continue;
                clazz2 = classArray[i];
            }
            if (clazz2 == null) {
                throw new XmlException("Unable to find Factory inner class for class:" + clazz);
            }
            Method method = clazz2.getDeclaredMethod("parse", Node.class);
            return method.invoke(null, element);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new XmlException("Unable to find parse method on XmlObject", (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XmlException("Unable to access parse method on XmlObject", (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XmlException("Unable to invoke parse method on XmlObject", (Throwable)invocationTargetException);
        }
    }

    protected static UnmarshalOptions createUnmarshalOptions() {
        UnmarshalOptions unmarshalOptions = new UnmarshalOptions();
        unmarshalOptions.setValidation(validateXml);
        StreamReaderFromNode streamReaderFromNode = BaseDeserializerContext.getStreamReaderFromNode();
        unmarshalOptions.setStreamReaderFromNode(streamReaderFromNode);
        NodeFromStreamReader nodeFromStreamReader = BaseDeserializerContext.getNodeFromStreamReader();
        unmarshalOptions.setNodeFromStreamReader(nodeFromStreamReader);
        return unmarshalOptions;
    }

    protected static NodeFromStreamReader getNodeFromStreamReader() {
        return WLSDomNodeFromStreamReader.getInstance();
    }

    protected static StreamReaderFromNode getStreamReaderFromNode() {
        return GenericStreamReaderFromNode.getInstance();
    }

    public MessageContext getMessageContext() {
        return this.msgCtx;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.msgCtx = messageContext;
    }
}

