/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.runtime.internal;

import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.staxb.runtime.MarshalOptions;
import com.bea.staxb.runtime.StaxWriterToNode;
import com.bea.staxb.runtime.internal.XOPMarshaller;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.XmlException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import weblogic.wsee.bind.runtime.SerializerContext;
import weblogic.wsee.bind.runtime.internal.BindingContextImpl;
import weblogic.wsee.bind.runtime.internal.PushToTopNSHandler;
import weblogic.wsee.bind.types.TypeRegistry;
import weblogic.wsee.bind.types.XOPByteArrayMarshallerImpl;
import weblogic.wsee.util.Verbose;
import weblogic.xml.dom.DOMStreamWriter;
import weblogic.xml.domimpl.ElementBase;
import weblogic.xml.domimpl.Loader;
import weblogic.xml.domimpl.XMLDomWriter;
import weblogic.xml.util.WriteNamespaceHandler;

public abstract class BaseSerializerContext
extends BindingContextImpl
implements SerializerContext {
    private Document document;
    private static final boolean mVerbose = Verbose.isVerbose(BaseSerializerContext.class);
    private static final TypeRegistry registry = TypeRegistry.getInstance();
    static final MarshalOptions DEFAULT_MARSHAL_OPTIONS = BaseSerializerContext.createDefaultMarshalOptions();
    protected MarshalOptions marshalOptions = null;

    BaseSerializerContext(SchemaTypeLoader schemaTypeLoader, MarshalOptions marshalOptions) {
        super(schemaTypeLoader);
        this.marshalOptions = marshalOptions;
    }

    public void setUseMultiRef(boolean bl) {
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void serializeType(SOAPElement sOAPElement, Object object, Class clazz, XmlTypeName xmlTypeName, QName qName, boolean bl, String string) throws XMLStreamException, XmlException {
        if (sOAPElement == null) {
            throw new IllegalArgumentException("null parent");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("null javaType");
        }
        if (xmlTypeName == null) {
            throw new IllegalArgumentException("null xmlType");
        }
        if (qName == null) {
            throw new IllegalArgumentException("null name");
        }
        if (mVerbose) {
            Verbose.logArgs("xml root", sOAPElement.getElementName(), "object", object, "java Type", clazz.getName(), "xml Type", xmlTypeName, "name", qName, "useMTOMmessage", bl);
        }
        assert (this.getDocument() != null);
        if (registry.isWellKnownType(clazz, xmlTypeName.getQName(), bl)) {
            registry.serializeType(sOAPElement, object, clazz, xmlTypeName.getQName(), qName, this, bl, string);
        } else {
            this.marshalOptions.setMarshaller((XOPMarshaller)new XOPByteArrayMarshallerImpl(this.getMessage()));
            this.internalSerializeType(sOAPElement, object, qName, xmlTypeName, clazz);
        }
    }

    public void serializeElement(SOAPElement sOAPElement, Object object, Class clazz, XmlTypeName xmlTypeName, boolean bl, String string) throws XMLStreamException, XmlException {
        if (xmlTypeName == null) {
            throw new IllegalArgumentException("null xmlElement");
        }
        if (!xmlTypeName.isElement()) {
            throw new IllegalArgumentException(xmlTypeName + " must be an element");
        }
        if (mVerbose) {
            Verbose.log("serializing element in " + sOAPElement + "\n" + "object = " + object + "\n" + "javaType = " + clazz.getName() + "\n" + "xmlElement = " + xmlTypeName + "\n" + "useMTOMmessage = " + xmlTypeName + "\n");
        }
        if (registry.isWellKnownElement(clazz, xmlTypeName.getQName(), bl)) {
            registry.serializeElement(sOAPElement, object, clazz, xmlTypeName.getQName(), this, bl, string);
        } else {
            this.marshalOptions.setMarshaller((XOPMarshaller)new XOPByteArrayMarshallerImpl(this.getMessage()));
            this.internalSerializeElement(sOAPElement, object, xmlTypeName, clazz);
        }
    }

    protected void v91serializeXmlObjects(boolean bl, boolean bl2, boolean bl3, SOAPElement sOAPElement, Class clazz, Object object, QName qName) throws XmlException {
        if (bl3) {
            throw new XmlException("  ERROR: " + clazz.getName() + ", is an array of XmlBeans.  Arrays of XmlBeans are not supported " + "in 9.1 style XmlBean marshalling");
        }
        if (bl && !bl2) {
            SOAPElement sOAPElement2 = this.createWrappedXBeanTopElement(sOAPElement, qName);
            this.serializeXmlObject(sOAPElement2, object);
        } else {
            this.serializeXmlObject(sOAPElement, object);
        }
    }

    protected abstract void marshalType(XMLStreamWriter var1, Object var2, QName var3, XmlTypeName var4, Class var5) throws XMLStreamException, XmlException;

    protected abstract void marshalElement(XMLStreamWriter var1, Object var2, XmlTypeName var3, Class var4) throws XMLStreamException, XmlException;

    private void internalSerializeType(SOAPElement sOAPElement, Object object, QName qName, XmlTypeName xmlTypeName, Class clazz) throws XMLStreamException, XmlException {
        XMLStreamWriter xMLStreamWriter = this.getStaxDomWriter(sOAPElement);
        this.marshalType(xMLStreamWriter, object, qName, xmlTypeName, clazz);
        xMLStreamWriter.close();
    }

    protected XMLStreamWriter getStaxDomWriter(SOAPElement sOAPElement) {
        return Loader.createDOMWriter((ElementBase)((ElementBase)sOAPElement), (WriteNamespaceHandler)PushToTopNSHandler.getInstance());
    }

    private void internalSerializeElement(SOAPElement sOAPElement, Object object, XmlTypeName xmlTypeName, Class clazz) throws XMLStreamException, XmlException {
        XMLStreamWriter xMLStreamWriter = this.getStaxDomWriter(sOAPElement);
        this.marshalElement(xMLStreamWriter, object, xmlTypeName, clazz);
        xMLStreamWriter.close();
    }

    public void serializeXmlObject(SOAPElement sOAPElement, Object object) throws XmlException {
        try {
            Node node = (Node)object.getClass().getMethod("getDomNode", new Class[0]).invoke(object, new Object[0]);
            if (node.getNodeType() == 9) {
                node = ((Document)node).getDocumentElement();
            }
            sOAPElement.appendChild(this.getDocument().importNode(node, true));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new XmlException("Unable to find getDomNode() method on XmlObject", (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XmlException("Unable to access getDomNode() method on XmlObject", (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XmlException("Unable to invoke getDomNode() method on XmlObject", (Throwable)invocationTargetException);
        }
    }

    protected SOAPElement createWrappedXBeanTopElement(SOAPElement sOAPElement, QName qName) throws XmlException {
        SOAPElement sOAPElement2 = null;
        try {
            String string = qName.getPrefix();
            if (string == null || string.equals("")) {
                string = sOAPElement.getPrefix();
            }
            sOAPElement2 = sOAPElement.addChildElement(qName.getLocalPart(), string, qName.getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            throw new XmlException(" could not create child element '" + qName + "' for Wrapped XMLBean operation '" + sOAPElement + "'  ", (Throwable)sOAPException);
        }
        return sOAPElement2;
    }

    public static MarshalOptions createDefaultMarshalOptions() {
        MarshalOptions marshalOptions = new MarshalOptions();
        marshalOptions.setStaxWriterToNode((StaxWriterToNode)new WlsStaxDomWriter());
        return marshalOptions;
    }

    private static final class WlsStaxDomWriter
    implements StaxWriterToNode {
        private WlsStaxDomWriter() {
        }

        public Node getCurrentNode(XMLStreamWriter xMLStreamWriter) {
            if (xMLStreamWriter instanceof XMLDomWriter) {
                XMLDomWriter xMLDomWriter = (XMLDomWriter)xMLStreamWriter;
                return xMLDomWriter.getCurrentNode();
            }
            if (xMLStreamWriter instanceof DOMStreamWriter) {
                DOMStreamWriter dOMStreamWriter = (DOMStreamWriter)((Object)xMLStreamWriter);
                return dOMStreamWriter.getCurrentNode();
            }
            throw new RuntimeException("unexpected writer type: " + xMLStreamWriter.getClass().getName());
        }
    }
}

