/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.runtime.internal;

import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.staxb.runtime.EncodingStyle;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeLoader;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.bind.runtime.BindingContext;

abstract class BindingContextImpl
implements BindingContext {
    private int encoding = 0;
    private SOAPMessage wlMessage;
    private final SchemaTypeLoader schemaTypeLoader;

    public BindingContextImpl(SchemaTypeLoader schemaTypeLoader) {
        this.schemaTypeLoader = schemaTypeLoader;
    }

    public SOAPMessage getMessage() {
        return this.wlMessage;
    }

    public void setMessage(SOAPMessage sOAPMessage) {
        this.wlMessage = sOAPMessage;
    }

    public void setEncoding(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Unknown encoding style: " + n);
        }
        this.encoding = n;
    }

    public int getEncoding() {
        return this.encoding;
    }

    protected EncodingStyle convertEncodingStyle(int n) {
        EncodingStyle encodingStyle;
        switch (n) {
            case 1: {
                encodingStyle = EncodingStyle.SOAP11;
                break;
            }
            case 2: {
                EncodingStyle encodingStyle2 = EncodingStyle.SOAP12;
            }
            default: {
                throw new AssertionError((Object)("unknown encoding style: " + n));
            }
        }
        return encodingStyle;
    }

    public SchemaType getTypeOfWrappedElement(XmlTypeName xmlTypeName) {
        SchemaProperty[] schemaPropertyArray;
        if (!xmlTypeName.isElement()) {
            throw new IllegalArgumentException(xmlTypeName + " is not an element");
        }
        XmlTypeName xmlTypeName2 = xmlTypeName.getOuterComponent();
        if (xmlTypeName2 == null) {
            throw new IllegalArgumentException("no outer type for " + xmlTypeName);
        }
        if (!xmlTypeName2.isType()) {
            throw new IllegalArgumentException(xmlTypeName2 + " is not a type");
        }
        XmlTypeName xmlTypeName3 = xmlTypeName2.getOuterComponent();
        SchemaType schemaType = null;
        if (xmlTypeName3 == null) {
            schemaType = this.schemaTypeLoader.findType(xmlTypeName2.getQName());
            if (schemaType == null) {
                throw new IllegalArgumentException(xmlTypeName2 + " is not global type.");
            }
        } else {
            if (!xmlTypeName3.isElement()) {
                throw new IllegalArgumentException(xmlTypeName3 + " is not an element");
            }
            schemaPropertyArray = this.schemaTypeLoader.findElement(xmlTypeName3.getQName());
            if (schemaPropertyArray == null) {
                throw new IllegalArgumentException("no global element " + xmlTypeName3.getQName());
            }
            schemaType = schemaPropertyArray.getType();
        }
        schemaPropertyArray = schemaType.getElementProperties();
        for (int i = 0; i < schemaPropertyArray.length; ++i) {
            String string = schemaPropertyArray[i].getName().getLocalPart();
            if (!string.equals(xmlTypeName.getQName().getLocalPart())) continue;
            return schemaPropertyArray[i].getType();
        }
        throw new IllegalArgumentException("no property named '" + xmlTypeName.getQName() + "' on type " + (xmlTypeName3 != null ? xmlTypeName3.getQName() : xmlTypeName2.getQName()));
    }

    protected boolean isCR205512WrappedArray(Class clazz, XmlTypeName xmlTypeName) {
        if (!clazz.isArray()) {
            return false;
        }
        XmlTypeName xmlTypeName2 = xmlTypeName.getOuterComponent();
        if (xmlTypeName2 == null) {
            return false;
        }
        SchemaType schemaType = xmlTypeName2.findTypeIn(this.schemaTypeLoader);
        if (schemaType == null) {
            return false;
        }
        if (schemaType.getProperties()[0].getMaxOccurs() == null) {
            return true;
        }
        return schemaType.getProperties()[0].getMaxOccurs().intValue() > 1;
    }
}

