/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.runtime.internal;

import com.bea.staxb.buildtime.Java2Schema;
import com.bea.staxb.buildtime.internal.bts.BindingFile;
import com.bea.staxb.buildtime.internal.bts.BindingLoader;
import com.bea.staxb.buildtime.internal.bts.BindingType;
import com.bea.staxb.buildtime.internal.bts.BindingTypeName;
import com.bea.staxb.buildtime.internal.bts.BuiltinBindingLoader;
import com.bea.staxb.buildtime.internal.bts.ByNameBean;
import com.bea.staxb.buildtime.internal.bts.CompositeBindingLoader;
import com.bea.staxb.buildtime.internal.bts.GenericXmlProperty;
import com.bea.staxb.buildtime.internal.bts.JavaTypeName;
import com.bea.staxb.buildtime.internal.bts.JaxRpcBuiltinBindingLoader;
import com.bea.staxb.buildtime.internal.bts.JaxrpcEnumType;
import com.bea.staxb.buildtime.internal.bts.ListArrayType;
import com.bea.staxb.buildtime.internal.bts.MethodName;
import com.bea.staxb.buildtime.internal.bts.QNameProperty;
import com.bea.staxb.buildtime.internal.bts.SimpleBindingType;
import com.bea.staxb.buildtime.internal.bts.SimpleContentBean;
import com.bea.staxb.buildtime.internal.bts.SimpleContentProperty;
import com.bea.staxb.buildtime.internal.bts.SimpleDocumentBinding;
import com.bea.staxb.buildtime.internal.bts.SoapArrayType;
import com.bea.staxb.buildtime.internal.bts.WrappedArrayType;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.staxb.buildtime.internal.tylar.Tylar;
import com.bea.staxb.buildtime.internal.tylar.TylarImpl;
import com.bea.staxb.buildtime.internal.tylar.TylarWriter;
import com.bea.staxb.runtime.internal.AnyRuntimeBindingType;
import com.bea.xbean.schema.BuiltinSchemaTypeSystem;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.SchemaGlobalElement;
import com.bea.xml.SchemaParticle;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.SchemaTypeSystem;
import com.bea.xml.XmlBeans;
import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import com.bea.xml.XmlOptions;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.j2ee.descriptor.ConstructorParameterOrderBean;
import weblogic.j2ee.descriptor.ExceptionMappingBean;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.JavaXmlTypeMappingBean;
import weblogic.j2ee.descriptor.PackageMappingBean;
import weblogic.j2ee.descriptor.VariableMappingBean;
import weblogic.utils.StringUtils;
import weblogic.wsee.bind.BaseTypeLoaderFactory;
import weblogic.wsee.bind.internal.FormQualifiedHelper;
import weblogic.wsee.bind.runtime.internal.AnonymousTypeFinder;
import weblogic.wsee.bind.runtime.internal.LiteralArrayHelper;
import weblogic.wsee.bind.runtime.internal.SoapArrayHelper;
import weblogic.wsee.util.ExceptionUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Deploytime109MappingHelper {
    private static final boolean mVerbose = Verbose.isVerbose(Deploytime109MappingHelper.class);
    private static final String SCOPE_ELEMENT = "element";
    private static final String SCOPE_COMPLETXTYPE = "complexType";
    private static final String SCOPE_SIMPLETYPE = "simpleType";
    private static final String JAXRPC_CTWSC_GETTER = "get_value";
    private static final String JAXRPC_CTWSC_SETTER = "set_value";
    private static boolean suppressDeployErrorMessage = Boolean.getBoolean("weblogic.wsee.bind.suppressDeployErrorMessage");
    private static boolean suppressSimpleExceptionErrorMessage = Boolean.getBoolean("weblogic.wsee.bind.suppressSimpleExceptionErrorMessage");
    private static boolean setCompileNoUpaRule = Boolean.getBoolean("weblogic.wsee.bind.setCompileNoUpaRule");
    private boolean isSimpleExceptionErrorPresent = false;
    private JavaWsdlMappingBean m109dd;
    private WsdlDefinitions mWsdl;
    private SchemaDocument[] mSchemas;
    private BindingFile mBindingFile = null;
    private BindingLoader mLoader = null;
    private SchemaTypeSystem mSchemaTypeSystem = null;
    private Map mNs2Package = new HashMap();
    private FormQualifiedHelper mFQH;
    private Map mPackage2Ns = new HashMap();
    private AnonymousTypeFinder mATF = null;
    private boolean treatEnumsAsSimpleTypes;
    private HashMap<Integer, SchemaType> simpleContentTypes = new HashMap();

    Deploytime109MappingHelper(JavaWsdlMappingBean javaWsdlMappingBean, WsdlDefinitions wsdlDefinitions, SchemaDocument[] schemaDocumentArray, boolean bl) throws IOException, XmlException {
        this.treatEnumsAsSimpleTypes = bl;
        this.m109dd = javaWsdlMappingBean;
        this.mSchemas = schemaDocumentArray;
        this.mWsdl = wsdlDefinitions;
        this.mFQH = FormQualifiedHelper.getInstance();
        this.debugInputs();
        this.initSchemaTypeSystem();
        this.processPackageMappings();
        this.initBindingFileFrom109dd();
    }

    Tylar buildTylar() throws XmlException, IOException {
        try {
            this.processExceptionMappings();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.debugOutputs();
        TylarImpl tylarImpl = new TylarImpl();
        this.writeTylar((TylarWriter)tylarImpl);
        return tylarImpl;
    }

    private void initSchemaTypeSystem() throws IOException, XmlException {
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setCompileDownloadUrls();
        xmlOptions.setLoadUseDefaultResolver();
        xmlOptions.setCompileNoAnnotations();
        xmlOptions.setCompileNoPvrRule();
        if (setCompileNoUpaRule) {
            xmlOptions.setCompileNoUpaRule();
        }
        SchemaTypeLoader schemaTypeLoader = BaseTypeLoaderFactory.newInstance(null);
        if (mVerbose) {
            for (int i = 0; i < this.mSchemas.length; ++i) {
                SchemaDocument schemaDocument = this.mSchemas[i];
                Verbose.log("schema " + i + " " + schemaDocument.documentProperties().getSourceName());
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Collections.addAll(arrayList, this.mSchemas);
        if (this.mWsdl != null && this.mWsdl.getTypes() != null) {
            for (SchemaDocument schemaDocument : this.mWsdl.getTypes().getSchemaArray()) {
                if (arrayList.contains(schemaDocument) || schemaDocument.getSchema().getTargetNamespace() == null || schemaTypeLoader.isNamespaceDefined(schemaDocument.getSchema().getTargetNamespace())) continue;
                arrayList.add(schemaDocument);
            }
        }
        if (!arrayList.isEmpty()) {
            for (SchemaDocument schemaDocument : arrayList) {
                String string = Deploytime109MappingHelper.fixFileUri(schemaDocument.documentProperties().getSourceName());
                if (string == null) continue;
                schemaDocument.documentProperties().setSourceName(string);
            }
        }
        this.mSchemaTypeSystem = XmlBeans.compileXsd((XmlObject[])((XmlObject[])arrayList.toArray(new SchemaDocument[0])), (SchemaTypeLoader)schemaTypeLoader, (XmlOptions)xmlOptions);
    }

    private void processPackageMappings() {
        if (this.m109dd == null) {
            return;
        }
        PackageMappingBean[] packageMappingBeanArray = this.m109dd.getPackageMappings();
        for (int i = 0; i < packageMappingBeanArray.length; ++i) {
            PackageMappingBean packageMappingBean = packageMappingBeanArray[i];
            this.mNs2Package.put(packageMappingBean.getNamespaceURI(), packageMappingBean.getPackageType());
            this.mPackage2Ns.put(packageMappingBean.getPackageType(), packageMappingBean.getNamespaceURI());
        }
    }

    private void initBindingFileFrom109dd() {
        this.mBindingFile = new BindingFile();
        this.mLoader = CompositeBindingLoader.forPath((BindingLoader[])new BindingLoader[]{JaxRpcBuiltinBindingLoader.getInstance(), this.mBindingFile});
        if (this.m109dd != null) {
            this.processTypeMappings();
        }
    }

    private void processExceptionMappings() {
        if (this.m109dd == null) {
            return;
        }
        ExceptionMappingBean[] exceptionMappingBeanArray = this.m109dd.getExceptionMappings();
        if (exceptionMappingBeanArray == null || exceptionMappingBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < exceptionMappingBeanArray.length; ++i) {
            ByNameBean byNameBean = this.getTypeBindingForException(exceptionMappingBeanArray[i]);
            if (byNameBean == null) {
                if (!this.isSimpleExceptionErrorPresent) {
                    this.logError(exceptionMappingBeanArray[i].getExceptionType() + " is not understood because " + "there is no type mapping for exception class");
                    continue;
                }
                this.isSimpleExceptionErrorPresent = false;
                continue;
            }
            ConstructorParameterOrderBean constructorParameterOrderBean = exceptionMappingBeanArray[i].getConstructorParameterOrder();
            if (constructorParameterOrderBean == null || constructorParameterOrderBean.getElementNames() == null) continue;
            String[] stringArray = constructorParameterOrderBean.getElementNames();
            for (int j = 0; j < stringArray.length; ++j) {
                QName qName = new QName(stringArray[j]);
                QNameProperty qNameProperty = this.mFQH.getPropertyForElement(byNameBean, stringArray[j]);
                if (qNameProperty == null) {
                    qNameProperty = this.mFQH.getPropertyForAttribute(byNameBean, stringArray[j]);
                }
                if (qNameProperty == null) {
                    StringWriter stringWriter = new StringWriter();
                    stringWriter.write("<exception-mapping> for " + exceptionMappingBeanArray[i].getExceptionType() + " specifies constructor parameter for unbound property '" + stringArray[j] + "' (" + qName + ")\n  Available properties are:\n");
                    Iterator iterator = byNameBean.getProperties().iterator();
                    while (iterator.hasNext()) {
                        stringWriter.write("  ");
                        stringWriter.write(((QNameProperty)iterator.next()).getQName().toString());
                        stringWriter.write(10);
                    }
                    this.logError(stringWriter.toString());
                    continue;
                }
                qNameProperty.setCtorParamIndex(j);
            }
        }
    }

    private ByNameBean getTypeBindingForException(ExceptionMappingBean exceptionMappingBean) {
        QName qName;
        String string;
        QName qName2 = exceptionMappingBean.getWsdlMessage();
        WsdlPart wsdlPart = this.getPartNamed(qName2, string = exceptionMappingBean.getWsdlMessagePartName());
        if (wsdlPart == null) {
            return null;
        }
        String string2 = exceptionMappingBean.getExceptionType();
        BindingTypeName bindingTypeName = null;
        if (wsdlPart.getType() != null) {
            qName = wsdlPart.getType();
            bindingTypeName = BindingTypeName.forPair((JavaTypeName)JavaTypeName.forString((String)string2), (XmlTypeName)XmlTypeName.forTypeNamed((QName)qName));
        } else if (wsdlPart.getElement() != null) {
            Object object;
            qName = wsdlPart.getElement();
            bindingTypeName = BindingTypeName.forPair((JavaTypeName)JavaTypeName.forString((String)string2), (XmlTypeName)XmlTypeName.forGlobalName((char)'e', (QName)qName));
            BindingType bindingType = this.mBindingFile.getBindingType(bindingTypeName);
            if (bindingType == null) {
                object = "While processing <exception-mapping> for wsdlMessageName='" + qName2 + "', wsdlMessagePartElement='" + wsdlPart.getElement() + "'.  Unable to find a BindingType in the binding file " + " for javaTypeName ='" + JavaTypeName.forString((String)string2) + "', xmlTypeName='" + XmlTypeName.forGlobalName((char)'e', (QName)qName) + "'.  The cause of this error is likely because " + "an <exception-mapping> specified for " + qName2 + "requires that a <java-xml-type-mapping> exist for java type='" + string2 + "', xmlTypeName='" + XmlTypeName.forGlobalName((char)'e', (QName)qName) + "', with a <root-type-qname> of  " + qName;
                try {
                    this.registerElement(qName);
                    bindingTypeName = BindingTypeName.forPair((JavaTypeName)JavaTypeName.forString((String)string2), (XmlTypeName)XmlTypeName.forGlobalName((char)'e', (QName)qName));
                    bindingType = this.mBindingFile.getBindingType(bindingTypeName);
                    if (bindingType == null) {
                        if (!suppressSimpleExceptionErrorMessage) {
                            this.logError((String)object);
                        } else {
                            this.isSimpleExceptionErrorPresent = true;
                        }
                        return null;
                    }
                }
                catch (Exception exception) {
                    this.logError((String)object);
                    return null;
                }
            }
            if (!(bindingType instanceof SimpleDocumentBinding)) {
                this.logError("Internal error: generated a " + bindingType.getClass() + " for " + qName + "; expected it to be a " + SimpleDocumentBinding.class);
                return null;
            }
            object = ((SimpleDocumentBinding)bindingType).getTypeOfElement();
            if (object == null) {
                this.logError("Internal error: SimpleDocumentBinding for " + qName + " has a null TypeOfElement.");
                return null;
            }
            bindingTypeName = BindingTypeName.forPair((JavaTypeName)JavaTypeName.forString((String)string2), (XmlTypeName)object);
        } else {
            this.logError("WSDL message part '" + exceptionMappingBean.getWsdlMessagePartName() + " must specify 'type' or 'attribute'");
            return null;
        }
        qName = this.mBindingFile.getBindingType(bindingTypeName);
        if (qName == null) {
            this.logError("Internal error: no binding available for " + bindingTypeName);
            return null;
        }
        if (!(qName instanceof ByNameBean)) {
            this.logError("Internal error: generated a " + qName.getClass() + " for " + bindingTypeName + "; expected a " + ByNameBean.class);
            return null;
        }
        return (ByNameBean)qName;
    }

    private WsdlPart getPartNamed(QName qName, String string) {
        if (this.mWsdl == null) {
            return null;
        }
        WsdlMessage wsdlMessage = this.mWsdl.getMessages().get(qName);
        if (wsdlMessage == null) {
            this.logError("<exception-mapping> specified for non-existent WSDL message named '" + qName);
            return null;
        }
        if (string == null) {
            Iterator<? extends WsdlPart> iterator = wsdlMessage.getParts().values().iterator();
            if (!iterator.hasNext()) {
                this.logError("<exception-mapping> specified for WSDL message named '" + qName + "' which has no parts!");
                return null;
            }
            WsdlPart wsdlPart = iterator.next();
            if (iterator.hasNext()) {
                this.logError("<exception-mapping> specified for multi-part WSDL message named '" + qName + "' must have a " + "<wsdl-message-part-name> element");
                return null;
            }
            return wsdlPart;
        }
        WsdlPart wsdlPart = wsdlMessage.getParts().get(string);
        if (wsdlPart == null) {
            this.logError("<exception-mapping> for multi-part WSDL message named '" + qName + "' specifies a " + "non-existent part named '" + string + "'");
            return null;
        }
        return wsdlPart;
    }

    private void processTypeMappings() {
        int n;
        JavaXmlTypeMappingBean[] javaXmlTypeMappingBeanArray = this.m109dd.getJavaXmlTypeMappings();
        BindingType[] bindingTypeArray = new BindingType[javaXmlTypeMappingBeanArray.length];
        for (n = 0; n < javaXmlTypeMappingBeanArray.length; ++n) {
            bindingTypeArray[n] = this.createBindingTypeFrom(n, javaXmlTypeMappingBeanArray[n]);
        }
        for (n = 0; n < javaXmlTypeMappingBeanArray.length; ++n) {
            Class<?> clazz;
            Object object;
            BindingTypeName bindingTypeName;
            Object object2;
            JavaTypeName javaTypeName;
            if (bindingTypeArray[n] == null) continue;
            if (bindingTypeArray[n] instanceof WrappedArrayType) {
                javaTypeName = (JavaTypeName)bindingTypeArray[n];
                if (javaTypeName.getName().getJavaName().getArrayDepth() != 0) continue;
                object2 = javaTypeName.getItemType();
                bindingTypeName = this.mLoader.lookupPojoFor(object2.getXmlName());
                if (bindingTypeName == null) {
                    throw new IllegalStateException("For ArrayType '" + javaTypeName.getName().getJavaName() + "', Array item type " + javaTypeName.getItemType() + " is not mapped in jaxrpc mapping file.");
                }
                javaTypeName.setItemType(bindingTypeName);
                continue;
            }
            if (bindingTypeArray[n] instanceof SoapArrayType) {
                javaTypeName = (SoapArrayType)bindingTypeArray[n];
                object2 = javaTypeName.getItemType().getJavaName().toString();
                if (!ExceptionUtil.classNameIsSchemaBuiltin((String)object2)) {
                    if (javaTypeName.getName().getJavaName().getArrayDepth() > 0) {
                        bindingTypeName = javaTypeName.getItemType();
                        object = this.mLoader.lookupPojoFor(bindingTypeName.getXmlName());
                        if (object == null) {
                            throw new IllegalStateException("For ArrayType '" + javaTypeName.getName().getJavaName() + "', non-schema builtin Array item type " + javaTypeName.getItemType() + " is not mapped in jaxrpc mapping file.");
                        }
                        javaTypeName.setItemType(object);
                    }
                    new SoapArrayHelper((SchemaTypeLoader)this.mSchemaTypeSystem, this.mLoader, this.mBindingFile).checkArrayItem((SoapArrayType)javaTypeName);
                    continue;
                }
            } else if (bindingTypeArray[n] instanceof SimpleContentBean) {
                javaTypeName = JavaTypeName.forString((String)javaXmlTypeMappingBeanArray[n].getJavaType());
                bindingTypeName = this.createJaxRpcSimpleContentPropertyFor(javaTypeName, (SchemaType)(object2 = this.simpleContentTypes.get(n)));
                if (bindingTypeName == null) {
                    bindingTypeArray[n] = null;
                    continue;
                }
                ((SimpleContentBean)bindingTypeArray[n]).setSimpleContentProperty((SimpleContentProperty)bindingTypeName);
            }
            if ((javaTypeName = javaXmlTypeMappingBeanArray[n].getVariableMappings()) == null || ((JavaTypeName)javaTypeName).length == 0) continue;
            object2 = bindingTypeArray[n].getName().getXmlName();
            if (object2.isElement()) {
                object2 = XmlTypeName.forNestedAnonymous((char)'t', (XmlTypeName)object2);
            }
            if ((bindingTypeName = object2.findTypeIn((SchemaTypeLoader)this.mSchemaTypeSystem)) == null) {
                this.logError("could not find schema type for '" + bindingTypeArray[n].getName().getXmlName());
                continue;
            }
            object = javaXmlTypeMappingBeanArray[n].getJavaType();
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass((String)object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("ClassNotFound " + classNotFoundException.getMessage());
            }
            String string = this.findTargetNamespace(javaXmlTypeMappingBeanArray[n]);
            QNameProperty[] qNamePropertyArray = this.createQNameProps(string, (VariableMappingBean[])javaTypeName, clazz, (SchemaType)bindingTypeName);
            this.addPropertiesToBinding(bindingTypeArray[n], qNamePropertyArray);
        }
        this.createInheritedProperties(javaXmlTypeMappingBeanArray, bindingTypeArray);
    }

    private void createInheritedProperties(JavaXmlTypeMappingBean[] javaXmlTypeMappingBeanArray, BindingType[] bindingTypeArray) {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        HashMap<QName, JavaXmlTypeMappingBean> hashMap = new HashMap<QName, JavaXmlTypeMappingBean>();
        HashMap<QName, BindingType> hashMap2 = new HashMap<QName, BindingType>();
        for (int i = 0; i < javaXmlTypeMappingBeanArray.length; ++i) {
            if (javaXmlTypeMappingBeanArray[i].getRootTypeQname() == null || bindingTypeArray[i] == null) continue;
            hashMap.put(javaXmlTypeMappingBeanArray[i].getRootTypeQname(), javaXmlTypeMappingBeanArray[i]);
            hashMap2.put(javaXmlTypeMappingBeanArray[i].getRootTypeQname(), bindingTypeArray[i]);
        }
        for (QName qName : hashMap.keySet()) {
            this.processInheritedProperties((JavaXmlTypeMappingBean)hashMap.get(qName), arrayList, hashMap, hashMap2);
        }
    }

    private void processInheritedProperties(JavaXmlTypeMappingBean javaXmlTypeMappingBean, List<QName> list, Map<QName, JavaXmlTypeMappingBean> map, Map<QName, BindingType> map2) {
        SchemaType schemaType;
        QName qName = javaXmlTypeMappingBean.getRootTypeQname();
        if (qName == null) {
            return;
        }
        if (list.contains(qName)) {
            return;
        }
        BindingType bindingType = map2.get(qName);
        XmlTypeName xmlTypeName = bindingType.getName().getXmlName();
        if (xmlTypeName.isElement()) {
            xmlTypeName = XmlTypeName.forNestedAnonymous((char)'t', (XmlTypeName)xmlTypeName);
        }
        if ((schemaType = xmlTypeName.findTypeIn((SchemaTypeLoader)this.mSchemaTypeSystem)) != null) {
            BindingType bindingType2;
            JavaXmlTypeMappingBean javaXmlTypeMappingBean2;
            Object object;
            ArrayList arrayList = new ArrayList();
            boolean bl = false;
            SchemaType schemaType2 = schemaType;
            while (schemaType2.getBaseType() != null && !bl) {
                object = (schemaType2 = schemaType2.getBaseType()).getName();
                if (!map.containsKey(object)) continue;
                javaXmlTypeMappingBean2 = map.get(object);
                bindingType2 = map2.get(object);
                this.processInheritedProperties(javaXmlTypeMappingBean2, list, map, map2);
                arrayList.addAll(this.getPropertiesFromBinding(bindingType2));
                bl = true;
            }
            if (!arrayList.isEmpty()) {
                object = this.getPropertiesFromBinding(bindingType);
                javaXmlTypeMappingBean2 = new QNameProperty[object.size()];
                object.toArray((T[])javaXmlTypeMappingBean2);
                bindingType2 = new QNameProperty[arrayList.size()];
                arrayList.toArray((T[])bindingType2);
                ArrayList arrayList2 = new ArrayList();
                arrayList2.addAll(arrayList);
                block1: for (int i = 0; i < ((BindingType)bindingType2).length; ++i) {
                    for (int j = 0; j < ((JavaXmlTypeMappingBean)javaXmlTypeMappingBean2).length; ++j) {
                        if (bindingType2[i] == null || javaXmlTypeMappingBean2[j] == null || bindingType2[i].getQName() == null || javaXmlTypeMappingBean2[j].getQName() == null || !bindingType2[i].getQName().equals(javaXmlTypeMappingBean2[j].getQName())) continue;
                        arrayList2.remove(bindingType2[i]);
                        continue block1;
                    }
                }
                if (!arrayList2.isEmpty()) {
                    this.addPropertiesToBinding(bindingType, arrayList2.toArray(new QNameProperty[arrayList2.size()]));
                }
            }
        }
        if (qName != null) {
            list.add(qName);
        }
    }

    void addPropertiesToBinding(BindingType bindingType, QNameProperty[] qNamePropertyArray) {
        block4: {
            block3: {
                if (!(bindingType instanceof ByNameBean)) break block3;
                for (QNameProperty qNameProperty : qNamePropertyArray) {
                    if (qNameProperty == null) continue;
                    ByNameBean byNameBean = (ByNameBean)bindingType;
                    if (qNameProperty instanceof GenericXmlProperty) {
                        byNameBean.setAnyElementProperty((GenericXmlProperty)qNameProperty);
                        continue;
                    }
                    byNameBean.addProperty(qNameProperty);
                }
                break block4;
            }
            if (!(bindingType instanceof SimpleContentBean)) break block4;
            for (QNameProperty qNameProperty : qNamePropertyArray) {
                if (qNameProperty == null) continue;
                ((SimpleContentBean)bindingType).addProperty(qNameProperty);
            }
        }
    }

    Collection getPropertiesFromBinding(BindingType bindingType) {
        Collection collection = null;
        if (bindingType instanceof ByNameBean) {
            collection = ((ByNameBean)bindingType).getProperties();
        } else if (bindingType instanceof SimpleContentBean) {
            collection = ((SimpleContentBean)bindingType).getAttributeProperties();
        }
        if (collection == null) {
            return Collections.EMPTY_LIST;
        }
        return collection;
    }

    void registerElement(QName qName) throws IOException, XmlException {
        SchemaGlobalElement schemaGlobalElement = this.mSchemaTypeSystem.findElement(qName);
        if (schemaGlobalElement == null) {
            throw new IllegalArgumentException(qName + " is not found in schema.");
        }
        XmlTypeName xmlTypeName = XmlTypeName.forGlobalName((char)'e', (QName)qName);
        BindingTypeName bindingTypeName = this.mBindingFile.lookupPojoFor(xmlTypeName);
        if (bindingTypeName == null) {
            bindingTypeName = this.mBindingFile.lookupXmlObjectFor(xmlTypeName);
        }
        if (bindingTypeName == null) {
            XmlTypeName xmlTypeName2;
            BindingTypeName bindingTypeName2;
            if (mVerbose) {
                Verbose.log("Register global element: " + qName);
            }
            if ((bindingTypeName2 = this.mLoader.lookupPojoFor(xmlTypeName2 = XmlTypeName.forSchemaType((SchemaType)schemaGlobalElement.getType()))) != null) {
                BindingTypeName bindingTypeName3 = BindingTypeName.forPair((JavaTypeName)bindingTypeName2.getJavaName(), (XmlTypeName)xmlTypeName);
                SimpleDocumentBinding simpleDocumentBinding = new SimpleDocumentBinding(bindingTypeName3);
                simpleDocumentBinding.setTypeOfElement(xmlTypeName2);
                this.mBindingFile.addBindingType((BindingType)simpleDocumentBinding, false, true);
            } else if (schemaGlobalElement.getType().isSimpleType()) {
                BindingType bindingType = this.registerType(schemaGlobalElement.getType());
                BindingTypeName bindingTypeName4 = BindingTypeName.forPair((JavaTypeName)bindingType.getName().getJavaName(), (XmlTypeName)xmlTypeName);
                SimpleDocumentBinding simpleDocumentBinding = new SimpleDocumentBinding(bindingTypeName4);
                simpleDocumentBinding.setTypeOfElement(xmlTypeName2);
                this.mBindingFile.addBindingType((BindingType)simpleDocumentBinding, false, true);
            } else {
                this.logError("Ignoring element declaration " + qName + " because there is no entry for its type in the " + "JAXRPC mapping file.");
            }
        }
    }

    void registerType(QName qName) throws IOException, XmlException {
        SchemaType schemaType = BuiltinSchemaTypeSystem.get().findType(qName);
        if (schemaType == null) {
            SchemaTypeLoader schemaTypeLoader = BaseTypeLoaderFactory.newInstance(null);
            schemaType = schemaTypeLoader.findType(qName);
        }
        if (schemaType == null) {
            schemaType = this.mSchemaTypeSystem.findType(qName);
        }
        if (schemaType == null) {
            throw new IllegalArgumentException("Schema global type " + qName + " is not found in schema.");
        }
        this.registerType(schemaType);
    }

    private BindingType registerType(SchemaType schemaType) {
        XmlTypeName xmlTypeName = XmlTypeName.forSchemaType((SchemaType)schemaType);
        BindingTypeName bindingTypeName = JaxRpcBuiltinBindingLoader.getInstance().lookupPojoFor(xmlTypeName);
        if (bindingTypeName != null) {
            return this.mLoader.getBindingType(bindingTypeName);
        }
        bindingTypeName = this.mLoader.lookupPojoFor(xmlTypeName);
        if (bindingTypeName != null) {
            return this.mLoader.getBindingType(bindingTypeName);
        }
        if (SoapArrayHelper.isSoapArray(schemaType)) {
            SoapArrayType soapArrayType = new SoapArrayHelper((SchemaTypeLoader)this.mSchemaTypeSystem, this.mLoader, this.mBindingFile).createSoapArrayType(schemaType);
            this.mBindingFile.addBindingType((BindingType)soapArrayType, false, true);
            return soapArrayType;
        }
        if (LiteralArrayHelper.isLiteralArray(schemaType)) {
            WrappedArrayType wrappedArrayType = new LiteralArrayHelper((SchemaTypeLoader)this.mSchemaTypeSystem, this.mLoader).createLiteralArrayType(schemaType);
            this.mBindingFile.addBindingType((BindingType)wrappedArrayType, false, true);
            return wrappedArrayType;
        }
        if (schemaType.getListItemType() != null) {
            SchemaType schemaType2 = schemaType.getListItemType();
            BindingTypeName bindingTypeName2 = this.mLoader.lookupPojoFor(XmlTypeName.forSchemaType((SchemaType)schemaType2));
            if (bindingTypeName2 == null) {
                this.logError("Internal error: no builtin binding found for " + schemaType2);
            }
            JavaTypeName javaTypeName = this.getJavaTypeForSimpleType(schemaType2);
            javaTypeName = JavaTypeName.forArray((JavaTypeName)javaTypeName, (int)1);
            BindingTypeName bindingTypeName3 = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)XmlTypeName.forSchemaType((SchemaType)schemaType));
            ListArrayType listArrayType = new ListArrayType(bindingTypeName3);
            listArrayType.setItemType(bindingTypeName2);
            this.mBindingFile.addBindingType((BindingType)listArrayType, false, true);
            return listArrayType;
        }
        if (schemaType.isSimpleType()) {
            JavaTypeName javaTypeName = this.getJavaTypeForSimpleType(schemaType);
            BindingTypeName bindingTypeName4 = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)XmlTypeName.forSchemaType((SchemaType)schemaType));
            SimpleBindingType simpleBindingType = new SimpleBindingType(bindingTypeName4);
            simpleBindingType.setAsIfXmlType(XmlTypeName.forSchemaType((SchemaType)Deploytime109MappingHelper.getBuiltinBaseType(schemaType)));
            this.mBindingFile.addBindingType((BindingType)simpleBindingType, false, true);
            return simpleBindingType;
        }
        SchemaParticle schemaParticle = schemaType.getContentModel();
        if (schemaParticle == null) {
            return null;
        }
        switch (schemaParticle.getParticleType()) {
            case 1: {
                SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
                return this.createBindingType(schemaType.getName(), schemaType, schemaPropertyArray);
            }
            case 3: 
            case 4: {
                SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
                return this.createBindingType(schemaType.getName(), schemaType, schemaPropertyArray);
            }
        }
        this.logError("unknown schema particle type '" + schemaParticle.getParticleType() + "' on " + schemaType.getName());
        return null;
    }

    private BindingType createBindingType(QName qName, SchemaType schemaType, SchemaProperty[] schemaPropertyArray) {
        String string = (String)this.mNs2Package.get(qName.getNamespaceURI());
        if (string == null) {
            this.logError("Type " + qName + " is not understood because package name " + "mapping for " + qName.getNamespaceURI() + " is not found. " + "You can not use this type in operation calls. Operations that " + "don't use this type are still callable.");
            return null;
        }
        String string2 = string + "." + Deploytime109MappingHelper.ucfirst(schemaType.getName().getLocalPart());
        if (mVerbose) {
            Verbose.log("Formed java class name " + string2);
        }
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logError("Class not found " + string2, classNotFoundException);
            return null;
        }
        XmlTypeName xmlTypeName = XmlTypeName.forTypeNamed((QName)qName);
        JavaTypeName javaTypeName = JavaTypeName.forString((String)string2);
        BindingTypeName bindingTypeName = this.mLoader.lookupPojoFor(xmlTypeName);
        if (bindingTypeName == null) {
            bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
            if (mVerbose) {
                Verbose.log("Adding ByNameBean for non-builtin type " + xmlTypeName);
            }
            ByNameBean byNameBean = new ByNameBean(bindingTypeName);
            this.mBindingFile.addBindingType((BindingType)byNameBean, true, true);
            Map map = this.checkProperties(clazz, schemaPropertyArray);
            for (int i = 0; i < schemaPropertyArray.length; ++i) {
                SchemaProperty schemaProperty = schemaPropertyArray[i];
                SchemaType schemaType2 = schemaProperty.getType();
                QName qName2 = schemaType2.getName();
                if (qName2 == null) {
                    this.logError("XMLType " + schemaType.getName() + " local element " + schemaProperty.getName() + " doesn't have a type");
                    continue;
                }
                QNameProperty qNameProperty = new QNameProperty();
                qNameProperty.setQName(qName2);
                qNameProperty.setNillable(schemaProperty.hasNillable() != 0);
                BindingType bindingType = this.registerType(schemaType2);
                qNameProperty.setBindingType(bindingType);
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)map.get(schemaProperty.getName().getLocalPart());
                propertyDescriptor.getPropertyType();
                JavaTypeName javaTypeName2 = JavaTypeName.forString((String)propertyDescriptor.getPropertyType().getName());
                qNameProperty.setSetterName(MethodName.create((String)propertyDescriptor.getWriteMethod().getName(), (JavaTypeName)javaTypeName2));
                qNameProperty.setGetterName(MethodName.create((String)propertyDescriptor.getReadMethod().getName()));
                byNameBean.addProperty(qNameProperty);
            }
        }
        return this.mLoader.getBindingType(bindingTypeName);
    }

    private Map checkProperties(Class clazz, SchemaProperty[] schemaPropertyArray) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            this.logError(clazz.getName() + " is not a valid java bean.", introspectionException);
            return null;
        }
        HashMap<String, SchemaProperty> hashMap = new HashMap<String, SchemaProperty>();
        for (int i = 0; i < schemaPropertyArray.length; ++i) {
            hashMap.put(schemaPropertyArray[i].getName().getLocalPart(), schemaPropertyArray[i]);
        }
        HashMap<String, PropertyDescriptor> hashMap2 = new HashMap<String, PropertyDescriptor>();
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if ("class".equals(propertyDescriptor.getName())) continue;
            if (hashMap.get(propertyDescriptor.getName()) == null) {
                this.logError(clazz.getName() + " java bean " + "properties don't match with schema. " + "property " + propertyDescriptor.getName() + " is not found in schema.");
                return null;
            }
            hashMap.remove(propertyDescriptor.getName());
            hashMap2.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        if (hashMap.size() != 0) {
            this.logError(clazz.getName() + " java bean " + "properties don't match with schema. " + "Scheam type has more properites " + hashMap.keySet());
        }
        return hashMap2;
    }

    private SchemaType getBaseTypeForComplexTypeWithSimpleContent(SchemaType schemaType) {
        if (schemaType.getContentType() == 2) {
            SchemaType schemaType2;
            for (schemaType2 = schemaType; schemaType2 != null && !schemaType2.isSimpleType(); schemaType2 = schemaType2.getContentBasedOnType()) {
            }
            if (schemaType2 != null && schemaType2.isSimpleType()) {
                if (schemaType2.getListItemType() != null || schemaType2.getBaseEnumType() != null) {
                    return schemaType2;
                }
                return Deploytime109MappingHelper.getBuiltinBaseType(schemaType2);
            }
        }
        return null;
    }

    private String findTargetNamespace(JavaXmlTypeMappingBean javaXmlTypeMappingBean) {
        QName qName = javaXmlTypeMappingBean.getRootTypeQname();
        if (qName != null) {
            return qName.getNamespaceURI();
        }
        String string = javaXmlTypeMappingBean.getAnonymousTypeQname();
        if (string != null) {
            int n = string.lastIndexOf(58);
            return n == -1 ? string : string.substring(0, n);
        }
        throw new AssertionError((Object)"no root name or anonymous name specified");
    }

    /*
     * Enabled aggressive block sorting
     */
    private BindingType createBindingTypeFrom(int n, JavaXmlTypeMappingBean javaXmlTypeMappingBean) {
        ByNameBean byNameBean;
        BindingTypeName bindingTypeName;
        XmlTypeName xmlTypeName;
        SchemaGlobalElement schemaGlobalElement;
        boolean bl;
        String string = javaXmlTypeMappingBean.getQnameScope();
        if (string.equals(SCOPE_ELEMENT)) {
            return this.bindElementScopedMapping(javaXmlTypeMappingBean);
        }
        QName qName = javaXmlTypeMappingBean.getRootTypeQname();
        boolean bl2 = bl = qName == null;
        if (bl && javaXmlTypeMappingBean.getAnonymousTypeQname() == null) {
            throw new IllegalStateException("<java-xml-type-mapping>  element has neither a <root-type-qname> nor an <anonymous-type-qname> - exactly one is required.");
        }
        SchemaType schemaType = null;
        SchemaProperty schemaProperty = null;
        if (bl) {
            if (this.mATF == null) {
                this.mATF = new AnonymousTypeFinder(this.mSchemaTypeSystem);
            }
            if ((schemaType = this.mATF.getTypeNamed(javaXmlTypeMappingBean.getAnonymousTypeQname())) == null) {
                schemaProperty = this.mATF.getHiddenArrayElementComponentTypeNamed(javaXmlTypeMappingBean.getAnonymousTypeQname());
                if (schemaProperty == null) {
                    this.logWarning("could not identify anonymous schema type named '" + javaXmlTypeMappingBean.getAnonymousTypeQname() + "', ignoring");
                    return null;
                }
                schemaType = schemaProperty.getContainerType();
            }
        } else {
            schemaType = this.mSchemaTypeSystem.findType(qName);
            if (schemaType == null && (schemaGlobalElement = this.mSchemaTypeSystem.findElement(qName)) != null) {
                schemaType = schemaGlobalElement.getType();
            }
            if (schemaType == null) {
                this.logError("could not find schema type '" + qName);
                return null;
            }
        }
        schemaGlobalElement = XmlTypeName.forSchemaType((SchemaType)schemaType);
        JavaTypeName javaTypeName = JavaTypeName.forString((String)javaXmlTypeMappingBean.getJavaType());
        if (Java2Schema.isCollectionType((String)javaTypeName.getClassName())) {
            BindingTypeName bindingTypeName2 = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)schemaGlobalElement);
            boolean bl3 = SoapArrayHelper.isSoapArray(schemaType);
            Object object = bl3 ? Java2Schema.createSoapEncCollectionType((BindingTypeName)bindingTypeName2) : Java2Schema.createCollectionType((BindingTypeName)bindingTypeName2);
            this.mBindingFile.addBindingType((BindingType)object, false, true);
            return object;
        }
        if (javaTypeName.getArrayDepth() != 0) {
            if (SoapArrayHelper.isSoapArray(schemaType)) {
                List list = new SoapArrayHelper((SchemaTypeLoader)this.mSchemaTypeSystem, this.mLoader, this.mBindingFile).createSoapArrayType(javaTypeName, schemaType);
                Iterator iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return (SoapArrayType)list.get(0);
                    }
                    this.mBindingFile.addBindingType((BindingType)((SoapArrayType)iterator.next()), false, true);
                }
            }
            if (LiteralArrayHelper.isLiteralArray(schemaType)) {
                WrappedArrayType wrappedArrayType = new LiteralArrayHelper((SchemaTypeLoader)this.mSchemaTypeSystem, this.mLoader).createLiteralArrayType(javaTypeName, schemaType);
                this.mBindingFile.addBindingType((BindingType)wrappedArrayType, false, true);
                return wrappedArrayType;
            }
            if (schemaProperty != null) {
                return null;
            }
            if (schemaType.getListItemType() != null) {
                BindingTypeName bindingTypeName3 = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)schemaGlobalElement);
                ListArrayType listArrayType = new ListArrayType(bindingTypeName3);
                SchemaType schemaType2 = schemaType.getListItemType();
                if (!schemaType2.isPrimitiveType()) {
                    if (schemaType2.getEnumerationValues() != null || schemaType2.isAnonymousType()) {
                        schemaType2 = schemaType2.getBaseType();
                    } else if (schemaType2.getUnionMemberTypes() != null && schemaType2.getUnionMemberTypes().length > 0) {
                        schemaType2 = schemaType2.getUnionCommonBaseType();
                    }
                }
                BindingTypeName bindingTypeName4 = BindingTypeName.forPair((JavaTypeName)javaTypeName.getArrayItemType(javaTypeName.getArrayDepth()), (XmlTypeName)XmlTypeName.forSchemaType((SchemaType)schemaType2));
                listArrayType.setItemType(bindingTypeName4);
                this.mBindingFile.addBindingType((BindingType)listArrayType, false, true);
                return listArrayType;
            }
            if (!schemaType.isSimpleType()) {
                throw new IllegalStateException("JavaType " + javaXmlTypeMappingBean.getJavaType() + " is" + " a array. XmlType " + schemaType.getName() + " is not.");
            }
        }
        if (bl) {
            if (schemaProperty != null) {
                SchemaGlobalElement schemaGlobalElement2 = schemaGlobalElement;
                BindingTypeName bindingTypeName5 = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)schemaGlobalElement2);
                WrappedArrayType wrappedArrayType = new WrappedArrayType(bindingTypeName5);
                wrappedArrayType.setItemName(schemaProperty.getName());
                wrappedArrayType.setItemNillable(true);
                BindingTypeName bindingTypeName6 = BindingTypeName.forPair((JavaTypeName)javaTypeName.getArrayItemType(javaTypeName.getArrayDepth()), (XmlTypeName)XmlTypeName.forSchemaType((SchemaType)schemaProperty.getType()));
                wrappedArrayType.setItemType(bindingTypeName6);
                this.mBindingFile.addBindingType((BindingType)wrappedArrayType, false, true);
                return wrappedArrayType;
            }
            xmlTypeName = schemaGlobalElement.getOuterComponent();
            if (this.mBindingFile.lookupPojoFor(xmlTypeName) == null && this.mBindingFile.lookupXmlObjectFor(xmlTypeName) == null) {
                bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
                byNameBean = new SimpleDocumentBinding(bindingTypeName);
                byNameBean.setTypeOfElement((XmlTypeName)schemaGlobalElement);
                this.mBindingFile.addBindingType((BindingType)byNameBean, false, true);
            }
        }
        if (BuiltinBindingLoader.getInstance().lookupPojoFor((XmlTypeName)schemaGlobalElement) != null) {
            return null;
        }
        xmlTypeName = this.getBaseTypeForComplexTypeWithSimpleContent(schemaType);
        bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)schemaGlobalElement);
        if (string.equals(SCOPE_COMPLETXTYPE)) {
            if (xmlTypeName == null) {
                byNameBean = new ByNameBean(bindingTypeName);
                this.mBindingFile.addBindingType((BindingType)byNameBean, true, true);
                return byNameBean;
            }
            this.simpleContentTypes.put(n, (SchemaType)xmlTypeName);
            byNameBean = new SimpleContentBean(bindingTypeName);
            this.mBindingFile.addBindingType((BindingType)byNameBean, true, true);
            return byNameBean;
        }
        if (!string.equals(SCOPE_SIMPLETYPE)) {
            this.logError("unknown qname-scope '" + string + "' on <java-xml-type mapping> " + "for " + javaXmlTypeMappingBean.getJavaType());
            return null;
        }
        if (schemaType.getEnumerationValues() != null && !this.treatEnumsAsSimpleTypes) {
            byNameBean = new JaxrpcEnumType(bindingTypeName);
            byNameBean.setGetValueMethod(JaxrpcEnumType.DEFAULT_GET_VALUE);
            byNameBean.setFromStringMethod(JaxrpcEnumType.DEFAULT_FROM_STRING);
            SchemaType schemaType3 = Deploytime109MappingHelper.getBuiltinBaseType(schemaType);
            BindingTypeName bindingTypeName7 = this.mLoader.lookupPojoFor(XmlTypeName.forSchemaType((SchemaType)schemaType3));
            if (bindingTypeName7 == null) {
                this.logError("binding for " + schemaType3 + " not in loader");
                return null;
            }
            byNameBean.setBaseType(bindingTypeName7);
            byNameBean.setFromValueMethod(MethodName.create((String)"fromValue", (JavaTypeName)bindingTypeName7.getJavaName()));
            this.mBindingFile.addBindingType((BindingType)byNameBean, true, true);
            return byNameBean;
        }
        if (schemaType.getListItemType() != null) {
            byNameBean = new ListArrayType(bindingTypeName);
            SchemaType schemaType4 = schemaType.getListItemType();
            BindingTypeName bindingTypeName8 = this.mLoader.lookupPojoFor(XmlTypeName.forSchemaType((SchemaType)schemaType4));
            if (bindingTypeName8 == null) {
                this.logError("could not find list item biding for schema type " + schemaType4.getName());
                return null;
            }
            byNameBean.setItemType(bindingTypeName8);
            this.mBindingFile.addBindingType((BindingType)byNameBean, true, true);
            return byNameBean;
        }
        byNameBean = new SimpleBindingType(bindingTypeName);
        if (!schemaType.isSimpleType()) {
            this.logError(qName + " is not a simple type but is mapped with simple type scope");
            return null;
        }
        byNameBean.setAsIfXmlType(XmlTypeName.forSchemaType((SchemaType)Deploytime109MappingHelper.getBuiltinBaseType(schemaType)));
        this.mBindingFile.addBindingType((BindingType)byNameBean, true, true);
        return byNameBean;
    }

    private BindingType bindElementScopedMapping(JavaXmlTypeMappingBean javaXmlTypeMappingBean) {
        QName qName = javaXmlTypeMappingBean.getRootTypeQname();
        if (qName == null) {
            this.logWarning("Ignoring <java-xml-mapping-bean> for " + javaXmlTypeMappingBean.getJavaType() + "because it is anonymous and has element scope.");
            return null;
        }
        XmlTypeName xmlTypeName = XmlTypeName.forGlobalName((char)'e', (QName)qName);
        JavaTypeName javaTypeName = JavaTypeName.forString((String)javaXmlTypeMappingBean.getJavaType());
        BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
        SimpleDocumentBinding simpleDocumentBinding = new SimpleDocumentBinding(bindingTypeName);
        SchemaGlobalElement schemaGlobalElement = this.mSchemaTypeSystem.findElement(qName);
        if (schemaGlobalElement == null) {
            this.logError("could not locate schema element named " + qName);
            return null;
        }
        SchemaType schemaType = schemaGlobalElement.getType();
        if (schemaType == null) {
            this.logError("schema element named " + qName + " has no type");
            return null;
        }
        XmlTypeName xmlTypeName2 = XmlTypeName.forSchemaType((SchemaType)schemaType);
        simpleDocumentBinding.setTypeOfElement(xmlTypeName2);
        this.mBindingFile.addBindingType((BindingType)simpleDocumentBinding, false, true);
        return simpleDocumentBinding;
    }

    private SimpleContentProperty createJaxRpcSimpleContentPropertyFor(JavaTypeName javaTypeName, SchemaType schemaType) {
        SimpleContentProperty simpleContentProperty = new SimpleContentProperty();
        BindingType bindingType = this.mLoader.getBindingType(this.mLoader.lookupPojoFor(XmlTypeName.forSchemaType((SchemaType)schemaType)));
        if (bindingType == null) {
            this.logError("Could not find built-in binding for " + schemaType.getName());
            return null;
        }
        simpleContentProperty.setSetterName(MethodName.create((String)JAXRPC_CTWSC_SETTER, (JavaTypeName)bindingType.getName().getJavaName()));
        simpleContentProperty.setGetterName(MethodName.create((String)JAXRPC_CTWSC_GETTER));
        simpleContentProperty.setBindingType(bindingType);
        return simpleContentProperty;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QNameProperty[] createQNameProps(String string, VariableMappingBean[] variableMappingBeanArray, Class clazz, SchemaType schemaType) {
        if (string == null) {
            throw new IllegalArgumentException("null tns");
        }
        if (variableMappingBeanArray == null) {
            throw new IllegalArgumentException("null vars");
        }
        if (schemaType == null) {
            throw new IllegalArgumentException("null schemaType");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("null javaClass");
        }
        QNameProperty[] qNamePropertyArray = new QNameProperty[variableMappingBeanArray.length];
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            this.logError(clazz.getName() + " is not a valid java bean.", introspectionException);
        }
        HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
        if (beanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                hashMap.put(Deploytime109MappingHelper.ucfirst(propertyDescriptor.getName()), propertyDescriptor);
            }
        }
        int n = 0;
        while (true) {
            block30: {
                BindingTypeName bindingTypeName;
                JavaTypeName javaTypeName;
                String string2;
                BindingType bindingType;
                PropertyDescriptor propertyDescriptor;
                String string3;
                Object object;
                block36: {
                    block37: {
                        block38: {
                            block34: {
                                block35: {
                                    Field field;
                                    Method method;
                                    Method method2;
                                    block32: {
                                        block33: {
                                            block31: {
                                                if (n >= variableMappingBeanArray.length) {
                                                    return qNamePropertyArray;
                                                }
                                                qNamePropertyArray[n] = variableMappingBeanArray[n].getXmlWildcard() != null ? new GenericXmlProperty() : new QNameProperty();
                                                object = null;
                                                method2 = null;
                                                method = null;
                                                field = Deploytime109MappingHelper.getJavaVariablePublicField(clazz, variableMappingBeanArray[n]);
                                                if (field == null) break block31;
                                                object = field.getType();
                                                break block32;
                                            }
                                            string3 = variableMappingBeanArray[n].getJavaVariableName();
                                            propertyDescriptor = (PropertyDescriptor)hashMap.get(Deploytime109MappingHelper.ucfirst(string3));
                                            if (propertyDescriptor != null) {
                                                method2 = propertyDescriptor.getReadMethod();
                                                method = propertyDescriptor.getWriteMethod();
                                            }
                                            if (method2 != null) break block33;
                                            this.logError("could not find getter for property '" + variableMappingBeanArray[n].getJavaVariableName() + "' on " + clazz.getName());
                                            qNamePropertyArray[n] = null;
                                            break block30;
                                        }
                                        object = method2.getReturnType();
                                        if (method != null || Deploytime109MappingHelper.isException(clazz)) break block32;
                                        this.logError("Could not find a setter for property '" + variableMappingBeanArray[n].getJavaVariableName() + "' on " + clazz.getName());
                                        qNamePropertyArray[n] = null;
                                        break block30;
                                    }
                                    string3 = JavaTypeName.forClassName((String)((Class)object).getName());
                                    if (field != null) {
                                        qNamePropertyArray[n].setFieldName(field.getName());
                                    } else {
                                        qNamePropertyArray[n].setGetterName(MethodName.create((String)method2.getName()));
                                        if (method != null) {
                                            qNamePropertyArray[n].setSetterName(MethodName.create((String)method.getName(), (JavaTypeName)string3));
                                        }
                                    }
                                    propertyDescriptor = null;
                                    bindingType = null;
                                    string2 = variableMappingBeanArray[n].getXmlElementName();
                                    if (string2 == null) break block34;
                                    javaTypeName = this.mFQH.getElementProperties(schemaType, string2);
                                    if (javaTypeName.size() > 1) {
                                        bindingTypeName = javaTypeName.iterator();
                                        while (bindingTypeName.hasNext() && propertyDescriptor == null) {
                                            propertyDescriptor = bindingTypeName.next();
                                            bindingType = this.getBindingTypeBetween((JavaTypeName)string3, propertyDescriptor.getType());
                                            if (bindingType != null) continue;
                                            propertyDescriptor = null;
                                        }
                                    } else {
                                        propertyDescriptor = this.mFQH.getElementProperty(schemaType, string2);
                                    }
                                    if (propertyDescriptor == null) break block35;
                                    qNamePropertyArray[n].setQName(propertyDescriptor.getName());
                                    qNamePropertyArray[n].setAttribute(false);
                                    break block36;
                                }
                                this.logMissingPropertyError(schemaType, string2, false);
                                qNamePropertyArray[n] = null;
                                break block30;
                            }
                            string2 = variableMappingBeanArray[n].getXmlAttributeName();
                            if (string2 == null) break block37;
                            propertyDescriptor = this.mFQH.getAttributeProperty(schemaType, string2);
                            if (propertyDescriptor == null) break block38;
                            qNamePropertyArray[n].setQName(propertyDescriptor.getName());
                            qNamePropertyArray[n].setAttribute(true);
                            break block36;
                        }
                        this.logMissingPropertyError(schemaType, string2, true);
                        qNamePropertyArray[n] = null;
                        break block30;
                    }
                    if (variableMappingBeanArray[n].getXmlWildcard() != null) {
                        this.fillWildProperty(qNamePropertyArray[n], schemaType, (JavaTypeName)string3);
                        break block30;
                    } else {
                        this.logError("invalid <variable-name> for " + variableMappingBeanArray[n].getJavaVariableName() + " - neither element not attribute specified");
                        qNamePropertyArray[n] = null;
                    }
                    break block30;
                }
                qNamePropertyArray[n].setNillable(propertyDescriptor.hasNillable() != 0);
                if (bindingType == null) {
                    bindingType = this.getBindingTypeBetween((JavaTypeName)string3, propertyDescriptor.getType());
                }
                if (bindingType != null) {
                    qNamePropertyArray[n].setTypeName(bindingType.getName());
                } else {
                    string2 = XmlTypeName.forSchemaType((SchemaType)propertyDescriptor.getType());
                    if (!((Class)object).isArray()) {
                        throw new IllegalStateException("Could not find binding for QNameProperty " + variableMappingBeanArray[n].getJavaVariableName() + " : " + BindingTypeName.forPair((JavaTypeName)string3, (XmlTypeName)string2) + " Bean type :" + clazz + " XmlType " + schemaType.getName());
                    }
                    if (SoapArrayHelper.isSoapArray(propertyDescriptor.getType())) {
                        bindingType = new SoapArrayHelper((SchemaTypeLoader)this.mSchemaTypeSystem, this.mLoader, this.mBindingFile).createSoapArrayType(propertyDescriptor.getType());
                        this.mBindingFile.addBindingType(bindingType, false, true);
                    } else if (LiteralArrayHelper.isLiteralArray(propertyDescriptor.getType())) {
                        bindingType = new LiteralArrayHelper((SchemaTypeLoader)this.mSchemaTypeSystem, this.mLoader).createLiteralArrayType(propertyDescriptor.getType());
                        this.mBindingFile.addBindingType(bindingType, false, true);
                    }
                    if (propertyDescriptor.getMaxOccurs() == null || propertyDescriptor.getMaxOccurs().intValue() > 1) {
                        qNamePropertyArray[n].setMultiple(true);
                        qNamePropertyArray[n].setCollectionClass((JavaTypeName)string3);
                        javaTypeName = JavaTypeName.forClassName((String)((Class)object).getComponentType().getName());
                        bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)string2);
                        bindingType = this.mLoader.getBindingType(bindingTypeName);
                        if (bindingType == null) {
                            throw new IllegalStateException("Could not find binding for QNameProperty " + variableMappingBeanArray[n].getJavaVariableName() + " : " + bindingTypeName + " Bean type :" + clazz + " XmlType " + schemaType.getName());
                        }
                    } else if (bindingType == null) {
                        throw new IllegalStateException("Could not find binding for QNameProperty " + variableMappingBeanArray[n].getJavaVariableName() + " Java type is array. XmlType is not array " + " Bean type :" + clazz + " XmlType " + schemaType.getName());
                    }
                    qNamePropertyArray[n].setTypeName(bindingType.getName());
                }
            }
            ++n;
        }
    }

    private void fillWildProperty(QNameProperty qNameProperty, SchemaType schemaType, JavaTypeName javaTypeName) {
        qNameProperty.setAttribute(false);
        qNameProperty.setQName(new QName("any"));
        qNameProperty.setTypeName(AnyRuntimeBindingType.ANY_TYPE_NAME);
        qNameProperty.setMultiple(this.countWildcards(schemaType.getContentModel()) > 1);
        qNameProperty.setOptional(qNameProperty.isMultiple());
        if (qNameProperty.isMultiple()) {
            qNameProperty.setCollectionClass(javaTypeName);
        }
    }

    private int countWildcards(SchemaParticle schemaParticle) {
        if (schemaParticle == null) {
            return 0;
        }
        int n = 0;
        switch (schemaParticle.getParticleType()) {
            case 1: 
            case 3: {
                SchemaParticle[] schemaParticleArray = schemaParticle.getParticleChildren();
                for (int i = 0; i < schemaParticleArray.length; ++i) {
                    n += this.countWildcards(schemaParticleArray[i]);
                }
                break;
            }
            case 2: {
                SchemaParticle[] schemaParticleArray = schemaParticle.getParticleChildren();
                for (int i = 0; i < schemaParticleArray.length; ++i) {
                    int n2 = this.countWildcards(schemaParticleArray[i]);
                    if (n2 <= n) continue;
                    n = n2;
                }
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                n = schemaParticle.getIntMaxOccurs();
            }
        }
        return n;
    }

    private BindingType getBindingTypeBetween(JavaTypeName javaTypeName, SchemaType schemaType) {
        XmlTypeName xmlTypeName = XmlTypeName.forSchemaType((SchemaType)schemaType);
        BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
        BindingType bindingType = this.mLoader.getBindingType(bindingTypeName);
        if (bindingType != null) {
            return bindingType;
        }
        SchemaType schemaType2 = this.getBaseTypeForComplexTypeWithSimpleContent(schemaType);
        if (schemaType2 == null) {
            schemaType2 = Deploytime109MappingHelper.getBuiltinBaseType(schemaType);
        }
        if (schemaType2 == null) {
            return null;
        }
        xmlTypeName = XmlTypeName.forSchemaType((SchemaType)schemaType2);
        bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
        bindingType = this.mLoader.getBindingType(bindingTypeName);
        return bindingType;
    }

    private void logWarning(String string) {
        System.out.println(string);
    }

    private void logError(String string) {
        if (!suppressDeployErrorMessage) {
            System.out.println("<WS data binding error>" + string);
        }
    }

    private void logError(String string, Throwable throwable) {
        IllegalStateException illegalStateException = new IllegalStateException(string);
        illegalStateException.initCause(throwable);
        illegalStateException.printStackTrace();
    }

    private void logMissingPropertyError(SchemaType schemaType, String string, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        String string2 = bl ? "attribute" : SCOPE_ELEMENT;
        stringWriter.write("Could not find " + string2 + " property '" + string + "' on " + schemaType.getName() + ".\n  Available " + string2 + "s are:\n");
        SchemaProperty[] schemaPropertyArray = bl ? schemaType.getAttributeProperties() : schemaType.getElementProperties();
        for (int i = 0; i < schemaPropertyArray.length; ++i) {
            stringWriter.write(schemaPropertyArray[i].getName().toString());
            stringWriter.write(10);
        }
        this.logError(stringWriter.toString());
    }

    private void debugOutputs() {
    }

    private void debugInputs() {
        if (mVerbose) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Processing following schemas:");
            for (int i = 0; i < this.mSchemas.length; ++i) {
                stringBuffer = stringBuffer.append("\n");
                stringBuffer.append(this.mSchemas[i].getSchema().getTargetNamespace());
            }
            Verbose.log(stringBuffer.toString());
        }
    }

    private void writeTylar(TylarWriter tylarWriter) throws IOException {
        tylarWriter.writeBindingFile(this.mBindingFile);
        tylarWriter.writeSchemaTypeSystem(this.mSchemaTypeSystem);
        if (this.mSchemas != null) {
            for (int i = 0; i < this.mSchemas.length; ++i) {
                tylarWriter.writeSchema(this.mSchemas[i], "schema-" + i + ".xsd", null);
            }
        }
    }

    private static Field getJavaVariablePublicField(Class clazz, VariableMappingBean variableMappingBean) {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
        if (variableMappingBean == null) {
            throw new IllegalArgumentException("null varmap");
        }
        if (variableMappingBean.getDataMember() != null) {
            try {
                Field field = clazz.getField(variableMappingBean.getJavaVariableName());
                if (Modifier.isPublic(field.getModifiers())) {
                    return field;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return null;
            }
        }
        return null;
    }

    private static final String ucfirst(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        return StringUtils.ucfirst((String)string);
    }

    private JavaTypeName getJavaTypeForSimpleType(SchemaType schemaType) {
        SchemaType schemaType2;
        if (!schemaType.isSimpleType()) {
            this.logError("Internal error: " + schemaType + " expected to be a simple type");
        }
        if ((schemaType2 = Deploytime109MappingHelper.getBuiltinBaseType(schemaType)) == null) {
            this.logError("Internal error: no builtin base st found for " + schemaType);
            return null;
        }
        BindingTypeName bindingTypeName = this.mLoader.lookupPojoFor(XmlTypeName.forSchemaType((SchemaType)schemaType2));
        if (bindingTypeName == null) {
            this.logError("Internal error: no binding found for builtin base st " + schemaType2);
            return null;
        }
        return bindingTypeName.getJavaName();
    }

    private static SchemaType getBuiltinBaseType(SchemaType schemaType) {
        while (!schemaType.isBuiltinType()) {
            schemaType = schemaType.getBaseType();
        }
        return schemaType;
    }

    private static boolean isException(Class clazz) {
        return Throwable.class.isAssignableFrom(clazz);
    }

    private static String fixFileUri(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.replaceAll(" ", "%20");
        return string2;
    }
}

