/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.runtime.internal;

import com.bea.staxb.buildtime.internal.bts.BindingLoader;
import com.bea.staxb.buildtime.internal.bts.BindingTypeName;
import com.bea.staxb.buildtime.internal.bts.JavaTypeName;
import com.bea.staxb.buildtime.internal.bts.WrappedArrayType;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeLoader;
import java.math.BigInteger;

public class LiteralArrayHelper {
    private BindingLoader mBindings;
    private SchemaTypeLoader mSchemaTypes;

    public LiteralArrayHelper(SchemaTypeLoader schemaTypeLoader, BindingLoader bindingLoader) {
        this.mBindings = bindingLoader;
        this.mSchemaTypes = schemaTypeLoader;
    }

    private void p(String string) {
        System.out.println(" [LiteralArrayHelper] " + string);
    }

    private static void pStatic(String string) {
        System.out.println(" [LiteralArrayHelper] " + string);
    }

    WrappedArrayType createLiteralArrayType(SchemaType schemaType) {
        SchemaType schemaType2 = LiteralArrayHelper.getLiteralArrayItemType(schemaType);
        XmlTypeName xmlTypeName = XmlTypeName.forSchemaType((SchemaType)schemaType2);
        BindingTypeName bindingTypeName = this.mBindings.lookupPojoFor(xmlTypeName);
        if (bindingTypeName == null) {
            throw new IllegalStateException("Literal Array " + schemaType + " item type " + xmlTypeName + " is not found.");
        }
        return this.createLiteralArrayType(bindingTypeName.getJavaName(), schemaType, true);
    }

    WrappedArrayType createLiteralArrayType(JavaTypeName javaTypeName, SchemaType schemaType) {
        return this.createLiteralArrayType(javaTypeName, schemaType, false);
    }

    private WrappedArrayType createLiteralArrayType(JavaTypeName javaTypeName, SchemaType schemaType, boolean bl) {
        if (schemaType == null) {
            throw new IllegalArgumentException("null stype");
        }
        SchemaType schemaType2 = LiteralArrayHelper.getLiteralArrayItemType(schemaType);
        XmlTypeName xmlTypeName = XmlTypeName.forSchemaType((SchemaType)schemaType2);
        JavaTypeName javaTypeName2 = javaTypeName;
        if (!bl) {
            javaTypeName2 = javaTypeName.getArrayTypeMinus1Dim(javaTypeName.getArrayDepth());
        }
        BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName2, (XmlTypeName)xmlTypeName);
        XmlTypeName xmlTypeName2 = XmlTypeName.forSchemaType((SchemaType)schemaType);
        JavaTypeName javaTypeName3 = JavaTypeName.forArray((JavaTypeName)bindingTypeName.getJavaName(), (int)1);
        BindingTypeName bindingTypeName2 = BindingTypeName.forPair((JavaTypeName)javaTypeName3, (XmlTypeName)xmlTypeName2);
        WrappedArrayType wrappedArrayType = new WrappedArrayType(bindingTypeName2);
        SchemaProperty[] schemaPropertyArray = schemaType.getProperties();
        boolean bl2 = schemaPropertyArray[0].hasNillable() != 0;
        wrappedArrayType.setItemNillable(bl2);
        wrappedArrayType.setItemType(bindingTypeName);
        wrappedArrayType.setItemName(schemaPropertyArray[0].getName());
        return wrappedArrayType;
    }

    public static boolean isLiteralArray(SchemaType schemaType) {
        return LiteralArrayHelper.getLiteralArrayItemType(schemaType) != null;
    }

    public static SchemaType getLiteralArrayItemType(SchemaType schemaType) {
        if (schemaType.isSimpleType() || schemaType.getContentType() == 2) {
            return null;
        }
        SchemaProperty[] schemaPropertyArray = schemaType.getProperties();
        if (schemaPropertyArray.length != 1 || schemaPropertyArray[0].isAttribute()) {
            return null;
        }
        BigInteger bigInteger = schemaPropertyArray[0].getMaxOccurs();
        if (bigInteger != null && bigInteger.compareTo(BigInteger.ONE) <= 0) {
            return null;
        }
        SchemaType schemaType2 = schemaPropertyArray[0].getType();
        return schemaPropertyArray[0].getType();
    }
}

