/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.runtime.internal;

import com.bea.staxb.buildtime.WildcardUtil;
import com.bea.staxb.buildtime.internal.bts.BindingLoader;
import com.bea.staxb.buildtime.internal.bts.BindingTypeName;
import com.bea.staxb.buildtime.internal.bts.BuiltinBindingLoader;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.staxb.buildtime.internal.tylar.CompositeTylar;
import com.bea.staxb.buildtime.internal.tylar.Tylar;
import com.bea.staxb.runtime.BindingContext;
import com.bea.staxb.runtime.BindingContextFactory;
import com.bea.staxb.runtime.EncodingStyle;
import com.bea.staxb.runtime.MarshalOptions;
import com.bea.staxb.runtime.internal.BindingContextFactoryImpl;
import com.bea.xml.SchemaGlobalElement;
import com.bea.xml.SchemaParticle;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.XmlException;
import com.bea.xml.XmlRuntimeException;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.bind.runtime.DeserializerContext;
import weblogic.wsee.bind.runtime.RuntimeBindings;
import weblogic.wsee.bind.runtime.SerializerContext;
import weblogic.wsee.bind.runtime.internal.BaseSerializerContext;
import weblogic.wsee.bind.runtime.internal.EncodedDeserializerContext;
import weblogic.wsee.bind.runtime.internal.EncodedSerializerContext;
import weblogic.wsee.bind.runtime.internal.LiteralDeserializerContext;
import weblogic.wsee.bind.runtime.internal.LiteralSerializerContext;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.WsType;
import weblogic.xml.dom.DOMStreamReaderExt;

public class RuntimeBindingsImpl
implements RuntimeBindings {
    protected static final boolean mVerbose = Verbose.isVerbose(RuntimeBindingsImpl.class);
    private static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private final BindingContext mBindingContext;
    private BindingLoader mBindingLoader;
    private com.bea.xbeanmarshal.runtime.BindingContext mXBeanBindingContext;
    private com.bea.xbeanmarshal.buildtime.internal.bts.BindingLoader mXBeanBindingLoader;
    private final SchemaTypeLoader mSchemaTypeLoader;

    public RuntimeBindingsImpl() {
        this.mBindingContext = this.getDefaultXbeanContext();
        this.mBindingLoader = BuiltinBindingLoader.getInstance();
        this.mXBeanBindingLoader = null;
        this.mSchemaTypeLoader = null;
    }

    public RuntimeBindingsImpl(Tylar[] tylarArray) throws IOException, XmlException {
        if (mVerbose) {
            Verbose.log("Constructing WlsBindingProvider from: " + tylarArray.length + " tylars");
        }
        CompositeTylar compositeTylar = new CompositeTylar(tylarArray);
        if (mVerbose) {
            // empty if block
        }
        this.mSchemaTypeLoader = compositeTylar.getSchemaTypeLoader();
        this.mBindingLoader = compositeTylar.getBindingLoader();
        this.mBindingContext = ((BindingContextFactoryImpl)BindingContextFactoryImpl.newInstance()).createBindingContext((Tylar)compositeTylar);
    }

    public void setXmlBeansBindingLoader(com.bea.xbeanmarshal.buildtime.internal.bts.BindingLoader bindingLoader) {
        assert (bindingLoader != null);
        this.mXBeanBindingLoader = bindingLoader;
        com.bea.xbeanmarshal.runtime.internal.BindingContextFactoryImpl cfr_ignored_0 = (com.bea.xbeanmarshal.runtime.internal.BindingContextFactoryImpl)com.bea.xbeanmarshal.runtime.internal.BindingContextFactoryImpl.newInstance();
        this.mXBeanBindingContext = com.bea.xbeanmarshal.runtime.internal.BindingContextFactoryImpl.createBindingContext((com.bea.xbeanmarshal.buildtime.internal.bts.BindingLoader)bindingLoader);
    }

    public DeserializerContext createDeserializerContext(int n, Element element, boolean bl) {
        try {
            switch (n) {
                case 0: {
                    return new LiteralDeserializerContext(this.mBindingContext, this.mXBeanBindingContext, this.mSchemaTypeLoader, bl);
                }
                case 1: {
                    return new EncodedDeserializerContext(this.mBindingContext, this.mSchemaTypeLoader, EncodingStyle.SOAP11, element, bl);
                }
                case 2: {
                    return new EncodedDeserializerContext(this.mBindingContext, this.mSchemaTypeLoader, EncodingStyle.SOAP12, element, bl);
                }
            }
            throw new AssertionError((Object)("unknown encoding: " + n));
        }
        catch (XmlException xmlException) {
            throw new XmlRuntimeException(xmlException);
        }
    }

    public SerializerContext createSerializerContext(int n, MarshalOptions marshalOptions) {
        try {
            switch (n) {
                case 0: {
                    return new LiteralSerializerContext(this.mBindingContext, this.mXBeanBindingContext, this.mSchemaTypeLoader, marshalOptions);
                }
                case 1: {
                    return new EncodedSerializerContext(this.mBindingContext, this.mSchemaTypeLoader, EncodingStyle.SOAP11, marshalOptions);
                }
                case 2: {
                    return new EncodedSerializerContext(this.mBindingContext, this.mSchemaTypeLoader, EncodingStyle.SOAP12, marshalOptions);
                }
            }
            throw new AssertionError((Object)("unknown encoding: " + n));
        }
        catch (XmlException xmlException) {
            throw new XmlRuntimeException(xmlException);
        }
    }

    public SerializerContext createSerializerContext(int n) {
        return this.createSerializerContext(n, BaseSerializerContext.DEFAULT_MARSHAL_OPTIONS);
    }

    public int elementIsSingleWildcard(XmlTypeName xmlTypeName) {
        SchemaGlobalElement schemaGlobalElement = this.mSchemaTypeLoader.findElement(xmlTypeName.getQName());
        if (schemaGlobalElement == null) {
            throw new IllegalArgumentException("GlobalElement " + xmlTypeName + " doesn't exist in the schema.");
        }
        SchemaType schemaType = schemaGlobalElement.getType();
        return WildcardUtil.schemaTypeIsSingleWildcard((SchemaType)schemaType);
    }

    public QName getLocalElementName(XmlTypeName xmlTypeName, String string) {
        SchemaGlobalElement schemaGlobalElement = this.mSchemaTypeLoader.findElement(xmlTypeName.getQName());
        if (schemaGlobalElement == null) {
            throw new IllegalArgumentException("GlobalElement " + xmlTypeName + " doesn't exist in the schema.");
        }
        SchemaType schemaType = schemaGlobalElement.getType();
        SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
        for (int i = 0; i < schemaPropertyArray.length; ++i) {
            String string2 = schemaPropertyArray[i].getName().getLocalPart();
            if (!string2.equals(string)) continue;
            if (schemaPropertyArray[i].getMaxOccurs() == null || schemaPropertyArray[i].getMaxOccurs().intValue() > 1) {
                return xmlTypeName.getQName();
            }
            return schemaPropertyArray[i].getName();
        }
        throw new IllegalArgumentException("no local element named '" + string + "' on global element " + xmlTypeName);
    }

    public XmlTypeName getLocalElementType(XmlTypeName xmlTypeName, String string) {
        SchemaGlobalElement schemaGlobalElement = this.mSchemaTypeLoader.findElement(xmlTypeName.getQName());
        if (schemaGlobalElement == null) {
            throw new IllegalArgumentException("GlobalElement " + xmlTypeName + " doesn't exist in the schema.");
        }
        SchemaType schemaType = schemaGlobalElement.getType();
        SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
        for (int i = 0; i < schemaPropertyArray.length; ++i) {
            String string2 = schemaPropertyArray[i].getName().getLocalPart();
            if (!string2.equals(string)) continue;
            if (schemaPropertyArray[i].getMaxOccurs() == null || schemaPropertyArray[i].getMaxOccurs().intValue() > 1) {
                return XmlTypeName.forSchemaType((SchemaType)schemaType);
            }
            return XmlTypeName.forSchemaType((SchemaType)schemaPropertyArray[i].getType());
        }
        throw new IllegalArgumentException("no local element named '" + string + "' on global element " + xmlTypeName);
    }

    public QName getTypeForElement(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException(" unexpected: input param elementQName is null");
        }
        SchemaGlobalElement schemaGlobalElement = this.mSchemaTypeLoader.findElement(qName);
        if (schemaGlobalElement == null) {
            return null;
        }
        SchemaType schemaType = schemaGlobalElement.getType();
        if (schemaType == null) {
            return null;
        }
        return schemaType.getName();
    }

    public SchemaType getSchemaTypeForXmlTypeName(XmlTypeName xmlTypeName) {
        return xmlTypeName.findTypeIn(this.mSchemaTypeLoader);
    }

    public boolean isSimpleType(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException(" unexpected: input param typeQName is null");
        }
        if (qName.getNamespaceURI().equals(XSD_NAMESPACE)) {
            return true;
        }
        SchemaType schemaType = this.mSchemaTypeLoader.findType(qName);
        return schemaType.isSimpleType();
    }

    public String getJavaType(XmlTypeName xmlTypeName) {
        if (xmlTypeName == null) {
            throw new IllegalArgumentException("null xmlType");
        }
        BindingTypeName bindingTypeName = this.mBindingLoader.lookupPojoFor(xmlTypeName);
        if (bindingTypeName == null) {
            String string = this.lookupXmlObjectFor(xmlTypeName);
            if (string != null) {
                return string;
            }
            if (mVerbose) {
                Verbose.log("Unknown xmlType " + xmlTypeName + " -- using String instead");
                Verbose.log("Using Binding Provider: " + this.toString());
            }
            return "java.lang.String";
        }
        return bindingTypeName.getJavaName().toString();
    }

    public boolean isOptionalLocalElement(XmlTypeName xmlTypeName, String string, WsMethod wsMethod, WsType wsType) {
        SchemaGlobalElement schemaGlobalElement = this.mSchemaTypeLoader.findElement(xmlTypeName.getQName());
        if (schemaGlobalElement == null) {
            throw new IllegalArgumentException("GlobalElement " + xmlTypeName + " doesn't exist in the schema.");
        }
        SchemaType schemaType = schemaGlobalElement.getType();
        int n = this.elementIsSingleWildcard(xmlTypeName);
        if (n == 1 || n == 2) {
            SchemaParticle schemaParticle = schemaType.getContentModel();
            if (schemaParticle != null && schemaParticle.countOfParticleChild() == 0 && schemaParticle.getParticleType() == 5) {
                return schemaParticle.getMinOccurs() != null && schemaParticle.getMinOccurs().intValue() < 1;
            }
        } else {
            if (StringUtil.isEmpty(string) && WildcardUtil.WILDCARD_CLASSNAMES.contains(wsType.getJavaType().getCanonicalName())) {
                if (wsType instanceof WsParameterType) {
                    int n2 = -1;
                    SchemaParticle[] schemaParticleArray = wsMethod.getParameters();
                    while (schemaParticleArray.hasNext()) {
                        WsType wsType2 = (WsType)schemaParticleArray.next();
                        if (wsType2 == wsType) {
                            ++n2;
                            break;
                        }
                        if (!StringUtil.isEmpty(wsType2.getName()) || !WildcardUtil.WILDCARD_CLASSNAMES.contains(wsType2.getJavaType().getCanonicalName())) continue;
                        ++n2;
                    }
                    if (n2 > -1 && schemaType.getContentModel() != null && (schemaParticleArray = schemaType.getContentModel().getParticleChildren()) != null) {
                        int n3 = 0;
                        for (int i = 0; i < schemaParticleArray.length; ++i) {
                            if (schemaParticleArray[i].countOfParticleChild() != 0 || schemaParticleArray[i].getParticleType() != 5) continue;
                            if (n3 == n2) {
                                return schemaParticleArray[i].getIntMinOccurs() < 1;
                            }
                            ++n3;
                        }
                    }
                }
                return false;
            }
            SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
            for (int i = 0; i < schemaPropertyArray.length; ++i) {
                String string2 = schemaPropertyArray[i].getName().getLocalPart();
                if (!string2.equals(string)) continue;
                if (schemaPropertyArray[i].getMaxOccurs() == null || schemaPropertyArray[i].getMaxOccurs().intValue() > 1) {
                    return schemaGlobalElement.getMinOccurs() != null && schemaGlobalElement.getMinOccurs().intValue() < 1;
                }
                return schemaPropertyArray[i].getMinOccurs() != null && schemaPropertyArray[i].getMinOccurs().intValue() < 1;
            }
        }
        return false;
    }

    private void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.writeField("binding loader", this.mBindingLoader);
        toStringWriter.end();
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    private String lookupXmlObjectFor(XmlTypeName xmlTypeName) {
        if (this.mSchemaTypeLoader == null) {
            return null;
        }
        SchemaType schemaType = this.mSchemaTypeLoader.findType(xmlTypeName.getQName());
        if (schemaType != null) {
            return schemaType.getFullJavaName();
        }
        return null;
    }

    private BindingContext getDefaultXbeanContext() {
        return BindingContextFactory.newInstance().createBindingContext();
    }

    static XMLStreamReader createReader(SOAPElement sOAPElement) throws XMLStreamException {
        if (sOAPElement == null) {
            throw new IllegalArgumentException("null SOAPElement");
        }
        return new DOMStreamReaderExt((Node)sOAPElement);
    }
}

