/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.runtime.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jws.WebMethod;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.jws.Types;
import weblogic.wsee.bind.runtime.internal.ServerTypesHandler;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class ServerTypesDeploymentListener
implements WsDeploymentListener {
    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        WsService wsService = wsDeploymentContext.getWsService();
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            try {
                if (!this.hasTypesAnnotation(wsService)) continue;
                HandlerList handlerList = wsPort.getInternalHandlerList();
                this.insertHandler(handlerList);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Failed to register SERVER_TYPES_HANDLER", handlerException);
            }
        }
    }

    private boolean hasTypesAnnotation(WsService wsService) {
        Iterator iterator = wsService.getEndpoints();
        while (iterator.hasNext()) {
            WsEndpoint wsEndpoint = (WsEndpoint)iterator.next();
            Class clazz = wsEndpoint.getJwsClass();
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!method.isAnnotationPresent(WebMethod.class)) continue;
                if (method.isAnnotationPresent(Types.class)) {
                    return true;
                }
                Annotation[][] annotationArray = method.getParameterAnnotations();
                for (int j = 0; j < annotationArray.length; ++j) {
                    Annotation[] annotationArray2 = annotationArray[j];
                    for (int k = 0; k < annotationArray2.length; ++k) {
                        Annotation annotation = annotationArray2[k];
                        if (!annotation.annotationType().equals(Types.class)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void insertHandler(HandlerList handlerList) throws HandlerException {
        HandlerInfo handlerInfo = this.getHandlerInfo();
        ArrayList arrayList = this.getPrecedingHandlers();
        ArrayList arrayList2 = this.getFollowingHandlers();
        handlerList.lenientInsert("SERVER_TYPES_HANDLER", handlerInfo, arrayList, arrayList2);
    }

    protected ArrayList getPrecedingHandlers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("CODEC_HANDLER");
        return arrayList;
    }

    protected ArrayList getFollowingHandlers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("COMPONENT_HANDLER");
        return arrayList;
    }

    protected HandlerInfo getHandlerInfo() {
        HashMap hashMap = new HashMap();
        return new HandlerInfo(ServerTypesHandler.class, hashMap, null);
    }
}

