/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.runtime.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import weblogic.jws.Types;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsMethodImpl;
import weblogic.wsee.ws.WsParameterType;
import weblogic.wsee.ws.dispatch.Dispatcher;

public class ServerTypesHandler
extends GenericHandler
implements WLHandler {
    private static List collectionTypes = new ArrayList();

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleRequest(MessageContext messageContext) {
        Dispatcher dispatcher = this.getDispatcher(messageContext);
        Map map = dispatcher.getInParams();
        WsMethodImpl wsMethodImpl = (WsMethodImpl)dispatcher.getWsMethod();
        Object[] objectArray = wsMethodImpl.getMethodArgs(map);
        List list = this.getParameterClasses(wsMethodImpl);
        Method method = this.getMethod(dispatcher, wsMethodImpl, list);
        Annotation[][] annotationArray = this.getParameterAnnotations(method);
        for (int i = 0; i < objectArray.length; ++i) {
            Class clazz;
            Object object = objectArray[i];
            if (object == null || this.isDeclaredClass(object, clazz = (Class)list.get(i))) continue;
            Annotation[] annotationArray2 = annotationArray[i];
            this.checkAnnotatedClass(object, annotationArray2);
        }
        return true;
    }

    private Annotation[][] getParameterAnnotations(Method method) {
        Annotation[][] annotationArray = method.getParameterAnnotations();
        return annotationArray;
    }

    private Method getMethod(Dispatcher dispatcher, WsMethod wsMethod, List list) {
        WsEndpoint wsEndpoint = dispatcher.getWsPort().getEndpoint();
        Class clazz = wsEndpoint.getJwsClass();
        Method method = null;
        try {
            method = clazz.getMethod(wsMethod.getOperationName().getLocalPart(), list.toArray(new Class[list.size()]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JAXRPCException("Could not get Method from operation name " + wsMethod.getOperationName().getLocalPart());
        }
        return method;
    }

    private List getParameterClasses(WsMethod wsMethod) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        Iterator iterator = wsMethod.getParameters();
        while (iterator.hasNext()) {
            WsParameterType wsParameterType = (WsParameterType)iterator.next();
            Class clazz = wsParameterType.getJavaType();
            arrayList.add(clazz);
        }
        return arrayList;
    }

    private Class getReturnClass(WsMethod wsMethod) {
        return wsMethod.getReturnType().getJavaType();
    }

    private void checkAnnotatedClass(Object object, Annotation[] annotationArray) {
        for (int i = 0; i < annotationArray.length; ++i) {
            Annotation annotation = annotationArray[i];
            if (!annotation.annotationType().equals(Types.class)) continue;
            Types types2 = (Types)annotation;
            String[] stringArray = types2.value();
            if (!this.isCollection(object.getClass())) {
                if (this.isType(object, stringArray)) continue;
                throw new JAXRPCException("Found parameter object of invalid type: " + object.getClass().getName());
            }
            Collection collection = (Collection)object;
            for (Object e : collection) {
                if (this.isType(e, stringArray)) continue;
                throw new JAXRPCException("Found object in collection parameter of invalid type: " + e.getClass().getName());
            }
        }
    }

    private boolean isDeclaredClass(Object object, Class clazz) {
        return !this.isCollection(object.getClass()) && (object.getClass().equals(clazz) || this.isInterface(object, clazz));
    }

    private boolean isInterface(Object object, Class clazz) {
        Class<?>[] classArray = object.getClass().getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz2 = classArray[i];
            if (!clazz2.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean isCollection(Class clazz) {
        return collectionTypes.contains(clazz.getName());
    }

    private boolean isType(Object object, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals(object.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    private Dispatcher getDispatcher(MessageContext messageContext) {
        WlMessageContext wlMessageContext = (WlMessageContext)messageContext;
        Dispatcher dispatcher = wlMessageContext.getDispatcher();
        return dispatcher;
    }

    public boolean handleResponse(MessageContext messageContext) {
        Dispatcher dispatcher = this.getDispatcher(messageContext);
        WsMethod wsMethod = dispatcher.getWsMethod();
        Map map = dispatcher.getOutParams();
        if (map.size() <= 0) {
            return true;
        }
        Object v = map.values().iterator().next();
        Class clazz = this.getReturnClass(wsMethod);
        List list = this.getParameterClasses(wsMethod);
        Method method = this.getMethod(dispatcher, wsMethod, list);
        Annotation[] annotationArray = method.getAnnotations();
        if (this.isDeclaredClass(v, clazz)) {
            return true;
        }
        this.checkAnnotatedClass(v, annotationArray);
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        return true;
    }

    public boolean handleClosure(MessageContext messageContext) {
        return true;
    }

    static {
        collectionTypes.add(Collection.class.getName());
        collectionTypes.add(List.class.getName());
        collectionTypes.add(ArrayList.class.getName());
        collectionTypes.add(LinkedList.class.getName());
        collectionTypes.add(Vector.class.getName());
        collectionTypes.add(Stack.class.getName());
        collectionTypes.add(Set.class.getName());
        collectionTypes.add(TreeSet.class.getName());
        collectionTypes.add(SortedSet.class.getName());
        collectionTypes.add(HashSet.class.getName());
    }
}

