/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.runtime.internal;

import com.bea.staxb.buildtime.internal.bts.BindingFile;
import com.bea.staxb.buildtime.internal.bts.BindingLoader;
import com.bea.staxb.buildtime.internal.bts.BindingType;
import com.bea.staxb.buildtime.internal.bts.BindingTypeName;
import com.bea.staxb.buildtime.internal.bts.JavaTypeName;
import com.bea.staxb.buildtime.internal.bts.SoapArrayType;
import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.xml.SchemaLocalAttribute;
import com.bea.xml.SchemaProperty;
import com.bea.xml.SchemaType;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.XmlObject;
import com.bea.xml.soap.SOAPArrayType;
import com.bea.xml.soap.SchemaWSDLArrayType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.wsee.util.Verbose;

class SoapArrayHelper {
    private static final boolean VERBOSE = Verbose.isVerbose(SoapArrayHelper.class);
    private static final QName SOAPARRAY_TYPE = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    private static String[] PRIMITIVE_TYPES = new String[]{"int", "boolean", "float", "long", "double", "short", "byte", "char"};
    private static String[] BOXED_TYPES = new String[]{"java.lang.Integer", "java.lang.Boolean", "java.lang.Float", "java.lang.Long", "java.lang.Double", "java.lang.Short", "java.lang.Byte", "java.lang.Character"};
    private static String SOAPARRAY_NAME_PREFIX = "ArrayOf";
    private BindingLoader mBindings;
    private SchemaTypeLoader mSchemaTypes;
    private BindingFile mBindingFile = null;

    static boolean isSoapArray(SchemaType schemaType) {
        while (schemaType != null) {
            String string = XmlTypeName.forSchemaType((SchemaType)schemaType).toString();
            if (string.equals("t=Array@http://schemas.xmlsoap.org/soap/encoding/") || string.startsWith("t=Array@http://www.w3.org/") && string.endsWith("/soap-encoding")) {
                return true;
            }
            schemaType = schemaType.getBaseType();
        }
        return false;
    }

    public SoapArrayHelper(SchemaTypeLoader schemaTypeLoader, BindingLoader bindingLoader, BindingFile bindingFile) {
        this.mBindings = bindingLoader;
        this.mSchemaTypes = schemaTypeLoader;
        this.mBindingFile = bindingFile;
    }

    SoapArrayType createSoapArrayType(SchemaType schemaType) {
        boolean bl;
        SOAPArrayType sOAPArrayType;
        QName qName;
        SchemaType schemaType2;
        BindingTypeName bindingTypeName;
        if (schemaType == null) {
            throw new IllegalArgumentException("null stype");
        }
        if (schemaType.getName() == null) {
            throw new IllegalArgumentException("null stype.getName()");
        }
        if (VERBOSE) {
            Verbose.banner("createSoapArrayType for " + schemaType);
        }
        XmlTypeName xmlTypeName = XmlTypeName.forSchemaType((SchemaType)schemaType);
        XmlTypeName xmlTypeName2 = SoapArrayHelper.soapArrayTypeName(schemaType);
        XmlTypeName xmlTypeName3 = xmlTypeName2.getOuterComponent();
        if (VERBOSE) {
            Verbose.log("soapArrayTypeName = " + xmlTypeName2);
            Verbose.log("itemTypeName = " + xmlTypeName3);
        }
        if ((bindingTypeName = this.mBindings.lookupPojoFor(xmlTypeName3)) == null) {
            if (VERBOSE) {
                Verbose.log("  itemBtn for '" + xmlTypeName3 + "' is NULL create one and add it.");
            }
            if ((schemaType2 = this.mSchemaTypes.findType(qName = xmlTypeName3.getQName())) == null) {
                throw new IllegalStateException("Array item type is not understood." + xmlTypeName3);
            }
            if (SoapArrayHelper.isSoapArray(schemaType2)) {
                sOAPArrayType = this.createSoapArrayType(schemaType2);
                bindingTypeName = sOAPArrayType.getName();
                this.mBindingFile.addBindingType((BindingType)sOAPArrayType, false, true);
            } else {
                throw new IllegalStateException("Array item type is not understood." + xmlTypeName3);
            }
        }
        if (VERBOSE) {
            Verbose.log("itemBtn = " + bindingTypeName);
        }
        qName = JavaTypeName.forArray((JavaTypeName)bindingTypeName.getJavaName(), (int)1);
        schemaType2 = BindingTypeName.forPair((JavaTypeName)qName, (XmlTypeName)xmlTypeName);
        sOAPArrayType = SoapArrayHelper.getWsdlArrayType(schemaType);
        BindingType bindingType = this.mBindings.getBindingType(bindingTypeName);
        if (VERBOSE) {
            Verbose.log("targetJavaName = " + qName);
            Verbose.log("soapType = " + sOAPArrayType);
            Verbose.log("targetBtn = " + schemaType2);
            Verbose.log("itemType = " + bindingType);
        }
        if (bindingTypeName == null) {
            throw new IllegalStateException("null itemBtn");
        }
        if (bindingType == null) {
            throw new IllegalStateException("null itemType");
        }
        SoapArrayType soapArrayType = new SoapArrayType((BindingTypeName)schemaType2);
        if (sOAPArrayType != null) {
            soapArrayType.setRanks(sOAPArrayType.getDimensions().length);
        } else {
            soapArrayType.setRanks(1);
        }
        SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
        boolean bl2 = bl = schemaPropertyArray.length == 1;
        if (bl) {
            soapArrayType.setItemName(schemaPropertyArray[0].getName());
            soapArrayType.setItemNillable(schemaPropertyArray[0].hasNillable() != 0);
        }
        if (bindingType != null) {
            if (bl) {
                if (soapArrayType.isItemNillable()) {
                    bindingType = this.findBoxedType(bindingType);
                }
            } else {
                JavaTypeName javaTypeName = this.getBoxedName(bindingType.getName().getJavaName());
                if (javaTypeName == null) {
                    soapArrayType.setItemNillable(true);
                } else {
                    soapArrayType.setItemNillable(false);
                }
            }
            soapArrayType.setItemType(bindingType.getName());
        }
        return soapArrayType;
    }

    List createSoapArrayType(JavaTypeName javaTypeName, SchemaType schemaType) {
        boolean bl;
        JavaTypeName javaTypeName2;
        if (VERBOSE) {
            Verbose.banner("createSoapArrayType for " + schemaType);
        }
        ArrayList<SoapArrayType> arrayList = new ArrayList<SoapArrayType>();
        XmlTypeName xmlTypeName = XmlTypeName.forSchemaType((SchemaType)schemaType);
        XmlTypeName xmlTypeName2 = SoapArrayHelper.soapArrayTypeName(schemaType);
        XmlTypeName xmlTypeName3 = xmlTypeName2.getOuterComponent();
        int n = xmlTypeName2.getSoapArrayRankAt(1);
        int n2 = javaTypeName.getArrayDepth();
        if (VERBOSE) {
            Verbose.log("schemaType        = " + schemaType);
            Verbose.log("array Dimension   = " + n2);
            Verbose.log("soapArrayTypeName = " + xmlTypeName2);
            Verbose.log("soapArrayTypeName rank = '" + n + "'");
            Verbose.log("itemTypeName      = " + xmlTypeName3);
        }
        JavaTypeName javaTypeName3 = javaTypeName.getArrayItemType(n2);
        SOAPArrayType sOAPArrayType = SoapArrayHelper.getWsdlArrayType(schemaType);
        int[] nArray = sOAPArrayType == null ? new int[]{} : sOAPArrayType.getRanks();
        int n3 = nArray.length - 1;
        int n4 = n3 < 0 ? 1 : nArray[n3];
        int n5 = n2 - n4;
        if (VERBOSE) {
            Verbose.log(" soapType from WsdlArrayType was " + (sOAPArrayType == null ? "" : "not ") + "NULL. \n" + "ranks.length = '" + nArray.length + "', rankIndex = '" + n3 + "', arrayRank = '" + n4 + "', subArrayDimension = arrayDimension - arrayRank = '" + n5 + "'.");
        }
        if (xmlTypeName3.getComponentType() == 121) {
            if (VERBOSE) {
                Verbose.log("\n process itemTypeName '" + xmlTypeName3 + "' as XmlTypName.SOAP_ARRAY type.");
            }
            if (n5 > 0) {
                javaTypeName3 = javaTypeName.getArrayTypeOfDimension(n5);
            }
        } else {
            if (VERBOSE) {
                Verbose.log("\n process itemTypeName '" + xmlTypeName3 + "' as a NON XmlTypName.SOAP_ARRAY type.");
            }
            if ((javaTypeName2 = this.computeItemJavaNameFromSoapArrayRank(xmlTypeName2, javaTypeName)) != null) {
                if (VERBOSE) {
                    Verbose.log("check whether we should use the alternate item java name '" + javaTypeName2 + "' instead.");
                }
                if (javaTypeName2.getArrayDepth() != javaTypeName3.getArrayDepth()) {
                    javaTypeName3 = javaTypeName2;
                    if (VERBOSE) {
                        Verbose.log(" using alternate item java name '" + javaTypeName2 + "'");
                    }
                } else if (VERBOSE) {
                    Verbose.log(" using default item java name '" + javaTypeName3 + "'");
                }
            }
            if (VERBOSE) {
                Verbose.log(" itemJavaName will be '" + javaTypeName3 + "'");
            }
        }
        javaTypeName2 = BindingTypeName.forPair((JavaTypeName)javaTypeName3, (XmlTypeName)xmlTypeName3);
        BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
        SoapArrayType soapArrayType = new SoapArrayType(bindingTypeName);
        if (VERBOSE) {
            Verbose.log("javaName = " + javaTypeName);
            Verbose.log("soapType = " + sOAPArrayType);
            Verbose.log("targetBtn = " + bindingTypeName);
            Verbose.log("itemBtn = " + javaTypeName2);
        }
        soapArrayType.setName(bindingTypeName);
        soapArrayType.setItemType((BindingTypeName)javaTypeName2);
        if (sOAPArrayType != null) {
            soapArrayType.setRanks(sOAPArrayType.getDimensions().length);
        } else {
            soapArrayType.setRanks(1);
        }
        boolean bl2 = false;
        SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
        boolean bl3 = bl = schemaPropertyArray.length == 1;
        if (bl) {
            soapArrayType.setItemName(schemaPropertyArray[0].getName());
            bl2 = schemaPropertyArray[0].hasNillable() != 0;
            soapArrayType.setItemNillable(bl2);
        }
        arrayList.add(soapArrayType);
        if (xmlTypeName3.getComponentType() == 121 && n5 > 0) {
            this.createSoapArrayType(arrayList, xmlTypeName3, javaTypeName3, nArray, --n3, bl2);
        }
        return arrayList;
    }

    private JavaTypeName computeItemJavaNameFromSoapArrayRank(XmlTypeName xmlTypeName, JavaTypeName javaTypeName) {
        if (xmlTypeName == null) {
            return null;
        }
        if (javaTypeName == null) {
            return null;
        }
        XmlTypeName xmlTypeName2 = xmlTypeName.getOuterComponent();
        QName qName = xmlTypeName2.getQName();
        String string = qName.getLocalPart();
        int n = xmlTypeName.getSoapArrayRankAt(1);
        int n2 = javaTypeName.getArrayDepth();
        if (VERBOSE) {
            Verbose.log(" computeItemJavaNameFromSoapArrayRank:  arrayTypeName '" + xmlTypeName + "', arrayJavaName '" + javaTypeName + "', arrayDimension '" + n2 + "', soapArrayRank '" + n + "'");
        }
        assert (n > 0);
        if (n <= 0) {
            return null;
        }
        if (n2 < n) {
            if (VERBOSE) {
                Verbose.log(" unexpected condition !   arrayDimension = '" + n2 + "' is less than the soapArrayRank = '" + n + "' abandoning alternate java itemArray type computation");
            }
            return null;
        }
        int n3 = n2 - n;
        JavaTypeName javaTypeName2 = javaTypeName.getArrayItemType(n2);
        String string2 = "";
        for (int i = 0; i < n3; ++i) {
            string2 = string2 + "[]";
        }
        String string3 = javaTypeName2.getClassName() + string2;
        if (VERBOSE) {
            Verbose.log(" computeJavaNameFromArrayOfItemName   returning JavaTypeName for java class: '" + string3 + "', JTN = '" + JavaTypeName.forString((String)string3) + "'");
        }
        return JavaTypeName.forString((String)string3);
    }

    private String printIntArray(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(" int[" + i + "] is '" + nArray[i] + "',  ");
        }
        return stringBuffer.toString();
    }

    private void createSoapArrayType(List list, XmlTypeName xmlTypeName, JavaTypeName javaTypeName, int[] nArray, int n, boolean bl) {
        int n2 = n < 0 ? 1 : nArray[n];
        int n3 = javaTypeName.getArrayDepth() - n2;
        JavaTypeName javaTypeName2 = javaTypeName.getArrayTypeOfDimension(n3);
        XmlTypeName xmlTypeName2 = xmlTypeName.getOuterComponent();
        if (VERBOSE) {
            Verbose.log(" createSoapArrayType   typeName is '" + xmlTypeName + "' javaName is '" + javaTypeName + "', itemTypeName is '" + xmlTypeName2 + "', itemJavaName is '" + javaTypeName2 + "', ranks is '" + n2 + "'");
        }
        BindingTypeName bindingTypeName = BindingTypeName.forPair((JavaTypeName)javaTypeName, (XmlTypeName)xmlTypeName);
        BindingTypeName bindingTypeName2 = BindingTypeName.forPair((JavaTypeName)javaTypeName2, (XmlTypeName)xmlTypeName2);
        SoapArrayType soapArrayType = new SoapArrayType(bindingTypeName);
        soapArrayType.setName(bindingTypeName);
        soapArrayType.setItemNillable(bl);
        soapArrayType.setItemType(bindingTypeName2);
        soapArrayType.setRanks(n2);
        list.add(soapArrayType);
        if (n3 > 0) {
            this.createSoapArrayType(list, xmlTypeName2, javaTypeName2, nArray, --n, bl);
        }
    }

    void checkArrayItem(SoapArrayType soapArrayType) {
        BindingType bindingType = this.mBindings.getBindingType(soapArrayType.getItemType());
        if (bindingType == null) {
            throw new IllegalStateException("For ArrayType '" + soapArrayType + "', Array item type " + bindingType + " is not mapped in jaxrpc mapping file.");
        }
        if (soapArrayType.isItemNillable()) {
            bindingType = this.findBoxedType(bindingType);
            soapArrayType.setItemType(bindingType.getName());
        }
    }

    private JavaTypeName getBoxedName(JavaTypeName javaTypeName) {
        for (int i = 0; i < PRIMITIVE_TYPES.length; ++i) {
            if (!PRIMITIVE_TYPES[i].equals(javaTypeName.toString())) continue;
            return JavaTypeName.forString((String)BOXED_TYPES[i]);
        }
        return null;
    }

    private BindingType findBoxedType(BindingType bindingType) {
        BindingTypeName bindingTypeName = bindingType.getName();
        JavaTypeName javaTypeName = bindingTypeName.getJavaName();
        BindingType bindingType2 = null;
        JavaTypeName javaTypeName2 = this.getBoxedName(javaTypeName);
        if (javaTypeName2 != null) {
            BindingTypeName bindingTypeName2 = BindingTypeName.forPair((JavaTypeName)javaTypeName2, (XmlTypeName)bindingTypeName.getXmlName());
            bindingType2 = this.mBindings.getBindingType(bindingTypeName2);
            if (bindingType2 != null) {
                return bindingType2;
            }
            throw new IllegalStateException();
        }
        return bindingType;
    }

    private static XmlTypeName soapArrayTypeName(SchemaType schemaType) {
        SOAPArrayType sOAPArrayType = SoapArrayHelper.getWsdlArrayType(schemaType);
        if (sOAPArrayType != null) {
            if (VERBOSE) {
                Verbose.log(" wsdlArrayType is not NULL, returning XmlTypeName.forSoapArrayType = '" + XmlTypeName.forSoapArrayType((SOAPArrayType)sOAPArrayType) + "'");
            }
            return XmlTypeName.forSoapArrayType((SOAPArrayType)sOAPArrayType);
        }
        if (VERBOSE) {
            Verbose.log(" wsdlArrayType is NULL, get soapArrayType name by other means.");
        }
        SchemaType schemaType2 = XmlObject.type;
        SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
        if (schemaPropertyArray.length == 1) {
            schemaType2 = schemaPropertyArray[0].getType();
        }
        return XmlTypeName.forNestedNumber((char)'y', (int)1, (XmlTypeName)XmlTypeName.forSchemaType((SchemaType)schemaType2));
    }

    private static SOAPArrayType getWsdlArrayType(SchemaType schemaType) {
        SchemaLocalAttribute schemaLocalAttribute = schemaType.getAttributeModel().getAttribute(SOAPARRAY_TYPE);
        if (schemaLocalAttribute != null) {
            return ((SchemaWSDLArrayType)schemaLocalAttribute).getWSDLArrayType();
        }
        return null;
    }
}

