/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.types;

import com.bea.xml.XmlException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.bind.runtime.DeserializerContext;
import weblogic.wsee.bind.runtime.SerializerContext;
import weblogic.wsee.bind.types.AttachmentBase;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

public abstract class ArrayAttachmentBase
extends AttachmentBase {
    private static final boolean verbose = Verbose.isVerbose(ArrayAttachmentBase.class);

    abstract AttachmentPart createAttachmentPart(String var1, SOAPMessage var2, Object var3, String var4) throws XmlException;

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }

    public void serializeType(SOAPElement sOAPElement, Object object, Class clazz, QName qName, QName qName2, SerializerContext serializerContext, String string) throws XmlException {
        if (verbose) {
            Verbose.log("name = " + qName2);
        }
        SOAPElement sOAPElement2 = this.addChildElement(sOAPElement, qName2);
        if (object != null) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                String string2 = qName2.getLocalPart() + "[" + i + "]";
                this.serializeArrayItem(sOAPElement2, object2, serializerContext, string2, string);
            }
        }
    }

    private void serializeArrayItem(SOAPElement sOAPElement, Object object, SerializerContext serializerContext, String string, String string2) throws XmlException {
        SOAPElement sOAPElement2 = this.addChildElement(sOAPElement, new QName("attachment-item"));
        if (object != null) {
            this.writeHref(serializerContext.getMessage(), sOAPElement2, string);
            SOAPMessage sOAPMessage = serializerContext.getMessage();
            AttachmentPart attachmentPart = this.createAttachmentPart(string, sOAPMessage, object, string2);
            sOAPMessage.addAttachmentPart(attachmentPart);
        }
    }

    public Object deserializeType(SOAPElement sOAPElement, Class clazz, QName qName, DeserializerContext deserializerContext) throws XmlException {
        Iterator iterator = sOAPElement.getChildElements();
        if (!iterator.hasNext()) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPElement)) continue;
            SOAPElement sOAPElement2 = (SOAPElement)e;
            Object object = this.deserializeArrayItem(sOAPElement2, deserializerContext);
            arrayList.add(object);
        }
        return this.toArray(arrayList);
    }

    private Object deserializeArrayItem(SOAPElement sOAPElement, DeserializerContext deserializerContext) throws XmlException {
        Object object = null;
        SOAPMessage sOAPMessage = deserializerContext.getMessage();
        Name name = null;
        try {
            name = sOAPMessage.getSOAPPart().getEnvelope().createName("href");
        }
        catch (SOAPException sOAPException) {
            throw new XmlException("Failed to get href from SOAP envelope", (Throwable)sOAPException);
        }
        String string = sOAPElement.getAttributeValue(name);
        if (string != null && !"".equals(string)) {
            object = this.deserializeItem(string, sOAPMessage, object);
        }
        return object;
    }

    private Object deserializeItem(String string, SOAPMessage sOAPMessage, Object object) throws XmlException {
        string = this.cleanCID(string);
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.addHeader("Content-Id", string);
        Iterator iterator = sOAPMessage.getAttachments(mimeHeaders);
        if (iterator.hasNext()) {
            object = this.deserializeAttachmentPart((AttachmentPart)iterator.next());
        }
        if (iterator.hasNext()) {
            throw new XmlException("Found more than one attachment part");
        }
        return object;
    }

    private String cleanCID(String string) {
        if (string.startsWith("cid:")) {
            return string.substring("cid:".length());
        }
        return string;
    }

    abstract Object[] toArray(ArrayList var1);
}

