/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.types;

import com.bea.xml.XmlException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Node;
import weblogic.wsee.bind.SchemaConstants;
import weblogic.wsee.bind.runtime.DeserializerContext;
import weblogic.wsee.bind.runtime.SerializerContext;
import weblogic.wsee.bind.types.TypeMapper;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

public abstract class AttachmentBase
implements TypeMapper {
    private static final boolean verbose = Verbose.isVerbose(AttachmentBase.class);
    private static final QName XOP_INCLUDE_QNAME = new QName("http://www.w3.org/2004/08/xop/include", "Include");

    protected SOAPElement addChildElement(SOAPElement sOAPElement, QName qName) throws XmlException {
        SOAPElement sOAPElement2;
        try {
            sOAPElement2 = sOAPElement.addChildElement(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            throw new XmlException("Failed to serialize source array", (Throwable)sOAPException);
        }
        return sOAPElement2;
    }

    public void serializeType(SOAPElement sOAPElement, Object object, Class clazz, QName qName, QName qName2, SerializerContext serializerContext, boolean bl, String string) throws XmlException {
        SOAPElement sOAPElement2 = this.addChildElement(sOAPElement, qName2);
        SOAPMessage sOAPMessage = serializerContext.getMessage();
        if (object != null) {
            String string2 = qName.getLocalPart();
            String string3 = null;
            string3 = qName2.getLocalPart();
            this.writeHref(sOAPMessage, sOAPElement2, string3);
            AttachmentPart attachmentPart = this.createAttachmentPart(this.addAngleBrackets(string3), sOAPMessage, object, string);
            sOAPMessage.addAttachmentPart(attachmentPart);
        }
    }

    protected void writeHref(SOAPMessage sOAPMessage, SOAPElement sOAPElement, String string) throws XmlException {
        try {
            Name name = sOAPMessage.getSOAPPart().getEnvelope().createName("href");
            sOAPElement.addAttribute(name, "cid:" + string);
        }
        catch (SOAPException sOAPException) {
            throw new XmlException("Failed to add href attribute", (Throwable)sOAPException);
        }
    }

    abstract AttachmentPart createAttachmentPart(String var1, SOAPMessage var2, Object var3, String var4) throws XmlException;

    public Object deserializeType(SOAPElement sOAPElement, Class clazz, QName qName, DeserializerContext deserializerContext, boolean bl) throws XmlException {
        String string;
        if (verbose) {
            string = DOMUtils.toXMLString((Node)sOAPElement);
            Verbose.log(" deserializeType called with SOAPElement " + string + "\n");
        }
        string = this.getCid(sOAPElement);
        if (verbose) {
            Verbose.log("CID = " + string);
        }
        if (string == null) {
            return null;
        }
        SOAPMessage sOAPMessage = deserializerContext.getMessage();
        Iterator iterator = sOAPMessage.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
            if (verbose) {
                this.dumpHeader(attachmentPart);
            }
            if (('<' + string + '>').equals(attachmentPart.getContentId())) {
                return this.deserializeAttachmentPart(attachmentPart);
            }
            if (!string.equals(attachmentPart.getContentId())) continue;
            return this.deserializeAttachmentPart(attachmentPart);
        }
        throw new XmlException("Unable to find attachment part for href = " + string);
    }

    public void serializeElement(SOAPElement sOAPElement, Object object, Class clazz, QName qName, SerializerContext serializerContext, boolean bl, String string) throws XMLStreamException, XmlException {
        this.serializeType(sOAPElement, object, clazz, SchemaConstants.any, qName, serializerContext, bl, string);
    }

    public Object deserializeElement(SOAPElement sOAPElement, Class clazz, QName qName, DeserializerContext deserializerContext, boolean bl) throws XmlException, XMLStreamException {
        return this.deserializeType(sOAPElement, clazz, SchemaConstants.any, deserializerContext, bl);
    }

    private void dumpHeader(AttachmentPart attachmentPart) {
        Iterator iterator = attachmentPart.getAllMimeHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            Verbose.log("Mime Header: " + mimeHeader.getName() + " = " + mimeHeader.getValue());
        }
    }

    abstract Object deserializeAttachmentPart(AttachmentPart var1) throws XmlException;

    abstract Object deserializeBase64Binary(String var1) throws XmlException;

    private String getCid(SOAPElement sOAPElement) {
        String string = sOAPElement.getAttribute("href");
        if (string == null || "".equals(string)) {
            return null;
        }
        if (string.startsWith("cid:")) {
            return string.substring("cid:".length(), string.length());
        }
        return string;
    }

    private String addAngleBrackets(String string) {
        String string2 = string;
        if (string2 != null && string2.length() > 0 && (string2.charAt(0) != '<' || string2.charAt(string2.length() - 1) != '>')) {
            string2 = '<' + string2 + '>';
        }
        return string2;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }
}

