/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.types;

import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import com.bea.xml.XmlException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.bind.runtime.DeserializerContext;
import weblogic.wsee.bind.runtime.SerializerContext;
import weblogic.wsee.bind.types.TypeMapper;
import weblogic.wsee.util.Verbose;

public class SOAPElementArrayTypeMapper
implements TypeMapper {
    private static final boolean verbose = Verbose.isVerbose(SOAPElementArrayTypeMapper.class);
    private static boolean WRITE_ELEMENT_WILDCARD_ARRAY_WRAPPER = false;
    private static final QName anyElementWildCardArrayElementQName = XmlTypeName.forElementWildCardArrayElement().getQName();
    private static final QName anyElementWildCardArrayTypeQName = XmlTypeName.forElementWildCardArrayType().getQName();
    static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";

    public void serializeType(SOAPElement sOAPElement, Object object, Class clazz, QName qName, QName qName2, SerializerContext serializerContext, boolean bl, String string) throws XmlException {
        this.serialize(object, sOAPElement, qName2, qName);
    }

    private void serialize(Object object, SOAPElement sOAPElement, QName qName, QName qName2) throws XmlException {
        SOAPElement sOAPElement2;
        boolean bl;
        if (verbose) {
            Verbose.here();
        }
        boolean bl2 = bl = !qName2.equals(anyElementWildCardArrayElementQName) && !qName2.equals(anyElementWildCardArrayTypeQName) || qName2.equals(anyElementWildCardArrayElementQName) || qName2.equals(anyElementWildCardArrayTypeQName) && WRITE_ELEMENT_WILDCARD_ARRAY_WRAPPER;
        if (verbose) {
            Verbose.log(" xmlTypeOrXmlElementQName='" + qName2 + "'");
        }
        if (bl) {
            if (verbose) {
                Verbose.log("writing SOAPElement array wrapper " + qName.getNamespaceURI() + " ; " + qName.getLocalPart());
            }
            try {
                sOAPElement2 = sOAPElement.addChildElement(qName.getLocalPart(), "", qName.getNamespaceURI());
                if (object == null) {
                    sOAPElement2.setAttributeNS(XSI_NS, "xsi:nil", "true");
                    return;
                }
            }
            catch (Exception exception) {
                throw new XmlException("Failed to add array wrapper element", (Throwable)exception);
            }
            sOAPElement = sOAPElement2;
        } else if (verbose) {
            Verbose.log("for element wildcard <any/> NOT writing SOAPElement array wrapper " + qName.getNamespaceURI() + " ; " + qName.getLocalPart());
        }
        if (object instanceof SOAPElement[]) {
            sOAPElement2 = (SOAPElement)object;
            try {
                for (int i = 0; i < ((SOAPElement)sOAPElement2).length; ++i) {
                    sOAPElement.addChildElement(sOAPElement2[i]);
                }
            }
            catch (SOAPException sOAPException) {
                throw new XmlException("Failed to add child SOAPElement to SOAPArray wrapper, " + (Object)((Object)sOAPException));
            }
        } else if (object == null) {
            sOAPElement.setAttributeNS(XSI_NS, "xsi:nil", "true");
        } else {
            throw new XmlException("object type unknown: " + object.getClass());
        }
    }

    public SOAPElement[] deserializeType(SOAPElement sOAPElement, Class clazz, QName qName, DeserializerContext deserializerContext, boolean bl) throws XmlException {
        if (verbose) {
            Verbose.here();
        }
        return this.deserializeElement(sOAPElement, clazz, qName, deserializerContext, bl);
    }

    public void serializeElement(SOAPElement sOAPElement, Object object, Class clazz, QName qName, SerializerContext serializerContext, boolean bl, String string) throws XMLStreamException, XmlException {
        this.serialize(object, sOAPElement, qName, qName);
    }

    public SOAPElement[] deserializeElement(SOAPElement sOAPElement, Class clazz, QName qName, DeserializerContext deserializerContext, boolean bl) throws XmlException {
        SOAPElement[] sOAPElementArray;
        if (verbose) {
            Verbose.here();
        }
        if (sOAPElement == null) {
            return null;
        }
        if (SOAPElementArrayTypeMapper.hasXsiNil((Node)sOAPElement)) {
            return null;
        }
        ArrayList<SOAPElement[]> arrayList = new ArrayList<SOAPElement[]>();
        NodeList nodeList = sOAPElement.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            sOAPElementArray = nodeList.item(i);
            arrayList.add(sOAPElementArray);
        }
        SOAPElement[] sOAPElementArray2 = (SOAPElement[])Array.newInstance(SOAPElement.class, n);
        sOAPElementArray = arrayList.toArray(sOAPElementArray2);
        return sOAPElementArray;
    }

    private static boolean hasXsiNil(Node node) {
        if (!node.hasAttributes()) {
            return false;
        }
        Node node2 = node.getAttributes().getNamedItemNS(XSI_NS, "nil");
        if (node2 == null) {
            return false;
        }
        if (node2.getNodeType() != 2) {
            return false;
        }
        String string = node2.getNodeValue();
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("true");
    }
}

