/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.types;

import com.bea.xml.XmlException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import weblogic.utils.CharsetMap;
import weblogic.utils.io.XMLDeclaration;
import weblogic.wsee.bind.types.AttachmentBase;
import weblogic.wsee.util.ToStringWriter;

public class SourceTypeMapper
extends AttachmentBase {
    protected static final URL DUMMY_URL;
    private static final int STREAM_BUFFER_SIZE = 256;
    private static final int MARK_READLIMIT = 128;
    private static final String DEFAULT_ENCODING = "utf-8";

    AttachmentPart createAttachmentPart(String string, SOAPMessage sOAPMessage, Object object, String string2) throws XmlException {
        Source source = (Source)object;
        if (!(source instanceof StreamSource)) {
            throw new XmlException("unsupported source " + source);
        }
        StreamSource streamSource = (StreamSource)source;
        AttachmentPart attachmentPart = this.createAttachmentFromStreamSource(streamSource, string, sOAPMessage);
        attachmentPart.setContentId(string);
        attachmentPart.setMimeHeader("Content-Transfer-Encoding", "binary");
        return attachmentPart;
    }

    private AttachmentPart createAttachmentFromStreamSource(StreamSource streamSource, String string, SOAPMessage sOAPMessage) throws XmlException {
        Reader reader = streamSource.getReader();
        if (reader != null) {
            return this.createReaderAttachment(reader, string, sOAPMessage);
        }
        InputStream inputStream = streamSource.getInputStream();
        if (inputStream != null) {
            return this.createInputStreamAttachment(inputStream, string, sOAPMessage);
        }
        String string2 = streamSource.getSystemId();
        if (string2 != null) {
            InputStream inputStream2 = this.getInputStreamFromSystemId(string2);
            return this.createInputStreamAttachment(inputStream2, string, sOAPMessage);
        }
        throw new XmlException("no valid contents found in StreamSource: " + streamSource);
    }

    private InputStream getInputStreamFromSystemId(String string) throws XmlException {
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            return inputStream;
        }
        catch (IOException iOException) {
            throw new XmlException("error retreiving system id " + string, (Throwable)iOException);
        }
    }

    private AttachmentPart createReaderAttachment(Reader reader, String string, SOAPMessage sOAPMessage) throws XmlException {
        try {
            if (!reader.markSupported()) {
                reader = new BufferedReader(reader, 256);
            }
            reader.mark(128);
            XMLDeclaration xMLDeclaration = new XMLDeclaration();
            xMLDeclaration.parse(reader);
            String string2 = xMLDeclaration.getEncoding();
            if (string2 == null) {
                string2 = DEFAULT_ENCODING;
            }
            reader.reset();
            ReaderDataHandler readerDataHandler = new ReaderDataHandler(string, reader, string2);
            AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart((DataHandler)readerDataHandler);
            attachmentPart.setMimeHeader("Content-Type", SourceTypeMapper.createTextXmlContentType(string2));
            return attachmentPart;
        }
        catch (IOException iOException) {
            throw new XmlException("error creating attachment " + string, (Throwable)iOException);
        }
    }

    private AttachmentPart createInputStreamAttachment(InputStream inputStream, String string, SOAPMessage sOAPMessage) throws XmlException {
        ISDataSource iSDataSource;
        try {
            iSDataSource = new ISDataSource(inputStream, string);
        }
        catch (IOException iOException) {
            throw new XmlException("error creating attachment for " + string, (Throwable)iOException);
        }
        DataHandler dataHandler = new DataHandler((DataSource)iSDataSource);
        return sOAPMessage.createAttachmentPart(dataHandler);
    }

    Object deserializeBase64Binary(String string) throws XmlException {
        throw new XmlException(" deserializing SourceType from xs:base64Binary type not supported");
    }

    protected static String createTextXmlContentType(String string) {
        return "text/xml; charset=\"" + string + "\"";
    }

    Object deserializeAttachmentPart(AttachmentPart attachmentPart) throws XmlException {
        try {
            Object object = attachmentPart.getContent();
            if (object instanceof StreamSource) {
                return (StreamSource)object;
            }
            if (object instanceof InputStream) {
                return new StreamSource((InputStream)object);
            }
            throw new SOAPException("the Source content from the attachment is bad class type,the type should be StreamSource orInputStream. ");
        }
        catch (SOAPException sOAPException) {
            throw new XmlException("Failed to get Source content from the attachment", (Throwable)sOAPException);
        }
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }

    static {
        try {
            DUMMY_URL = new URL("file:/nowhere");
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    private static final class ISDataSource
    implements DataSource {
        private final InputStream inputStream;
        private final String name;
        private final String contentType;

        public ISDataSource(InputStream inputStream, String string) throws IOException {
            this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream, 256);
            assert (inputStream.markSupported());
            this.name = string;
            this.contentType = ISDataSource.extractContentType(this.inputStream);
            assert (this.contentType != null);
        }

        private static String extractContentType(InputStream inputStream) throws IOException {
            inputStream.mark(128);
            XMLDeclaration xMLDeclaration = new XMLDeclaration(inputStream);
            String string = xMLDeclaration.getEncoding();
            inputStream.reset();
            if (string == null) {
                string = SourceTypeMapper.DEFAULT_ENCODING;
            }
            return SourceTypeMapper.createTextXmlContentType(string);
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        public String getName() {
            return this.name;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ReaderDataHandler
    extends DataHandler {
        private final String name;
        private final Reader reader;
        private final String encoding;

        public ReaderDataHandler(String string, Reader reader, String string2) {
            super(DUMMY_URL);
            assert (reader != null);
            assert (string2 != null);
            this.name = string;
            this.reader = reader;
            this.encoding = string2;
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            assert (this.encoding != null);
            String string = CharsetMap.getJavaFromIANA((String)this.encoding);
            Charset charset = Charset.forName(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset);
            char[] cArray = new char[256];
            int n = 0;
            while (-1 != (n = this.reader.read(cArray))) {
                outputStreamWriter.write(cArray, 0, n);
            }
            outputStreamWriter.close();
        }

        public String getName() {
            return this.name;
        }
    }
}

