/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.bind.types;

import com.bea.xml.XmlException;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import weblogic.wsee.bind.runtime.DeserializerContext;
import weblogic.wsee.bind.runtime.SerializerContext;
import weblogic.wsee.bind.types.DataHandlerArrayTypeMapper;
import weblogic.wsee.bind.types.DataHandlerTypeMapper;
import weblogic.wsee.bind.types.ImageArrayTypeMapper;
import weblogic.wsee.bind.types.ImageTypeMapper;
import weblogic.wsee.bind.types.MimeMultipartArrayTypeMapper;
import weblogic.wsee.bind.types.MimeMultipartTypeMapper;
import weblogic.wsee.bind.types.SOAPElementArrayTypeMapper;
import weblogic.wsee.bind.types.SOAPElementTypeMapper;
import weblogic.wsee.bind.types.SourceArrayTypeMapper;
import weblogic.wsee.bind.types.SourceTypeMapper;
import weblogic.wsee.bind.types.TypeMapper;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;

public class TypeRegistry {
    private static final boolean verbose = Verbose.isVerbose(TypeRegistry.class);
    private static final String BYTEARRAY_CLASSNAME = byte[].class.getName();
    private static TypeRegistry registry = new TypeRegistry();
    private Map javaTypeMapping = new HashMap();

    private TypeRegistry() {
        if (verbose) {
            Verbose.log("Creating type registry");
        }
        this.register(Source.class, null, new SourceTypeMapper());
        this.register(Source[].class, null, new SourceArrayTypeMapper());
        this.register(DataHandler.class, null, new DataHandlerTypeMapper());
        this.register(DataHandler[].class, null, new DataHandlerArrayTypeMapper());
        this.register(Image.class, null, new ImageTypeMapper());
        this.register(Image[].class, null, new ImageArrayTypeMapper());
        this.register(MimeMultipart.class, null, new MimeMultipartTypeMapper());
        this.register(MimeMultipart[].class, null, new MimeMultipartArrayTypeMapper());
        this.register(SOAPElement.class, null, new SOAPElementTypeMapper());
        this.register(SOAPElement[].class, null, new SOAPElementArrayTypeMapper());
    }

    public static TypeRegistry getInstance() {
        return registry;
    }

    public void register(Class clazz, QName qName, TypeMapper typeMapper) {
        if (clazz == null) {
            throw new IllegalArgumentException("javaType can not be null");
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException("mapper can not be null");
        }
        this.javaTypeMapping.put(clazz, typeMapper);
    }

    public void serializeType(SOAPElement sOAPElement, Object object, Class clazz, QName qName, QName qName2, SerializerContext serializerContext, boolean bl, String string) throws XmlException {
        TypeMapper typeMapper = this.getMapper(clazz);
        typeMapper.serializeType(sOAPElement, object, clazz, qName, qName2, serializerContext, bl, string);
    }

    private TypeMapper getMapper(Class clazz) {
        TypeMapper typeMapper = (TypeMapper)this.javaTypeMapping.get(clazz);
        if (typeMapper == null) {
            throw new IllegalArgumentException("Unable to find type mapper for class: " + clazz);
        }
        return typeMapper;
    }

    public Object deserializeType(SOAPElement sOAPElement, Class clazz, QName qName, DeserializerContext deserializerContext, boolean bl) throws XmlException {
        TypeMapper typeMapper = this.getMapper(clazz);
        return typeMapper.deserializeType(sOAPElement, clazz, qName, deserializerContext, bl);
    }

    public boolean isWellKnownType(Class clazz, QName qName, boolean bl) {
        if (verbose) {
            Verbose.logArgs("javaType", clazz, "xmlType", qName, "useMTOMmessage", bl);
        }
        if (clazz.getName().equals(BYTEARRAY_CLASSNAME) && !bl) {
            return false;
        }
        return this.javaTypeMapping.containsKey(clazz);
    }

    public boolean isWellKnownElement(Class clazz, QName qName, boolean bl) {
        if (verbose) {
            Verbose.logArgs("javaType", clazz, "xmlElement", qName, "useMTOMmessage", bl);
        }
        if (clazz.getName().equals(BYTEARRAY_CLASSNAME) && !bl) {
            return false;
        }
        return this.javaTypeMapping.containsKey(clazz);
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }

    public void serializeElement(SOAPElement sOAPElement, Object object, Class clazz, QName qName, SerializerContext serializerContext, boolean bl, String string) throws XmlException, XMLStreamException {
        TypeMapper typeMapper = this.getMapper(clazz);
        if (typeMapper == null) {
            throw new AssertionError((Object)"Mapper can not be null");
        }
        typeMapper.serializeElement(sOAPElement, object, clazz, qName, serializerContext, bl, string);
    }

    public Object deserializeElement(SOAPElement sOAPElement, Class clazz, QName qName, DeserializerContext deserializerContext, boolean bl) throws XmlException, XMLStreamException {
        TypeMapper typeMapper = this.getMapper(clazz);
        if (typeMapper == null) {
            throw new AssertionError((Object)"Mapper can not be null");
        }
        return typeMapper.deserializeElement(sOAPElement, clazz, qName, deserializerContext, bl);
    }
}

