/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer;

import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.xml.rpc.JAXRPCException;
import weblogic.ejb.spi.JmsMessageDrivenBean;
import weblogic.jms.extensions.WLSession;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.buffer.NoRetryException;
import weblogic.wsee.jws.RetryException;
import weblogic.wsee.jws.container.Duration;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;

public abstract class BaseDispatchMDB
implements JmsMessageDrivenBean,
MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 8642792753370642882L;
    private WLSession session = null;
    private static final boolean verbose = Verbose.isVerbose(BaseDispatchMDB.class);

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) {
    }

    public void ejbRemove() {
        if (verbose) {
            Verbose.log("BaseDispatchMDB removed");
        }
    }

    public void ejbCreate() throws CreateException {
        if (verbose) {
            Verbose.log("BaseDispatchMDB created");
        }
    }

    public void onMessage(Message message) {
        long l = System.nanoTime();
        if (verbose) {
            Verbose.say(l + " Entering BaseDispatchMDB.onMessage()");
        }
        boolean bl = true;
        long l2 = 0L;
        String string = null;
        try {
            string = message.getStringProperty("ASYNC_URI");
            if (verbose) {
                Verbose.say(l + " Deliver message to " + string);
            }
            if (verbose) {
                Verbose.say(l + " Before calling onMessage(targetURI, message) from within BaseDispatchMDB.onMessage()");
            }
            this.onMessage(string, message);
            if (verbose) {
                Verbose.say(l + " After calling onMessage(targetURI, message) from within BaseDispatchMDB.onMessage()");
            }
        }
        catch (NoRetryException noRetryException) {
            assert (noRetryException.getCause() != null);
            if (verbose) {
                Verbose.say(l + " Inside BaseDispatchMDB.onMessage() == 1\n");
                Verbose.logException(noRetryException.getCause());
            }
            bl = false;
            if (noRetryException.getCause() instanceof JAXRPCException) {
                if (verbose) {
                    Verbose.say(l + " Inside BaseDispatchMDB.onMessage() == 2\n");
                    Verbose.logException(noRetryException);
                }
                throw (JAXRPCException)noRetryException.getCause();
            }
            if (verbose) {
                Verbose.say(l + " Inside BaseDispatchMDB.onMessage() == 2.1");
            }
            throw new JAXRPCException(noRetryException.getCause());
        }
        catch (Exception exception) {
            if (verbose) {
                Verbose.say(l + " Inside BaseDispatchMDB.onMessage() == 3\n");
                Verbose.logException(exception);
            }
            if (exception instanceof JAXRPCException) {
                Throwable throwable;
                if (verbose) {
                    Verbose.say(l + " Inside BaseDispatchMDB.onMessage() == 4\n");
                }
                if ((throwable = ((JAXRPCException)((Object)exception)).getLinkedCause()) instanceof WsException && throwable.getCause() instanceof RetryException) {
                    if (verbose) {
                        Verbose.say(l + " Inside BaseDispatchMDB.onMessage() == 5\n");
                    }
                    RetryException retryException = (RetryException)throwable.getCause();
                    if (verbose) {
                        Verbose.say(l + " Reset the retry delay from user-defined RetryException:" + retryException.getRetryDelay());
                    }
                    Duration duration = new Duration(retryException.getRetryDelay());
                    if (verbose) {
                        Verbose.say(l + " Inside BaseDispatchMDB.onMessage() == 6\n");
                    }
                    long l3 = duration.convertToSeconds(new Date());
                    if (verbose) {
                        Verbose.say(l + " Inside BaseDispatchMDB.onMessage() == 7\n");
                    }
                    l2 = l3;
                    return;
                }
            }
            if (exception instanceof RuntimeException) {
                if (verbose) {
                    Verbose.say(l + " Inside BaseDispatchMDB.onMessage() == 8\n");
                    Verbose.logException(exception);
                }
                throw (RuntimeException)exception;
            }
            if (verbose) {
                Verbose.say(l + " Inside BaseDispatchMDB.onMessage() == 9\n");
                Verbose.logException(exception);
            }
            throw new RuntimeException(exception);
        }
        finally {
            if (bl) {
                if (verbose) {
                    Verbose.say(l + " Inside BaseDispatchMDB.onMessage() == 10\n");
                }
                this.setRetryDelay(message, string, l2);
            }
        }
    }

    protected abstract void onMessage(String var1, Message var2) throws Exception;

    private void setRetryDelay(Message message, String string, long l) {
        block8: {
            try {
                long l2 = BufferManager.instance().getRetryDelay(string, message.getJMSMessageID());
                if (l > 0L) {
                    if (l != l2) {
                        l2 = l;
                        BufferManager.instance().putRetryDelay(string, message.getJMSMessageID(), l2);
                    }
                } else if (message.propertyExists("BEARetryDelay")) {
                    l2 = message.getLongProperty("BEARetryDelay");
                    BufferManager.instance().putRetryDelay(string, message.getJMSMessageID(), l2);
                }
                if (l2 > 0L) {
                    if (verbose) {
                        Verbose.log("Setting retry delay to " + l2);
                        Verbose.log("Old retryDelay=" + this.session.getRedeliveryDelay());
                    }
                    this.session.setRedeliveryDelay(l2 * 1000L);
                }
            }
            catch (JMSException jMSException) {
                if (!verbose) break block8;
                Verbose.log("Could not set retry delay");
                Verbose.logException(jMSException);
            }
        }
    }

    public void setSession(Session session) {
        this.session = (WLSession)session;
    }
}

