/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer;

import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import weblogic.jws.MessageBuffer;
import weblogic.wsee.buffer.ServerBufferingHandler;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.Verbose;

public class BufferHelper {
    private static final boolean verbose = Verbose.isVerbose(BufferHelper.class);

    public static boolean isRuntimeRetryExceptionEnabled(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        MessageBuffer messageBuffer = ServerBufferingHandler.getMessageBufferConfig(wlMessageContext);
        if (messageBuffer == null) {
            if (verbose) {
                Verbose.log("Method is not buffered");
            }
            throw new JAXRPCException("Method is not buffered. So the RetryException can NOT be thrown!");
        }
        if (wlMessageContext.getProperty("weblogic.wsee.oneway.confirmed") == null && !wlMessageContext.containsProperty("weblogic.wsee.handler.wlw81BufferCompatFlat")) {
            throw new JAXRPCException("Buffering only works with one way messages or asynchronous request/response messages. So the RetryException can NOT be thrown!");
        }
        if (verbose) {
            Verbose.log("The method can throw a RetryException");
        }
        return true;
    }
}

