/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer;

import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.rpc.JAXRPCException;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.WLMessage;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.util.Verbose;

public class BufferManager {
    private static final boolean verbose = Verbose.isVerbose(BufferManager.class);
    public static final String RETRY_DELAY = "BEARetryDelay";
    private static final String QUEUE_SESSION_POOL_SIZE_PROP = "weblogic.wsee.buffer.QueueSessionPoolSize";
    private static final BufferManager theManager = new BufferManager();
    private final Map listeners = new HashMap();
    private final Map<String, ConcurrentHashMap<String, Long>> retryDelays = new ConcurrentHashMap<String, ConcurrentHashMap<String, Long>>();
    private final Map errorListeners = new HashMap();
    private final Map<String, ServerUtil.QueueInfo> queues = new HashMap<String, ServerUtil.QueueInfo>();
    private boolean initialized;
    private QueueConnectionFactory factory;
    private QueueConnection connection;
    private Vector sessions;
    private Vector transactedSessions;
    private Context ctx;
    private int numWaiters = 0;

    public static BufferManager instance() {
        return theManager;
    }

    private synchronized QueueSession getSession(boolean bl) {
        Vector vector = bl ? this.transactedSessions : this.sessions;
        boolean bl2 = false;
        while (vector.isEmpty()) {
            if (!vector.isEmpty()) continue;
            if (!bl2) {
                ++this.numWaiters;
                bl2 = true;
            }
            if (verbose) {
                Verbose.log("BufferManager ran out of sessions. Waiting as one of " + this.numWaiters + " waiting threads");
            }
            try {
                this.wait(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (bl2) {
            --this.numWaiters;
            if (verbose) {
                Verbose.log("BufferManager now has an available session. Waking up to use newly available session. Available sessions=" + vector.size() + " numWaiters=" + this.numWaiters);
            }
        }
        QueueSession queueSession = (QueueSession)vector.remove(0);
        return queueSession;
    }

    private synchronized void putSession(QueueSession queueSession, boolean bl) {
        Vector vector = bl ? this.transactedSessions : this.sessions;
        if (queueSession == null) {
            return;
        }
        vector.add(queueSession);
        if (verbose && this.numWaiters > 0) {
            Verbose.log("BufferManager put back one session. Now have " + vector.size() + " sessions and " + this.numWaiters + " threads waiting for a session. Notifying all threads");
        }
        this.notifyAll();
    }

    public void bufferMessage(String string, Serializable serializable, int n, long l) {
        this.initialize();
        if (verbose) {
            Verbose.log("Buffering message for " + string);
            Verbose.log("(retryCount = " + n + ", retryDelay = " + l + ")");
        }
        QueueSession queueSession = null;
        QueueSender queueSender = null;
        try {
            queueSession = this.getSession(true);
            queueSender = this.getQueueSender(queueSession, string);
            ObjectMessage objectMessage = queueSession.createObjectMessage(serializable);
            objectMessage.setStringProperty("ASYNC_URI", string);
            objectMessage.setLongProperty(RETRY_DELAY, l);
            ((WLMessageProducer)queueSender).setRedeliveryLimit(n);
            this.sendMessage(string, queueSender, (Message)objectMessage);
            queueSession.commit();
        }
        catch (JMSException jMSException) {
            throw new JAXRPCException("Could not enqueue buffered message: " + (Object)((Object)jMSException), (Throwable)jMSException);
        }
        finally {
            if (queueSender != null) {
                try {
                    queueSender.close();
                }
                catch (Exception exception) {
                    if (verbose) {
                        Verbose.logException(exception);
                    }
                    exception.printStackTrace();
                }
            }
            this.putSession(queueSession, true);
        }
    }

    private void sendMessage(String string, final QueueSender queueSender, final Message message) throws JMSException {
        if (string != null) {
            string.hashCode();
        }
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                queueSender.send(message);
                return null;
            }
        };
        try {
            privilegedExceptionAction.run();
        }
        catch (JMSException jMSException) {
            throw jMSException;
        }
        catch (Exception exception) {
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public void bufferMessageWithServiceURI(String string, String string2, Serializable serializable, int n, long l) {
        this.initialize();
        if (verbose) {
            Verbose.log("Buffering message for " + string);
            Verbose.log("(retryCount = " + n + ", retryDelay = " + l + ")");
        }
        QueueSession queueSession = null;
        QueueSender queueSender = null;
        try {
            queueSession = this.getSession(true);
            queueSender = this.getQueueSender(queueSession, string);
            ObjectMessage objectMessage = queueSession.createObjectMessage(serializable);
            objectMessage.setStringProperty("ASYNC_URI", string);
            objectMessage.setLongProperty(RETRY_DELAY, l);
            objectMessage.setStringProperty("SERV_URI", string2);
            ((WLMessageProducer)queueSender).setRedeliveryLimit(n);
            this.sendMessage(string, queueSender, (Message)objectMessage);
            queueSession.commit();
        }
        catch (JMSException jMSException) {
            throw new JAXRPCException("Could not enqueue buffered message: " + (Object)((Object)jMSException), (Throwable)jMSException);
        }
        finally {
            if (queueSender != null) {
                try {
                    queueSender.close();
                }
                catch (Exception exception) {
                    if (verbose) {
                        Verbose.logException(exception);
                    }
                    exception.printStackTrace();
                }
            }
            this.putSession(queueSession, true);
        }
    }

    public void bufferMessageUOO(String string, Serializable serializable, int n, long l, String string2, long l2) {
        this.initialize();
        if (verbose) {
            Verbose.log("Buffering message for " + string);
            Verbose.log("(retryCount = " + n + ", retryDelay = " + l + ")");
        }
        QueueSession queueSession = null;
        QueueSender queueSender = null;
        try {
            queueSession = this.getSession(false);
            queueSender = this.getQueueSender(queueSession, string);
            ObjectMessage objectMessage = queueSession.createObjectMessage(serializable);
            objectMessage.setStringProperty("ASYNC_URI", string);
            objectMessage.setLongProperty(RETRY_DELAY, l);
            ((WLMessageProducer)queueSender).setRedeliveryLimit(n);
            ((WLMessageProducer)queueSender).setUnitOfOrder(string2);
            ((WLMessage)objectMessage).setSAFSequenceName(string2);
            ((WLMessage)objectMessage).setSAFSeqNumber(l2);
            ((MessageImpl)objectMessage).setSAFNeedReorder(true);
            this.sendMessage(string, queueSender, (Message)objectMessage);
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
            if (jMSException.getCause() != null) {
                jMSException.getCause().printStackTrace();
            }
            throw new JAXRPCException("Could not enqueue buffered message: " + (Object)((Object)jMSException), (Throwable)jMSException);
        }
        finally {
            if (queueSender != null) {
                try {
                    queueSender.close();
                }
                catch (Exception exception) {
                    if (verbose) {
                        Verbose.logException(exception);
                    }
                    exception.printStackTrace();
                }
            }
            this.putSession(queueSession, false);
        }
    }

    public void dispatchBufferedMessage(String string, Message message) throws Exception {
        MessageListener messageListener;
        if (verbose) {
            Verbose.log("Dispatching buffered message to " + string);
        }
        if ((messageListener = this.getMessageListener(string)) == null) {
            throw new JAXRPCException("Message listener for " + string + " not available");
        }
        messageListener.onMessage(message);
    }

    public void dispatchErrorMessage(String string, Message message) throws Exception {
        MessageListener messageListener;
        if (verbose) {
            Verbose.log("Dispatching error message to " + string);
        }
        if ((messageListener = this.getErrorListener(string)) == null) {
            throw new JAXRPCException("Error listener for " + string + " not available");
        }
        messageListener.onMessage(message);
    }

    public synchronized void addErrorListener(String string, MessageListener messageListener) {
        if (verbose) {
            Verbose.log("Adding error listener for " + string);
        }
        this.errorListeners.put(string, messageListener);
    }

    public synchronized void addMessageListener(String string, MessageListener messageListener) {
        if (verbose) {
            Verbose.log("Adding message listener for " + string);
        }
        this.listeners.put(string, messageListener);
    }

    public synchronized MessageListener getMessageListener(String string) {
        return (MessageListener)this.listeners.get(string);
    }

    public synchronized void removeMessageListener(String string) {
        this.listeners.remove(string);
    }

    public synchronized MessageListener getErrorListener(String string) {
        return (MessageListener)this.errorListeners.get(string);
    }

    public synchronized void removeErrorListener(String string) {
        this.errorListeners.remove(string);
    }

    public void putRetryDelay(String string, String string2, long l) {
        ConcurrentHashMap<String, Long> concurrentHashMap = this.retryDelays.get(string);
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap();
            this.retryDelays.put(string, concurrentHashMap);
        }
        concurrentHashMap.put(string2, l);
    }

    public long getRetryDelay(String string, String string2) {
        ConcurrentHashMap<String, Long> concurrentHashMap = this.retryDelays.get(string);
        if (concurrentHashMap == null) {
            return -1L;
        }
        Long l = concurrentHashMap.get(string2);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public void removeRetryDelay(String string) {
        this.retryDelays.remove(string);
    }

    public synchronized void setTargetQueue(String string, ServerUtil.QueueInfo queueInfo) {
        if (verbose) {
            Verbose.log("Setting " + queueInfo.getQueueName() + " as target queue for " + string);
        }
        this.queues.put(string, queueInfo);
    }

    public synchronized ServerUtil.QueueInfo getTargetQueue(String string) {
        ServerUtil.QueueInfo queueInfo = this.queues.get(string);
        if (queueInfo == null) {
            queueInfo = ServerUtil.getMessagingQueueInfo();
        }
        return queueInfo;
    }

    private QueueSender getQueueSender(final QueueSession queueSession, String string) {
        try {
            QueueSender queueSender;
            ServerUtil.QueueInfo queueInfo;
            if (verbose) {
                Verbose.log("Looking up queue for " + string);
            }
            if ((queueInfo = this.getTargetQueue(string)) == null) {
                throw new JAXRPCException("Could not find buffer queue for " + string);
            }
            if (verbose) {
                Verbose.log("queue JNDI " + queueInfo.getQueueName());
            }
            final Queue queue = (Queue)this.ctx.lookup(queueInfo.getQueueName());
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    return queueSession.createSender(queue);
                }
            };
            try {
                queueSender = (QueueSender)privilegedExceptionAction.run();
            }
            catch (Exception exception) {
                if (exception instanceof JMSException) {
                    throw (JMSException)((Object)exception);
                }
                JMSException jMSException = new JMSException(exception.toString());
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            return queueSender;
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            throw new JAXRPCException("Could not find buffer queue for " + string, (Throwable)namingException);
        }
        catch (JMSException jMSException) {
            throw new JAXRPCException("Could not create sender for buffer queue", (Throwable)jMSException);
        }
    }

    private synchronized void initialize() {
        if (!this.initialized) {
            if (verbose) {
                Verbose.log("Initializing");
            }
            try {
                this.sessions = this.initializeSessions(false);
                this.transactedSessions = this.initializeSessions(true);
                this.connection.start();
            }
            catch (JMSException jMSException) {
                throw new JAXRPCException("Could not create JMS resources: " + (Object)((Object)jMSException));
            }
            this.initialized = true;
        }
    }

    private Vector initializeSessions(boolean bl) {
        Vector<QueueSession> vector = new Vector<QueueSession>();
        this.factory = bl ? (QueueConnectionFactory)JMSServerUtilities.getXAConnectionFactory() : (QueueConnectionFactory)JMSServerUtilities.getXAConnectionFactory1();
        try {
            this.ctx = new InitialContext();
            this.connection = this.factory.createQueueConnection();
            int n = 10;
            String string = System.getProperty(QUEUE_SESSION_POOL_SIZE_PROP);
            if (string != null && (string = string.trim()).length() != 0) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 < 2) {
                        n2 = 2;
                    } else if (n2 > 50) {
                        n2 = 50;
                    }
                    n = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (verbose) {
                Verbose.log("BufferManager initializing " + n + " " + (bl ? "transacted" : "non-transacted") + " sessions");
            }
            for (int i = 0; i < n; ++i) {
                vector.add(this.connection.createQueueSession(bl, 1));
            }
        }
        catch (NamingException namingException) {
            throw new JAXRPCException("Could not get buffering queue: " + namingException);
        }
        catch (JMSException jMSException) {
            throw new JAXRPCException("Could not create JMS resources: " + (Object)((Object)jMSException));
        }
        return vector;
    }

    private BufferManager() {
    }
}

