/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.jws.MessageBuffer;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.buffer.ServerBufferingHandler;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.server.jms.WsDispatchMessageListener;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class ServerBufferDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(ServerBufferDeploymentListener.class);
    private static final List BEFORE = Arrays.asList((Object[])new String[]{"AUTHORIZATION_HANDLER"});
    private static final List AFTER = Arrays.asList((Object[])new String[]{"ONE_WAY_HANDLER"});
    private static final String HANDLER_NAME = "SERVER_BUFFER_HANDLER";
    private static final HandlerInfo HANDLER_INFO = new HandlerInfo(ServerBufferingHandler.class, null, new QName[0]);

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("ServerBufferDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            Class clazz = wsPort.getEndpoint().getJwsClass();
            if (clazz == null || !this.hasBufferedMethods(clazz)) continue;
            if (verbose) {
                Verbose.log(clazz.getName() + " has buffered methods");
            }
            try {
                wsPort.getInternalHandlerList().insert(HANDLER_NAME, HANDLER_INFO, AFTER, BEFORE);
                if (verbose) {
                    Verbose.log("Added buffering handlers for " + clazz.getSimpleName());
                }
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Could not insert server buffering handler", handlerException);
            }
            this.setupBuffering(clazz, wsPort, wsDeploymentContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupBuffering(Class clazz, WsPort wsPort, WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        ServerUtil.QueueInfo queueInfo = ServerUtil.getBufferQueueInfo(clazz);
        StringBuffer stringBuffer = new StringBuffer();
        WsDispatchMessageListener wsDispatchMessageListener = new WsDispatchMessageListener(wsPort);
        boolean bl = true;
        for (int i = 0; i < wsDeploymentContext.getServiceURIs().length; ++i) {
            BufferManager bufferManager;
            String string = wsDeploymentContext.getContextPath();
            String string2 = wsDeploymentContext.getServiceURIs()[i];
            String string3 = AsyncUtil.calculateServiceTargetURI(string, string2);
            BufferManager bufferManager2 = bufferManager = BufferManager.instance();
            synchronized (bufferManager2) {
                if (bufferManager.getMessageListener(string3) != null) {
                    bl = false;
                    continue;
                }
                bufferManager.addMessageListener(string3, wsDispatchMessageListener);
            }
            if (queueInfo.getQueueName() != null) {
                bufferManager.setTargetQueue(string3, queueInfo);
            }
            wsDeploymentContext.addBufferTargetURI(string3);
            if (stringBuffer.length() == 0) {
                stringBuffer.append(AsyncUtil.getAsyncSelector(string3));
                continue;
            }
            stringBuffer.append(" OR (" + AsyncUtil.getAsyncSelector(string3) + ")");
        }
        if (bl) {
            if (verbose) {
                Verbose.log("Set up dynamic MDB to queue: " + queueInfo.getQueueName());
            }
            AsyncUtil.setupDynamicMDB(wsDeploymentContext, stringBuffer.toString(), queueInfo.getQueueName(), queueInfo.getMdbRunAsPrincipalName(), "weblogic.wsee.server.jms.MdbWS", 0);
        }
    }

    private boolean hasBufferedMethods(Class clazz) {
        Method[] methodArray;
        if (clazz.getAnnotation(MessageBuffer.class) != null) {
            return true;
        }
        for (Method method : methodArray = clazz.getMethods()) {
            if (method.getAnnotation(MessageBuffer.class) == null) continue;
            return true;
        }
        return false;
    }
}

