/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.jws.MessageBuffer;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.connection.transport.ServerTransport;
import weblogic.wsee.jws.container.Duration;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.ServerSecurityHelper;
import weblogic.wsee.util.Verbose;

public class ServerBufferingHandler
extends GenericHandler {
    private static final boolean verbose = Verbose.isVerbose(ServerBufferingHandler.class);
    public static final String BUFFER_ONEWAY_CONFIRM_OVERRIDE = "weblogic.wsee.handler.wlw81BufferCompatFlat";
    public static final String HANDLER_NAME = "SERVER_BUFFER_HANDLER";

    public boolean handleRequest(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        ServerTransport serverTransport = (ServerTransport)wlMessageContext.getDispatcher().getConnection().getTransport();
        if (serverTransport.isReliable()) {
            if (verbose) {
                Verbose.log("Transport is reliable; skipping buffering");
            }
            return true;
        }
        MessageBuffer messageBuffer = ServerBufferingHandler.getMessageBufferConfig(wlMessageContext);
        if (messageBuffer == null) {
            if (verbose) {
                Verbose.log("Method is not buffered");
            }
            return true;
        }
        if (wlMessageContext.getProperty("weblogic.wsee.oneway.confirmed") == null && !wlMessageContext.containsProperty(BUFFER_ONEWAY_CONFIRM_OVERRIDE)) {
            throw new JAXRPCException("Buffering only works with one way messages or asynchronous request/response messages.");
        }
        if (verbose) {
            Verbose.log("Buffering message");
        }
        int n = messageBuffer.retryCount();
        String string = messageBuffer.retryDelay();
        Duration duration = new Duration(string);
        long l = duration.convertToSeconds(new Date());
        if (verbose) {
            Verbose.log("Buffer retry count " + n);
            Verbose.log("Buffer retry delay " + l);
        }
        Serializable serializable = this.getBufferMessageBody(messageContext);
        BufferManager.instance().bufferMessage(serverTransport.getServiceURI(), serializable, n, l);
        messageContext.setProperty("weblogic.wsee.queued.invoke", (Object)"true");
        return false;
    }

    public boolean handleResponse(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        ServerTransport serverTransport = (ServerTransport)wlMessageContext.getDispatcher().getConnection().getTransport();
        if (!serverTransport.isReliable()) {
            // empty if block
        }
        return true;
    }

    static MessageBuffer getMessageBufferConfig(WlMessageContext wlMessageContext) {
        Class clazz = wlMessageContext.getDispatcher().getWsPort().getEndpoint().getJwsClass();
        assert (clazz != null);
        Method method = ServerBufferingHandler.findMethod(clazz, wlMessageContext.getDispatcher().getWsMethod().getMethodName());
        assert (method != null);
        MessageBuffer messageBuffer = method.getAnnotation(MessageBuffer.class);
        if (messageBuffer == null) {
            messageBuffer = clazz.getAnnotation(MessageBuffer.class);
        }
        return messageBuffer;
    }

    static Method findMethod(Class clazz, String string) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getMethods()) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    private Serializable getBufferMessageBody(MessageContext messageContext) {
        if (!(messageContext instanceof SOAPMessageContext)) {
            throw new JAXRPCException("Unsupported MessageContext; only SOAP messages are supported");
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        SOAPInvokeState sOAPInvokeState = new SOAPInvokeState(sOAPMessageContext, false);
        sOAPInvokeState.setSubject(ServerSecurityHelper.getCurrentSubject());
        return sOAPInvokeState;
    }

    public QName[] getHeaders() {
        return new QName[0];
    }
}

