/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.buffer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.jws.MessageBuffer;
import weblogic.jws.wlw.UseWLW81BindingTypes;
import weblogic.wsee.buffer.Wlw81CompatBufferingHandler;
import weblogic.wsee.buffer.Wlw81CompatBufferingResponseBlockerHandler;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class Wlw81CompatBufferDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(Wlw81CompatBufferDeploymentListener.class);
    private static final List BEFORE_RESPONDER = Arrays.asList((Object[])new String[]{"SERVER_BUFFER_HANDLER"});
    private static final List AFTER_RESPONDER = Arrays.asList((Object[])new String[]{"ONE_WAY_HANDLER"});
    private static final List BEFORE_RESPONSE_BLOCKER = new ArrayList();
    private static final List AFTER_RESPONSE_BLOCKER = Arrays.asList((Object[])new String[]{"CONNECTION_HANDLER"});
    private static final String RESPONDER_HANDLER_NAME = "WLW81_COMPAT_SERVER_BUFFER_HANDLER";
    private static final String RESPONSE_BLOCKER_HANDLER_NAME = "WLW81_COMPAT_SERVER_RESPONSE_BLOCKER_HANDLER";
    private static final HandlerInfo RESPONDER_HANDLER_INFO = new HandlerInfo(Wlw81CompatBufferingHandler.class, null, new QName[0]);
    private static final HandlerInfo RESPONSE_BLOCKER_HANDLER_INFO = new HandlerInfo(Wlw81CompatBufferingResponseBlockerHandler.class, null, new QName[0]);

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("Wlw81CompatBufferDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            Class clazz = wsPort.getEndpoint().getJwsClass();
            if (clazz != null && this.isWlw81UpgradedService(clazz)) {
                if (this.hasBufferedMethods(clazz)) {
                    if (verbose) {
                        Verbose.log(clazz.getName() + " is wlw81 AND has buffered methods");
                    }
                    try {
                        wsPort.getInternalHandlerList().insert(RESPONDER_HANDLER_NAME, RESPONDER_HANDLER_INFO, AFTER_RESPONDER, BEFORE_RESPONDER);
                        wsPort.getInternalHandlerList().insert(RESPONSE_BLOCKER_HANDLER_NAME, RESPONSE_BLOCKER_HANDLER_INFO, AFTER_RESPONSE_BLOCKER, BEFORE_RESPONSE_BLOCKER);
                        if (!verbose) continue;
                        Verbose.log("Added WLW buffering handlers for " + clazz.getSimpleName());
                        continue;
                    }
                    catch (HandlerException handlerException) {
                        throw new WsDeploymentException("Could not insert WLW buffering handlers", handlerException);
                    }
                }
                if (!verbose) continue;
                Verbose.log(clazz.getClass().getName() + " is upgraded 8.1 JWS, but has no buffered methods");
                continue;
            }
            if (!verbose || clazz == null) continue;
            Verbose.log(clazz.getClass().getName() + " is not an upgraded 8.1 JWS");
        }
    }

    private boolean isWlw81UpgradedService(Class clazz) {
        return clazz.isAnnotationPresent(UseWLW81BindingTypes.class);
    }

    private boolean hasBufferedMethods(Class clazz) {
        Method[] methodArray;
        if (clazz.getAnnotation(MessageBuffer.class) != null) {
            return true;
        }
        for (Method method : methodArray = clazz.getMethods()) {
            if (method.getAnnotation(MessageBuffer.class) == null) continue;
            return true;
        }
        return false;
    }
}

